/***************************************************************

	CU_IBMPC.C  --  Minimal CURSES routines
			for Simple Software.

			Implementation for IBM PC or Compatible
			utilizing ANSI.SYS.

			Note that the ANSI.SYS driver must be
			installed on your computer for these
			functions to work.  Be sure you check
			your DOS manual and know how to set up
			the driver (which is supplied with
			MSDOS and PCDOS).

			This implementation contains code specific
			to the Microsoft Quick C (tm) compiler.

			The use of Simple Software is governed by the
			"Simple Software User Agreement" (see file
			SS.DOC).

			Copyright (c) 1988, Ted A. Campbell

			Bywater Software
			Box 4023
			Duke Station,
			Durham, NC  27706

***************************************************************/

#include "stdio.h"
#include "dos.h"

#ifndef CR
#define CR      0x0d
#define LF      0x0a
#define DEL     0x08
#endif

char ibm_tbuf[ 64 ];            /* A scratch buffer     */

/**************************************************************

	FUNCTION:       initscr()

	DESCRIPTION:    This function performs any necessary
			initialization for the video system.

	INPUT:          none.

	RETURNS:        none.

**************************************************************/

initscr()
	{
	}

/**************************************************************

	FUNCTION:       endwin() -- Deinitialize Video System

	DESCRIPTION:    This function performs any necessary
			deinitialization for the video system,
			that it, it returns the video system to
			its default state.

	INPUT:          none.

	RETURNS:        none.

**************************************************************/

endwin()
	{
	}

/**************************************************************

	FUNCTION:       clear()

	DESCRIPTION:    This function clears the screen and homes
			the cursor.

	INPUT:          none.

	RETURNS:        none.

**************************************************************/

clear()
     {
     ibm_str( "\033[H\033[J" );
     }

/***************************************************************

	FUNCTION:       move()

	DESCRIPTION:    This function moves (or "addresses) the
			cursor to a specific line and column on
			the video screen.

	INPUT:          <line> and <column> define the position
			at which the cursor will be located.

	RETURNS:        none.

***************************************************************/

move( line, column )
     int line, column;
     {
     sprintf( ibm_tbuf, "\033[%d;%dH", line + 1, column + 1 );
     ibm_str( ibm_tbuf );
     }

/***************************************************************

	FUNCTION:       standout()

	DESCRIPTION:    This function turns on a special video
			effect (normally reverse video).

	INPUT:          none.

	RETURNS:        none.

***************************************************************/

standout()
	{
	ibm_str( "\033[0m\033[7m" );
	}

/***************************************************************

	FUNCTION:       standend()

	DESCRIPTION:    This function turns off the special video
			effect which was initiated by standout().

	INPUT:          none.

	RETURNS:        none.

***************************************************************/

standend()
	{
	ibm_str( "\033[0m" );
	}

/***************************************************************

	FUNCTION:       clrtoeol()

	DESCRIPTION:    This function clears from the current
			cursor position to the end of the line.

	INPUT:          none.

	RETURNS:        none.

***************************************************************/

clrtoeol()
	{
	addch( 0x1b );
	addch( '['  );
	addch( 'K'  );
	}

/***************************************************************

	FUNCTION:       ibm_str()

	DESCRIPTION:    This function outputs a null-terminated
			string to the screen, using the addchar()
			function below.

	INPUT:          <s> is a pointer to the buffer holding
			the string.

	RETURNS:        none.

***************************************************************/

ibm_str( s )
	char *s;
	{
	register char *p;
	p = s;
	while( *p != 0 )
		{
		addch( *p );
		++p;
		}
	}

/***************************************************************

	FUNCTION:       addch()

	DESCRIPTION:    This function outputs a character to the
			video screen.  Normally puchar() will
			work for it.

	INPUT:          <character> is the character to be output.

	RETURNS:        none.

***************************************************************/

addch( c )
	char c;
	{
	bdos( 2, c, 0 );
	}

/***************************************************************

	FUNCTION:       refresh()

	DESCRIPTION:    This function "refreshes" the screen.  In
			this relatively limited implementation of the
			CURSES functions, it simple empties the
			stdout buffer.  In more sophisticated versions
			of CURSES, all CURSES calls are mapped to
			memory, and then are output all at once by
			this call.

	INPUT:          none.

	RETURNS:        none.

***************************************************************/

refresh()
	{
	}


