



  NAME
       egaint - Enhanced graphics aint

  SYNOPSIS
       egaint [cmp]

  DESCRIPTION
       Egaint represents an IBM Enhanced Graphics Adapter-specific
       implementation of and complete replacement for aint.  While providing
       a very high degree of compatibility with its predecessor, egaint also
       features several improvements, including a greater level of
       compatibility with TETRIS, the Russian pioneer of the falling shape
       genre of computer games.

  MACHINE REQUIREMENTS
       Egaint 0.93.05 was developed and tested solely on a Toshiba T5100
       Personal Portable Computer; this means that I had a 16 Mhz 80386, an
       EGA with 256K RAM, and MS-DOS 3.3 in mind during development.  It is
       highly recommended that at least an 80286 be present when egaint is
       run (though you could probably make due without one); in addition, I
       have heard rumors that the VGA is supported (though I cannot verify
       this).

  OBJECT
       If you've played egaint before (or aint, TETRIS, NYET, Son of TETRIS,
       or any of the related games), you can skip this part.

       But for those of you who are new to this genre of computer games, the
       object of egaint is to create solid rows across the twenty-four unit
       high, ten unit wide playing field (solid in the sense that there are
       no holes) by both moving and rotating the shapes which fall from the
       top of the playing field towards the bottom.  Once a solid row is
       created, egaint will clear it from the screen, allowing everything
       above it to fall into its place.  However, if the shapes pile up and
       reach the top of the playing field, the game will end (but your
       addiction won't--at least for a while it shouldn't).

  COMMAND-LINE OPTIONS
       Egaint accepts one option which will allow the user to specify what
       sort of display device will be used:

       c    An IBM Enhanced Color Display (or any compatible device capable
            of displaying sixteen distinctive attributes at one time) will be
            used.

       m    An IBM ECD-compatible device capable of displaying only two
            distinctive attributes at one time (i.e., "black" and "white")
            will be used.

       p    An IBM ECD-compatible device capable of displaying only four
            distinctive attributes at one time (namely, the gas plasma
            display of Toshiba T5100 Portable Personal Computer, which can
            only show "bright orange," "medium-bright orange," "medium-dark
            orange," and "dark orange") will be used.

  GAME OPTIONS
       Once inside egaint, a game options screen (after, of course, the title
       screen).  A brief summary of the available options (and their preset
       values) follows.



       Tournament Game (No)
            There are two hundred and fifty-six possible tournament games
            built into egaint; each tournament game will play exactly the
            same each time it is invoked, making them ideal vehicle for
            competitions between two players.  Note that all conditions must
            be identical for the games to be identical (i.e., the same
            initial level, the same initial height, the same version of
            egaint, etc.)

       Tournament Game Number (0)
            This option allows you to choose which particular game (out of
            the two-hundred and fifty-six possible) you wish to play (they
            range from zero to two-hundred and fifty-five).

       Initial Level (5)
            Where one is the easiest (slowest) and ten is the hardest
            (fastest).

       Initial Height (0)
            Specifies how high (in blocks) an area should be filled with
            randomly placed blocks (ranges from one to twelve).  And, as an
            improvement upon aint, egaint offers hidden (or invisible)
            blocks, which may be set by incrementing the height past twelve.

       Show Next (Yes)
            Toggles whether or not the next piece to be put into play should
            be displayed in a window in the upper-left corner of the screen.

       Show Shadow (No)
            This is still being worked on; the idea behind this is to have a
            "shadow" cast upon the area beneath the falling shape (which
            should, in theory, result in less placement errors).

       Extended Shapes (Classic)
            Egaint builds upon aint by offering four sets of shapes:

            Classic
              the seven basic shapes

            Easy
              the Classic set plus an assortment of smaller shapes

            Medium
              the Classic and Easy sets plus some moderately awkward shapes

            Hard
              all of the above sets plus larger, more difficult shapes

       Block Style (varies)
            There are four styles of blocks which you can choose from:

            New
              A style introduced in egaint 0.93.01 as part of the title
              screen, it was found appealing enough to eventually replace the
              original style (though that was later brought back).

            Classic
              The original style which was, as mentioned above, abandoned
              (but later restored).



            Pumped Full of Drugs
              A random style which was created (out of boredom) after the New
              style was added (did I here someone mention featuritis?); this
              apt moniker was lifted directly from the not-so-apt title of a
              very lethargic concert videotape.

            Really P.F.D.
              Another random style which represents a random combination of
              all of the above styles.

  KEY BINDINGS
       The essential key bindings are the same as for aint, though some
       additions have been made:

       J    Moves the current shape towards the left wall of the playing
            field.  In addition, this key moves the cursor upward while in
            the game options screen.

       K    Rotates the current shape in the right, or clockwise, direction.
            In addition, this key also toggles the selected option during the
            game options screen.

       L    Moves the current shape towards the right wall of the playing
            field.  In addition, this key moves the cursor downward while in
            the game options screen.

       I    Rotates the current shape in the left, or counter-clockwise,
            direction.

       Space Bar
            Drops the current shape (and, as a result, relinquishes all user
            control of it).

       Escape
            When first hit, it pauses the game:  if Escape is hit again while
            paused, it will abort the game; otherwise, play resumes.  In
            addition, pressing this during the game options screen while exit
            you from the game and into the operating system.

       B    Cycles the current block style through from New to Classic to
            Pumped Full of Drugs to Really P.F.D. and back to New, etc.

       N    Toggles the Show Next setting.

       S    Toggles the (non-functioning) Show Shadow setting.

       V    Increments the current level (and cycles back to level one).

       X    Cycles the current shape set through from Classic to Easy to
            Medium to Hard and back to Classic, etc.

  PLAYING FIELD SCREEN
       The playing field screen is divided into four components:

       Next window
            This window is located in the upper-left corner of the screen and
            displays, if Show Next is set, the next shape scheduled to come
            into play.



       Score window
            This window is located in the upper-right corner of the screen,
            directly opposite from the Next window, and consists of the
            following:

            Score
              The current number of points attained by the player.

            Value
              The point value (after all bonuses have been added; see SCORING
              for more information about this) of the current shape (i.e.,
              the one falling).

            Level
              The current level of play (see ADVANCEMENT for more information
              about this) and the current shape set.

            Rows
              The total number of rows which have been cleared during this
              game.

       Playing Field
            This is represented by the narrow pit running the height of the
            screen.

       Key Bindings window
            These are the two windows on either side of the playing field at
            the bottom of the screen; they provide a quick summary of the
            recognized keys to press and their assigned functions.

  SCORING
       The scoring is not complicated:  each shape has been given a value
       which was determined with the difficulty in placing and frequency of
       necessity being the governing factors.  This value is first multiplied
       by your current level and then bonuses are added on; these bonuses are
       awarded for not using Show Next, not using Show Shadow, having an
       Initial Height, etc.

       In addition, to the points which you automatically get for each piece,
       you also get points for dropping pieces (the higher you drop, the more
       points you get) and for, naturally, clearing rows.  Again, these
       points are multiplied by your current level and the above bonuses are
       then added in.

       Careful experimentation (or just looking at the source code) will
       allow you to determine the exact scoring algorithm.

  ADVANCEMENT
       In addition, egaint will automatically provide level advancement (and
       higher point values) for you after you clear a certain number of rows.

       The rule for this is:  after you clear your "x"th row, if "x" is a
       multiple of ten, you will be advanced (if you are not at this or above
       this already) to the "n"th level, where "n" is "x" divided by ten.

  CONFIGURATION FILE
       Egaint will save the current options (upon exit to the operating
       system) in a file called EGAINT.RC; the format is pretty self-
       explanatory upon inspection (i.e., if you don't understand this, don't
       bother with it).



       If egaint cannot find its configuration file, it will create one with
       the above default options.

  HIGH SCORE FILE
       Egaint will save the top fifteen high scores (along with other
       information about those particular games) into a file called
       EGAINT.REC.

       Again, if egaint cannot find its high score file, it will create one
       (this means you can delete the high score file at any time).

  UNRESTRICTIONS
       Egaint is free software; you can redistribute it and/or modify it
       under the terms of the GNU General Public License, Version 1, as
       published by the Free Software Foundation.

       This program is distributed in the hope that it will be useful, but
       without any warranty whatsoever, without even the implied warranties
       of merchantability or fitness for a particular purpose.  See the
       accompanying GNU General Public License for more details.

       You should have received a copy of the GNU General Public License
       along with egaint; see the file COPYING.  If not, write to:

            Free Software Foundation, Inc.
            675 Massachusetts Avenue
            Cambridge, Massachusetts 02139

  PUBLIC DOMAIN AND SHAREWARE
       This program is not public domain nor is it shareware (or freeware, or
       whateverware):  note that I am not asking you to send me any fees or
       donations; also note that I have copyrighted this program.

       What does this mean?  Well, if you really drastically feel the need to
       send someone money because you enjoy egaint, donate it to a worthy
       cause, like (I think this is the correct spelling) Bruce Ritter's
       Covenant Houses or to the above Free Software Foundation or whatever
       you deem appropriate.

  SOURCE CODE
       For this particular version, egaint 0.93.05, you can obtain the
       complete source code (which has compiled correctly under Turbo Pascal
       versions 4.0 and 5.5, so I assume, by interpolation, it will compile
       under 5.0) at either of the below bulletin board systems:

            Tom and Sue McDermet's The Odyssey
            A carrier of the SmartNet network
            Morris Plains, New Jersey
            (201) 984-6574

            John Looker's Bandersnatch
            Phoenix Net #807/7
            Basking Ridge, New Jersey
            (201) 766-3801



       In addition, those of you with Internet access can reach me at the
       following address:

            erc@{mars,irss,inis}.njit.edu

       Please send any bug reports, modifications, or other assorted queries
       to the above address (if you can).  Also, I will be returning to
       college sometime in mid-August, meaning that later versions of egaint
       may not be posted on the above bulletin boards (being that they will
       be quite long distance calls for me); the e-mail address, however,
       should remain valid.

  REVISION HISTORY
       aint 0.0 (19-Apr-89)
            The original, bare-bones version of aint, it represented a
            falling shape game, though not much else.  Originally "thrown
            together" under the aegis of a wager.

       aint 0.1 (20-Apr-89)
            The first version of aint to adequately capture the concept of
            the genre it was trying to fit into (i.e., constructing rows)
            without possessing any really major bugs; it, in turn, lacked the
            "standard" features of generic computer games (scoring being one
            notable example).

       aint 0.2 (20-Apr-89)
            The alpha-test version of aint:  the really major bugs that were
            later discovered were fixed and "standard features" like scoring
            and levels were added.

       aint 0.8 (21-Apr-89)
            The beta-test version of aint:  pretty much rewritten, it used
            more reliable machine-independent timing functions and more
            realistic scoring functions while Show Next, Show Statistics,
            Initial Height, (a not particularly reliable implementation of)
            Tournament Games, a game options screen, and a true high score
            list were added.

       aint 0.9 (26-Apr-89)
            The pre-release version of aint:  a bug which caused a fatal
            system crash at peculiar moments was fixed while "debug features"
            like Smart Bomb, Polymorph, and Nuke were added.  This was the
            first version to be distributed (in a still quite limited and
            very lackadaisical fashion) beyond the initial test groups.

       egaint 0.9 (2-May-89)
            The initial version of egaint, it was written specifically for
            the graphics hardware which I had:  EGAs with 256K RAM connected
            to gas plasma screens capable of displaying only four shades of
            orange.  Originally conceived as a rewritten, portable aint
            (cough), it slowly (de-) evolved (due to laziness) into a
            hideously slow, flickery, EGA-only version.

            All the cheap bells and whistles present in aint (like the "debug
            features") were abandoned in favor of less tacky bells and
            whistles, like actually drawing the shapes in the Statistics
            window and not calling them funny names like "ell" and "lel."



       egaint 0.91 (2-Jun-89)
            A kludged version of egaint which provided support for more
            colors.

       egaint 0.92 (13-Jun-89)
            The "lost" egaint:  conceived as an idea on paper, this was the
            ambitious start of a complete rewrite of egaint.  This new
            version would add support for CGAs, bare-bone EGAs, HGCs, MCGAs,
            and VGAs.  In addition, the "flagship" version of egaint for EGAs
            with 256K RAM (and VGAs) would employ video page switching (in an
            attempt to remove the flicker).

            Unfortunately, this version is still that, an idea on paper.

       egaint 0.91.99 (18-Jun-89)
            Being too lazy (and busy) to actually rewrite egaint at this
            point and time, this revision provided a bridge between versions
            and included specific improvements conceived with egaint 0.92.
            The most important was the test of video page switching in the
            title screen (which, after several almost hilarious attempts,
            turned out great).  In addition, extended shapes were added (most
            of them quite ridiculous) and Show Statistics was removed because
            of this (there were too many damned shapes!).  Minor fixes
            included the ability to use Escape as an editing key while
            entering high score names and the removal of the wilder block
            styles.

       egaint 0.92.01 (18-Jun-89)
            Since so many of egaint 0.92's planned improvements were being
            implemented (and since I didn't feel like using hexidecimal
            version numbers), the revision number was advanced to reflect
            "0.92" status.  Shadowing, a feature seen in a UNIX
            implementation by Adam Margulies was begun (and latter scuttled).
            In addition, the use of Escape to pause, double Escape to quit
            was implemented, as was the ability to toggle options during game
            play.  Finally, Initial Height blocks were given their own
            special, muted-color style (in order to distinguish them from
            "real" blocks).

       egaint 0.92.02 (18-Jun-89)
            This version added true shadowing (though extremely flickery).
            In addition, an attempt to use video page switching in the actual
            game play was attempted and quickly abandoned.

       egaint 0.93.01 (24-Jun-89)
            The actual rewrite of egaint began with this version:  however,
            due to laziness (again), it turned into a half-rewrite, half-
            recopy.  On the other hand, all of the code which was rewritten
            turned out to be the only code which needed to be rewritten (at
            least in my opinion).  A more elegant video page switching scheme
            was implemented throughout the entire program, causing a
            noticeable performance degradation in the title and game over
            screens but (mysteriously) not in the actual game play itself.
            Shadowing code was, at the very last moment, commented out due to
            an inability to conceive of an elegant (or at least efficient)
            manner of implementation.

            Also, code was added that allowed the user to determine which
            shape set was currently in use.  In addition, the "New" block
            style was introduced, though not for game play, but rather for



            the title and game over screens.  Finally, the playing field
            screen was modified:  the Score window was moved over to the
            upper-right corner, and the Key Bindings window asexually
            reproduced into two.

       egaint 0.93.02 (25-Jun-89)
            This version consisted mainly of cosmetic improvements; the most
            notable was the addition of the "New" block style as an
            alternative to the "Old" (later renamed "Classic") block style.
            Also, the Score window was now updated after each toggle, making
            it less confusing.  Finally, the game over code was removed
            because the "New" block style was now being used within the game
            play.

       egaint 0.93.03 (25-Jun-89)
            The pre-release version of egaint:  it added minor features, like
            the "Pumped Full of Drugs" and "Really P.F.D." block styles, a
            new game over screen, a completely re-implemented extended shape
            set, the ability to rotate shapes the other direction (the I key;
            another improvement from Adam Margulies), and the "Value" entry
            in the Score window.  Finally, the high score file format was
            changed to note which version (out of the seemingly hundreds) was
            played for each score.

            This version also featured pre-release documentation, a hastily
            put-together mishmash of old aint documents modified for the
            egaint context.

            Distribution of egaint began with this version; a rudimentary
            serial number system (to allow the author, just for curiosity, to
            track the distribution path of a specific copy) was implemented.
            Unfortunately, distribution was limited to only bulletin board
            systems which were non-toll calls from Morris Plains.

       egaint 0.93.04 (30-Jun-89)
            A private maintenance revision of egaint, it tuned down the
            scoring and changed the name of the "Old" block style to
            "Classic."

       egaint 0.93.04x (7-Jul-89)
            This revision of egaint was the first to be compiled under Turbo
            Pascal 5.5 and marked the removal of the serial number system (in
            anticipation for the distribution of source code, which would
            render any sort of tracking useless).

       egaint 0.93.05 (13-Jul-89)
            The first release of egaint to fully comply with the GNU General
            Public License (though it and aint had been previously
            distributed without source code under terms and conditions set up
            by the Free Software Foundation), it provided for a configuration
            file and a name change (from "New More Order" to the author's
            real identity).  In addition, the documentation was rewritten
            into a UNIX "man"-like format.

       aint 0.90.01 (13-Jun-89)
            A fix-up of aint for inclusion in the egaint 0.93.05 package, it
            added some cosmetic improvements to the title/game options screen
            and reset the initial values for some variables; note that there
            are (major) scoring differences between egaint 0.93.05 and aint
            0.90.01.



  STILL TO COME
       Realistically, there still is a long way to go before the "whole"
       version of egaint 1 can be released; the following are only a few of
       the improvements which must be implemented before that release can
       become a reality:

         +  Support (via different versions, like cgaint, hgaint, mcgaint,
            etc.) for different graphics cards, including EGAs with only 64K
            RAM.

         +  An elegant (or at least efficient) implementation of Show Shadow.

         +  More efficient code, allowing egaint to be run on slower machines
            without noticeable performance degradation.

         +  Placement of code into separate modules, allowing for easier
            maintenance.

         +  Microsoft Mouse support.

       In addition, the following ideas are being considered:

         +  Background screens:  I've been considering loading .GIF screens
            onto the background so that users aren't forced to gaze at low-
            resolution caricatures of Russian life.

         +  A different game premise (if you ask me, I'm kind of sick of the
            falling shape genre of computer games).

  CREDITS
       Borland International's BGI (Borland Graphics Interface, I believe)
       system was used for the graphics and font libraries of egaint.

  SEE ALSO
       TETRIS, NYET, Son of TETRIS Project (SOT), etc.

  TRADEMARKS
       All brand and product names are the trademarks or registered
       trademarks of their respective holders.

       Whew!


















                          Copyright (C) 1989 Eric Ng