
       page    60,132

;********************************************
;*                                          *
;*   This is an installable device driver   *
;*   to provide buffered communications.    *
;*                                          *
;*   Richard Ellis 1984                     *
;********************************************



CSEG   SEGMENT PARA PUBLIC 'CODE'
;
;
STATUS MACRO   STATE,ERR,RC
       IFIDN   <STATE>,<DONE>
        OR     ES:WORD PTR SRH_STA_FLD[BX],0100H
       ENDIF
       IFIDN   <STATE>,<BUSY>
        OR     ES:WORD PTR SRH_STA_FLD[BX],0200H
       ENDIF
       IFIDN   <STATE>,<ERROR>
        OR     ES:WORD PTR SRH_STA_FLD[BX],1000H
       ENDIF
       IFNB    <RC>
        OR     ES:WORD PTR SRH_STA_FLD[BX],RC
       ENDIF
       ENDM


A8259  EQU     20H                     ;ADDRESS OF INTERRUPT CONTROLER
ACOM   EQU     3F8H                    ;ADDRESS OF COM CONTROLLER
BUFSIZE EQU    1024


SRH            EQU     0               ;STATIC REQUEST HEADER START
SRH_LEN        EQU     13              ;LENGTH
SRH_LEN_FLD    EQU     SRH             ;LENGTH FIELD
SRH_UCD_FLD    EQU     SRH+1           ;UNIT CODE FIELD
SRH_CCD_FLD    EQU     SRH+2           ;COMMAND CODE FIELD
SRH_STA_FLD    EQU     SRH+3           ;STATUS FIELD
SRH_RES_FLD    EQU     SRH+5           ;RESERVED AREA

MD             EQU     SRH+SRH_LEN     ;MEDIA DESC BYTE
MD_LEN         EQU     1               ;

DTA            EQU     MD+MD_LEN       ;DISK XFER ADDR
DTA_LEN        EQU     4               ;

COUNT          EQU     DTA+DTA_LEN     ;BYTE/SECTOR COUNT
COUNT_LEN      EQU     2               ;

SSN            EQU     COUNT+COUNT_LEN ;STARTING SECTOR #
SSN_LEN        EQU     2               ;

RET_BYTE       EQU     MD+MD_LEN       ;BYTE RETURNED FROM DRIVER

BPBA_PTR       EQU     DTA+DTA_LEN     ;POINTER TO BPB
BPBA_PTR_LEN   EQU     4               ;



;      INIT


UNITS          EQU     SRH+SRH_LEN
UNITS_LEN      EQU     1
BR_ADDR_0      EQU     UNITS+UNITS_LEN
BR_ADDR_1      EQU     BR_ADDR_0+2
BR_ADDR_LEN    EQU     4


BCOM           PROC    FAR
               ASSUME  CS:CSEG,DS:CSEG,ES:CSEG

BEGIN:
START          EQU     $

;  SPECIAL DEVICE HEADER

NEXT_DEV       DD      -1                      ;PTR TO NEXT DEVICE
ATTRIBUTE      DW      8000H                   ;CHARACTER DEVICE
STRATEGY       DW      DEV_STRATEGY            ;POINTER TO STRATEGY
INTERRUPT      DW      DEV_INT                 ;  "     "  INTERRUPT HANDLER
DEV_NAME       DB      'BCOM'
               DB      7 DUP(' ')


RH_OFF         DW      ?                       ;REQUEST HEADER OFFSET
RH_SEG         DW      ?                       ;REQUEST HEADER SEGMENT


;  FUNCTION TABLE

FUNTAB         DW      INIT
               DW      MEDIA_CHECK
               DW      BUILD_BPB
               DW      IOCTL_IN
               DW      INPUT                   ;READ
               DW      ND_INPUT
               DW      IN_STAT
               DW      IN_FLUSH
               DW      OUTPUT                  ;WRITE
               DW      OUT_VERIFY
               DW      OUT_STAT
               DW      OUT_FLUSH
               DW      IOCTL_OUT



DEV_STRATEGY:
               MOV     CS:RH_SEG,ES
               MOV     CS:RH_OFF,BX
               RET



;          DEVICE INTERRUPT HANDLER

DEV_INT:
               CLD
               PUSH    DS
               PUSH    ES
               PUSH    AX
               PUSH    BX
               PUSH    CX
               PUSH    DX
               PUSH    DI
               PUSH    SI


               MOV     BX,CS:RH_OFF
               MOV     ES,CS:RH_SEG

               MOV     AL,ES:[BX]+2                    ;GET FUNCTION BYTE
               ROL     AL,1                            ;GET OFFSET INTO TABLE
               LEA     DI,CS:FUNTAB                    ;GET ADDR OF TABLE
               XOR     AH,AH
               ADD     DI,AX                           ;CALC OFFSET
               JMP     WORD PTR cs:[DI]                ;AND GO DO IT



;   INIT

INIT:          CLI                             ;***DISABLE***
               MOV     AX,OFFSET CS:IBUF
               MOV     CS:IBUFE,AX
               MOV     CS:IBUFS,AX

               MOV     AX,OFFSET CS:OBUF
               MOV     CS:OBUFE,AX
               MOV     CS:OBUFS,AX


;      INITIALIZE 8250

               MOV     DX,3FBH
               MOV     AL,80H
               OUT     DX,AL                           ;GET ACCESS TO DIVISOR

               MOV     DX,3F8H
               MOV     AX,96
               OUT     DX,AL
               INC     DX
               MOV     AL,AH
               OUT     DX,AL                           ;SET TO 1200 BAUD

               MOV     DX,3FBH                         ;LINE CONTROL REG
               MOV     AL,1AH                          ;E,7,1
               OUT     DX,AL

               PUSH    CS
               POP     DX                              ;GET CURRENT CS
               MOV     AX,OFFSET CS:EOD                ;GET OFFSET OF LAST BYTE
               MOV     ES:WORD PTR BR_ADDR_0[BX],AX    ;SET LAST ADDR
               MOV     ES:BR_ADDR_1[BX],DX

;      SETUP INTERRUPT VECTOR

               PUSH    DS
               SUB     AX,AX
               MOV     DS,AX
               MOV     AX,OFFSET INTSERV               ;GET INTERRUPT SERVICE
               MOV     DS:30H,AX                       ;ADDR TO VECTOR
               MOV     DS:32H,DX
               POP     DS

;      TELL THE 8259 THE INTERRUPT IS OK!

               IN      AL,A8259+1
               AND     AL,0EFH                         ;UNMASK IRQ4
               OUT     A8259+1,AL

;      ENABLE THE 8250 TO INTERRUPT

               MOV     DX,ACOM+1                       ;GET ADDR OF IER
               MOV     AL,0FH                          ;ENABLE ALL INTERRUPTS
               OUT     DX,AL

;      TURN ON DTR+RTS

               MOV     DX,ACOM+4                       ;ADDR OF MODEM CONTROL
               MOV     AL,0BH                          ;RTS+DTR+out2
               OUT     DX,AL
               STI                             ;***ENABLE***

               MOV     ES,CS:RH_SEG
               MOV     BX,CS:RH_OFF
               STATUS  DONE,NOERROR
               JMP     EXIT


;          MEDIA CHECK

MEDIA_CHECK:
               MOV     ES:BYTE PTR RET_BYTE[BX],0      ;UNKNOWN CHANGE STATUS
BUILD_BPB:
               STATUS  DONE,NOERROR
               JMP     EXIT


IOCTL_IN:
               MOV     DI,ES:WORD PTR DTA+2[BX]
               MOV     DS,DI
               MOV     DI,ES:WORD PTR DTA[BX]          ;GET ADDRESS
               MOV     CX,ES:WORD PTR COUNT[BX]        ;GET # OF BYTES
               SUB     AX,AX
               MOV     AX,ES:WORD PTR COUNT[BX]        ;RESET COUNT
               OR      CX,CX                           ;CHECK IF ANY?
               JZ      BUILD_BPB                       ;JMP/NO-EXIT

               MOV     DX,ACOM+6                       ;GET MODEM STATUS
               IN      AL,DX
               MOV     DS:[DI],AL                      ;SEND IT TO USER
               INC     DI
               INC     ES:WORD PTR COUNT[BX]           ;BUMP COUNT
               DEC     CX                              ;DECR BUF SIZE
               JZ      BUILD_BPB                       ;JMP/DONE-BUF FULL

               MOV     DX,ACOM+5                       ;GET LINE STATUS
               IN      AL,DX
               MOV     DS:[DI],AL                      ;SEND IT TO USER
               INC     DI
               INC     ES:WORD PTR COUNT[BX]           ;BUMP COUNT
               DEC     CX                              ;DECR BUF SIZE
               JZ      BUILD_BPB                       ;JMP/DONE-BUF FULL

               MOV     DX,ACOM+3                       ;GET LINE CONTROL
               IN      AL,DX
               MOV     DS:[DI],AL                      ;SEND IT TO USER
               INC     DI
               INC     ES:WORD PTR COUNT[BX]           ;BUMP COUNT
               DEC     CX                              ;DECR BUF SIZE
               JZ      BUILD_BPB                       ;JMP/DONE-BUF FULL

               MOV     DX,ACOM+4                       ;GET MODEM CONTROL
               IN      AL,DX
               MOV     DS:[DI],AL                      ;SEND IT TO USER
               INC     DI
               INC     ES:WORD PTR COUNT[BX]           ;BUMP COUNT
               JMP     BUILD_BPB                       ;JMP/DONE

IOCTL_OUT:
               MOV     DI,ES:WORD PTR DTA+2[BX]
               MOV     DS,DI
               MOV     DI,ES:WORD PTR DTA[BX]          ;GET ADDRESS
               MOV     CX,ES:WORD PTR COUNT[BX]        ;GET # OF BYTES
               OR      CX,CX                           ;CHECK IF ANY?
               JZ      BUILD_BPB                       ;JMP/NO-EXIT

               MOV     AL,DS:[DI]                      ;GET TYPE
               OR      AL,AL
               JNZ     IC_NZ                           ;JMP/NOT MODEM CONTROL

               INC     DI
               MOV     AL,DS:[DI]                      ;GET MODEM CONTROL BYTE
               MOV     DX,ACOM+4                       ;GET MODEM CONTROL ADDR
               OUT     DX,AL                           ;AND SEND IT
               JMP     IC_OUT                          ;GET OUT

IC_NZ:
               CMP     AL,1                            ;IS IT LINE CONTROL?
               JNE     IC_BAUD                         ;JMP/NO
               INC     DI
               MOV     AL,DS:[DI]                      ;GET LINE CONTROL BYTE
               MOV     DX,ACOM+3                       ;GET LINE CONTROL ADDR
               OUT     DX,AL                           ;AND SEND IT
               JMP     SHORT IC_OUT                    ;GET OUT

IC_BAUD:
               CMP     AL,2                            ;VALID?
               JNE     IC_OUT                          ;JMP/NO--GET OUT

               MOV     DX,ACOM+3                       ;GET LINE STATUS
               IN      AL,DX
               MOV     AH,AL
               OR      AL,80H                          ;SET DLAB BIT
               OUT     DX,AL                           ;AND OUTPUT THE BYTE

               MOV     DX,ACOM
               MOV     AL,DS:[DI]
               OUT     DX,AL
               INC     DX
               MOV     AL,DS:[DI+1]
               OUT     DX,AL

               MOV     AL,AH
               MOV     DX,ACOM+3
               OUT     DX,AL                           ;RESET LINE CONTROL BYTE


ND_INPUT:
OUT_STAT:              ;THESE ARE NOT SUPPORTED BY THIS DEVICE

IC_OUT:
               STATUS  DONE,NOERROR
               JMP     EXIT

IN_STAT:       CLI
               MOV     DX,ACOM+1                       ;GET ADDR OF IER
               MOV     AL,0FH                          ;ENABLE ALL INTERRUPTS
               OUT     DX,AL

               MOV     BX,CS:IBUFS
               CMP     BX,CS:IBUFE
               JE      INS_BUSY
               MOV     BX,CS:RH_OFF
               MOV     ES,CS:RH_SEG

               STATUS  DONE,NOERROR
               JMP     EXIT

INS_BUSY:
               MOV     BX,CS:RH_OFF
               MOV     ES,CS:RH_SEG

               STATUS  BUSY,NOERROR
               JMP     EXIT



IN_FLUSH:      CLI                             ;***DISABLE***
               MOV     AX,OFFSET CS:IBUF
               MOV     CS:IBUFE,AX
               MOV     CS:IBUFS,AX
               JMP     SHORT OUTF

OUT_FLUSH:
               MOV     AX,OFFSET CS:OBUF
               MOV     CS:OBUFE,AX
               MOV     CS:OBUFS,AX

OUTF:
               STI                             ;***ENABLE***
               MOV     BX,CS:RH_OFF
               MOV     ES,CS:RH_SEG

               STATUS  DONE,NOERROR
               JMP     EXIT


INPUT:         STI                             ;***ENABLE***
               MOV     DI,ES:WORD PTR DTA+2[BX]
               MOV     DS,DI
               MOV     DI,ES:WORD PTR DTA[BX]          ;GET ADDRESS
               MOV     CX,ES:WORD PTR COUNT[BX]        ;GET # OF BYTES
NEXTIN:        MOV     BX,CS:IBUFS
               CMP     BX,CS:IBUFE
               JE      NEXTIN                          ;B/BUFFER EMPTY
               INC     BX
               CMP     BX,OFFSET CS:IBUF+BUFSIZE
               JNE     IN10
               MOV     BX,OFFSET CS:IBUF
IN10:          MOV     AL,CS:[BX]                      ;GET THE CHARACTER
               MOV     DS:[DI],AL                      ;MOVE IT TO USER
               INC     DI
               MOV     CS:IBUFS,BX

IN_NEXT:       LOOP    NEXTIN

               MOV     BX,CS:RH_OFF
               MOV     ES,CS:RH_SEG

               STATUS  DONE,NOERROR
               JMP     EXIT



OUTPUT:
OUT_VERIFY:    STI
               MOV     DX,ACOM+1                       ;GET ADDR OF IER
               MOV     AL,0FH                          ;ENABLE ALL INTERRUPTS
               OUT     DX,AL

               MOV     DI,ES:WORD PTR DTA[BX]          ;GET ADDRESS
               MOV     DS,ES:WORD PTR DTA+2[BX]
               MOV     CX,ES:WORD PTR COUNT[BX]        ;GET # OF BYTES
NEXTOUT:       MOV     BX,CS:OBUFS
               INC     BX
               CMP     BX,OFFSET CS:OBUF+BUFSIZE
               JNE     OUT_OK
               MOV     BX,OFFSET CS:OBUF
OUT_OK:        CMP     BX,CS:OBUFE
               JE      NEXTOUT                         ;B/BUFFER FULL--WAIT

               MOV     CS:OBUFS,BX
               MOV     AL,DS:[DI]                      ;GET THE CHARACTER
               MOV     CS:[BX],AL                      ;MOVE IT TO BUFFER
               INC     DI

OUT_NEXT:      LOOP    NEXTOUT

OUTOUT:        CLI                             ;***DISABLE***
               MOV     DX,ACOM+5                       ;CHECK IF XMIT EMPTY
               IN      AL,DX
               TEST    AL,20H
               JZ      OUTLEAVE                        ;JUST FOOLIN'

               MOV     BX,CS:OBUFE                     ;GET BUFFER END ADDR
               CMP     BX,CS:OBUFS                     ;COMPARE TO START ADDR
               JE      OUTLEAVE                        ;B/EMPTY
               INC     BX
               CMP     BX,OFFSET CS:OBUF+BUFSIZE
               JNE     OUT10
               MOV     BX,OFFSET CS:OBUF
OUT10:         MOV     CS:OBUFE,BX
               MOV     AL,CS:[BX]
               MOV     DX,ACOM
               OUT     DX,AL                           ;SEND THE CHAR

OUTLEAVE:      MOV     BX,CS:RH_OFF
               MOV     ES,CS:RH_SEG
               STI                             ;***ENABLE***
               STATUS  DONE,NOERROR
               JMP     EXIT


;          COMMON EXIT


EXIT:
               POP     SI
               POP     DI
               POP     DX
               POP     CX
               POP     BX
               POP     AX
               POP     ES
               POP     DS
               RET




;      INTERRUPT SERVICE ROUTINE

INTSERV:       STI
               CLD
               PUSH    AX
               PUSH    BX
               PUSH    CX
               PUSH    DX
               PUSH    DI

               MOV     DX,ACOM+2                       ;GET ADDR OF IIR
               IN      AL,DX                           ;GET INTERRUPT TYPE

               AND     AX,06H                          ;MAKE SURE EVEN
               LEA     DI,CS:INTTAB                    ;GET ADDR OF TABLE
               ADD     DI,AX                           ;CALC OFFSET
               JMP     WORD PTR CS:[DI]                ;AND GO DO IT

INTTAB         DW      MODEMSTAT
               DW      XMITBUF
               DW      RECBUF
               DW      LINESTAT


LINESTAT:      MOV     DX,ACOM+5
               IN      AL,DX                           ;READ THE LINE STATUS
               JMP     SHORT RECBUF                    ;JUST EXIT FOR NOW

MODEMSTAT:     MOV     DX,ACOM+6
               IN      AL,DX                           ;READ THE MODEM STATUS
               MOV     CS:MODSTAT,AL                   ;SAVE THE MODEM STATUS


RECBUF:
               MOV     DX,ACOM+5                       ;MAKE SURE WE REALLY
               IN      AL,DX                           ;HAVE A CHARACTER
               TEST    AL,1
               JZ      XMITBUF

               MOV     BX,CS:IBUFE                     ;GET BUFFER END ADDR
               INC     BX
               CMP     BX,OFFSET CS:IBUF+BUFSIZE
               JNE     RECVCHAR
               MOV     BX,OFFSET CS:IBUF
RECVCHAR:      MOV     DX,ACOM
               IN      AL,DX                           ;GET THE CHARACTER

               CMP     BX,CS:IBUFS                     ;COMPARE TO START ADDR
               JNE     STORECHAR                       ;B/NOT FULL
               JMP     SHORT XMITBUF                   ;B/RECEIVE BUF FULL

STORECHAR:     MOV     CS:[BX],AL                      ;PUT CHAR IN BUFFER
               MOV     CS:IBUFE,BX


XMITBUF:
               MOV     DX,ACOM+5                       ;CHECK IF XMIT EMPTY
               IN      AL,DX
               TEST    AL,20H
               JZ      INTOUT                          ;JUST FOOLIN'


               MOV     BX,CS:OBUFE                     ;GET BUFFER END ADDR
               CMP     BX,CS:OBUFS                     ;COMPARE TO START ADDR
               JNE     SENDCHAR                        ;B/NOT EMPTY
               JMP     INTOUT


SENDCHAR:
               INC     BX
               CMP     BX,OFFSET CS:OBUF+BUFSIZE
               JNE     SEND10
               MOV     BX,OFFSET CS:OBUF
SEND10:        MOV     CS:OBUFE,BX
               MOV     AL,CS:[BX]
               MOV     DX,ACOM
               OUT     DX,AL                           ;SEND THE CHAR

               JMP     INTOUT


INTOUT:        CLI
               MOV     AL,20H                          ;SIGNAL END OF INT
               OUT     A8259,AL

               POP     DI
               POP     DX
               POP     CX
               POP     BX
               POP     AX
               IRET


BCOM           ENDP


MODSTAT        DB      0

IBUFS          DW      OFFSET IBUF
IBUFE          DW      OFFSET IBUF
OBUFS          DW      OFFSET OBUF
OBUFE          DW      OFFSET OBUF


IBUF           DB      BUFSIZE DUP(0)
OBUF           DB      BUFSIZE DUP(0)



EOD            EQU     $

CSEG           ENDS

               END     BEGIN

OBUF           DB      BUFSIZE DUP(0)



EOD                                                                                                                                                                                                                                                                                                                                                                                                    