               PAGE 60,132
TITLE  SLASH.COM  VER.2.0  14-AUG-83  15:20
comment *

                        SLASH.COM


        VERSION 2.0     14-AUG-83

        Written by      Warren Craycroft
                        6236 Oakdale Ave.
                        Oakland, CA  94605


        (C)  1983  by Warren Craycroft.  Permission is granted to copy and
        distribute this program, including source code, provided that no
        charge shall be made except for a reasonable charge for the media
        and handling, and that this notice shall remain intact in all copies.


*
comment *
        This program is a utility that can be used with DOS 2.0
        to help format the system console display, especially
        during execution of a batch file.  The program does this by
        parsing the command line entered with SLASH.  The syntax
        of the command line is shown below.  Brackets [] denote optional
        fields of the command line (the brackets themselves should not
        appear in the command line characters):

                SLASH [ / [ cmd1 [ cmd2 ...]] / ] [ <string>

        cmdi are one-letter commands listed below.

        If the first slash is present, then all one-letter commands
        recognized between first and second slash are executed in the
        order inwhich they occure left to right.

        If slashes are not present, the string is displayed with leading
        tabs and blanks removed.

        If slashes are present, all characters after the second slash are
        displayed, including all leading tabs and blanks.

        A carriage return - line feed is sent to the display at the end of
        a NON-null <string>.  If however the <string> is null, or if slashes
        are absent and string is all blanks and tabs, then no CR LF is displayed
               ( i.e. to skip a line, use SLASH/L and not SLASH )


        The one-letter commands include:

                L or l          skip one line

                B or b          sound buzzer

                D or d          print border across screen, double line



                INCLUDE THESE FILES WHEN ASSEMBLING

                        PARSER.INC

                        Q_CMDS.INC


*
;
;               constant equates
;
BEL_CHAR        EQU     07              ;ascii BEL keycode
CR              EQU     0DH             ;ascii carriage return
LF              EQU     0AH             ;ascii line feed
BLANK_CHAR      EQU     20H             ;ascii blank character
;
;       declare a relocatable segment.  Follow the .COM file requirements
;       of entry point at 100H and making all seg register references relative
;       to CS (no relocatable values MOV'ed into segment registers).
;
;
COM_CODE      SEGMENT
;
                ORG     80H             ;PSP offset 80:  user's command line
PSP_CMD_LINE    LABEL   BYTE            ;define a label for address refs
;
                ORG     100H            ;for COM file
;
;
                ASSUME  CS:COM_CODE,DS:COM_CODE    ;tell assembler value of CS
                                                   ; and DS
;
;       parse command line in PSP for commands inside slashes
;
;       leave CX pointing to first character after leading delimiters if no
;       slashes, or first char after second slash
;
START           PROC            FAR     ;FAR is meaningless; no RETS
;
;       address of PSP's command line into SI
;
                MOV     SI,OFFSET PSP_CMD_LINE
;
INCLUDE         PARSER.INC              ;bring in parser include file
;
;       if the string is not null (CX not zero), then display the
;       string and append a CR LF onto the string
;       Use single character DOS function; DOS string display function
;       will not display "$".
;
                MOV     AH,2            ;DOS fn call, 1 char display
                OR      CL,CL           ;is byte count of string zero?
                JE      EXIT            ;no display if yes
DISPLAY_LINE:   MOV     DL,[SI][BX]     ;next char into DL
                INT     21H             ;call DOS to display char
                INC     BX              ;point to next char
                LOOP    DISPLAY_LINE    ;and loop on char count
                CALL    SKIP            ;append CR LF onto end of string

;
;       return to DOS
;
EXIT:           INT     20H             ;return to DOS
START           ENDP
PAGE
INCLUDE         Q_CMDS.INC              ;bring in slash command tables and code
;
COM_CODE        ENDS
                END     START
age string
                MOV     AH,9            ;DOS fun code to display string