/*
                            VIDEODEM.C

Constructed by David Lovelock to demonstrate the use of the functions
described in the article "Assembly Video Routines for your PC" by
Thomas D. Webb, COMPUTER LANGUAGE, Vol. 3, No. 1, Jan 1986, pages 49-58.
Those source codes were revised so that they would compile and link with
Microsoft's C Compiler (Ver 3.00) and Microsoft's Macro Assembler (Ver 3.00),
and are distributed in a file called VIDEOMS.ASM.  A revised header file,
called VIDEOMS.H is also required.

*/

#include "stdio.h"     /* from Microsoft */
#include "malloc.h"    /* from Microsoft */
#include "videoms.h"   /* supplied with this demo */

main()
{
   unsigned size;                     /* for crtbuf()   ROUTINE 10 */
   char *video_buffer;                /* for crtbuf()   ROUTINE 10 */
   char *n;                           /* for scancrt()  ROUTINE 13 */
   char readstring[80];               /* for scancrt()  ROUTINE 13 */
   union                              /* for get_mode() ROUTINE  4 */
     {                                /* for get_mode() ROUTINE  4 */
     int value;                       /* for get_mode() ROUTINE  4 */
     struct                           /* for get_mode() ROUTINE  4 */
         {                            /* for get_mode() ROUTINE  4 */
         char al;                     /* for get_mode() ROUTINE  4 */
         char ah;                     /* for get_mode() ROUTINE  4 */
         } al_ah;                     /* for get_mode() ROUTINE  4 */
     } mode_area;                     /* for get_mode() ROUTINE  4 */
   int i, j, numbytes;

   size = 4096;                       /* for crtbuf()   ROUTINE 10 */
   video_buffer=malloc(size);         /* for crtbuf()   ROUTINE 10 */

   clear();                           /* ROUTINE 1 demo            */
   mode_area.value=get_mode();        /* ROUTINE 4 demo            */
   i=mode_area.al_ah.al;              /* ROUTINE 4 demo            */
   j=mode_area.al_ah.ah;              /* ROUTINE 4 demo            */
   printf("CRT mode = %d\n",i);       /* ROUTINE 4 demo            */
   printf("No. cols = %d\n",j);       /* ROUTINE 4 demo            */
   key();                             /* ROUTINE 3 and 7 demo      */

   for (i=0;i<=15;i++)
     for (j=0;j<=15;j++)
      isrtstr(j,4*i,"ABC ",j+i*16);   /* displays all avail attrbs */
   key();
   crtbuf(0,video_buffer);            /* saves current screen ROUTINE 10 */

   clear();
   key();

   crtbuf(1,video_buffer);            /* restores saved screen ROUTINE 10 */
   getch();

   clear();
   locate(5,5);                       /* ROUTINE 2  demo           */
   putchat('A',REVERSE);              /* ROUTINE 9  demo           */
   numbytes=7;
   isrtcnt(6,15,"1234567890",NORMAL,numbytes);
                                      /* ROUTINE 8  demo           */
   numbytes=5;
   scancrt(6,15,readstring,numbytes); /* ROUTINE 13 demo           */
   n=&readstring[0];                  /* how to add a zero         */
   n=n+numbytes;                      /* to make it a legal        */
   *n=0;                              /* string.                   */
   key();

   clear();
   locate(1,1);
   printf("%s",readstring);           /* proof that scanstr is OK! */
   key();
}
/*  key() demonstrates cursize() and isrtstr(), ROUTINEs 3 and 7.
The first call to cursize() makes the cursor invisible - the second visible.
Before returning the PRESS ANY KEY message is erased, which is why it is
not saved by CRTBUF.
*/

key()
{
   cursize(13,13);
   isrtstr(22,22,"                                 ",BLINK_REVERSE_VIDEO);
   isrtstr(23,22," Please PRESS ANY KEY when ready ",BLINK_REVERSE_VIDEO);
   isrtstr(24,22,"                                 ",BLINK_REVERSE_VIDEO);
   getch();
   isrtstr(22,22,"                                 ",NORMAL);
   isrtstr(23,22,"                                 ",NORMAL);
   isrtstr(24,22,"                                 ",NORMAL);
   cursize(6,13);
}