/*
       PCIO.C
       6/22/87 D.A. Knapp
       
       This set of subroutines is a subset of the screen routines
       found in PCIO which comes with DeSmet C.  I have simply
       rewritten them in Microsoft C.  They are also compatible with
       Turbo C.

   The functions are:
      scr_rowcol(row,col)       move the cursor to row,column
            int row,col;

      scr_curpos(&row,&col)     get the current cursor position
            int row,col;

      char scr_sinp()           returns the character under the cursor

      scr_clr()                 clear the screen and reset colors

      scr_color(fcolor,bcolor)  clear the screen and set default colors
            int fcolor,bcolor;

      scr_clrl()                clear from the cursor to the end of line

      scr_scrup(numLines,fromRow,fromCol,toRow,toCol)
            char numLines,fromRow,fromCol,toRow,toCol;
                                scroll a portion of the screen  (can also
                                be used to clear a portion of the screen
                                by setting numLines=0)

      scr_aputs(string,attr)    put a character string with attributes to
            char *string,attr;  the screen

*/
       
#include <stdio.h>
#include <dos.h>

char color_scr;         /* global variable of default screen color */

scr_rowcol(row,col)
	int row,col;
{
	union REGS inregs,outregs;
	char row1,col1;
	row1 = (row & 0x00FF);
	col1 = (col & 0x00FF);
	inregs.h.ah = 2;
	inregs.h.al = 0;
	inregs.h.dh = row1;
	inregs.h.dl = col1;
	inregs.h.bh = 0;
	int86(0x10,&inregs,&outregs);
	return;
}

scr_curpos(rowp,colp)
	int *rowp,*colp;
{
	union REGS inregs,outregs;
	inregs.h.ah = 3;
	inregs.h.al = 0;
	inregs.h.bh = 0;
	int86(0x10,&inregs,&outregs);
	*rowp = outregs.h.dh;
	*colp = outregs.h.dl;
	return;
}

char scr_sinp()
{
	union REGS inregs,outregs;
	inregs.h.ah = 8;
	inregs.h.bh = 0;
	int86(0x10,&inregs,&outregs);
	return outregs.h.al;
}
	
scr_clr()
{
	union REGS inregs,outregs;
	inregs.h.ah = 6;
	inregs.h.al = 0;
	inregs.h.ch = 0;
	inregs.h.cl = 0;
	inregs.h.dh = 25;
	inregs.h.dl = 80;
	inregs.h.bh = 7;
	color_scr = 7;
	int86(0x10,&inregs,&outregs);
	return;
}

scr_clrl()
{
	union REGS inregs,outregs;
	inregs.h.ah = 3;
	inregs.h.al = 0;
	inregs.h.bh = 0;
	int86(0x10,&inregs,&outregs);
	inregs.h.ah = 6;
	inregs.h.al = 0;
	inregs.h.ch = outregs.h.dh;
	inregs.h.cl = outregs.h.dl;
	inregs.h.dh = outregs.h.dh;
	inregs.h.dl = 80;
	inregs.h.bh = color_scr;
	int86(0x10,&inregs,&outregs);
	return;
}

scr_color(fcolor,bcolor)
	int fcolor,bcolor;
{
	union REGS inregs,outregs;
	inregs.h.ah = 6;
	inregs.h.al = 0;
	inregs.h.ch = 0;
	inregs.h.cl = 0;
	inregs.h.dh = 25;
	inregs.h.dl = 80;
	color_scr = ((fcolor + ((bcolor << 4) & 0xF0)) & 0xFF);
	inregs.h.bh = color_scr;
	int86(0x10,&inregs,&outregs);
	return;
}

scr_scrup(numLines,fromRow,fromCol,toRow,toCol)
	char numLines,fromRow,fromCol,toRow,toCol;
{
	union REGS inregs,outregs;
	inregs.h.ah = 6;
	inregs.h.al = numLines;
	inregs.h.ch = fromRow;
	inregs.h.cl = fromCol;
	inregs.h.dh = toRow;
	inregs.h.dl = toCol;
	inregs.h.bh = color_scr;
	int86(0x10,&inregs,&outregs);
	return;
}


scr_aputs(string,attr)
	char *string,attr;
{
	union REGS inregs,outregs;
	char *str;
	str = string;
	inregs.h.bh = 0;
	inregs.h.ah = 3;
	int86(0x10,&inregs,&outregs);
	inregs.x.dx = outregs.x.dx;
	inregs.x.cx = 1;
	while (*str != 0) {
		if (*str == '\n') {
			inregs.h.al = 13;
			inregs.h.ah = 14;
			int86(0x10,&inregs,&outregs);
		}
		else {
			inregs.h.al = *str;
			inregs.h.ah = 9;
			inregs.h.bl = attr;
			int86(0x10,&inregs,&outregs);
			inregs.h.dl++;
			inregs.h.ah = 2;
			int86(0x10,&inregs,&outregs);
		}
		str++;		
	}
}
