; INTHAND.ASM
;
; Copyright (c) 1986 Peter W. Gofton
; Interrupt handler for IBM PC Serial i/o
; Designed to interface with Microsoft 'C'
; Compile as: MASM INTHAND;
;
;------------------------------------------------------------------------

_TEXT	SEGMENT  BYTE PUBLIC 'CODE'
_TEXT	ENDS

ASSUME  CS: _TEXT, DS: NOTHING, SS:NOTHING, ES:NOTHING


_TEXT      SEGMENT

; Create a stack for use by the 'C' function

intstack DB 256 DUP (?)

EXTRN _myds:WORD

EXTRN _cfunct:NEAR

;--------------------------------------------------------------------------
PUBLIC _inthand

_inthand    PROC NEAR
; 
; This function is called automatically by the interrupt mechanism.
; cfunct() must be a function which takes any necessary action such as 
; receiving or transmitting characters

; We know when we get here that CS is the same as the CS containing
; out 'C' code, since CS and IP were saved in the interrupt vector.

; But DS may be anything, and the 'C' function will need it to access
; the data. So we have to restore it before calling cfunct()


    STI            ; Enable interrupts

    PUSH    AX     ; Save all registers
    PUSH    BX
    PUSH    CX
    PUSH    DX
    PUSH    SI
    PUSH    DI
    PUSH    DS
    PUSH    ES
    
    MOV    AL, 20H
    OUT    20H, AL

    MOV    SI, OFFSET _myds
    MOV    DS, CS:[SI]

    PUSH    SS
    PUSH    CS
    POP     SS
    MOV     SP, offset intstack

    CALL    _cfunct             ; Call the 'C' function

    POP     SS
    POP    ES                   ; Restore all registers
    POP    DS
    POP    DI
    POP    SI
    POP    DX
    POP    CX
    POP    BX
    POP    AX

    IRET

_inthand endp
;--------------------------------------------------------------------------
_TEXT    ENDS

END
;--------------------------------------------------------------------------






; Figure 17.2: Interrupt Handler Gate

