typedef    struct {
   int count;                /* number of chars now in the buffer          */
   int start;                /* offset of next characte to take            */
   int size;                 /* size of the buffer                         */
   char *buffer;             /* Address of the buffer                      */
} RING;

/*_________________________________________________________________________*/
void initbuf(r, addr, len)
register RING *r;
char *addr;
int len;

/*
* initialize a RING buffer
*/

{
    r -> count   = 0;
    r -> start   = 0;
    r -> buffer  = addr;
    r -> size    = len;
}
/*_______________________________________________________________________*/
void putbuf(r, ch)
register RING *r;
char   ch;

/*
* Put a character into a RING buffer
*/

{
int offset;

    offset = (r -> start + r -> count) % r -> size; 
                                                 /* Position for new char  */
                                                                     
    r -> buffer[offset] = ch;                    /* place char in buffer   */

    if (r -> count >= r -> size) {
                                                 /* overflow?              */
       r -> start++;                             /* move starting point    */

       if (r -> start >= r -> size)              /* Start is beyond end    */
          r -> start -= r -> size;               /* Rotate it              */

    }

    else {
       r -> count++;                             /* just update the count  */
    }
}
/*_________________________________________________________________________*/
int getbuf(r, ch)
register RING    *r;
char *ch;
/*
* Get a character from a RING buffer
* Returns 0 if buffer is empty.
*/
{

    if (r -> count == 0)                         /* Nothing there          */
         return (0);                             /* return 'failure'       */

    *ch = r -> buffer[r -> start];               /* get next char to take  */

    r -> start++;                                /* move starting point    */

    if (r -> start >= r -> size) {               /* Do not overflow        */
       r -> start = 0;
    }

    r -> count--;                                /* One less char there    */

    return(1);                                   /* return 'success'       */
}
/*_________________________________________________________________________*/

/* Figure 16.11: Circular Buffer Creation */


