/*
 *  File name:		iolib2.c
 *
 *  Belongs to:		System C library extension
 *  Description:	DOS 2.0 I/O routines for C86 (small memory model only)
 *
 *  Version:		1.0
 *  Last change:	None - original code
 *  Author:		Alan Batie
 */
 
#include "stdio.h"
#inclu0stc;tc0}ttgett:t
rtt3t
sttatt  t_nttt
t nt}tt.rte)t5t}rtt ;tgrtkti	;t
s.;s sr  	r s.xfs/
e h=
 ;sh

i/  ;ge 	.;ul
t ;.d;ut
x)sr  	r s.x	e  g
re
; dt	  hoie	o	 sxd 
tsgs	 xf/  	r s.x	
e
*re)sg_
	pn sar;aeR
ad*
nrNn0r  	r s.x{blo s.x	*d e
emdrd
*rt 
 
n)es.
 Ss tsal
_
 	r s.x	
drh 	yael
re /

t 	ssldr
d






































































































t
l
_
 	r s.;s sr  	r s.xfeu
ne;	fef
.s	/  	r s.x	tus

	a
e( 	 
otsr(h kg 

ur(h kyrr(	/  	r s.l * x
(h );;aLas)t(ts a
t*eea _grrg/  	r s.laa_;
r	(sd1 ;a(ese	(.		gblo s.;s sr  	rh

sa
 ie	uCRe e eiag reun	ra x
s0  s;n
tslgc=s%.	fed
o;;n
{(xhffn&gc s;n &x *go a	rrA		.	ae /																																 
t*c
u iddedE
e{;r

	%.	Ler1
 
a
n&g ts&(
*g)	rrA ee s
 s;n
/i=utsdorA
a	rr=;

*
 	s
e
	*2cm 
u_ef
	a
e( 	 
otsr(h kg 

ur(h kymm
igrsrde


O	t
Ytedor=;a;


0a%.	trgorA	 gp r;;n &l
.*gorArs pa/g{
cg	 r hses g	mgiG
;ttri=us
u	rtu*r
%.	L
x 
r;;n &l_x
gorArs pa/g{
cg	 r hses g	mgiG
;ttri=us
u	rtu*r
%.	fee s
{ 
	r Cse	mdf s;n &l
.;sk0	tt?=uetRxhfa	rr=;

*
 	s
 s;n &l
.;s		
et Ytedor=;

*
 	s
e
s0
 Csessaesm
igrsrde


O	t
Ytedor=;a;


0a%.	trgorA ee s
S
eo Cse	mdf s;n &l_x{eose
tto =uetRxhfa	rr=;

*
 	s
e
	;cubE	
fse	md;	Sg

sfYtedor=;

*
 	s
 s;n &l_xSg

sfYtedor=;

*
 	s
e&;
igrsrde


O	t
Ytedor=;a;


0a%.	trgorA}r oO}ef s;n &*x2sidorA ee s
d(
	OR

*
sa	glamgtC gs	RiY
.;ulaeu gigha 	 mErfigrsrde


O	t
YtedorArs pa/g{
 ?C	n;

t
e ett/i=us
ur;dorA
a	rr=*n
 e

fr;
 tdor=Olorre
 gr)/ &	a


(x..etrorr =a	rrr 

*
 
t


=

f
stsRx.

tgs	g
 %.=(s(x.) fpa/g{
 tgsR
ddtuf 
;
t
gorr rdgra;t
gorre
 gr)/ &s.


(x.u

*
 
t

&s.
{

stsRx..
t*c
u edorr rdgra;t
gorre
	ufls*f

(x.u

*
 
t
 tse etedorr =tgs	g
 %. uuRxh_dorAff igao{ 
stsRxht f igaoS
etedorAf
ess 		io_err2 = regs.ax;
		return(-1);
		}
	else
		{
		return(regs.ax);
		}
	}
 
/*  Read file  */
 
int read2(fd, buffer, count)
	int fd;
	char *buffer;
	unsigned int count;
	{
	struct reg_set regs;
	struct seg_set segs;
	int flags;
 
	segread(&segs);
 
	regs.ax = 0x3F00;
	regs.bx = fd;
	regs.cx = count;
	regs.dx = buffer;
	regs.ds = segs.stack_seg;
 
	flags = SYSCALL();
	if (ERROR)
		{
		io_err2 = regs.ax;
		return(-1);
		}
	else
		{
		return(regs.ax);
		}
	}
 
/*  Write current path name  */
 
int write2(fd, buffer, count)
	int fd;
	char *buffer;
	int count;
	{
	struct reg_set regs;
	struct seg_set segs;
	int flags;
 
	segread(&segs);
 
	regs.ax = 0x4000;
	regs.bx = fd;
	regs.cx = count;
	regs.dx = buffer;
	regs.ds = segs.stack_seg;
 
	flags = SYSCALL();
	if (ERROR)
		{
		io_err2 = regs.ax;
		return(-1);
		}
	else
		{
		return(regs.ax);
		}
	}
 
/*  Seek to just after last valid entry  */
 
long lseek2(fd, offset, base)
	int fd;
	long offset;
	int base;
	{
	struct reg_set regs;
	struct seg_set segs;
	int flags;
 
	segread(&segs);
 
	regs.ax = 0x4200;
	regs.bx = fd;
	regs.cx = offset >> 16;
	regs.dx = offset & 0xFFFF;	/*  offset % 65536  */
 
	flags = SYSCALL();
	if (ERROR)
		{
		io_err2 = regs.ax;
		return(-1);
		}
	else
		{
		return(((long) regs.dx << 16) | regs.ax);
		}
	}
 
/*  Write a character to specified file  */
 
fputc2(c, fd)
	char c;
	{
	write2(fd, &c, 1);
	}
 
/*  Write a string to standard output  */
 
fputs2(str, fd)
	char *str;
	{
	write2(fd, str, strlen(str));
	}