C                                 STAT-SAK
C                            The Statistician's
C                             Swiss Army Knife   
C                               Version 2.15
C                            February 11, 1987
C
C                       "One of many STATOOLS(tm)..."
C                                    by
C
C                             Gerard E. Dallal
C                             53 Beltran Street
C                             Malden, MA  02148
C
C
C                                  NOTICE
C
C       Documentation and original code  copyright  1985  and 1986 by  
C       Gerard E. Dallal. Reproduction of material for non-commercial
C       purposes is permitted, without charge, provided that suitable 
C       reference is made to STAT-SAK and its author.  
C
C       Neither  STAT-SAK nor its documentation should be modified in 
C       any way without permission from the author,  except for those 
C       changes  that  are  essential  to move   STAT-SAK to  another 
C       computer.  
C
      CHARACTER*2 QUERY
      DATA IIN /0/, IOUT /0/, NOPT /10/, QUERY /'  '/
C
      WRITE(IOUT,1)
    1 FORMAT (////35X,'STAT-SAK'/
     *   30X,'The Statistician''s'/
     *   31X,'Swiss Army Knife'/
     *   33X,'Version 2.15'/29X,'(c) 1985, 1986, 1987'//
     *   26X,'"One of many STATOOLS(tm)..."'/
     *   38X,'by'//
     *   31X,'Gerard E. Dallal'/
     *   31X,'53 Beltran Street'/
     *   31X,'Malden, MA  02148'/////)
C
   30 WRITE(IOUT,40) 
   40 FORMAT (/' Enter ''Q'' to quit, press  <ENTER>  to continue:  '$)
      READ (IIN,50) QUERY
   50 FORMAT (A2)
   55 CALL UPCASE(QUERY)
      IF (QUERY.EQ.'Q ') STOP ' '
      IF (QUERY.EQ.'  ') GOTO 60
      CALL OPTION(QUERY,NPICK)
      
      IF (NPICK.LT.1 .OR. NPICK.GT.NOPT) GOTO 60
C
      GOTO (100,200,300,400,500,600,700,800,900,1000), NPICK
C

C
   60 WRITE(IOUT,70)
   70 FORMAT(/' Your options are:'//
     *        '  DF -- distribution functions'/
     *        '  CT -- independence in ',
     *        'two-dimensional contingency tables'/
     *        '  FI -- Fisher''s exact test for 2*2 tables'/
     *        '  MH -- Mantel-Haenszel test / odds ratios'/
     *        '  MC -- McNemar''s test'/
     *        '  CC -- correlation coefficients'/
     *        '  BP -- Bartholomew''s test for increasing proportions'/
     *        '  BM -- Bartholomew''s test for increasing means'/
     *        '  T1 -- one sample t-test from summary statistics'/
     *        '  T2 -- two sample t-test from summary statistics'/)
C
      WRITE(IOUT,80)
   80 FORMAT(' Your choice?:  ',$)
      READ(IIN,50) QUERY
      GOTO 55
C
  100 CALL PROB(IIN,IOUT)
      GOTO 30
C
  200 CALL GOF(IIN,IOUT)
      GOTO 30
C
  300 CALL MANTEL(IIN,IOUT)
      GOTO 30
C
  400 CALL MCNEMR(IIN,IOUT)
      GOTO 30 
C
  500 CALL CORR(IIN,IOUT)
      GOTO 30
C
  600 CALL BART(IIN,IOUT)
      GOTO 30
C 
  700 CALL TTEST1(IIN,IOUT)
      GOTO 30
C
  800 CALL TTEST2(IIN,IOUT)
      GOTO 30
C
  900 CALL OMEANS(IIN,IOUT)
      GOTO 30
C
 1000 CALL FISHER(IIN,IOUT)
      GOTO 30
C
      END
C
      SUBROUTINE UPCASE(TEXT)
      CHARACTER*2 TEXT
      CHARACTER*26 UPPER, LOWER
      DATA UPPER / 'ABCDEFGHIJKLMNOPQRSTUVWXYZ' /
      DATA LOWER / 'abcdefghijklmnopqrstuvwxyz' /
C
      DO 100 I = 1, 2
      IF (TEXT(I:I).LE.'Z' .OR. TEXT(I:I).EQ.' ') GOTO 100
      DO 90 K = 1, 26
      IF (TEXT(I:I).NE.LOWER(K:K)) GOTO 90
      TEXT(I:I) = UPPER(K:K)
      GOTO 100
   90 CONTINUE
  100 CONTINUE
      RETURN
      END
C
      SUBROUTINE OPTION(TEXT,NO)
C
      CHARACTER*2 TEXT, LIST(10)
      DATA NOPT /10/
C      
      DATA LIST(1), LIST(2), LIST(3), LIST(4)
     *   /    'DF',    'CT',    'MH',    'MC'/
      DATA LIST(5), LIST(6), LIST(7), LIST(8), LIST(9), LIST(10)
     *  /     'CC',    'BP',    'T1',    'T2',    'BM',     'FI'/
C
      DO 100 I = 1, NOPT
      NO = I
      IF (TEXT.EQ.LIST(I)) RETURN
  100 CONTINUE
      NO = NO + 1
      RETURN
      END
C
      FUNCTION ALGAMA(S)
C
C        CACM ALGORITHM 291
C        LOGARITHM OF GAMMA FUNCTION
C        BY PIKE, M.C. AND HILL, I.D.
C
C        TRANSLATED INTO FORTRAN BY
C                   Gerard E. Dallal
C                   USDA-Human Nutrition Research Center on Aging
C                              at Tufts University
C                   711 Washington Street
C                   Boston, MA  02111
C
C
      X = S
      ALGAMA = 0.0
      IF (X .LE. 0.0) RETURN
      F = 0.0
      IF (X .GE. 7.0) GOTO 30
C
      F = 1.0
      Z = X - 1.0
C
   10 Z = Z + 1.0
      IF (Z .GE. 7.0) GOTO 20
      X = Z
      F = F * Z
      GOTO 10
C
   20 X = X + 1
      F = -ALOG(F)
C
   30 Z = 1.0 / X ** 2
      ALGAMA = F + ( X - 0.5) * ALOG(X) - X + 0.918938533204673 +
     1   (((-0.000595238095238 * Z + 0.000793650793651) * Z
     2   - 0.002777777777778) * Z + 0.083333333333333) / X
      RETURN
      END
C
      FUNCTION ALNORM(X,UPPER)
C
C        ALGORITHM AS 66 APPL. STATIST. (1973) VOL.22, NO.3
C
C        EVALUATES THE TAIL AREA OF THE STANDARD NORMAL CURVE
C        FROM X TO INFINITY IF UPPER IS .TRUE. OR
C        FROM MINUS INFINITY TO X IF UPPER IS .FALSE.
C
      REAL LTONE, UTZERO, ZERO, HALF, ONE, CON, Z, Y, X
      LOGICAL UPPER, UP
C
C        LTONE AND UTZERO MUST BE SET TO SUIT THE PARTICULAR
C        COMPUTER (SEE INTRODUCTORY TEXT)
C
      DATA LTONE, UTZERO/7.0, 18.66/
      DATA ZERO, HALF, ONE, CON/0.0, 0.5, 1.0, 1.28/
      UP = UPPER
      Z = X
      IF (Z .GE. ZERO) GOTO 10
      UP = .NOT. UP
      Z = -Z
   10 IF (Z .LE. LTONE .OR. UP .AND. Z .LE. UTZERO) GOTO 20
      ALNORM = ZERO
      GOTO 40
   20 Y = HALF * Z * Z
      IF (Z .GT. CON) GOTO 30
C
      ALNORM = HALF - Z * (0.398942280444 - 0.399903438504 * Y /
     1   (Y + 5.75885480458 - 29.8213557808 /
     2   (Y + 2.62433121679 + 48.6959930692 /
     3   (Y + 5.92885724438))))
      GOTO 40
C
   30 ALNORM = .398942280385 * EXP(-Y) /
     1   (Z - 3.8052E-8 + 1.00000615302 /
     2   (Z + 3.98064794E-4 + 1.98615381364 /
     3   (Z - 0.151679116635 + 5.29330324926 /
     4   (Z + 4.8385912808 - 15.1508972451 /
     5   (Z + 0.742380924027 + 30.789933034 / (Z + 3.99019417011))))))
C
   40 IF (.NOT. UP) ALNORM = ONE - ALNORM
      RETURN
      END
C
      SUBROUTINE BART(IIN,IOUT)
C
C              BARTHOLOMEW'S TEST FOR ORDERED SAMPLES (INCREASING)
C
      DIMENSION CT(10),X(2,10),P(10)
      CHARACTER*1 QUERY
C
    3 WRITE(IOUT,4)
    4 FORMAT(/' Enter the number of columns [.LE.10]:  ',$)
      READ(IIN,*,ERR=3) NCOL
      IF(NCOL.LT.2 .OR. NCOL.GT.10) GOTO 3
C
    8 WRITE (IOUT,9)
    9 FORMAT(' Do you wish to enter two rows (R) or ',
     *       'one row with column totals (T)?:  '$)
      READ (IIN,10) QUERY
   10 FORMAT(A1)
      IF (QUERY.NE.'R' .AND. QUERY.NE.'r' .AND. 
     *   QUERY.NE.'T' .AND. QUERY.NE.'t') GO TO 8
C
      WRITE (IOUT,5)
    5 FORMAT(' ')
    6 WRITE(IOUT,7) 
    7 FORMAT('         Enter row 1:  ',$)
      READ(IIN,*,ERR=6) (X(1,J), J = 1, NCOL)
      IF (QUERY.EQ.'2') GOTO 16
C
      IF (QUERY.EQ.'R' .OR. QUERY.EQ.'r') GOTO 16
   11 WRITE (IOUT,12)
   12 FORMAT(' Enter column totals:  ',$)
      READ(IIN,*,ERR=11) (CT(J), J = 1, NCOL)
      GOTO 18
C
   16 WRITE(IOUT,17) 
   17 FORMAT('         Enter row 2:  ',$)
      READ(IIN,*,ERR=16) (X(2,J), J = 1, NCOL)
C
C              GET COL TOTALS AND P'S
C
   18 PNUM=0.
      PDEN=0.
      DO 19 J=1,NCOL
      IF (QUERY.EQ.'R' .OR. QUERY.EQ.'r') CT(J)=X(1,J)+X(2,J)
      P(J)=X(1,J)/CT(J)
      PNUM=PNUM+X(1,J)
      PDEN=PDEN+CT(J)
   19 CONTINUE
      PBAR=PNUM/PDEN
C
C              PEARSON CHI-SQUARE STATISTIC
C
      PX2 = 0.0
      DO 25 J = 1, NCOL
      E11 = PBAR * CT(J)
      PX2 = Px2 + (X(1,J) - E11)**2 * (1.0 / E11 + 1.0 / (CT(J) - E11))
   25 CONTINUE
C
C              BARTHOLOMEW'S TEST
C              FIRST MASSAGE TABLE
C
      DO 50 J=2,NCOL
      IF (P(J-1).LE.P(J)) GO TO 50
C
C              P DECREASES...DETERMINE VALUE BY 'COLLAPSING'
C              SO THAT SEQUENCE IS MONOTONE
C
      PNUM=P(J-1)*CT(J-1)+P(J)*CT(J)
      PDEN=CT(J-1)+CT(J)
      PX=PNUM/PDEN
C
C              IS IT NECESSARY TO GO FURTHER BACK?
C
      JS=J-1
      IF (JS.EQ.1) GO TO 30
      JM2=J-2
      DO 29 I=1,JM2
      IF (P(JS-1).LE.PX) GO TO 30
      JS=JS-1
      PNUM=PNUM+P(JS)*CT(JS)
      PDEN=PDEN+CT(JS)
      PX=PNUM/PDEN
   29 CONTINUE
   30 DO 40 J1=JS,J
   40 P(J1)=PX
   50 CONTINUE
C
C              CALCULATE STATISTIC
C
      CHISQ=0.
      DO 70 J=1,NCOL
   70 CHISQ=CHISQ+CT(J)*(P(J)-PBAR)**2
      CHISQ=CHISQ/(PBAR*(1.-PBAR))
C
      WRITE (IOUT,80)CHISQ
   80 FORMAT(/' Chi-square statistic for order restriction = ',G11.4)
C
C              INDICES FOR USE WITH TABLES
C
      CALL PBART(CHISQ,PVAL,NCOL,DIFF,2,CT)
      IF (NCOL.EQ.3 .OR. NCOL.EQ.4) WRITE(IOUT,90) PVAL
   90 FORMAT ('                            P-value (exact) = ',F7.3)
      IF (NCOL.NE.3 .AND.NCOL.NE.4) WRITE(IOUT,100) PVAL
  100 FORMAT ('           P-value (assuming equal weights) = ',F7.3)
C
  200 DIFF = PX2 - CHISQ
      PDIFF = CHIDFC(DIFF,NCOL-1)
      WRITE(IOUT,210) PX2, DIFF, PDIFF
  210 FORMAT(/' Pearson chi-square statistic =',F8.2,5X,
     * /'     Difference (lack of fit) =',F8.2,5X,'(P-value <',F6.3,')')
C
      RETURN
      END
C
      FUNCTION BETAIN(X,P,Q)
C
C        ALGORITHM AS 63  APPL.STATIST. (1973), VOL.22, NO.3
C        MODIFIED AS PER REMARK ASR 19  (1977), VOL.26, NO. 1
C        ***[FAULT INDICATOR REMOVED BY G.E.D.]***
C
C        COMPUTES INCOMPLETE BETA FUNCTION RATIO FOR ARGUMENTS
C        X BETWEEN ZERO AND ONE, P AND Q POSITIVE.
C        LOG OF COMPLETE BETA FUNCTION, BETA, ASSUMED TO BE KNOWN.
C        ***[CALCULATION OF BETA ADDED BY G.E.D]***
C
      LOGICAL INDEX
C
C        DEFINE ACCURACY AND INITIALIZE
C
      DATA ACU /0.1E-7/
      BETAIN = X 
C
C        TEST FOR ADMISIBILITY OF AGRUMENTS
C
      IF (P .LE. 0.0 .OR. Q .LE. 0.0) STOP 40
      IF (X .LT. 0.0 .OR .X .GT. 1.0) STOP 41
      IF (X .EQ .0.0 .OR .X .EQ. 1.0) RETURN
C
C     CHANGE TAIL IF NECESSARY AND DETERMINE S
C
      PSQ = P + Q
      CX = 1.0 - X
      IF (P .GE .PSQ * X) GOTO 1
      XX = CX
      CX = X
      PP = Q
      QQ = P
      INDEX = .TRUE.
      GOTO 2
    1 XX = X
      PP = P
      QQ = Q
      INDEX = .FALSE.
    2 TERM = 1.0
      AI = 1.0
      BETAIN = 1.0
      NS = QQ + CX * PSQ
C
C        USE SOPER'S REDUCTION FORMULAE
C
      RX = XX / CX
    3 TEMP = QQ - AI
      IF (NS .EQ. 0) RX = XX
    4 TERM = TERM * TEMP * RX / (PP + AI)
      BETAIN = BETAIN + TERM
      TEMP = ABS(TERM)
      IF (TEMP .LE. ACU .AND. TEMP .LE. ACU * BETAIN) GOTO 5
      AI = AI + 1.0
      NS = NS - 1
      IF (NS .GE. 0) GOTO 3
      TEMP = PSQ
      PSQ = PSQ + 1.0
      GOTO 4
C
C        CALCULATE RESULT
C
    5 BETA = ALGAMA(P) + ALGAMA(Q) - ALGAMA(P+Q)
      BETAIN = BETAIN * 
     *     EXP(PP * ALOG(XX) + (QQ - 1.0) * ALOG(CX) - BETA) / PP
      IF (INDEX) BETAIN = 1.0 - BETAIN
      RETURN
      END
C
      FUNCTION CHIDFC(X,NDF)
C
C        RETURNS P(CHISQ(NDF).GT.X), WHERE CHISQ(NDF) IS A CHI-SQUARE
C        RANDOM VARIABLE WITH 'NDF' DEGREES OF FREEDOM.
C
C        IF  X.LE.0, RETURNS THE VALUE 1.0
C
C        UPPER TAIL RECURRENCE FORMULA...
C           Q(X/NDF)=Q(X/NDF-2)+X**(NDF/2-1)*EXP(-X/2)/GAMMA(NDF/2),
C              WHERE Q(X/NDF) IS THE UPPER TAIL, (X, INFINITY), OF THE
C              CHI-SQUARE DISTRIBUTION WITH 'NDF' DEGREES OF FREEDOM.
C        SEE HANDBOOK OF MATHEMATICAL FUNCTIONS,
C        NBS,55(1964),26.4.8
C
C        USES WILSON-HILFERTY APPROXIMATION FOR NDF.GT.NDFBIG
C        NBS HANDBOOK, 24.4.17
C           (X/NDF)**(1./3.) IS APPROXIMATLEY NORMALLY DISTRIBUTED
C           WITH MEAN 1.-2./(9.*NDF) AND VARIANCE 2./(9.*NDF)
C
C        REQUIRES FUNCTIONS ALNORM, ALGAMA
C
C        WRITTEN BY  Gerard E. Dallal
C                    USDA-Human Nutrition Research Center on Aging
C                               at Tufts University
C                    711 Washington Street
C                    Boston, MA  02111
C
C
C        EXPBIG IS A NUMBER GREATER THAN THE MOST NEGATIVE VALID
C           ARGUMENT TO THE EXP() FUNCTION.
C
      DATA NDFBIG /60/, EXPBIG /-80.0/
C
      CHIDFC = 1.0
      IF (X .LE. 0.0 .OR. NDF .LT. 1) RETURN
      CHIDFC = 0.
      DF = NDF
      IF (NDF .GT. NDFBIG) GOTO 50
      HX = X / 2.0
      IF ((NDF / 2) * 2 .EQ. NDF) GOTO 30
C
C        ODD NUMBER OF DEGREES OF FREEDOM
C
      IF (NDF .EQ. 1) GOTO 20
C
      INDEX = (NDF - 1) / 2
      DO 10 I = 1, INDEX
      C = FLOAT(I) + 0.5
      D = (C - 1.0) * ALOG(HX) - HX - ALGAMA(C)
      IF (D .GT. EXPBIG) CHIDFC = CHIDFC + EXP(D)
   10 CONTINUE
   20 CHIDFC = CHIDFC + 2.0 * ALNORM (SQRT(X), .TRUE.)
      RETURN
C
C        EVEN NUMBER OF DEGREES OF FREEDOM
C
   30 INDEX = NDF / 2
      DO 40 I = 1, INDEX
      C = I
      D =(C - 1.0) * ALOG(HX) - HX - ALGAMA(C)
      IF (D .GT. EXPBIG) CHIDFC = CHIDFC + EXP(D)
   40 CONTINUE
      RETURN
C
   50 D = 2.0 / (9.0 * DF)
      D = ((X / DF) ** (1.0 / 3.0) + D - 1.0) / SQRT(D)
      CHIDFC = ALNORM(D, .TRUE.)
      RETURN
      END
C
      SUBROUTINE CORR(IIN,IOUT)
C
      CHARACTER*1 QUERY
C
   10 WRITE (IOUT,20)
   20 FORMAT (/'   0 -- test that a population correlation '
     *   'coefficient is zero'/
     *         '   1 -- confidence interval for a single '
     *   'correlation coefficient'/
     *         '   2 -- compare two independent correlation '
     *   'coefficients'//' Pick one:  ',$)
      READ (IIN,30) QUERY
   30 FORMAT (A1)
      IF (QUERY.NE.'0' .AND. QUERY.NE.'1' .AND. QUERY.NE.'2') GOTO 10
C
      IF (QUERY.EQ.'0') CALL CORR0(IIN,IOUT)
      IF (QUERY.EQ.'1') CALL CORR1(IIN,IOUT)
      IF (QUERY.EQ.'2') CALL CORR2(IIN,IOUT)
      RETURN
      END
C
      SUBROUTINE CORR0(IIN,IOUT)
C
  110 WRITE(IOUT,120)
  120 FORMAT(/' Enter sample correlation coefficient:  '$)
      READ(IIN,*,ERR=110) R
      IF(ABS(R).GT.1) GOTO 110
  130 WRITE(IOUT,140)
  140 FORMAT(' Enter number of observations:  '$)
      READ(IIN,*,ERR=130) FN
      IF (FN.LT.3.0) GOTO 130
C
      T = SQRT(FN - 2.0) * R / SQRT(1.0 - R**2)
      NDF = FN - 2.0
      P = FDFC(T**2,1.0,FLOAT(NDF))
      WRITE (IOUT,210) T, NDF, P
  210 FORMAT (
     *   /'   t = ',G11.4,5X,'(',I4,' d.f.)',5X,'P-value = ',F6.4)
C
      RETURN
      END
C
      SUBROUTINE CORR1(IIN,IOUT)
C
C        TWO-SIDED CONFIDENCE LIMITS FOR A POPULATION CORRELATION
C        COEFFICIENT.  TRANSLATED FROM THE BASIC PROGRAM ON P.300 OF
C          MAINDONALD, J.H.(1984)  STATISTICAL COMPUTATION.
C          NEW YORK:  JOHN WILEY & SONS, INC.
C
C        USES APPROXIMATION FROM 
C          WINTERBOTTOM, ALAN (1980).  ESTIMATION FOR THE BIVARIATE
C          NORMAL CORRELATION COEFFICIENT USING ASYMPTOTIC EXPANSIONS 
C
C        THREE DIGIT ACCURACY FOR SAMPLES OF 10
C        NEARLY FOUR DIGIT ACCURACY FOR SAMPLES OF 25 OR MORE     
C
      FNA(X,R,V,Z) = Z + X / SQRT(V) - R / (2.0 * V) + X * (X**2 +
     *   3.0 * (1.0 + R**2)) / (12.0 * V * SQRT(V))
      FNB(X,R,V) = R * (4.0 * (R * X)**2 + 5.0 * R**2 + 9.0) /
     *   (24.0 * V**2)
      FNC(X,R3,R4,V) = X * (X**4 + R3 * X**2 + R4) / 
     *   (480.0 * V**2 * SQRT(V))
      FNT(X,R,R3,R4,V,Z) = FNA(X,R,V,Z) - FNB(X,R,V) + FNC(X,R3,R4,V)
      FNR(Z) = (EXP(2.0 * Z) - 1.0) / (EXP(2.0 * Z) + 1.0)

C
   90 WRITE (IOUT,100)
  100 FORMAT(/' Enter confidence level (0,1):  '$)
      READ(IIN,*,ERR=90) CONF
      IF (CONF.LE.0.0 .OR. CONF.GE.1.0) GOTO 90
      Z0 = -GAUINV((1.0 - CONF)/ 2.0,IFAULT)
C
  110 WRITE(IOUT,120)
  120 FORMAT(' Enter sample correlation coefficient'
     *   'and number of observations:  '$)
      READ(IIN,*,ERR=110) R,N2
      IF(ABS(R).GE.1 .OR. N2.LE.2) GOTO 110
C
      V = N2 - 1
      Z = 0.5 * ALOG((1.0 + R) / (1.0 - R))
      R3 = 60.0 * R**4 - 30.0 * R**2 + 20.0
      R4 = 165.0 * R**4 + 30.0 * R**2 + 15.0
      X = -Z0
      Z1 = FNT(X,R,R3,R4,V,Z)
      X = Z0
      Z2 = FNT(X,R,R3,R4,V,Z)
      R1 = FNR(Z1)
      R2 = FNR(Z2)
      WRITE(IOUT,150) 100.0*CONF,R1,R2
  150 FORMAT (/' The ',F4.1,'-% confidence interval is (',
     *   F7.4,', ',F7.4,')')
      RETURN
      END
C
      SUBROUTINE CORR2(IIN,IOUT)
C
C             USES FISHER'S Z TO COMPARE TWO CORRELATION COEFFICENTS
C
   10 WRITE (IOUT,20) 
   20 FORMAT(/' Enter first  correlation coefficient'
     *   'and sample size:  '$)
   30 READ (IIN,*,ERR=10) CC1, N1
      IF(ABS(CC1).GE.1.0 .OR. N1.LE.2) GOTO 10
C
  110 WRITE (IOUT,120) 
  120 FORMAT(/' Enter second correlation coefficient'
     *   'and sample size:  '$)
  130 READ (IIN,*,ERR=110) CC2, N2
      IF(ABS(CC2).GE.1.0 .OR. N2.LE.2) GOTO 110
C
C
      Z = 0.0
      P = 0.0
      IF (N1.LE.3 .OR. N2.LE.3) GOTO 400
C
      CC1 = 0.5 * ALOG((1.0 + CC1) / (1.0 - CC1))
      CC2 = 0.5 * ALOG((1.0 + CC2) / (1.0 - CC2))
      Z = ABS(CC1 - CC2)/ SQRT(1.0 / FLOAT(N1 - 3) + 
     *   1.0 / FLOAT(N2 - 3))
      P = 2.0 * ALNORM(Z,.TRUE.)
C
  400 WRITE(IOUT,410) Z, P
  410 FORMAT (/' Test statistic = ',G11.4,'      P-value = ',F5.3)
      RETURN
      END
C
      FUNCTION FDFC(FQUAN, DFN, DFD)
C
C        THE COMPLEMENT OF THE CDF OF THE F DISTRIBUTION
C        WITH DFN NUMERATOR DEGREES OF FREEDOM AND DFD DENOMINATOR 
C        DEGREES OF FREEDOM EVALUATED AT FQUAN.
C
C
      ESQ = DFD / (DFD + DFN * FQUAN)
      FDFC = BETAIN (ESQ, DFD/2.0, DFN / 2.0)
      RETURN
      END
C
      SUBROUTINE FDFC0(IIN, IOUT, NPICK)
C
C        GET INFO FOR F-DISTRIBUTION CALCULATION
C
      IF(NPICK.EQ.1) GOTO 200
   10 WRITE (IOUT,20)
   20 FORMAT(/' Enter numerator degrees of freedom:  '$)
      READ (IIN,*,ERR=10) DFN
   30 WRITE (IOUT,40)
   40 FORMAT(' Enter denominator degrees of freedom:  '$)
      READ (IIN,*,ERR=30) DFD
   50 WRITE (IOUT,60)
   60 FORMAT(' Enter F quantile:  '$)
      READ (IIN,*,ERR=50) FQUAN
      PVAL = FDFC(FQUAN,DFN,DFD)
      WRITE (IOUT,80) PVAL
   80 FORMAT (/' Upper tail probability =',F8.5)
      RETURN
C
  200 WRITE (IOUT,210)
  210 FORMAT(/' Enter upper tail probability:  '$)
      READ(IIN,*,ERR=200) PVAL
      IF(PVAL.LT.0.0 .OR. PVAL.GT.1.0) GOTO 200
  220 WRITE (IOUT,20)
      READ (IIN,*,ERR=220) DFN
  230 WRITE (IOUT,40)
      READ (IIN,*,ERR=230) DFD
      BETA = XINBTA(DFD/2.0,DFN/2.0,PVAL)
      F = (1.0/BETA -1.0)*DFD/DFN
      WRITE (IOUT,240) F
  240 FORMAT(' Quantile:  ',G11.4)
      RETURN   
      END
C
      FUNCTION GAMAIN(X,P)
C
C        ALGORITHM AS 32 J.R.STATIST.SOC. C. (1970) VOL.19 NO.3
C
C        COMPUTES INCOMPLETE GAMMA RATIO FOR POSITIVE VALUES OF
C        ARGUMENTS X AND P.  G MUST BE SUPPLIED AND SHOULD BE EQUAL TO
C        LN(GAMMA(P)).
C        IFAULT = 1 IF P.LE.0 ELSE 2 IF X.LT.0 ELSE 0
C        USES SERIES EXPANSION IF P.GT.X OR X.LE.1, OTHERWISE A 
C        CONTINUED FRACTION APPROXIMATION.C
C
C        [FAULT INDICATOR REMOVED BY G.E.D
C        CALCULATION OF G INSERTED BY G.E.D.]
C
      DIMENSION PN(6)
C
C        DEFINE ACCURACY AND INITIALIZE
C
      ACU = 1.0E-8
      OFLO = 1.0E30
      GIN = 0.0
C
C        TEST FOR ADMISSIBILITY OF ARGUMENTS
C
      IF (P .LE. 0.0) STOP 21
      IF (X .LT. 0.0) STOP 22
      IF (X .EQ. 0.0) GOTO 50
      G = ALGAMA(P)
      FACTOR = EXP(P * ALOG(X) - X - G)
      IF (X .GT. 1.0 .AND. X .GE. P) GOTO 30
C
C        CALCULATION BY SERIES EXPANSION
C
      GIN = 1.0
      TERM = 1.0
      RN = P
   20 RN = RN + 1.0
      TERM = TERM * X / RN
      GIN = GIN + TERM
      IF (TERM .GT. ACU) GOTO 20
      GIN = GIN * FACTOR / P
      GOTO 50
C
C        CALCULATION BY CONTINUED FRACTION
C
   30 A = 1.0 - P
      B = A + X + 1.0
      TERM = 0.0
      PN(1) = 1.0
      PN(2) = X
      PN(3) = X + 1.0
      PN(4) = X * B
      GIN = PN(3) / PN(4)
   32 A = A + 1.0
      B = B + 2.0
      TERM = TERM + 1.0
      AN = A * TERM
      DO 33 I = 1, 2
   33 PN(I+4) = B * PN(I+2) - AN * PN(I)
      IF (PN(6) .EQ. 0.0) GOTO 35
      RN = PN(5) / PN(6)
      DIF = ABS(GIN - RN)
      IF (DIF .GT. ACU) GOTO 34
      IF (DIF .LE. ACU * RN) GOTO 42
   34 GIN = RN
   35 DO 36 I = 1, 4
   36 PN(I) = PN(I+2)
      IF (ABS(PN(5)).LT.OFLO) GOTO 32
      DO 41 I = 1, 4
   41 PN(I) = PN(I) / OFLO
      GOTO 32
   42 GIN = 1.0 - FACTOR * GIN
C
   50 GAMAIN = GIN
      RETURN
      END
C
      FUNCTION GAUINV(P,IFAULT)
C
C              ALGORITHM AS 70 APPL. STATIST. (1974) VOL. 23, NO.1
C              GAUINV FINDS PERCENTAGE POINTS OF THE NORMAL DISTRIBUTION
C
      DATA ZERO,ONE,HALF,ALIMIT/0.0, 1.0, 0.5, 1.0E-20/
C
      DATA             P0,  P1,             P2,                P3
     1   / -.322232431088, -1., -.342242088547, -.204231210245E-1/
C
      DATA                P4,               Q0,            Q1
     1   / -.453642210148E-4, .993484626060E-1, .588581570495/
C
      DATA            Q2,            Q3,              Q4
     1   / .531103462366, .103537752850, .38560700634E-2/
C
      IFAULT=1
      GAUINV=ZERO
      PS=P
      IF (PS.GT.HALF) PS=ONE-PS
      IF (PS.LT.ALIMIT) RETURN
      IFAULT=0
      IF (PS.EQ.HALF) RETURN
      YI=SQRT(ALOG(ONE/(PS*PS)))
      GAUINV=YI+((((YI*P4+P3)*YI+P2)*YI+P1)*YI+P0)
     1         /((((YI*Q4+Q3)*YI+Q2)*YI+Q1)*YI+Q0)
      IF (P.LT.HALF) GAUINV=-GAUINV
      RETURN
      END
C
      SUBROUTINE GOF(IIN,IOUT)
C
C        TEST OF INDEPENDENCE AND HOMOGENEITY OF VARIANCE
C        FOR TWO-DIMENSIONAL CONTINGENCY TABLES
C
C        LIMITATIONS:  NO MORE THAN FIVE ROWS OR COLUMNS.
C
      INTEGER ITABLE(5,10), IR(5), IC(10)
      CHARACTER*1 QUERY
      DATA NROW /5/, NCOL /10/
C
   30 WRITE(IOUT,70) NROW
   70 FORMAT(/2X,'Enter the number of rows [.LE.',I1,']:  ',$)
      READ(IIN,*,ERR=30) LROW
   75 WRITE(IOUT,80) NCOL
   80 FORMAT(2X,'Enter the number of columns [.LE.',I2,']:  ',$)
      READ(IIN,*,ERR=75)LCOL
      IF(LROW.LE.NROW.AND.LCOL.LE.NCOL)GO TO 100
      WRITE(IOUT,90)
   90 FORMAT(2X,'*** Permissible table dimensions exceeded')
      GO TO 30
C
  100 WRITE (IOUT,110)
  110 FORMAT(' ')
      DO 130 I = 1, LROW
  125 WRITE(IOUT,120) I
  120 FORMAT(2X,'Enter row #',I1,':  ',$)
      READ(IIN,*,ERR=125)(ITABLE(I,J), J = 1, LCOL)
  130 CONTINUE

      DO 140 J = 1, LCOL
      IC(J) = 0
      DO 140 I = 1, LROW
      IC(J) = IC(J) + ITABLE(I,J)
  140 CONTINUE
C
C        COMPUTE ROW SUMS AND GRAND TOTAL
C
      GRAND = 0.0
      DO 160 I = 1, LROW
      IR(I) = 0
      DO 150 J = 1, LCOL
      IR(I) = IR(I) + ITABLE(I,J)
  150 CONTINUE
      GRAND = GRAND + FLOAT(IR(I))
  160 CONTINUE
C
C        COMPUTE CHI-SQUARE P-VALUES
C
  180 CHISQ = 0.0
      DO 190 I = 1, LROW
      DO 190 J = 1, LCOL
      EXPECT = FLOAT(IR(I)) * FLOAT(IC(J)) / GRAND
      CHISQ = CHISQ + (FLOAT(ITABLE(I,J)) - EXPECT)**2 / EXPECT
  190 CONTINUE
      NDF = (LROW - 1) * (LCOL - 1)
      PCHI = CHIDFC(CHISQ,NDF)
      WRITE(IOUT,200) CHISQ,NDF,PCHI
  200 FORMAT(/'  Pearson chi-square equals ',G11.4,' with',I3,
     *   ' d.f.  (P-value = ',F7.5,')')
C
      IF (LROW.GT.2 .OR. LCOL.GT.2) GOTO 290
C
C        YATES'S CONTINUITY CORRECTED CHI-SQUARE STATISTIC
C
      YCHISQ = 0.0
      DO 201 I = 1, 2
      DO 201 J = 1, 2
      EXPECT = FLOAT(IR(I)) * FLOAT(IC(J)) / GRAND
      YCHISQ = YCHISQ + (ABS(FLOAT(ITABLE(I,J)) - EXPECT) - 0.5)**2 
     *   / EXPECT
  201 CONTINUE
      YPCHI = CHIDFC(YCHISQ,1)
      WRITE(IOUT,202) YCHISQ,YPCHI
  202 FORMAT ('  Yates''s corrected chi-square equals ',G11.4,
     *   '     (P-value = ',F7.5,')')

  290 WRITE(IOUT,300)
  300 FORMAT(/2X,'Entering another table?  (Y or N):  '$)
      READ(IIN,310) QUERY
  310 FORMAT (A1)
      IF (QUERY.EQ.'Y' .OR. QUERY.EQ.'y') GOTO 30
      RETURN
      END
C
      SUBROUTINE MCNEMR(IIN,IOUT)
C
C        MCNEMAR'S TEST 
C        EXACT--USES BINOMIAL(n,0.5) DISTRIBUTION
C
   90 WRITE(IOUT,100)
  100 FORMAT (/' Enter two discordant cells:  '$)
      READ(IIN,*,ERR=90) B, C
C
      XNOBS = B + C
      XNOBS1 = XNOBS + 1.0
      NSTAT = MIN1(B,C)
      PVAL = 0.0
      DO 70 I = 0, NSTAT
      TERM = ALGAMA(XNOBS1) - ALGAMA(FLOAT(I+1)) - 
     *   ALGAMA(XNOBS1-FLOAT(I)) - XNOBS * ALOG(2.0)
      IF (TERM.GT.-78.0) PVAL = PVAL + EXP(TERM)
   70 CONTINUE
      PVAL = AMIN1(1.0, 2.0 * PVAL)
C
      WRITE(IOUT,120) PVAL
  120 FORMAT(/' P-value = ',F6.4)
      RETURN
      END
C
      FUNCTION PPCHI2(P,V)
C
C        ALGORITHM AS 91  APPL. STATIST. (1975) VOL.24, NO.3
C
C        TO EVALUATE THE PECENTAGE POINTS OF THE CHI-SQUARED
C        PROBABILITY DISTRIBUTION FUNCTION.
C        P MUST LIE IN THE RANGE 0.000002 TO 0.999998, V MUST BE POSITIVE,
C        G MUST BE SUPPLIED AND SHOULD BE EQUAL TO LN(GAMMA(V/2.0))
C
C        [FAULT INDICATOR REMOVED BY G.E.D.  
C        CALCULATION OF G ADDED BY G.E.D.
C
      DATA E, AA /0.5E-6, 0.6931471805/
C
C        AFTER DEFINING THE ACCURACY AND LN(2), TEST ARGUMENTS AND INITIALIZE
C
      PPCHI2 = -1.0
      IF (P .LT. 0.000002 .OR. P .GT. 0.999998) STOP 31
      IF (V .LE. 0.0) STOP 32
      G = ALGAMA(V / 2.0)
      XX = 0.5 * V
      C = XX - 1.0
C
C        STARTING APPROXIMATION FOR SMALL CHI-SQUARED
C
      IF (V .GE. -1.24 * ALOG(P)) GOTO 1
      CH = (P * XX * EXP(G + XX * AA)) ** (1.0 / XX)
      IF (CH - E) 6, 4, 4
C
C        STARTING APPROXIMATION FOR V LESS THAN OR EQUAL TO 0.32
C
    1 IF (V .GT. 0.32) GOTO 3
      CH = 0.4
      A = ALOG(1.0 - P)
    2 Q = CH
      P1 = 1.0 + CH * (4.67 + CH)
      P2 = CH * (6.73 + CH * (6.66 + CH))
      T = -0.5 + (4.67 + 2.0 * CH) / P1 -
     *   (6.73 + CH * (13.32 + 3.0 * CH)) / P2
      CH = CH - (1.0 - EXP(A + G + 0.5 * CH + C * AA) * P2 / P1) / T
      IF (ABS(Q / CH - 1.0) - 0.01) 4, 4, 2
C
C        CALL TO ALGORITHM AS 70 - NOTE THAT P HAS BEEN TESTED ABOVE
C
    3 X = GAUINV(P,IF1)
C
C        STARTING APPROXIMATION USING WILSON AND HILFERTY ESTIMATE
C
      P1 = 0.222222 / V
      CH = V * (X * SQRT(P1) + 1.0 - P1) ** 3
C
C        STARTING APPROXIMATION FOR P TENDING TO 1
C
      IF (CH .GT. 2.2 * V + 6.0)
     *   CH = -2.0 * (ALOG(1.0 - P) - C * ALOG(0.5 * CH) + G)
C
C        CALL TO ALGORITHM AS 32 AND CALCULATION OF SEVEN TERM
C        TAYLOR SERIES
C
    4 Q = CH
      P1 = 0.5 * CH
      P2 = P - GAMAIN(P1, XX)
      T = P2 * EXP(XX * AA + G + P1 - C * ALOG(CH))
      B = T / CH
      A = 0.5 * T - B * C
      S1 = (210.0+A*(140.0+A*(105.0+A*(84.0+A*(70.0+60.0*A))))) / 420.0
      S2 = (420.0+A*(735.0+A*(966.0+A*(1141.0+1278.0*A)))) / 2520.0
      S3 = (210.0 + A * (426.0 + A * (707.0 + 932.0 * A))) / 2520.0
      S4 =(252.0+A*(672.0+1182.0*A)+C*(294.0+A*(889.0+1740.0*A)))/5040.0
      S5 = (84.0 + 264.0 * A + C * (175.0 + 606.0 * A)) / 2520.0
      S6 = (120.0 + C * (346.0 + 127.0 * C)) / 5040.0
      CH = CH+T*(1.0+0.5*T*S1-B*C*(S1-B*(S2-B*(S3-B*(S4-B*(S5-B*S6))))))
      IF (ABS(Q / CH - 1.0) .GT. E) GOTO 4
C
    6 PPCHI2 = CH
      RETURN
      END
C
      SUBROUTINE PROB(IIN, IOUT)
C
C        PROBABILITY CALCULATION
C
      CHARACTER*2 QUERY
      DATA MAXDIST /10/, KNORM /1/, KT /3/, KCHISQ /5/, KF /7/
C
      QUERY = ' '
   10 WRITE(IOUT,20) 
   20 FORMAT (/' Enter ''R'' to return to main menu,',
     *   '  press  <ENTER>  to continue:  '$)
   30 READ (IIN,40) QUERY
   40 FORMAT (A2)
      CALL UPCASE(QUERY)
      IF (QUERY.EQ.'R ') RETURN
      IF (QUERY.EQ.'Q ') STOP ' '
      IF (QUERY.EQ.'  ') GOTO 50
      CALL DFOPT(QUERY,NDIST)
      IF (NPICK.GT.MAXDIST) GOTO 10
      GOTO (100,100,200,200,300,300,400,400,500,600), NDIST
C
   50 WRITE (IOUT,60)
   60 FORMAT (/' Your options are:'//
     *   '       NQ -- standard normal:  quantile to probability'/
     *   '       NP -- standard normal:  probability to quantile'/
     *   '       TQ -- Student''s t:  quantile to probability'/
     *   '       TP -- Student''s t:  probability to quantile'/
     *   '       CQ -- chi-square:  quantile to probability'/
     *   '       CP -- chi-square:  probability to quantile'/
     *   '       FQ -- F:  quantile to probability'/
     *   '       FP -- F:  probability to quantile'/
     *   '       BI -- binomial'/
     *   '       P  -- Poisson'//
     *   ' Your choice?:  '$)
      GOTO 30
C
  100 CALL N01(IIN,IOUT,NDIST-KNORM)
      GOTO 10
C
  200 CALL STUDNT(IIN,IOUT,NDIST-KT)
      GOTO 10
C
  300 CALL X2DFC0(IIN,IOUT,NDIST-KCHISQ)
      GOTO 10
C
  400 CALL FDFC0(IIN,IOUT,NDIST-KF)
      GOTO 10
C
  500 CALL BINOM(IIN,IOUT)
      GOTO 10
C
  600 CALL POISN(IIN,IOUT)
      GOTO 10
      END
C
      SUBROUTINE DFOPT(TEXT,NO)
C
      CHARACTER*2 TEXT, LIST(10)
      DATA NOPT /10/
C      
      DATA LIST(1), LIST(2), LIST(3), LIST(4), LIST(5)
     *   /    'NQ',    'NP',    'TQ',    'TP',    'CQ'/
      DATA LIST(6), LIST(7), LIST(8), LIST(9), LIST(10)
     *  /     'CP',    'FQ ',   'FP',    'BI',     'P '/
C
      DO 100 I = 1, NOPT
      NO = I
      IF (TEXT.EQ.LIST(I)) RETURN
  100 CONTINUE
      NO = NO + 1
      RETURN
      END
C
      SUBROUTINE TTEST1(IIN,IOUT)
C
C        ONE SAMPLE T TEST FROM SUMMARY STATISTICS
C
      CHARACTER*1 QUERY
C
   10 WRITE (IOUT,20)
   20 FORMAT(/' Does the summary include a standard deviation (D) or '/
     *        '                              a standard error (E)?:  '$)
      READ (IIN,30) QUERY
   30 FORMAT(A1)
      IF (QUERY.NE.'D' .AND. QUERY.NE.'d' .AND. 
     *   QUERY.NE.'E' .AND. QUERY.NE.'e') GO TO 10
C
      IF (QUERY.EQ.'E' .OR. QUERY.EQ.'e') GOTO 140
C
C        STANDARD DEVIATION
C
   40 WRITE (IOUT,50)
   50 FORMAT (/' Enter the mean, standard deviation, and sample size:')
      READ (IIN,*,ERR=40) XBAR, SD, FN
      SE = SD / SQRT(FN)
      GOTO 200
C
C        STANDARD ERROR
C
  140 WRITE (IOUT,150)
  150 FORMAT (/' Enter the mean, standard error, and sample size:')
      READ (IIN,*,ERR=140) XBAR, SE, FN
C
  200 T = XBAR / SE
C
      NDF = FN - 1.0
C
      P = FDFC(T**2,1.0,FLOAT(NDF))
C
      WRITE (IOUT,210) T, NDF, P
  210 FORMAT (
     *   /'   t = ',G11.4,5X,'(',I4,' d.f.)',5X,'P-value = ',F6.4)
      RETURN
      END
C
      SUBROUTINE TTEST2(IIN,IOUT)
C
C        T TEST FOR INDEPENDENT SAMPLES FROM SUMMARY STATISTICS
C
      CHARACTER*1 QUERY
C
   10 WRITE (IOUT,20)
   20 FORMAT(/' Do the summaries include standard deviations (D) or '/
     *        '                              standard errors (E)?:  '$)
      READ (IIN,30) QUERY
   30 FORMAT(A1)
      IF (QUERY.NE.'D' .AND. QUERY.NE.'d' .AND. 
     *   QUERY.NE.'E' .AND. QUERY.NE.'e') GO TO 10
C
      IF (QUERY.EQ.'E' .OR. QUERY.EQ.'e') GOTO 140
C
C        STANDARD DEVIATIONS
C
   40 WRITE (IOUT,50)
   50 FORMAT (/' Enter the mean, standard deviation, and sample size',
     *   ' for sample 1:')
      READ (IIN,*,ERR=40) XBAR1, SD1, FN1
      SE1 = SD1 / SQRT(FN1)
   60 WRITE (IOUT,70)
   70 FORMAT (' Enter the mean, standard deviation, and sample size',
     *   ' for sample 2:')
      READ (IIN,*,ERR=60) XBAR2, SD2, FN2
      SE2 = SD2 / SQRT(FN2)
      GOTO 200
C
C        STANDARD ERRORS
C
  140 WRITE (IOUT,150)
  150 FORMAT (/' Enter the mean, standard error, and sample size',
     *   ' for sample 1:')
      READ (IIN,*,ERR=140) XBAR1, SE1, FN1
      SD1 = SE1 * SQRT(FN1)
  160 WRITE (IOUT,170)
  170 FORMAT (' Enter the mean, standard error, and sample size',
     *   ' for sample 2:')
      READ (IIN,*,ERR=160) XBAR2, SE2, FN2
      SD2 = SE2 * SQRT(FN2)
C
C        EQUAL VARIANCES
C
  200 XBARD = XBAR1 - XBAR2
      IFN1 = FN1
      IFN2 = FN2
      SDP = SQRT((((FN1 - 1.0) * SD1 * SD1 + (FN2 - 1.0) * SD2 * SD2)
     *   / (FN1 + FN2 - 2.0)))
      SEDEQ = SDP * SQRT(1.0 / FN1 + 1.0 / FN2)
      TEQ = XBARD / SEDEQ
      NDFEQ = FN1 + FN2 - 2.0
      PEQ = FDFC(TEQ**2,1.0,FLOAT(NDFEQ))
C
       WRITE(IOUT,210) XBAR1, XBAR2, XBARD, SD1, SD2, IFN1, IFN2
  210 FORMAT (/24X,'sample 1      sample 2     difference'/
     *   17X,'mean',3G14.5/
     *   3X,'standard deviation',2G14.5/
     *   10X,'sample size',I10,I14)
C
C        UNEQUAL VARIANCES
C
      IF (FN1.LE.1.0 .OR. FN2.LE.1.0 .OR. SD1.EQ.0.0 .OR. SD2.EQ.0.0) 
     *   GOTO 225
      SEDNEQ = SQRT(SE1 * SE1 + SE2 * SE2)
      TNEQ = XBARD / SEDNEQ
      C = SE1**2 / (SE1**2 + SE2**2)
      DFNEQ = 1.0 / ( C**2 / (FN1 - 1.0) + (1.0 - C)**2 / (FN2 - 1.0))
      PNEQ = FDFC(TNEQ**2, 1.0, DFNEQ)
      FRAT = SD1**2 / SD2**2
      NDFN = FN1 - 1.0
      NDFD = FN2 - 1.0
      IF (FRAT.GE.1.0) GOTO 219
      NDFD = FN1 - 1.0
      NDFN = FN2 - 1.0
      FRAT = 1.0 / FRAT
  219 PF =  2.0 * FDFC(FRAT,FLOAT(NDFN),FLOAT(NDFD))
      WRITE (IOUT,220) SDP, FRAT, NDFN, NDFD, PF
  220 FORMAT (/'      Pooled standard deviation:  ',G12.5//
     *   ' F-test for equality of variances:  F-ratio:  ',F7.2/
     *   '                             numerator d.f.:',I9/
     *   '                           denominator d.f.:',I9/
     *   '                                    P-value:  ',F7.4/)
C
  225 WRITE (IOUT,230) TEQ, NDFEQ, PEQ
  230 FORMAT (
     *   /'   Equal variances:  t = ',G11.4,5X,'(',I4,'   d.f.)',5X,
     *   'P-value = ',F6.4)
      IF (FN1.GT.1.0 .AND. FN2.GT.1.0 .AND. SD1.GT.0.0 .AND. 
     *   SD2.GT.0.0)  WRITE (IOUT,240) TNEQ, DFNEQ, PNEQ
  240 FORMAT (
     *    ' Unequal variances:  t = ',G11.4,5X,'(',F6.1,' d.f.)',5X,
     *   'P-value = ',F6.4)
C
      CIU = XINBTA(FLOAT(NDFEQ)/2.0, 0.5, 0.05)
      CIU = SQRT(FLOAT(NDFEQ)*(1.0/ CIU - 1.0))
      CIL = XBARD - CIU * SEDEQ
      CIU = XBARD + CIU * SEDEQ
      WRITE(IOUT,350) SEDEQ, CIL, CIU
  350 FORMAT (/'   Equal variances:  standard error of difference:  ',
     *   G12.5/
     *   21X,'95% C.I. for mean difference:  (',G12.5,' ,',G12.5')')
      IF (FN1.LE.1.0 .OR. FN2.LE.1.0 .OR. SD1.EQ.0.0 .OR. SD2.EQ.0.0) 
     *   RETURN
C
      CIU = XINBTA(DFNEQ/2.0, 0.5, 0.05)
      CIU = SQRT(DFNEQ*(1.0/ CIU - 1.0))
      CIL = XBARD - CIU * SEDNEQ
      CIU = XBARD + CIU * SEDNEQ
      WRITE(IOUT,360) SEDNEQ, CIL, CIU
  360 FORMAT (/' Unequal variances:  standard error of difference:  ',
     *   G12.5/
     *   21X,'95% C.I. for mean difference:  (',G12.5,' ,',G12.5')'/)
C
      RETURN
      END
C
      SUBROUTINE X2DFC0(IIN, IOUT, NPICK)
C
C        CHI-SQUARE DISTRIBUTION
C
      IF(NPICK.EQ.1) GOTO 200
C
   30 WRITE (IOUT,40)
   40 FORMAT(/' Enter chi-square quantile:  '$)
      READ (IIN,*,ERR=30) CHISQ
C
  110 WRITE (IOUT,120)
  120 FORMAT(' Enter degrees of freedom:  '$)
      READ (IIN,*,ERR=110) DF
      IF (DF.NE.FLOAT(IFIX(DF))) GOTO 110
      NDF = DF
      PVAL = CHIDFC(CHISQ,NDF)
      WRITE (IOUT,150) PVAL
  150 FORMAT (' Upper tail probability =',F8.5)
      RETURN
C
  200 WRITE (IOUT,210)
  210 FORMAT(/' Enter upper tail probability:  '$)
      READ(IIN,*,ERR=200) PVAL
      IF(PVAL.LT.0.0 .OR. PVAL.GT.1.0) GOTO 200
  220 WRITE (IOUT,230)
  230 FORMAT(' Enter degrees of freedom:  '$)
      READ (IIN,*,ERR=220) DF
      WRITE(IOUT,250) PPCHI2(1.0 - PVAL,DF)
  250 FORMAT (' Upper tail percentile = ',G12.5)
      RETURN
      END
C
      SUBROUTINE STUDNT(IIN, IOUT, NPICK)
C
C        INFORMATION FOR STUDENT'S T-DISTRIBUTION
C
      IF(NPICK.EQ.0) GOTO 230
C
   10 WRITE (IOUT,20)
   20 FORMAT(/' Enter upper tail probability:  '$)
      READ(IIN,*,ERR=10) PVAL
      IF(PVAL.LE.0.0 .OR. PVAL.GE.1.0) GOTO 10
   30 WRITE (IOUT,40)
   40 FORMAT(' Enter degrees of freedom:  '$)
      READ (IIN,*,ERR=30) DF
      T = XINBTA(DF/2.0, 0.5, 2.0 * AMIN1(PVAL,1.0-PVAL))
      T = SQRT(DF*(1.0/ T - 1.0))
      IF (PVAL.GT.0.5) T = -T
      WRITE(IOUT,50) T
   50 FORMAT (' Upper tail percentile: ',F8.3)
      RETURN
C
  230 WRITE (IOUT,240)
  240 FORMAT(/' Enter t quantile:  '$)
      READ (IIN,*,ERR=230) T
  250 WRITE (IOUT,260)
  260 FORMAT(' Enter degrees of freedom:  '$)
      READ (IIN,*,ERR=250) DF
      IF (DF.NE.FLOAT(IFIX(DF))) GOTO 250
      NDF = DF
      PVAL = 0.5 * FDFC(T**2,1.0,DF)
      IF (T.GT.0) PVAL = 1.0 - PVAL
C
      WRITE(IOUT,270) 1.0 - PVAL, PVAL, 
     *   2.0 * AMIN1(1.0 - PVAL, PVAL)
  270 FORMAT(/25X,'Upper tail = ',F7.4,
     *       /25X,'Lower tail = ',F7.4,
     *       /25X,'Two-tailed = ',F7.4)
      RETURN
      END
C
      SUBROUTINE N01(IIN, IOUT, NPICK)
C
C        INFORMATION FOR STANDARD NORMAL DISTRIBUTION
C
      IF(NPICK.EQ.1) GOTO 200
C
  130 WRITE (IOUT,140)
  140 FORMAT(/' Enter quantile:  '$)
      READ (IIN,*,ERR=130) Z
      ZC = Z      
      IF (Z.NE.0.0) GOTO 160
  150 WRITE (IOUT,155)
  155 FORMAT (' Enter A,B,C.  STAT-SAK will use A / (B / SQRT(C)):')
      READ (IIN,*,ERR=150) A,B,C
      Z = A / (B / SQRT(C))
  160 PVAL = ALNORM(Z,.TRUE.)
C
      IF (ZC.EQ.0.0) WRITE (IOUT,165) Z
  165 FORMAT(
     *       /25X,'         z = ',F7.3)
      WRITE(IOUT,170) PVAL, 1.0 - PVAL, 
     *   2.0 * AMIN1(1.0 - PVAL, PVAL)
  170 FORMAT(/25X,'Upper tail = ',F7.4,
     *       /25X,'Lower tail = ',F7.4,
     *       /25X,'Two-tailed = ',F7.4)
      RETURN
C
  200 WRITE (IOUT,210)
  210 FORMAT(/' Enter upper tail probability:  '$)
      READ(IIN,*,ERR=200) PVAL
      IF(PVAL.LT.0.0 .OR. PVAL.GT.1.0) GOTO 200
      WRITE(IOUT,250) ABS(GAUINV(PVAL,IFAULT))
  250 FORMAT (/' Quantile = ',G12.5)
      RETURN
      END
C
       SUBROUTINE OMEANS(IIN,IOUT)
C
C              BARTHOLOMEW'S TEST FOR ORDERED SAMPLES (INCREASING)
C
      DIMENSION XBAR(10), SD(10), SE(10), FN(10), DF(10)
      LOGICAL QSD
      CHARACTER*1 QUERY
      CHARACTER FNAME*50
      DATA IFIN /10/
C
    3 WRITE(IOUT,4)
    4 FORMAT(/' Enter the number of samples [.LE.10]:  ',$)
      READ(IIN,*,ERR=3) NSAM
      IF(NSAM.LT.2 .OR. NSAM.GT.10) GOTO 3
      TDF = NSAM - 1
C
    8 WRITE (IOUT,9)
    9 FORMAT(' Do you wish to enter standard errors (E) or ',
     *       'standard deviations (D)?:  '$)
      READ (IIN,10) QUERY
   10 FORMAT(A1)
      IF (QUERY.NE.'D' .AND. QUERY.NE.'d' .AND. 
     *   QUERY.NE.'E' .AND. QUERY.NE.'e') GO TO 8
      QSD = .TRUE.
      IF (QUERY.EQ.'E' .OR. QUERY.EQ.'e') QSD = .FALSE.
C
      WRITE (IOUT,900)
  900 FORMAT(' Are data contained in an external file?  (Y or N):  '$)
      READ (IIN,10) QUERY
      IF (QUERY.NE.'Y' .AND. QUERY.NE.'y') GOTO 999
  905 WRITE (IOUT,910)
  910 FORMAT (' Enter filename:  '$)
      READ (IIN,'(A)') FNAME
      OPEN (IFIN, FILE = FNAME, STATUS = 'OLD', IOSTAT =IOCHK)
      IF (IOCHK.NE.0) GOTO 905
      IF (QSD) GOTO 950
C
      WRITE (IOUT,920)
  920 FORMAT (/'    Mean      S.E.        count'/)
      DO 940 I = 1, NSAM
      READ (IFIN,*) XBAR(I), SE(I), FN(I)
      WRITE (IOUT,930) XBAR(I), SE(I), FN(I)
      SD(I) = SE(I) * SQRT(FN(I))
  930 FORMAT (1X,2G11.4,F8.0)
  940 CONTINUE
      CLOSE (IFIN)
      GOTO 26
C
  950 WRITE (IOUT,960)
  960 FORMAT (/'    Mean      S.D.        count'/)
      DO 970 I = 1, NSAM
      READ (IFIN,*) XBAR(I), SD(I), FN(I)
      WRITE (IOUT,930) XBAR(I), SD(I), FN(I)
      SE(I) = SD(I) / SQRT(FN(I))
  970 CONTINUE
      CLOSE (IFIN)
      GOTO 26      
C
C
  999 IF (QSD) GOTO 16
      DO 14 I = 1, NSAM
   11 WRITE (IOUT,12) I
   12 FORMAT(' Enter mean, standard error, and sample size for sample',
     *   I3,':')
      READ(IIN,*,ERR=11) XBAR(I), SE(I), FN(I)
      SD(I) = SE(I) * SQRT(FN(I))
   14 CONTINUE
      GOTO 26
C
   16 DO 25 I = 1, NSAM
   18 WRITE (IOUT,19) I
   19 FORMAT(' Enter mean, standard deviation, and sample size for ',
     *'sample',I3,':')
      READ(IIN,*,ERR=18) XBAR(I), SD(I), FN(I)
      SE(I) = SD(I) / SQRT(FN(I))
   25 CONTINUE
C
C              GET BETWEEN GROUP SUM OF SQUARES
C
   26 TBAR = 0.0
      TN = 0.0
      DO 27 I = 1, NSAM
      DF(I) = 1.0
      TBAR = TBAR + XBAR(I) * FN(I)
      TN = TN + FN(I)
   27 CONTINUE
      TBAR = TBAR / TN
C
      BSS = 0.0
      WSS = 0.0
      DO 28 I = 1, NSAM
      BSS = BSS + FN(I) * (XBAR(I) - TBAR)**2
      WSS = WSS + (FN(I) - 1.0) * SD(I)**2
   28 CONTINUE
C
C              BARTHOLOMEW'S TEST
C
      DO 50 J=2,NSAM
      IF (XBAR(J-1).LE.XBAR(J)) GO TO 50
C
C              MEAN DECREASES...DETERMINE VALUE BY POOLING
C              SO THAT SEQUENCE IS MONOTONE
C
      DF(J-1) = 0.0
      PNUM = FN(J-1) * XBAR(J-1) + FN(J) * XBAR(J)
      PDEN = FN(J-1) + FN(J)
      PX=PNUM/PDEN
C
C              IS IT NECESSARY TO GO FURTHER BACK?
C
      JS=J-1
      IF (JS.EQ.1) GO TO 30
      JM2=J-2
      DO 29 I=1,JM2
      IF (XBAR(JS-1).LE.PX) GO TO 30
      JS=JS-1
      DF(JS) = 0.0
      PNUM=PNUM+XBAR(JS)*FN(JS)
      PDEN=PDEN+FN(JS)
      PX=PNUM/PDEN
   29 CONTINUE
   30 DO 40 J1=JS,J
      XBAR(J1)=PX
   40 CONTINUE
   50 CONTINUE
C
C              CALCULATE STATISTIC
C
      ODF = -1.0
      OBSS = 0.0
      DO 60 I = 1, NSAM
      ODF = ODF + DF(I)
      OBSS = OBSS + FN(I) * (XBAR(I) - TBAR)**2
   60 CONTINUE
      OWSS = BSS + WSS - OBSS
C
      FRAT = (BSS / TDF) / (WSS / (TN - TDF + 1.0))
      PF = FDFC(FRAT,TDF,TN-TDF+1.0)
      OFRAT = 0.0
      IF (ODF.GT.0.0)
     *   OFRAT = (OBSS / ODF) / (OWSS / (TN - ODF + 1.0))
      CALL PBART(OFRAT,PVAL,NSAM,TN-ODF+1.0,1,SE)
C
C        PUT BOUNDS ON THE LACK OF FIT
C
      DIFFU = ((BSS - OBSS) / TDF) / (WSS / (TN - TDF + 1.0))
      PDIFFU = FDFC(DIFFU,TDF,TN-TDF+1.0)
      DIFFL = ((BSS - OBSS) / 1.0) / (WSS / (TN - TDF + 1.0))
      PDIFFL = 0.5 * FDFC(DIFFL,1.0,TN-TDF+1.0)
      WRITE (IOUT,70) BSS,OBSS,BSS-OBSS,WSS
   70 FORMAT (/' Sums of squares:',10X,'  between groups  ',G12.5
     *       //10X,'                monotone increase  ',G12.5
     *        /10X,'lack of fit  (between - monotone)  ',G12.5
     *       //10X,'                     within group  ',G12.5)
C
      WRITE (IOUT,72) FRAT, PF
   72 FORMAT(/' Overall F-ratio =',F8.2,5X,'P-value =',F6.3)
      WRITE (IOUT,80) OFRAT
   80 FORMAT(/'         F-ratio for order restriction = ',F8.2)
      IF (NSAM.EQ.3 .OR.NSAM.EQ.4) WRITE(IOUT,90) PVAL
   90 FORMAT ('                       P-value (exact) = ',F8.3)
      IF (NSAM.NE.3 .AND.NSAM.NE.4) WRITE(IOUT,100) PVAL
  100 FORMAT (' P-value (assuming equal weights) = ',F8.3)
      WRITE(IOUT,110) PDIFFL, PDIFFU
  110 FORMAT(/'     Lack of fit :  ',F6.3,' <= P-value <=',F6.3)
C
      RETURN
      END
C
      SUBROUTINE PBART(STAT,PVAL,IK,DFD,IFC,WT)
C
C        P-VALUE FOR BARTHOLOMEW'S TEST IN THE CASE OF EQUAL 
C        SAMPLE SIZES (ARBITRARY FOR IK = 3,4)
C
C        IK -- NUMBER OF GROUPS
C        DFD -- DENOMINATOR DF FOR F; DUMMY FOR CHI SQUARE
C        IFC = 1, F DISTRIBUTION
C              2, CHI SQUARE DISTRIBUTION
C        WT -- WEIGHTS:  COL TOTS FOR CHI SQUARE
C                        SE'S FOR F
C
C        CALLING PROGRAMS HAVE VERIFIED THAT THERE ARE FEWER 
C        THAN 10 GROUPS
C
      DIMENSION P(10,10), WT(IK)
      DATA PI /3.14159265/
C
      IF (IK.EQ.3) GOTO 150
      IF (IK.EQ.4) GOTO 180
C
      P(1,1) = 1.0
      DO 10 K = 2, IK
      P(1,K) = 1.0 / FLOAT(K)
      P(K,K) = P(K-1,K-1) * P(1,K)
   10 CONTINUE
C
      DO 20 K = 3, IK
      DO 20 L = 2, K-1
      P(L,K) = (P(L-1,K-1)+ FLOAT(K-1) * P(L,K-1)) / FLOAT(K)
   20 CONTINUE
C
      IF (IFC.EQ.2) GOTO 100
C
C        F DISTRIBUTION
C
      PVAL = 0.0
      DO 30 L = 2, IK
   30 PVAL = PVAL + P(L,IK) * FDFC(STAT,FLOAT(L-1),DFD)
      RETURN
C
  100 PVAL = 0.0
      DO 110 L = 2, IK
  110 PVAL = PVAL + P(L,IK) * CHIDFC(STAT,L-1)
      RETURN
C
C        IK = 3  (SPECIAL CASE)
C
  150 RHO12 = - SQRT(WT(1) * WT(3) / 
     *   ((WT(1) + WT(2)) * (WT(2) + WT(3))))
      IF (IFC.EQ.1) PVAL = 
     *   (1.0 - ACOS(RHO12) / PI) * FDFC(STAT,2.0,DFD)
     *   + FDFC(STAT,1.0,DFD)
      IF (IFC.EQ.2) PVAL = (1.0 - ACOS(RHO12) / PI) * CHIDFC(STAT,2)
     *   + CHIDFC(STAT,1)
      PVAL = 0.5 * PVAL
      RETURN
C
C        IK = 4  (SPECIAL CASE)
C
  180 RHO12 = - SQRT(WT(1) * WT(3) / 
     *   ((WT(1) + WT(2)) * (WT(2) + WT(3))))
      RHO23 = - SQRT(WT(2) * WT(4) / 
     *   ((WT(2) + WT(3)) * (WT(3) + WT(4))))
      RHO231 = - SQRT((WT(1) + WT(2)) * WT(4) / 
     *   ((WT(1) + WT(2) + WT(3)) * (WT(3) + WT(4))))
      RHO132 = - SQRT(WT(1) * WT(4) / 
     *   ((WT(1) + WT(2) + WT(3)) * (WT(2) + WT(3) + WT(4))))
      RHO123 = - SQRT(WT(1) * (WT(3) + WT(4)) / 
     *   ((WT(1) + WT(2)) * (WT(3) + WT(4))))
C
      P(2,4) = 0.125 + (ACOS(RHO12) + ACOS(RHO23))/ (4.0 * PI)
      P(3,4) = 0.75 - (ACOS(RHO231) + ACOS(RHO132) +ACOS(RHO123))
     *   / (4.0 * PI)
      P(4,4) = 0.50 - P(2,4)
      PVAL = 0.0
      DO 200 L = 2, 4
      IF (IFC.EQ.1)
     *   PVAL = PVAL + P(L,4) * FDFC(STAT,FLOAT(L-1),DFD)
      IF (IFC.EQ.2)
     *   PVAL = PVAL + P(L,4) * CHIDFC(STAT,L-1)  
  200 CONTINUE
      RETURN
      END
C
      SUBROUTINE BINOM(IIN,IOUT)
C
C        BINOMAL DISTRIBUTION
C
   10 WRITE(IOUT,20)
   20 FORMAT(/' Enter n, p, k:  '$)
      READ(IIN,*,ERR=10) XN,P,XK
      K = XK
C
      IF (P.LE.0.0 .OR. P.GE.1.0 .OR. FLOAT(K).NE.XK
     *   .OR. XK.GT.XN) GOTO 10
C
      PLO = 0.0
      XN1 = XN + 1.0
      DO 70 I = 0, K
      XI = I
      TERM = ALGAMA(XN1) - ALGAMA(XI+1.0) - 
     *   ALGAMA(XN1-XI) + XI * ALOG(P) + (XN-XI) * ALOG(1.0-P)
      IF (TERM.GT.-78.0) PLO = PLO + EXP(TERM)
   70 CONTINUE
      IF (TERM.GT.-78.0) TERM = EXP(TERM)
      IF (TERM.LT.0.0) TERM = 0.0
      PHI = 1.0 - PLO + TERM
C
      WRITE(IOUT,80) IFIX(XN),P,K,TERM,K,PLO,K,PHI
   80 FORMAT(/' Prob (binomial(',I3,',',F5.3,')  =',I3,')  = ',F7.4/
     *   27X,'<=',I3,')  = ',F7.4/
     *   27X,'>=',I3,')  = ',F7.4)
C
      RETURN
      END
C
      SUBROUTINE POISN(IIN,IOUT)
C
C        POISSON DISTRIBUTION
C
   10 WRITE(IOUT,20)
   20 FORMAT(/' Enter mean and quantile:  '$)
      READ(IIN,*,ERR=10) XLAM,XK
      K = XK
C
      IF (XLAM.LT.0.0 .OR. FLOAT(K).NE.XK) GOTO 10
C
      PLO = 0.0
      DO 70 I = 0, K
      XI = I
      TERM = -XLAM + XI * ALOG(XLAM) - ALGAMA(XI+1.0)
      IF (TERM.GT.-78.0) PLO = PLO + EXP(TERM)
   70 CONTINUE
      IF (TERM.GT.-78.0) TERM = EXP(TERM)
      IF (TERM.LT.0.0) TERM = 0.0
      PHI = 1.0 - PLO + TERM
C
      WRITE(IOUT,80) XLAM,K,TERM,K,PLO,K,PHI
   80 FORMAT(/' Prob (Poisson(',G10.4,')  =',I3,')  = ',F7.4/
     *   27X,'<=',I3,')  = ',F7.4/
     *   27X,'>=',I3,')  = ',F7.4)
C
      RETURN
      END
C
      SUBROUTINE FISHER(IIN,IOUT)
C
C        FISHER'S EXACT TEST FOR 2*2 CONTINGENCY TABLES
C
      HYPR(X11,RT1,RT2,CT1,XN) = ALGAMA(RT1+1.0) - ALGAMA(X11+1.0)
     *   - ALGAMA(RT1-X11+1.0) + ALGAMA(RT2+1.0) - ALGAMA(CT1-X11+1.0)
     *   - ALGAMA(RT2-CT1+X11+1.0)
  110 WRITE (IOUT,120)
  120 FORMAT(/' Enter row 1:  ',$)
      READ(IIN,*,ERR=110) TABL11, TABL12
  130 WRITE (IOUT,140)
  140 FORMAT(' Enter row 2:  ',$)
      READ(IIN,*,ERR=130) TABL21, TABL22
C
C        CALCULATE ROW AND COLUMN TOTALS
C        PERMUTE TABLE SO THAT FIRST ROW AND COLUMN 
C        HAVE SMALLER TOTALS
C
      RT1 = TABL11 + TABL12
      RT2 = TABL21 + TABL22
      IF (RT1.LE.RT2) GOTO 200
      DUM = RT1
      RT1 = RT2
      RT2 = DUM
      DUM = TABL11
      TABL11 = TABL21
      TABL21  = DUM
      DUM = TABL12
      TABL12 = TABL22
      TABL22 = DUM
C   
  200 CT1 = TABL11 + TABL21
      CT2 = TABL12 + TABL22
      IF (CT1.LE.CT2) GOTO 210
      DUM = CT1
      CT1 = CT2
      CT2 = DUM
      DUM = TABL11
      TABL11 = TABL12
      TABL12  = DUM
      DUM = TABL21
      TABL21 = TABL22
      TABL22 = DUM
C   
  210 GRAND = RT1 + RT2
      HYPR0 = ALGAMA(CT1+1.0) + ALGAMA(GRAND-CT1+1.0)
     *   - ALGAMA(GRAND+1.0)
      PVALL = 0.0
      PVALU = 0.0
      TERM = HYPR0 + HYPR(TABL11,RT1,RT2,CT1,GRAND) 
      IF (TERM.LT.-78.0) GO TO 280
      TERMO = EXP(TERM)
      IMAX = MIN1(RT1,CT1)
      I11 = TABL11
C
      PVALL = 0.0
      IENDL = -1
      DO 250 I = 0, I11
      TERM = HYPR0 + HYPR(FLOAT(I),RT1,RT2,CT1,GRAND) 
      IF (TERM.LT.-78.0) GOTO 250
      TERM = EXP(TERM)
      IF (TERM.GT.TERMO) GOTO 260
      IENDL = I
      PVALL = PVALL + TERM
  250 CONTINUE
      PVAL1 = PVALL
C
  260 PVALU = 0.0
      IENDU = -2
      DO 270 I = IMAX, I11, -1
      TERM = HYPR0 + HYPR(FLOAT(I),RT1,RT2,CT1,GRAND) 
      IF (TERM.LT.-78.0) GOTO 270
      TERM = EXP(TERM)
      IF (TERM.GT.TERMO) GOTO 280
      IENDU = I
      PVALU = PVALU + TERM
  270 CONTINUE
      PVAL1 = PVALU
C
  280 PVAL2 = PVALL + PVALU
      IF (IENDL.NE.IENDU) GOTO 290
      PVAL1 = AMIN1(PVALL, PVALU)
      PVAL2 = 1.0
  290 WRITE(IOUT,300) PVAL1, PVAL2
  300 FORMAT(/' Fisher''s exact test:   1 tailed  ',F7.4/
     *         '                        2 tailed  ',F7.4)
C
      RETURN
      END
C
      FUNCTION XINBTA(P, Q, ALPHA)
C
C        ALGORITHM AS 109 APPL.STATIST. (1977), VOL.26, NO.1
C        (REPLACING ALGORITHM AS 64  APPL. STATIST. (1973),
C        VOL.22, NO.3)
C        ***[FAULT INDICATOR REMOVED BY G.E.D.]***
C
C        COMPUTES INVERSE OF INCOMPLETE BETA FUNCTION
C        RATIO FOR GIVEN POSITIVE VALUES OF THE ARGUMENTS
C        P AND Q, ALPHA BETWEEN ZERO AND ONE.
C        LOG OF COMPLETE BETA FUNCTION, BETA, IS ASSUMED TO BE KNOWN.
C        ***[CALCULATION OF BETA ADDED BY G.E.D]***
C
      LOGICAL INDEX
C
C        DEFINE ACCURACY AND INITIALIZE
C
      DATA ACU /1.0E-14/
      XINBTA = ALPHA
C
C        TEST FOR ADMISIBILITY OF PARAMETERS
C
      IF (P.LE.0.0.OR.Q.LE.0.0) STOP 50
      IF (ALPHA.LT.0.0.OR.ALPHA.GT.1.0) STOP 51
      IF (ALPHA.EQ.0.0.OR.ALPHA.EQ.1.0) RETURN
C
      BETA=ALGAMA(P)+ALGAMA(Q)-ALGAMA(P+Q)
C
C        CHANGE TAIL IF NECESSARY
C
      IF (ALPHA .LE. 0.5) GOTO 1
      A = 1.0 - ALPHA
      PP = Q
      QQ = P
      INDEX = .TRUE.
      GOTO 2
    1 A = ALPHA
      PP = P 
      QQ = Q
      INDEX = .FALSE.
C
C        CALCULATE INITIAL APPROXIMATION
C
    2 R = SQRT(-ALOG(A * A))
      Y = R - (2.30753 + 0.27061 * R) / 
     *             (1.0 + (0.99229 + 0.04481 * R) * R)
      IF (PP .GT. 1.0 .AND. QQ .GT. 1.0) GOTO 5
      R = QQ +QQ
      T = 1.0 / (9.0 * QQ)
      T = R * (1.0 - T + Y * SQRT(T)) ** 3
      IF (T .LE. 0.0) GOTO 3
      T = (4.0 * PP + R - 2.0) / T
      IF (T .LE. 1.0) GOTO 4
      XINBTA = 1.0 - 2.0 / (T + 1.0)
      GOTO 6
    3 XINBTA = 1.0 - EXP((ALOG((1.0 - A) * QQ) + BETA) / QQ)
      GOTO 6
    4 XINBTA = EXP((ALOG(A * PP) + BETA) / PP)
      GOTO 6
    5 R = (Y * Y - 3.0) / 6.0
      S = 1.0 / (PP + PP - 1.0)
      T = 1.0 / (QQ + QQ - 1.0)
      H = 2.0 / (S + T)
      W = Y * SQRT(H + R) / H - (T - S) * 
     *   (R + 5.0 / 6.0 - 2.0 / (3.0 * H))
      XINBTA = PP / (PP + QQ * EXP(W + W))
C
C        SOLVE FOR X BY A MODIFIED NEWTON-RAPHSON METHOD,
C        USING THE FUNCTION BETAIN.
C
    6 R = 1.0 - PP
      T = 1.0 - QQ
      YPREV = 0.0
      SQ = 1.0
      PREV = 1.0
      IF (XINBTA .LT. 0.0001) XINBTA = 0.0001
      IF (XINBTA .GT. 0.9999) XINBTA = 0.9999
    7 Y = BETAIN(XINBTA, PP, QQ)
      Y = (Y - A) * EXP(BETA +
     *             R * ALOG(XINBTA) + T * ALOG(1.0 - XINBTA))
      IF (Y * YPREV .LE. 0.0) PREV = SQ
      G = 1.0
    9 ADJ = G * Y
      SQ = ADJ * ADJ
      IF (SQ .GE. PREV) GOTO 10
      TX = XINBTA - ADJ
      IF (TX .GE. 0.0 .AND. TX .LE. 1.0) GOTO 11
   10 G = G / 3.0
      GOTO 9
   11 IF (PREV .LE. ACU) GOTO 12
      IF (Y * Y .LE. ACU) GOTO 12
      IF (TX .EQ. 0.0 .OR. TX .EQ. 1.0) GOTO 10
      IF (TX .EQ. XINBTA) GOTO 12
      XINBTA = TX
      YPREV = Y
      GOTO 7
   12 IF (INDEX) XINBTA = 1.0 - XINBTA
      RETURN
      END
C
      SUBROUTINE MANTEL(IIN,IOUT)
C
C        MANTEL-HAENSZEL ESTIMATE OF COMMON ODDS RATIO
C        MANTEL-HAENSZEL STATISTIC TESTING SIGNIFICANCE OF 
C          COMMON ODDS RATIO
C        APPROXIMATE C.I. FOR COMMON ODDS RATIO BASED ON 
C          FLEISS(1981, EQ. 10.24).  THIS FORMULA CAN ALSO
C          BE USED TO CONSTRUCT AN APPROXIMATE C.I. FOR A 
C          SINGLE 2*2 TABLE.
C
      LOGICAL LZERO
      LZERO = .FALSE.
   90 WRITE(IOUT,100)
  100 FORMAT(/' Enter the number of 2 * 2 tables:  '$)
      READ(IIN,*,ERR=90) NTAB
      IF (NTAB.LT.1 .OR. NTAB.GT.6) GOTO 90
C
      SN = 0.0
      SD = 0.0
      SNMH = 0.0
      SDMH = 0.0
      ODDSN = 0.0
      ODDSD = 0.0
      HOMO = 0.0
C
      DO 300 K = 1, NTAB
  110 WRITE (IOUT,120) K
  120 FORMAT(/' Enter row 1 of table',I2,':  '$)
      READ(IIN,*,ERR=110) TAB11, TAB12
  130 WRITE (IOUT,140) K
  140 FORMAT(' Enter row 2 of table',I2,':  '$)
      READ(IIN,*,ERR=130) TAB21, TAB22
      IF (TAB11 * TAB12 * TAB21 * TAB22 .EQ. 0.0) LZERO = .TRUE.
      SUM = TAB11 + TAB12 + TAB21 + TAB22
C
C        MANTEL-HAENSZEL CHI-SQUARE STATISTIC
C
      SN = SN + TAB11 - (TAB11 + TAB12) *
     *   (TAB11 + TAB21) / SUM
      SD = SD + (TAB11 + TAB12) * (TAB11 + TAB21)
     *   * (TAB21 + TAB22) * (TAB12 + TAB22) /
     *   (SUM * SUM * (SUM-1.0))
C
C        MANTEL-HAENSZEL ESTIMATE OF COMMON ODDS RATIO
C
      SNMH = SNMH + TAB11 * TAB22 / SUM
      SDMH = SDMH + TAB12 * TAB21 / SUM
C
C        C.I. FOR ODDS RATIO BASED ON COMBINING LOG ODDS (FLIESS, 10.20)
C
      IF (LZERO) GOTO 300
      WEIGHT = 1.0 / TAB11 + 1.0 / TAB12 + 1.0 / TAB21 + 1.0 / TAB22
      WEIGHT = 1.0 / WEIGHT
      ODDSD = ODDSD + WEIGHT
      ORATL = ALOG(TAB11 * TAB22 / (TAB12 * TAB21))
      ODDSN = ODDSN + WEIGHT * ORATL
      HOMO = HOMO + WEIGHT * ORATL**2
C
  300 CONTINUE
C
C        MANTEL-HAENSZEL CHI-SQUARE
C
      CHISQC = (ABS(SN) - 0.5)**2 / SD
      PVALC = 2.0 * ALNORM(SQRT(CHISQC),.TRUE.)
      CHISQ = SN**2 / SD
      PVAL = 2.0 * ALNORM(SQRT(CHISQ),.TRUE.)
C
C        MANTEL-HAENSZEL ESTIMATE
C
      IF (SNMH * SDMH .NE. 0.0) GOTO 350
      WRITE(IOUT,340)
  340 FORMAT(/' Can''t evaluate odds ratio with counts of 0',
     *   ' in the summary table.')
      RETURN
C
  350 ODDS = SNMH / SDMH
C
      WRITE(IOUT,360) ODDS,CHISQ,PVAL,CHISQC,PVALC
  360 FORMAT(/' Common odds ratio = ',G12.5//
     *   ' Mantel-Haenszel chi-square statistic (P-value) '/
     *   '           uncorrected:  ',G11.4,'  (',F6.4,')'/
     *   '  continuity corrected:  ',G11.4,'  (',F6.4,')'/)
C
C        C.I. FOR COMMON ODDS RATIO
C
      IF (LZERO) RETURN
  410 WRITE(IOUT,420)
  420 FORMAT(/' Enter desired level of confidence (0,1):  '$)
      READ(IIN,*,ERR=410) CONF
      COEF = -GAUINV((1.0 - CONF) / 2.0, IFAULT)
      CONF = 100.0 * CONF
      ODDSC = ODDSN / ODDSD
      ODDSSE = 1.0 / SQRT(ODDSD)
      CL = EXP(ODDSC - COEF * ODDSSE)
      CU = EXP(ODDSC + COEF * ODDSSE)
C
      WRITE(IOUT,430) CONF,CL,CU
  430 FORMAT(
     *   ' Approximate ',F4.1,'-% confidence interval for the odds',
     *   ' ratio:'/'      (',F7.3,',',F7.3,')')
C
C        HOMOGENEITY OF ODDS RATIOS 
C
      IF (NTAB.EQ.1) RETURN
      HOMO = HOMO - ODDSN**2 / ODDSD
      PHOMO  = CHIDFC(HOMO,NTAB-1)
      WRITE(IOUT,440) HOMO,PHOMO
  440 FORMAT(/' Homogeneity of the odds ratios:'/
     *   '     Chi-square statistic = ',G11.4/
     *   '     P-value = ',F6.4/)
C
      RETURN
      END
