1000 REM ************************************************************
1010 REM *                                                          *
1020 REM *          DYNAMIC AUTOEXEC CONFIGURATION PROGRAM          *
1030 REM *                                                          *
1040 REM * PROGRAM AUTHOR: RICK FERRIS, PRESIDENT                   *
1050 REM *                 RAF SOFTWARE ENTERPRISES                 *
1060 REM *                 707 WOODHORN COURT                       *
1070 REM *                 HOUSTON, TEXAS, 77062                    *
1080 REM *                 (713) 280-0377                           *
1090 REM *                                                          *
1100 REM * PROGRAM ABSTRACT:                                        *
1110 REM *   THE INTENTION OF THIS PROGRAM IS TO ALLOW THE PC USER  *
1120 REM * CHOICES IN WHAT OPTIONS ARE LOCATED IN THE AUTOEXEC.BAT  *
1130 REM * FILE WITHOUT HAVING TO CHANGE THE FILE AND REBOOT THE PC.*
1140 REM * THIS CAN BE ACCOMPLISHED BY INCORPORATING A SERIES OF    *
1150 REM * DATA STATEMENTS AND CORRESPONDING QUESTIONS INTO A DATA  *
1160 REM * FILE NAMED "AUTOXQT.OPT" WHICH WILL BE INVOKED EACH TIME *
1170 REM * THE SYSTEM IS REBOOTED. THE PROGRAM WILL CREATE A NEW    *
1180 REM * BATCH FILE (AE.BAT) WHICH WILL BE ADDED AFTER THE PROGRAM*
1190 REM * IS FINISHED ASKING THE USER THE QUESTIONS.               *
1200 REM *                                                          *
1210 REM * REVISION HISTORY:                                        *
1220 REM *  VERSION 1.0 COMPLETED ON:  5 /26 /1985 BY RICK FERRIS   *
1230 REM *                                                          *
1240 REM *  VERSION 1.1 COMPLETED ON:  6 / 6 /1985 BY RICK FERRIS   *
1250 REM *     Error input flashes in red and is then reset.        *
1260 REM *                                                          *
1270 REM *  VERSION 2.0 COMPLETED ON:  8 /16 /1985 BY RICK FERRIS   *
1280 REM *     Input options changed to read from a data file       *
1290 REM *     instead of from data statements in the program.      *
1300 REM *                                                          *
1310 REM ************************************************************
1320 REM
1330 REM VARIABLE DEFINITIONS:
1340 REM
1350 REM  OPT$(n) = STRING ARRAY WHICH CONTAINS THE QUESTIONS FOR EACH OPTION
1360 REM            WHICH IS INCLUDED. n MUST BE >= THE NUMBER OF QUESTIONS.
1370 REM
1380 REM  TOPT$(m)= STRING ARRAY WHICH CONTAINS THE ACTUAL OUTPUT LINES FOR THE
1390 REM            AE.BAT FILE. m MUST BE >= THE MAXIMUM NUMBER OF LINES NEEDED
1400 REM            BY ANY OPTION TO BE WRITTEN INTO THE OUTPUT FILE.
1410 REM
1420 REM  I & J   = SIMPLE FOR LOOP COUNTERS.
1430 REM
1440 REM  AE$     = BATCH FILE NAME: "AE.BAT". THIS IS THE FILE THAT THIS
1450 REM            PROGRAM WRITES INTO WITH THE SELECTED CONFIGURATION INFO.
1460 REM
1470 REM  IN$     = TEMPORARY VARIABLE WHICH HOLDS ONE LINE OF INPUT FROM THE
1480 REM            OLD VERSION OF AE.BAT IF IT EXISTS.
1490 REM
1500 REM  A       = STATUS FLAG FROM THE 'YES OR NO ANSWER' SUBROUTINE. IF A<>0
1510 REM            ON RETURN, 'Yes' OR 'No' WAS NOT ANSWERED.
1520 REM
1530 REM  A$      = ANSWER INPUT IN 'YES OR NO' SUBROUTINE (ONE CHARACTER).
1540 REM
1550 REM  TOPT    = TEMPORARY NUMBER OF ACTUAL OUTPUT LINES TO BE OUTPUT TO THE
1560 REM            AE.BAT FILE FOR AN OPTION.
1570 REM
1580 REM  NOPTS   = TOTAL NUMBER OF OPTIONS WHICH WILL BE PROMPTED. THIS IS THE
1590 REM            FIRST ITEM READ IN FROM THE INPUT FILE 'AUTOXQT.OPT'.
1600 REM
1610 REM  COUNT   = INTEGER COUNT OF THE NUMBER OF SELECTED OPTIONS. THIS
1620 REM            VARIABLE IS NOT CURRENTLY BEING USED FOR ANYTHING.
1630 REM
1640 REM *********************************************************************
1650 REM *               SAMPLE INPUT FILE: AUTOXQT.OPT                      *
1660 REM *********************************************************************
1670 REM * Use EDLIN or some other editor to create this file. PLEASE NOTE:  *
1680 REM * The comments on each line must be left off your file. They are    *
1690 REM * only here to explain each line in the file. The file line numbers *
1700 REM * are here for clarity also.                                        *
1710 REM *********************************************************************
1720 REM *   1: 3      'This is the total option counter, NOPTS              *
1730 REM *   2: "DOS Edit"   'This line starts the endings to the question:  *
1740 REM *                   ' "Do you want "...                             *
1750 REM *   3: "the Screen Clock displayed"  'Note upper & lower case is OK.*
1760 REM *   4: "Super Spool"   'This is the third option. This is all that  *
1770 REM *                      ' line #1 is set up for (3).                 *
1780 REM *   5: 1    'This is the number of output lines needed for this     *
1790 REM *           ' particular option, DOS Edit.                          *
1800 REM *   6: "DOSEDIT"  'This is the line which goes into the output file *
1810 REM *                 ' AE.BAT. It is exactly like the command you would*
1820 REM *                 'issue at the Operating System prompt.            *
1830 REM *   7: 1    'Ditto line 5, except that this is for the Screen Clock.*
1840 REM *   8: "CLCK"  'This is like line 6 for this option.                *
1850 REM *   9: 2    'This is an example of an option which takes more than  *
1860 REM *           ' one line in the output file. This one takes two lines.*
1870 REM *  10: "MODE LPT1:" 'This is the 1st output line.                   *
1880 REM *  11: "SUPERSPL LPT1: /U=375 /B  'This is the second one.          *
1890 REM *                                                                   *
1900 REM *********************************************************************
1910 REM * That is all that there is to it! If you do it once, it will become*
1920 REM * obvious to you. If you notice that your output file (AE.BAT) does *
1930 REM * not contain all of the the information you entered in the order   *
1940 REM * that you entered it, you probably have a problem in your input    *
1950 REM * file (AUTOXQT.OPT). Please check it before you try to contact me. *
1960 REM *                                                                   *
1970 REM *   Good Luck!       RAF, 8/16/85                                   *
1980 REM *                                                                   *
1990 REM *********************************************************************
2000 REM
2010 SCREEN 0,1 : KEY OFF : CLS
2020 DIM OPT$(50), TOPT$(25)
2030 DEFINT A-Z
2040 PRINT "DYNAMIC AUTOEXEC.BAT CONFIGURATION PROGRAM" : PRINT
2050 COLOR 3 : PRINT "VERSION 1.0 WRITTEN BY R. A. FERRIS, 5/26/85" : COLOR 7
2060 PRINT "CURRENT VERSION 2.0 WRITTEN BY R. A. FERRIS,  8/16/85"
2070 PRINT
2080 AE$="AE.BAT"
2090 REM
2100 REM SET UP FOR ERROR CHECKING ON FILE I/O
2110 ON ERROR GOTO 3130
2120 REM
2130 REM ATTEMPT TO OPEN THE OLD OUTPUT BATCH FILE IF IT EXISTS
2140 OPEN AE$ FOR INPUT AS #1
2150 REM
2160 REM CHECK IF THE FILE IS EMPTY. IF SO, DELETE IT & TELL ABOUT IT.
2170 REM IF THE FILE IS NOT EMPTY, JUMP OVER SOME CODE.
2180 IF EOF(1) THEN CLOSE #1 : KILL AE$ : COLOR 6 : PRINT "No data was found in the old version of the AUTOEXEC file." : GOTO 2250 : ELSE GOTO 2340
2190 REM
2200 REM OK, THE FILE DIDN'T EXIST, ANNOUNCE THE FACT.
2210 COLOR 6
2220 PRINT "No old version of the AUTOEXEC file 'AE.BAT' exists."
2230 REM
2240 REM IF THE FILE DIDN'T EXIST OR WAS EMPTY, CONTINUE HERE
2250 COLOR 2 : PRINT
2260 PRINT "You may now set up this file according to the following questions."
2270 PRINT
2280 REM
2290 REM OPEN THE OUTPUT FILE AND GO TO ASK THE QUESTIONS
2300 OPEN AE$ FOR OUTPUT AS #1 : GOTO 2550
2310 REM
2320 REM ENTER HERE IF INFORMATION WAS FOUND IN THE OLD BATCH FILE.
2330 REM PRINT OUT THE DATA WHICH IS IN THE FILE.
2340 COLOR 2
2350 PRINT "The following information was found in the old version of"
2360 PRINT "the AUTOEXEC file 'AE.BAT':"
2370 COLOR 18
2380 PRINT "-----------------------------------------------------------------"
2390 COLOR 14
2400 LINE INPUT #1,IN$ : PRINT IN$ : IF NOT EOF(1) THEN 2400
2410 COLOR 18
2420 PRINT "-----------------------------------------------------------------"
2430 REM
2440 REM CHECK IF THE USER WANTS THE FILE AS IT WAS LAST TIME.
2450 COLOR 2
2460 PRINT "Do you wish to run with this file as it currently is? ";
2470 GOSUB 2960 : COLOR 2 : IF A<>0 THEN 2450
2480 REM
2490 REM IF A DIFFERENT COMMAND SEQUENCE IS DESIRED, DUMP THE OLD FILE AND
2500 REM TREAT THE CASE JUST LIKE AN EMPTY FILE. IF NO CHANGES ARE DESIRED,
2510 REM THEN EXIT WITH NO CHANGES APPLIED.
2520 IF A$="N" THEN CLOSE #1 : KILL AE$ : GOTO 2300 ELSE CLS : COLOR 15 : SYSTEM
2530 REM
2540 REM CHANGE THE ERROR ENTRY FOR THE NEW FILE TO BE READ FROM.
2550 ON ERROR GOTO 3140
2560 REM
2570 REM NOW OPEN THE FILE CONTAINING ALL AVAILABLE OPTIONS.
2580 OPEN "AUTOXQT.OPT" FOR INPUT AS #2
2590 REM INITIALIZE A SELECTION COUNTER, TURN ECHO OFF IN THE OUTPUT BATCH
2600 REM FILE, AND READ THE TOTAL NUMBER OF POSSIBLE OPTIONS VALUE.
2610 COUNT = 0 : PRINT #1,"ECHO OFF" : INPUT #2,NOPTS
2620 REM
2630 REM READ IN AND STORE THE OPTION QUESTION STRINGS.
2640 FOR I=1 TO NOPTS : INPUT #2,OPT$(I) : NEXT I
2650 REM
2660 REM SET UP LOOP TO PROMPT THE USER FOR EACH OF THE OPTIONS.
2670 FOR I=1 TO NOPTS
2680 REM
2690 REM ASK AN OPTION QUESTION AND GO GET AN ANSWER.
2700 PRINT "Do you want ";OPT$(I);"? ";
2710 GOSUB 2960 : COLOR 2 : IF A<>0 GOTO 2700
2720 REM
2730 REM READ IN ALL OF THE DATA FOR THIS PARTICULAR OPTION.
2740 INPUT #2,TOPT : FOR J=1 TO TOPT : INPUT #2,TOPT$(J) : NEXT J
2750 REM
2760 REM IF THIS OPTION IS DESIRED, PUT THE DATA FOR THIS OPTION INTO
2770 REM THE OUTPUT FILE. BUMP THE SELECTION COUNTER.
2780 IF A$="Y" THEN FOR J=1 TO TOPT : PRINT #1,TOPT$(J) : NEXT J : COUNT = COUNT + 1
2790 REM
2800 REM END THE OPTION PROMPTING LOOP.
2810 NEXT I
2820 REM
2830 REM PUT THE LAST LINE(S) INTO THE OUTPUT FILE, CLOSE THE FILE AND END.
2840 PRINT #1,"CLS" : CLOSE #1 : CLS : COLOR 15 : SYSTEM
2850 REM
2860 REM THIS SUBROUTINE ASSUMES THAT A YES OR NO QUESTION HAS BEEN ASKED,
2870 REM THEN WILL WAIT FOR A SINGLE CHARACTER TO BE INPUT FROM THE KEYBOARD.
2880 REM IF THE CHARACTER IS NOT A 'Y', 'y', 'N', OR 'n', AN ERROR MESSAGE IS
2890 REM PRINTED AND THE STATUS FLAG, A, IS SET NON-ZERO. THE CALLING CODE
2900 REM SHOULD CHECK THIS STATUS FOR A VALID ANSWER. IF THE VALID INPUT WAS
2910 REM IN LOWER CASE LETTERS, IT WILL BE CAPITALIZED FOR EASIER CHECKING
2920 REM IN THE CALLING CODE.
2930 REM
2940 REM NULL THE INPUT STRING, WAIT FOR THE CHARACTER, PRINT IT AND CLEAR
2950 REM THE STATUS FLAG TO THE VALID CONDITION.
2960 COLOR 14 : A$="" : WHILE A$="" : A$=INKEY$ : WEND : PRINT A$; : A=0
2970 REM
2980 REM CHECK FOR VALID INPUT CHARACTERS. CAPITALIZE IF NECESSARY.
2990 IF A$="Y" OR A$="y" THEN A$="Y" : PRINT "es" : GOTO 3060 : ELSE IF A$="N" OR A$="n" THEN A$="N" : PRINT "o" : GOTO 3060
3000 REM
3010 REM THE CHARACTER INPUT WAS INVALID. CHIDE THE USER AND SET THE STATUS
3020 REM FLAG TO SHOW AN INVALID INPUT.
3030 COLOR 20 : PRINT
3040 PRINT "You must enter either 'Y' or 'y' for 'YES' or 'N' or 'n' for 'NO'."
3050 PRINT "Please re-enter your answer in the proper manner." : PRINT : A=1
3060 RETURN
3070 REM
3080 REM THIS IS THE ERROR CHECKING ROUTINE. THE ONLY ERROR FROM WHICH YOU CAN
3090 REM RECOVER IS WHEN THE OLD AE.BAT INPUT FILE DOES NOT EXIST. WHEN THIS
3100 REM HAPPENS, EXECUTION IS RESUMED AT THE PROPER LOCATION. OTHERWISE,
3110 REM AN ERROR MESSAGE IS PRINTED OUT SHOWING THE BASIC ERROR NUMBER AND
3120 REM THE LINE NUMBER OF THE ERROR.
3130 IF ERR = 53 THEN RESUME 2210
3140 IF ERR = 53 THEN PRINT "Fatal Error. File "AUTOXQT.OPT" could not be found." : PRINT "Please create this file as per the instructions and try again." : STOP
3150 COLOR 4 : PRINT "***** ERROR *****" : COLOR 7
3160 PRINT "The error number was ";ERR;" which occured on line number";ERL
3170 PRINT "Please contact the program author to fix this bug. See the name and" : PRINT "address in the source code to this program. Thank you."
3180 CLOSE #1 : COLOR 15 : KEY ON : END
                                                                                                           