
                 (* ****************************** *)
                 (*                                *)
                 (*      NewFonts.pas Demo1        *)
                 (*                                *)
                 (*  This Demo Shows How to Use    *)
                 (*  Font Files That Are Stored    *)
                 (*  In Disk Files External To     *)
                 (*  Your Program. That is, How    *)
                 (*  To Transfer Them Into Your    *)
                 (*  Program and Use Them.         *)
                 (*                                *)
                 (*  (c) Donald L. Pavia           *)
                 (*  Department of Chemistry       *)
                 (*  Western Washington University *)
                 (*  Bellingham, WA   98225        *)
                 (*                                *)
                 (*               February 1, 1986 *)
                 (*                                *)
                 (* ****************************** *)

program FontDemo1;

type FontType = array[1..1024] of byte;   { required global variables for    }
     str14 = string[14];                  { the UseFonts.Lib library         }

var  i,j,k,m : integer;
     TempFonts : FontType;                { required global variable for Lib }
     HiAscii   : FontType;                { var to store a loaded font set   }
     ChemMath  : FontType;                {  "   "   "    "     "   "   "    }

{----------------------------------------------------------------------------}
{$I UseFonts.Lib}                          { procedures to load font files   }
{----------------------------------------------------------------------------}

{----------------------------------------------------------------------------}
procedure ChemMathFonts;                   { A procedure of this type must   }
                                           { be written for each fonttype    }
begin                                      { variable. Trying to pass a      }
     memw[$0000:$007E] := seg(ChemMath);   { structured variable to a single }
     memw[$0000:$007C] := ofs(ChemMath);   { procedure did not work reliably }
                                           { in earlier coding attempts.     }
end; { procedure ChangeFont }              {      I don't know why.          }
{----------------------------------------------------------------------------}
procedure HiAsciiFonts;                    { procedure sets interrupt vector }
                                           { (7C) to point to memory location}
begin                                      { of new pel maps - calls to high }
     memw[$0000:$007E] := seg(HiAscii);    { ascii nos 128 - 255 will use    }
     memw[$0000:$007C] := ofs(HiAscii);    { the maps this vector points to  }

end; { procedure HiAscii }
{----------------------------------------------------------------------------}
BEGIN

     (* *********************** MED RES MODE *************************** *)

     GraphColorMode; GraphBackGround (1); Palette (0);

     LoadFontFile ('HI_ASCII.FNT');      { load a copy of high ascii }
     {HiAsciiFonts := TempFonts;}        { and save them for reuse   }
     move (TempFonts,HiAscii,1024);      { either method shown works }

     LoadFontFile ('CHEMMATH.FNT');      { load redefined char file  }
     {ChemMathFonts := TempFonts;}       { and save in memory        }
     move (TempFonts,ChemMath,1024);

     ChemMathFonts;                      {  use redefined characters }

     TextColor (1);
     gotoxy (5,2);   write ('CH',#133,'CH',#132,'CO',#132,'H');
     TextColor (2);
     gotoxy (10,5);  write ('x',#143,' + y',#146,' = z',#142);
     TextColor (3);
     gotoxy (15,8);  write ('Na',#150,' HCO',#133,#151);

     HiAsciiFonts;                 { return to orig high ascii chars }

     TextColor (1); i := 11; m := 0;
     for j := 1 to 4 do begin
         gotoxy (1,i); for K := 0 to 35 do
         if ((128+k+m) < 256) then write (chr(128 + k + m));
         i := i + 2; m := m + 36;
     end;

     ChemMathFonts;                     { redefined characters again }

     TextColor (3);
     gotoxy (5,20); write ('CH',#133,'CH',#132,'(CH',#132,')',#138,'COOH');
     TextColor (2);
     gotoxy (10,22); write ('x',#142,' + y',#142,' = a',#143,' x b',#144);

     TextColor (1);
     gotoxy (25,25); write ('Press Enter');
     readln;

     (* ************************ HI RES MODE *************************** *)

     HiRes; HiResColor (1);                  { still redefined fonts }

     gotoxy (1,7); write ('CH',#133,'CH',#132,'(CH',#132,')',#138,'COOH');

     HiAsciiFonts;                             { regular fonts again }

     i := 12; m := 0;
     for j := 1 to 2 do begin
          gotoxy (1,i); for k := 0 to 71 do
          if ((128+k+m) < 256) then write (chr(128+k+m));
          i := i + 2; M := m + 72;
     end;

     ChemMathFonts;                                { redefined fonts }

     gotoxy (25,20); write ('x',#142,' + y',#142,' = a',#143,' x b',#144);

     HiAsciiFonts;                             { regular fonts again }

     gotoxy (50,25); write ('Press <ENTER> to Continue');
     readln; TextMode (c80);
END.

