;pstr will write a string to the screen.  It is passed the string and
;reads the foreground/background color, determines the kind of monitor
;used and the current cursor location, and prints the string by
;directly inserting the bytes into the appropriate memory locations by
;using the ES register.  Written for use with Quick BASIC version 1.01.
;Written by Bruce W. Tonkin on 12-30-85.  Copyright, Bruce W. Tonkin, 1985.
;This routine may be used with or without attribution.
;
;calling syntax is: CALL PSTR(A$,X)
;where A$ is the string to print, and X is an integer variable which
;contains the foreground and background colors, in the following
;scheme: X=16*(background color)+foreground color.
 
MONOCHROME    EQU  0B000H    ;SEGMENT ADDRESS FOR MONOCHROME ADAPTOR
GRAPHICS      EQU  0B800H    ;SEGMENT ADDRESS FOR GRAPHICS ADAPTOR
DATA     SEGMENT WORD PUBLIC 'DATA'
STORAGE  DW   0
DATA     ENDS
DGROUP   GROUP     DATA
CODE     SEGMENT BYTE PUBLIC 'CODE'
         ASSUME CS:CODE, DS:DGROUP
         PUBLIC PSTR
PSTR     PROC FAR
         PUSH BP             ;SAVE BASE POINTER
         MOV  BP,SP          ;SET UP TO ADDRESS OFF OF BP
         MOV  BX,[BP]+6      ;GET FOREGROUND/BACKGROUND COLOR
         MOV  AX,[BX]        ;INTO AX REGISTER AND
         MOV  AH,AL          ;PUT ATTRIBUTE BYTE INTO BOTH LOCATIONS
         MOV  BX,[BP]+8      ;GET THE ADDRESS OF THE STRING DESCRIPTOR
         MOV  CX,[BX]        ;LENGTH OF STRING IN CX
         MOV  DX,[BX]+2      ;LOCATION OF STRING IN DX
         PUSH DI
         PUSH SI
         PUSH AX             ;SAVE ATTRIBUTE BYTE
         PUSH CX             ;SAVE STRING LENGTH
         PUSH DX             ;SAVE STRING LOCATION
         MOV  AX,0           ;CLEAR AX
         MOV  AH,15          ;VIDEO MODE BIOS CALL
         INT  010H           ;DO THE BIOS CALL
         CMP  AL,07H         ;SEE IF IT'S MONOCHROME
         JZ   ISMONO         ;YES
         MOV  AX,GRAPHICS    ;SET IT UP FOR GRAPHICS
         PUSH AX             ;AND SAVE RESULT
         JMP  DOLOC          ;READY FOR LOCATION
ISMONO:  MOV  AX,MONOCHROME  ;SET IT FOR MONOCHROME
         PUSH AX             ;AND SAVE RESULT
DOLOC:   MOV  BX,00H         ;READY FOR LOCATION. SET CURRENT VIDEO PAGE
         MOV  AX,00H         ;CLEAR AX
         MOV  AH,03H         ;BIOS CALL FOR FINDING CURSOR LOCATION
         INT  010H           ;PERFORM BIOS CALL
                             ;DH IS ROW, DL IS COLUMN ON RETURN
         MOV  AX,050H        ;NUMBER OF COLUMNS=80
         MOV  BX,0           ;CLEAR BX
         MOV  BL,DH          ;BL=NUMBER OF ROWS
         MUL  BX             ;80 COLUMNS TIMES ROW LOCATION INTO AX
         MOV  CX,0           ;CLEAR CX
         MOV  CL,DL          ;MOVE COLUMN ADDRESS INTO CL
         ADD  AX,CX          ;NOW HAVE ADDRESS TO OFFSET INTO BUFFER
         SHL  AX,1           ;WITH TWO BYTES PER CHARACTER (1=ATTRIBUTE)
         MOV  DI,AX          ;RESULT GOES INTO DI
                             ;ATTRIBUTE, LENGTH, LOCATION, MONITOR TYPE
                             ;ARE NOW ON THE STACK
         POP  AX             ;THAT GETS MONITOR TYPE START ADDRESS TO AX
         POP  DX             ;STRING LOCATION RESTORED TO DX
         POP  CX             ;STRING LENGTH IS IN CX
         POP  BX             ;AND ATTRIBUTE INTO BX
         MOV  SI,DX          ;STORE STRING LOCATION IN SI
         PUSH ES             ;SAVE EXTRA SEGMENT, WE'LL USE IT
         MOV  ES,AX          ;MONITOR START INTO THE ES SEGMENT REGISTER
QUERY:   CMP  CX,0           ;ARE WE DONE?
         JZ   DONE           ;YES, EXIT
         MOV  BL,BYTE PTR [SI]         ;PUT CHARACTER INTO BL
         MOV  ES:WORD PTR [DI],BX      ;SEND CHARACTER TO SCREEN
         ADD  DI,2H          ;BUMP SCREEN MEMORY INDEX BY TWO
         ADD  SI,1H          ;AND STRING POINTER BY ONE
         DEC  CX             ;ONE LESS BYTE TO MOVE
         JMP  QUERY          ;LOOP UNTIL DONE
DONE:    POP  ES             ;RESTORE EXTRA SEGMENT
         POP  SI
         POP  DI
         POP  BP             ;RESTORE BASE POINTER
         RET  4              ;RETURN AND REMOVE 2 PARAMETERS FROM STACK
PSTR     ENDP
CODE     ENDS
         END
