	Page	60,132
	Title	RWSECTOR: Read and Write Absolute Sectors
	Subttl	Copyright (c) John Navas II, All Rights Reserved
;RWSECTOR is made available for personal, non-commercial use only.  You
;are granted a limited license to use RWSECTOR, and to copy it and
;distribute it, provided that no fee is charged for such copying and
;distribution, and that it is ONLY distributed in its original,
;unmodified state. */
	.Lall

	Name	RWSECTOR

; Language: MIcrosoft MASM 3.00 for Microsoft C 3.00 (small memory model)

	Comment	\
Provide access to DOS absolute sector read and write routines. The 4
arguments are as specified immediately below. If there is no error, a -1
is returned; otherwise, the AX error code(s) are returned. \

;	usage:	int asread( int, char *, int, unsigned int );
;		int aswrite( int, char *, int, unsigned int );

drive	equ	ss:word ptr[bp+4]	; 0 is A:, 1 is B:, etc.
dta	equ	ss:word ptr[bp+6]	; data transfer address
count	equ	ss:word ptr[bp+8]	; number of sectors
sector	equ	ss:word ptr[bp+10]	; starting sector number

_TEXT	segment	byte public 'CODE'
	assume	cs:_TEXT

	public	_ASREAD
_ASREAD	proc	near
	
	push	bp		; save registers
	mov	bp,sp
	push	di
	push	si

	mov	ax,drive	; arguments
	mov	bx,dta
	mov	cx,count
	mov	dx,sector

	int	25h		; DOS absolute sector read
	pop	bx		; old flags
	jc	exitr		; error
	mov	ax,-1		; no errors

exitr:
	pop	si
	pop	di
;	mov	sp,bp
	pop	bp
	ret

_ASREAD	endp

	public	_ASWRITE
_ASWRITE	proc	near

	push	bp		; save registers
	mov	bp,sp
	push	di
	push	si

	mov	ax,drive	; arguments
	mov	bx,dta
	mov	cx,count
	mov	dx,sector

	int	26h		; DOS absolute sector write
	pop	bx		; old flags
	jc	exitw		; error
	mov	ax,-1		; no errors

exitw:
	pop	si
	pop	di
;	mov	sp,bp
	pop	bp
	ret

_ASWRITE	endp

_TEXT	ends

	End
