
/*   RFILE2
*
*    Random file access functions.
*
*    This is an improvement on my "RFIEL.C", by using an "access structure"
*    RTBL it is more efficient and allows automatic tracking of the hi-record.
*
*    Both RTBL.H and the new RFILE.C are included here.  They were written and
*    tested using Lattice C, ver 2.15
*
*    "FCNTL.H" used in RFILE.C is a standard Lattice header that contain the
*    definitions for O_RDWR, O_CREAT, and O_RAW, and are as follows:
*
*          O_RDWR  2
*          O_CREAT 0x0100
*          O_RAW   0x8000
*
*    Note that rfile() returns the actual record read/written or a negitive
*    error number.  -1 = EOF, anything less is some other error.  But notice
*    that rfile() now tracks the hi-record number (tbl->hrn), therefore you
*    should check the return to see if it's the same one you called in "rec".
*    In other words, if you call a record that is higher then the hi-record,
*    rfile() will always read the hi-record or write `hi-record++'.
*
*    The "dat" is the buffer/data-transfer-area for one record of size "sz" and
*    "dat" is intended to be a structure.  Therefore your structure declaration
*    of "dat" becomes equilivent to a BASIC "FIELD" command.
*
*    Note that record numbers start at one (1).
*
*
*    EXAMPLE:  #include "rtbl.h"
*              int r,ropen(),rfile(),sz,cr;
*              struct RTBL fatbl;
*              struct {int fi;char cc;float ff;} data;
*              char ic='A';
*
*              sz=sizeof(data);
*              r=ropen("test.dat",&fatbl,&data,sz);
*              if(r)  exit(0);     /* open error */
*              for(cr=1;cr<11;cr++,ic++)
*              { data.fi=cr;
*                data.ff=cr/11.5;
*                data.cc=ic;
*                r=rfile(&fatbl,cr,'w');
*                if(r != cr)  exit(0);  /* error exit */
*              };
*              rclose(&fatbl);
*
*
*
*
*    FROM:  ED REDONDO
*
*
*/


/*  RTBL.H   access structure for ropen() and rfile()  */

struct RTBL {int fprt,szdta,hrn;char *dta; };

/* ends */


/*   RFILE.C  Random file access functions  */

#include "RTBL.H"
#include "FCNTL.H"

int ropen(filspc,tbl,dat,sz)  /*  open file for random access  */

char *filspc;       /* filespec string */
char *dat;          /* record structure, data transfer area */
struct RTBL *tbl;   /* file access table in rtbl.h */
int sz;             /* sizeof dat */

{ int port,open();
  long ef,lseek();

  port=open(filspc,O_RDWR | O_CREAT | O_RAW);
  if(port<0)  return(1);     /* error return */
  tbl->fprt=port;
  tbl->szdta=sz;
  ef=lseek(port,0L,2);
  ef+=1;
  tbl->hrn=ef/tbl->szdta;
  tbl->dta=dat;
  return(0);     /* no error */
}


int rfile(ftbl,rec,mode)     /* random file access */
                                  /*   assumes port assigned     */
struct RTBL *ftbl;     /* file access table */
int rec;               /* record to read-write */
char mode;             /*  r = read, w = write  */

{ int stat,read(),write();
  long pos,lseek();

  stat=0;
  if(rec>ftbl->hrn)
  {  if(mode=='w')  ftbl->hrn++;
     rec=ftbl->hrn;
  };
  rec--;
  pos=rec*ftbl->szdta;
  lseek(ftbl->fprt,pos,0);
  switch(mode)   {  case'r':stat=read(ftbl->fprt,ftbl->dta,ftbl->szdta);
                            break;
                    case'w':stat=write(ftbl->fprt,ftbl->dta,ftbl->szdta);
                            break;
                 };
  if(stat<=0) return(stat-1);   /* -1=EOF, <(-1)=error */
  else return(rec+1);
}



rclose(ctbl)     /* close a random file */

struct RTBL *ctbl;     /* file access table */

{ close(ctbl->fprt);
}
