	Page	60,132
	Title	KEYBIOS: Access to keyboard BIOS services
	Subttl	Copyright (c) John Navas II, All Rights Reserved
;KEYBIOS is made available for personal, non-commercial use only.  You
;are granted a limited license to use KEYBIOS, and to copy it and
;distribute it, provided that no fee is charged for such copying and
;distribution, and that it is ONLY distributed in its original,
;unmodified state. */
	.Lall

	Name	KEYBIOS

; Language: MIcrosoft MASM 3.00 for Microsoft C 3.00 (small memory model)

	Comment	\
Provides access to the PC ROM BIOS keyboard request routines, especially
the Zero Flag reported by Service 1 (Report Whether Character Ready).
Returns the AX value which can be treated as an int. If the ZF is
desired, the return should be considered a long, as the ZF is returned
in DX ( 0 = character ready; -1 = character not ready ). \

;	usage:	long keybios( int );

service	equ	ss:word ptr[bp+4]	; 0 = read next character (AX)
					; 1 = report whether char ready (AX)
					; 2 = get shift status (AL)

_TEXT	segment	byte public 'CODE'
	assume	cs:_TEXT

	public	_KEYBIOS
_KEYBIOS	proc	near

	push	bp		; save registers
	mov	bp,sp
;	push	di
;	push	si

	mov	ax,service	; service code
	xchg	ah,al		; put code in ah

	xor	dx,dx		; not zero default
	int	16h		; keyboard BIOS interrupt
	jnz	exit		; not zero
	dec	dx		; -1 = ZF set

exit:
;	pop	si
;	pop	di
;	mov	sp,bp
	pop	bp
	ret

_KEYBIOS	endp

_TEXT	ends

	End

