* The ATTR profile command defines the display attributes to be used for
* various portions of the FDIR display screen. Each display attribute value is
* entered as a 2 digit hexadecimal value or "*", if the default is desired.
* The ATTR command is described below;
*
*       ATTR  a  b  c  d  e  f  g  h
*
*       Where; a = title literals at top of display
*              b = borders between display areas
*              c = file information areas of display
*              d = command input areas of display
*              e = messages displayed in command input areas
*              f = "Fnn" literals at bottom of display
*              g = Function key names at bottom of display
*              h = Entire screen when a DOS command or "/H" is executed

* attr 0f 07 07 0f 70 70 07 07    (Default attributes for MONOCHROME monitors)
* attr 09 07 06 03 04 09 02 07    (Default attributes for COLOR monitors)

*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*

* The CHAR profile command defines the character to be used to identify FDIR
* commands or fileid functions within DOS commands. The character is entered
* as a 1 punctuation character OTHER than "*", "=" or "?". This command
* character MUST be "doubled-up" if it is to be part of the command text. For
* example, if "/" is the character "FORMAT B: //V" results in "FORMAT B: /V".
* The CHAR command is described below;
*
*       CHAR  a
*
*       Where; a = character denoting an FDIR command or fileid function
*

* char /    (Default FDIR command character)

*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*

* The DEFINE profile command defines the FDIR or DOS command to be assigned
* to a given function key. Each function key is identified as "Fnn", "A-Fnn",
* "C-Fnn" or "S-Fnn", followed by an equal sign, followed by the name to be
* displayed for the function key, followed by the FDIR or DOS command text
* to be assigned to the function key.
* The DEFINE command is described below;
*
*       DEFINE  a  =  [b]  c
*
*       Where; a = function key being assigned
*              b = name to be displayed in name area of display
*              c = FDIR or DOS command text

define f1    = [Help]         /h
define f2    = [Cancel]       /c
define f3    = [Quit]         /q
define f4    = [Edit]         edlin
define f5    = [Sort Date]    /sd
define f6    = [Sort Ext]     /se
define f7    = [Sort Name]    /sn
define f8    = [Sort Size]    /ss
define f9    = [Refresh]      /r
define f10   = [Execute]      /x
define a-f1  = [Read A:]      /r a:
define a-f2  = [Read B:]      /r b:
define a-f3  = [Read C:]      /r c:
define a-f4  =
define a-f5  =
define a-f6  = [Append A:]    /a a:
define a-f7  = [Append B:]    /a b:
define a-f8  = [Append C:]    /a c:
define a-f9  =
define a-f10 = [Find Next]    /f =
define c-f1  = [Tree (All)]   /l /dpn
define c-f2  = [Tree (DIRs)]  /l /dpn -d
define c-f3  = [Prev Level]   /l-
define c-f4  = [Next Level]   /l+
define c-f5  =
define c-f6  =
define c-f7  =
define c-f8  =
define c-f9  =
define c-f10 = [Run Program]  /dpn
define s-f1  = [Copy To A:]   copy / a:
define s-f2  = [Copy To B:]   copy / b:
define s-f3  = [Copy To C:]   copy / c:
define s-f4  =
define s-f5  =
define s-f6  =
define s-f7  =
define s-f8  =
define s-f9  =
define s-f10 = [Call DOS]     /o command

*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*

* The EXECUTE profile command defines a FDIR or DOS command to be executed
* during FDIR initialization. This is most useful for sorting the directory
* into a given sequence prior to being displayed.
* The EXECUTE command is described below;
*
*       EXECUTE  a
*
*       Where; a = FDIR or DOS command text

* execute /sd

*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*

* The FILEID profile command defines the components to be used for creating
* full fileids when inserting by "/" or appending to the end of a DOS command.
* The fileid may consist of "D(rive)", "P(ath)", "N(ame)" and/or "E(xtension)".
* The FILEID command is described below;
*
*       FILEID  a
*
*       Where; a = Any combination of "D", "P", "N" and/or "E"

* fileid dpne    (Default fileid components)

*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*

* The MACRO profile command defines the "macro" text to be assigned to a given
* alternate key. Each alternate key is identified as "A-x", followed by an
* equal sign, followed by the text of the "macro" to be assigned to the key.
* The MACRO command is described below;
*
*       MACRO  a  =  b
*
*       Where; a = alternate key being assigned
*              b = "macro" text

macro a-a =
macro a-b =
macro a-c = copy /
macro a-d =
macro a-e = erase
macro a-f = format
macro a-g =
macro a-h =
macro a-i =
macro a-j =
macro a-k =
macro a-l = label
macro a-m = mkdir
macro a-n =
macro a-o =
macro a-p = path
macro a-q =
macro a-r = rename
macro a-s =
macro a-t = type
macro a-u =
macro a-v =
macro a-w =
macro a-x =
macro a-y =
macro a-z =
macro a-0 =
macro a-1 =
macro a-2 =
macro a-3 =
macro a-4 =
macro a-5 =
macro a-6 =
macro a-7 =
macro a-8 =
macro a-9 =

*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*

* The OPTION profile command defines various options to be used by FDIR. The
* possible options are shown below;
*
*       CHDIR or NOCHDIR     - "CHDIR" before each DOS command
*       ECHO or NOECHO       - "ECHO" DOS commands prior to execution
*       HOLD or NOHOLD       - "HOLD" after DOS commands which create output
*       PAUSE or NOPAUSE     - "PAUSE" before each DOS command (ESC to skip)
*       RETRACE or NORETRACE - "RETRACE" synchronization required (Std. Color)
*
* The OPTION command is described below;
*
*       OPTION  a  b  c  d  e
*
*       Where; a = One of the options listed above
*              b = One of the options listed above
*              c = One of the options listed above
*              d = One of the options listed above
*              e = One of the options listed above

* option nochdir echo hold nopause retrace     (Default options in effect)

*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*

* The SYNONYM profile command defines an alias for a DOS command. Each alias
* is replaced by its true name prior to DOS command execution. A maximum of
* 50 SYNONYM commands are allowed, others will be IGNORED.
* The SYNONYM command is described below;
*
*       SYNONYM  a  b
*
*       Where; a = alias DOS command name
*              b = true DOS command name

synonym c copy
synonym e edlin
synonym l type
synonym r rename
