PROGRAM Write_ADL_File;  {Shareware version, ADL.PAS, 070987}


        (***********************************************************)
        (*                                                         *)
        (*                    Automatic Download                   *)
        (*                                                         *)
        (*     ADL is designed to be used with Procomm 2.42        *)
        (*     to speedup file downloads, especially from          *)
        (*     the Source [as we all know can be very slow].       *)
        (*                                                         *)
        (*     ADL.COM must be run from DOS, either before         *)
        (*     starting Procomm, or by using the Alt-F4 DOS        *)
        (*     gateway if you are already in it.  I suppose        *)
        (*     it could be your "editor" option for Alt-A          *)
        (*     if you are not already using that option.           *)
        (*                                                         *)
        (*     ADL writes a file, ADL.CMD.  This file's sole       *)
        (*     purpose is to assign values [the filenames to       *)
        (*     be downloaded] to the Procomm CMD file              *)
        (*     DL-xxxx.CMD, which it then calls via the            *)
        (*     EXEC command.  This file then talks to the          *)
        (*     BBS, or the Source, and downloads the files.        *)
        (*     The maximum number of files is nine at a time.      *)
        (*                                                         *)
        (*     So...put ADL.COM on your disk somewhere; there      *)
        (*     is an pathname option which lets you choose         *)
        (*     where ADL.COM will be written.  Choose the          *)
        (*     directory you run your CMD files from. Also         *)
        (*     put the DL-xxxx.CMD files there.  Then from         *)
        (*     DOS enter "ADL" [no quotes] and follow the          *)
        (*     prompts.  When the ADL.CMD file is written,         *)
        (*     go to, or return to, Procomm.  Hit Alt-F5 and       *)
        (*     enter "ADL" [no quotes] again.  You must be         *)
        (*     at the IBMSIG or PC-Board main prompts when         *)
        (*     the CMD file is started.  That's it!                *)
        (*                                                         *)
        (*     In addition to the four DL-x.CMD files included     *)
        (*     in this ARC file I have included the option         *)
        (*     to name four other EXEC that can be called from     *)
        (*     ADL.CMD:  DL-TBBS.CMD, DL-FIDO1.CMD,                *)
        (*     DL-SPCL1.CMD, and DL-SPCL2.CMD.                     *)
        (*     You can then write your own D/L Procomm files       *)
        (*     for four other BBSs or whatever.                    *)
        (*                                                         *)
        (*     I don't know too much about the speed of the        *)
        (*     DL-x CMD files, as the only machine I have to       *)
        (*     test it on is an AT clone.  However, once run-      *)
        (*     ning the DL- files, Procomm doesn't have to go      *)
        (*     to the disk again until done.                       *)
        (*                                                         *)
        (*     I hope you like it!  Please share it with           *)
        (*     anyone, but keep the ARC file intact.               *)
        (*                                                         *)
        (*                                                         *)
        (*     Feedback is readily accepted at:                    *)
        (*                                                         *)
        (*     Pepper's Data System  (205) 626-7447                *)
        (*     SourceMail, BEF697                                  *)
        (*                                                         *)
        (*            - or -                                       *)
        (*                                                         *)
        (*     Andrew Adams                                        *)
        (*     Intelligent Alternatives                            *)
        (*     2410 Hall's Mill Road                               *)
        (*     Mobile, AL 36606                                    *)
        (*     (205) 471-0005 (voice)                              *)
        (*                                                         *)
        (*     If you live in a PCP-accessable area I can call     *)
        (*     you on your modem after 6 p.m. or weekends.         *)
        (*     Or leave a message on Cotiere BBS, (404)            *)
        (*     948-6596.                                           *)
        (*                                                         *)
        (***********************************************************)


type
  Str12    = string[12];
  Str32    = string[32];

var
  OutFile   : text;
  OutChoice : integer;


function NumWord (Counter : integer) : Str32;
{Get a word as a function of the count}

begin
  case Counter of
    0 : NumWord := 'First';
    1 : NumWord := 'Second';
    2 : NumWord := 'Third';
    3 : NumWord := 'Fourth';
    4 : NumWord := 'Fifth';
    5 : NumWord := 'Sixth';
    6 : NumWord := 'Seventh';
    7 : NumWord := 'Eighth';
    8 : NumWord := 'Ninth'
  end
end;


function BdChoice (Choice  :integer) : Str32;
{Get download CMD file name as a function of user's choice}

begin
  case Choice of
    1 : BdChoice := 'DL-PCB';
    2 : BdChoice := 'DL-SRCE';
    3 : BdChoice := 'DL-RBBS';
    4 : BdChoice := 'DL-TBBS';
    5 : BdChoice := 'DL-FIDO1';
    6 : BdChoice := 'DL-VBG';
    7 : BdChoice := 'DL-SPCL1';
    8 : BdChoice := 'DL-SPCL2'
  end
end;


procedure StrToUpper (var S : Str32);

var
  i : integer;

begin
  for i := 1 to length(S) do
    S[i] := UpCase(S[i])
end;


procedure Done;

begin
  Close(OutFile);
  ClrScr;
  GotoXY(28,10);
  writeln('The CMD file is ready.')
end;  {Done}


procedure GetPathName;

var
  Pathname : Str32;
  Ch       : char;

begin
  Pathname := '';
  ClrScr;
  GotoXY(5,5);
  write('Do You need a pathname for your DL-.CMD file [Y] [C/R=N]?  ');
    repeat
      read (Kbd,Ch)
    until Upcase(Ch) in ['Y',#13];
    if (Upcase(Ch) = 'Y') then begin
      GotoXY(6,13);
      writeln('Pathname: ');writeln;
      write('Examples:  "B:", "\PROCOMM\", or "C:\PROCOMM\" (Without the quotes).');
      GotoXY(16,13);
      read(Pathname);
      StrToUpper(Pathname)
    end;  {Pathname select}
  writeln(OutFile,'EXEC "',Pathname,BdChoice(OutChoice),'"')
end;  {GetPathName}


procedure Files;
{Get the filenanes and write them to the disk}

var
  FileN    : Str12;
  LongName : Str32;
  FNCount  : byte;
  Yes      : char;

begin
  ClrScr;
  FNCount := 0;
  GotoXY(10,3);
  write('***** To stop entering filenames hit return at the prompt. *****');
  while (FNCount < 9 ) do begin
    repeat
      GotoXY(3,13);
      write('                                                            ');
      GotoXY(3,15);
      write('                                                            ');
      GotoXY(3,13);
      write('The ',NumWord(FNCount),' filename to download? ');
      readln(LongName);
        if (LongName = '') then begin
          writeln(OutFile,'ASSI S',FNCount+1,' "XXX"');
          exit
        end;     { Stop files list option }
      GotoXY(3,15);
      write('   Is the filename spelled correctly? ');
      readln(Yes)
    until (Yes in ['Y','y']);
    FNCount := FNCount + 1;
    StrToUpper(LongName);                       {to use StrToUpper}
    FileN := LongName;                          {       "         }
    writeln(OutFile,'ASSI S',FNCount,' "',FileN,'"')
  end { While < 9 }
end;  {Files}


procedure SourceChoice;
{Get choice of board in order to select DL file}

var
  Ch     : char;
  Result : integer;

begin
  ClrScr;
  writeln;
  writeln('           Enter the number of the download BBS:');
  writeln;
  writeln('                        1. PC-Board');
  writeln('                        2. The Source');
  writeln('                        3. RBBS');
  writeln('                        4. TBBS');
  writeln('                        5. FIDO1');
  writeln('                        6. Vern Buerg''s BBS');
  writeln('                        7. Special-1');
  writeln('                        8. Special-2');
    repeat
      read (Kbd,Ch)
    until Upcase(Ch) in ['1'..'8'];
  val(Ch,OutChoice,Result);
  assign(OutFile,'ADL.CMD');
  rewrite(OutFile)
end;


BEGIN
  SourceChoice;
  Files;
  GetPathName;
  Done
END.

