comment * WordStar Tab Ruler
L-------!-------!---------------!----!----!----!----!----!----!----!---------------------------R
12-5-85
*
cseg segment para public 'code'
assume cs:cseg,ds:cseg,es:cseg,ss:cseg


len_picture=2289

        org     0h
Zero:                           ;ret to DOS
        org     100h
start:  jmp     init            ;goto initialization routine

buffer          db 256 dup(?)
handle          dw ?
char            db ?
filespec_buffer db 256 dup(?) 

screen_page     db ?
attrib          db ?
mode            db ?
say_color_flag  db 0
cursor          label word

max_line        db ?
cur_line        db ?
max_col         db ?
cur_col         db ?
create          db ?
rotate          db ?
space_size      db ?
ins_del_flag    db ?

cursor_size     dw ?
screen_seg      dw ?
screen_buffer   dw ?

paste_size      dw ?            ; y/x size of paste_buffer
last_x          db ?
last_y          db ?
block_cursor    label word
 cursor_x       db ?
 cursor_y       db ?
quad            db ?
wrap_flag       db ?

esc=27

getkey  macro 
        call    get_keystroke
        endm

get_keystroke:
        mov     ah,1
        int     16h
        jz      GK_ret
        pushf
        mov     ah,0
        int     16h
        popf    
GK_ret: ret

jump    macro table,item
        mov     bx,offset table
        mov     al,item
        call    table_jump
        endm
;
search  macro   table,item
        mov     bx,offset table
        mov     ax,item
        call    table_search
        endm
;
table_jump:
        cmp     cs:[bx],al         ;too big an offset?
        jc      TJ_end
        dec     bx
        mov     ah,0
        add     ax,ax           ;prep offset
        add     bx,ax           ;get actual addr of routine
        jmp     word ptr cs:[bx]     ;go to routine
TJ_end: ret
;
table_search:
        push    bx
        push    cx              ;search table @ BX for AL
        push    dx
        push    di
        or      al,al           ;2-byter
        jz      TS_10           ;yes, don't clear top
        mov     ah,0            ;otherwise...
        call    capit_al
TS_10:  mov     cl,[bx]         ;get len of $ to search
        mov     ch,0
        mov     di,bx
TS_5:   inc     di              ;skip length
        mov     dx,[di]         ;get table entry
        or      dl,dl           ;test for 2-byter
        jnz     TS_2            ;no
        inc     di
        jmp short TS_3
TS_2:   mov     dh,0            ;clear top byte for cmp
TS_3:   cmp     ax,dx           ;are they the same?
        je      TS_4            ;go if they are
        loop    TS_5            ;else go to end of table
        jmp short TS_1          ;done but not found
TS_4:   mov     ch,[bx]         ;get len of table again
        sub     ch,cl           ;get offset into table
        mov     ah,ch           ;get offset into ah
        inc     ah              ;make go from 1
        xor     bx,bx           ;set flags
TS_1:   pop     di
        pop     dx
        pop     cx
        pop     bx
        ret
;
capit_al:
        cmp     al,'a'
        jc      CA_1
        cmp     al,'z'+1
        jnc     CA_1
        sub     al,32
CA_1:   ret

retf    macro   pop_value
 ifb <pop_value>
        db      0cbH            ;far ret w/no [pop-value]
 else
        db      0caH            ;far ret w/pop-value
        dw      pop_value
 endif
        endm
;

ceol db esc,'[K$'

print_cs_space:
        mov     ah,9
        int     21h
        mov     dl,32
        mov     ah,2
        int     21h
        ret

print_cs:
        mov     ah,9
        int     21h
        mov     dx,offset ceol
        mov     ah,9
        int     21h
        ret


save_screen:
        mov     si,0
        mov     di,[screen_buffer]
        mov     ax,screen_seg
        mov     ds,ax
        mov     cx,1760
        rep     movsw
        mov     ax,es
        mov     ds,ax
        ret

MU_undo:
restore_screen:
        pushf
        push    ax
        push    cx
        push    si
        push    di
        mov     ax,screen_seg
        mov     es,ax
        mov     si,[screen_buffer]
        mov     di,0
        mov     cx,1760
        rep     movsw
        mov     ax,ds
        mov     es,ax
        pop     di
        pop     si
        pop     cx
        pop     ax
        popf
        ret


memory_error db 'Memory allocation error (not enough, or bad allocation blocks)',13,10,10

break_handler:
        iret

No_parm:
        call    cls
        mov     cx,len_picture
        mov     dx,offset screen_buffer_1
        mov     bx,0            ;CON
        mov     ah,40h          ;write to file
        int     21h
np_1:   getkey
        jnz     np_1
np_2:   getkey
        jz      np_2

        call    cls
        jmp     editor

bad_dos_version db 'tDoodle 1.00: Incorrect DOS Version.$'

parm_error_so:
        jmp     parm_error

;************* Start *********************
init:   mov     ah,30h
        int     21h             ;get DOS ver #
        cmp     al,2
        jae     init_9
        mov     dx,offset bad_dos_version
        mov     ah,9
        int     21h
        jmp     zero

init_9: mov     bx,offset end_of_code
        mov     cl,4
        shr     bx,cl           ;turn byte count into para's
        inc     bx
        mov     ah,4Ah
        int     21h
        jnc     init_10
        mov     dx,offset Memory_error
        call    print_cs
        jmp     zero

no_parm_so: 
        jmp no_parm

init_10:
        mov     ah,25h          ;get ^Break addr
        mov     al,23h          ;^BREAK int #
        mov     dx,offset Break_handler
        int     21h
        
        mov     ah,3
        int     10h             ;get cursor size
        mov     cursor_size,cx
        call    fix_cursor_block

        mov     screen_buffer,offset screen_buffer_1
        
        mov     di,offset filespec_buffer
        mov     al,64
        stosb

        mov     si,80h          ;parameter addr
        lodsb                   ;get len of command$
        mov     bl,al
        mov     bh,0
        or      bl,bh           ;is len(parm)=0?
        jz      No_Parm_so
        mov     byte ptr [si+bx],0   ;terminate ASCIIZ

init_loop_1:
        lodsb                   ;get char of $
        or      al,al           ;EOS?
        jz      Parm_error_so
        cmp     al,13           ;EOS?
        jz      Parm_error_so
        cmp     al,9            ;nothing?
        jz      init_loop_1
        cmp     al,32           ;space?
        jz      init_loop_1
        dec     si

        push    si
        mov     cl,0
        inc     di
init_1: lodsb
        stosb
        inc     cl
        cmp     al,0            ;EOS?
        jne     init_1
        dec     cl
        mov     byte ptr [filespec_buffer+1],cl
        pop     si

        mov     dx,si
        mov     al,2            ;open for r/w
        mov     ah,3Dh
        int     21h             ;open file
        jnc     Load_File_so
        cmp     al,2
        jnz     File_open_error
        mov     dx,si
        mov     ah,3Ch
        mov     cx,0
        int     21h
        jc      File_open_error
Load_file_so:
        jmp     Load_file

Parm_error_message db 'Bad parameter line',13,10,'$'
File_open_error_message db 'Couldn',27h,'t open file',13,10,'$'
Load_error_message db 'Had trouble loading file.',13,10,'$'

Parm_error:
        mov     dx,offset Parm_error_message
        call    print_cs
        jmp     ret_to_dos
File_open_error:
        mov     dx,offset File_open_error_message
        call    print_cs
        jmp     ret_to_dos
Load_error:
        mov     byte ptr [di-1],13
        mov     bx,handle
        mov     ah,3Eh
        int     21h
        mov     dx,offset Load_error_message
        call    print_cs
Ret_to_DOS_2:
Ret_to_DOS:
        jmp     Zero

cls_string db esc,'[=2h',esc,'[?7h',esc,'[0m',esc,'[2J','$'

cls:    mov     dx,offset cls_string
        call    print_cs
        mov     attrib,7
        call    fix_cursor_block
        ret

Load_File:
        mov     handle,ax

        call    cls
Load_loop:
        mov     bx,handle
        mov     ah,3Fh
        mov     cx,1
        mov     dx,offset buffer
        int     21h
        jc      Load_Error
        or      ax,ax
        jz      Load_Ended

        mov     dl,byte ptr [buffer]
        cmp     dl,26           ;^Z terminating?
        jz      Load_Ended

        mov     ah,2
        int     21h
        jmp     Load_loop

Load_Ended:
        mov     bx,handle
        mov     ah,3Eh
        int     21h             ;close file

        mov     cx,0            ;home cursor
        call    set_cur_pos
        jmp     Editor

text_table db 14
        db 8    ;bksp
        db 13   ;RET
        db 0,71 ;HOME
        db 0,72 ;up
        db 0,73 ;PgUp
        db 0,75 ;lt
        db 0,77 ;rt
        db 0,79 ;END
        db 0,80 ;dn
        db 0,81 ;PgDn
        db 27   ;ESC
        db 0,82 ;INS
        db 0,83 ;DEL
        db 9    ;TAB

text_jmp_table db 14
        dw offset key_bksp
        dw offset key_cr
        dw offset key_home
        dw offset key_up
        dw offset key_pgup
        dw offset key_lt
        dw offset key_rt
        dw offset key_end
        dw offset key_dn
        dw offset key_pgdn
        dw offset key_esc
        dw offset key_ins
        dw offset key_del
        dw offset key_tab
 
cmd_key db 8, esc,'RCSLQWF'

cmd_table db 8
        dw offset cmd_esc       ;toggle to/from text/cmd
        dw offset cmd_R         ;replace (not implemented)
        dw offset cmd_C         ;set Colors
        dw offset cmd_S         ;Save file
        dw offset cmd_L         ;Load file
        dw offset cmd_Q         ;Quit tDoodle
        dw offset cmd_W         ;Wipe out screen (cls)
        dw offset cmd_F         ;Flip between screens

box_key_table db 14, 'QWEASDZXC-_\| '
box_table_list label word
        dw offset box_table_1
        dw offset box_table_2
        dw offset box_table_3
        dw offset box_table_4

box_table_1 db 218,194,191,195,197,180,192,193,217,196,196,179,179,32
box_table_2 db 201,203,187,204,206,185,200,202,188,205,205,186,186,32
box_table_3 db 213,209,184,198,216,181,212,207,190,205,205,179,179,32
box_table_4 db 214,210,183,199,215,182,211,208,189,196,196,186,186,32

fn_table db 10
        db 0,59                 ;F1: rotate box modes
        db 0,60                 ;F2: set csr attr to cur attr
        db 0,61                 ;F3: reverse screen attribs
        db 0,62                 ;F4: rotate paint/text/both 
        db 0,63                 ;F5: show colors
        db 0,64                 ;F6: Flip from one screen to the other
        db 0,65                 ;F7: Pickup
        db 0,66                 ;F8: PutDown
        db 0,67                 ;F9: Undo
        db 0,68                 ;F0: Macros

mode_update_table db 10
        dw offset MU_boxes
        dw offset MU_attrib
        dw offset MU_reverse
        dw offset MU_put_mode
        dw offset MU_show_colors
        dw offset MU_flip
        dw offset MU_Pickup
        dw offset MU_PutDown
        dw offset MU_Undo
        dw offset MU_Macros

key_bksp:
key_lt: call    get_cur
        cmp     cl,0
        jz      KL_1
        dec     cl
SCP:    jmp     Set_cur_pos
KL_1:   cmp     wrap_flag,255
        jne     scp
        mov     cl,78
Key_up_2:
        or      ch,ch
        jz      Set_cur_pos
        dec     ch
        jmp     Set_Cur_pos
Key_cr:
        call    get_cur
        cmp     ch,21
        jz      Set_Cur_pos
        inc     ch
        mov     cl,0
        jmp     Set_Cur_pos
Key_rt: call    get_cur
        cmp     cl,78
        jne     KR_1
        cmp     wrap_flag,255
        jne     set_cur_pos
        jmp     Key_cr
KR_1:   inc     cl
Set_cur_pos:
        mov     ah,2
        mov     bh,screen_page
        mov     dx,cx
        int     10h
	cmp	say_color_flag,0
	jz	SCP_ret
        call    say_color
SCP_ret:
        ret
Key_up: call    get_cur
        jmp     Key_up_2
Key_dn: call    get_cur
        cmp     ch,21
        jz      Set_cur_pos
        inc     ch
        jmp     Set_cur_pos
Key_home:
        mov     cx,0
        jmp     Set_cur_pos
Key_PgUp:
        call    Key_up
        call    key_rt
        ret
Key_PgDn:
        call    Key_dn
        call    key_rt
        ret
Key_End:
        mov     cx,21*256
        jmp     Set_cur_pos
get_cur:
        mov     ah,3
        mov     bh,screen_page
        int     10h
        mov     cx,dx
        ret
key_esc:
        clc
        call    save_cur
        pop     ax
        ret

key_ins:
        mov     bh,screen_page
        mov     ah,3
        int     10h
        mov     cursor,dx
        mov     al,attrib
        push    ax

        mov     ins_del_flag,255
        push    dx              ;save it for later
        mov     dl,78           ;last col

KI_1:   dec     dl
        mov     ah,2            ;set curpos
        int     10h
        mov     ah,8
        int     10h             ;read c/a
        mov     attrib,ah
        push    ax

        inc     dl
        mov     ah,2
        int     10h
        pop     ax
        push    dx
        call    alt_modes
        pop     dx
        mov     cx,1
        mov     ah,9
        int     10h             ;write c/a

        dec     dl
        pop     cx
        cmp     dl,cl
        push    cx
        jne     KI_1
        pop     cx
        mov     ah,2
        int     10h             ;reset cursor

        pop     ax
        mov     attrib,al
        mov     al,32
        call    alt_modes
        mov     cx,1
        mov     ah,9
        int     10h

        mov     ins_del_flag,0
        ret

key_del:
        mov     bh,screen_page
        mov     ah,3
        int     10h             ;get curpos
        mov     cursor,dx
        mov     al,attrib
        push    ax

        mov     ins_del_flag,255

kd_1:   inc     dl              ;next col over
        mov     ah,2
        int     10h
        mov     ah,8
        int     10h             ;get c/a
        mov     attrib,ah
        push    ax

        dec     dl
        mov     ah,2
        int     10h
        pop     ax
        push    dx
        call    alt_modes
        pop     dx
        mov     cx,1
        mov     ah,9
        int     10h

        inc     dl
        cmp     dl,78
        jne     kd_1
        mov     ah,2
        int     10h

        pop     ax
        mov     attrib,al
        mov     al,32
        call    alt_modes
        mov     cx,1
        mov     ah,9
        int     10h

        mov     dx,cursor
        mov     ah,2
        int     10h
        mov     ins_del_flag,0
        ret

key_tab:
        mov     bh,screen_page
        mov     ah,3
        int     10h             ;get curpos
        mov     cl,3
        sar     dl,cl
        inc     dl
        sal     dl,cl
        and     dl,255-7
        cmp     dl,78
        jbe     kt_cont
        mov     dl,78
        cmp     dh,22
        je      kt_cont
        inc     dh
        mov     dl,0

kt_cont:
        mov     ah,2
        int     10h
        ret

fix_cursor_block:
        mov     ah,15
        int     10h             ;get screen mode
        mov     screen_page,bh
        mov     cx,12           
        mov     dx,0B000h       ;mono seg
        mov     say_color_flag,255
        cmp     al,7            ;monochrome
        jz      set_cursor_block
        mov     cl,7
        mov     dx,0B800h       ;cga seg
        mov     say_color_flag,0
set_cursor_block:
        mov     screen_seg,dx
        mov     ah,1
        int     10h             ;set new cursor 
        ret

restore_cursor_block:
        mov     cx,cursor_size
        mov     ah,1
        int     10h
        ret


Editor: mov     attrib,7        ;default, white on black
        mov     mode,0          ;text mode
Editor_loop:
        mov     wrap_flag,255
        call    display_ctrls
        call    mode_text       ;go update screen
        call    mode_cmd
        jnc     Editor_loop
        call    restore_cursor_block
        jmp     Ret_to_DOS_2

mode_text:
        getkey  
        jz      mode_text
        push    ax
        search  text_table,ax
        jnz     MT_text
        pop     dx
        jump    text_jmp_table,ah
        jmp     mode_text
MT_text:
        pop     ax              ;get back key
        push    ax              ;and save it back
        search  fn_table,ax
        je      mode_update
        pop     ax
        or      al,al
        jz      mode_text       ;bad keystroke
        cmp     al,32
        jb      mode_text
        call    alt_modes
        mov     cx,1
        mov     ah,9
        int     10h
        call    key_rt
        jmp     mode_text

mode_update:
        pop     dx              ;clear stack
        jump    mode_update_table,ah
        mov     wrap_flag,255
        jmp     mode_text

MU_boxes:
        mov     ah,mode
        test    ah,128
        jz      F1_start
        mov     al,ah
        and     al,252
        inc     ah
        and     ah,3
        or      ah,ah
        jz      F1_end
        or      ah,al
        mov     mode,ah
        call    display_ctrls
        ret
F1_end: and     al,127
        mov     mode,al
        call    display_ctrls
        ret
F1_start:
        or      ah,128
        and     ah,252
        mov     mode,ah
        call    display_ctrls
        ret

MU_attrib:
        mov     ah,8
        mov     bh,screen_page
        int     10h
        mov     attrib,ah
        call    display_ctrls
        ret

MU_reverse:
        mov     ah,attrib
        mov     al,ah
        mov     cl,4
        ror     ah,cl
        and     ah,255-(128+8)  ;clear int/blnk bits
        and     al,128+8
        or      ah,al           ;move old blnk/int into attribs
        mov     attrib,ah
        call    display_ctrls
        ret

MU_put_mode:
        mov     ah,mode
        mov     cl,5
        ror     ah,cl
        and     ah,3
        test    ah,1            ;not "both"?
        jnz     MU_pm_1         ;go if not "both"
        mov     ah,1
MU_pm_3:
        mov     al,mode
        and     al,255-96       ;clear out current mode
        rol     ah,cl
        or      al,ah
        mov     mode,al       ;set new one
        call    display_ctrls
        ret
MU_pm_1:
        xor     ah,2            ;set 0 to 1
        test    ah,2            ;is it 0
        jz      MU_pm_2
        jmp     MU_pm_3
MU_pm_2:
        mov     ah,0
        jmp     MU_pm_3


mu_sc_setup db esc,'[24;1f$'

mu_sc_colors db 8
        dw offset mu_black
        dw offset mu_blue
        dw offset mu_green
        dw offset mu_cyan
        dw offset mu_red
        dw offset mu_magenta
        dw offset mu_yellow
        dw offset mu_white

mu_black        db 'Black$'
mu_blue         db 'Blue$'
mu_green        db 'Green$'
mu_cyan         db 'Cyan$'
mu_red          db 'Red$'
mu_magenta      db 'Magenta$'
mu_yellow       db 'Yellow$'
mu_white        db 'White$'

mu_blinking     db 'Blinking$'
mu_bright       db 'Bright$'
mu_on           db 'on$'
mu_comma        db 8,',$'

MU_show_colors:
        xor     say_color_flag,255
        cmp     say_color_flag,0
        jne     say_color
        ret

say_color:
        push    ax
        push    bx
        push    cx
        push    dx
        push    si
        push    di

        mov     bh,screen_page
        mov     ah,8
        int     10h             ;get c/a
        push    ax

        mov     ah,3
        int     10h             ;get curpos
        mov     cursor,dx

        mov     dx,offset mu_sc_setup
        call    print_cs

        pop     ax              ;get c/a
        push    ax
        test    ah,8            ;bright?
        jz      MU_sc_1
        mov     dx,offset mu_bright
        call    print_cs_space
        pop     ax 
        push    ax
        test    ah,128          ;blinking?
        jz      mu_sc_1
        mov     dx,offset mu_comma
        call    print_cs_space
        pop     ax
        push    ax
mu_sc_1:
        test    ah,128          ;blinking?
        jz      mu_sc_2
        mov     dx,offset mu_blinking
        call    print_cs_space
        pop     ax
        push    ax
mu_sc_2:
        and     ah,7            ;get foreground color
        mov     al,ah
        mov     ah,0
        add     ax,ax
        mov     bx,ax
        inc     bx
        mov     si,offset mu_sc_colors
        mov     dx,[si+bx]
        call    print_cs_space
        mov     dx,offset mu_on
        call    print_cs_space
        pop     ax
        mov     cl,4
        ror     ah,cl
        and     ah,7
        mov     al,ah
        mov     ah,0
        add     ax,ax
        mov     bx,ax
        inc     bx
        mov     dx,[si+bx]
        call    print_cs

        mov     dx,cursor
        mov     ah,2
        mov     bh,screen_page
        int     10h

        pop     di
        pop     si
        pop     dx
        pop     cx
        pop     bx
        pop     ax
        ret


alt_modes:
        test    mode,128        ;is graphic active?
        jz      AM_paint        ;no, go check attr only
        test    ins_del_flag,1  ;no box conv?
        jnz     AM_paint
        search  box_key_table,ax
        je      AM_1
        pop     ax              ;clear stack
        jmp     mode_text
AM_1:   mov     dl,mode
        mov     dh,0
        and     dl,3
        add     dx,dx
        mov     bx,offset box_table_list
        add     bx,dx
        mov     bx,cs:[bx]      ;get addr of xlat table
        dec     ah
        mov     al,ah
        mov     ah,0
        add     bx,ax
        mov     al,cs:[bx]      ;get xlated box part

AM_paint:                       ;t/a lockout? 
        push    ax
        test    mode,32
        jz      AM_normal
        mov     bh,screen_page
        mov     ah,8
        int     10h             ;get c/a
        test    mode,64         ;text only?
        jz      AM_attr         ;no, attr only.
        mov     bl,ah           ;set attr to what's under cur
        mov     bh,screen_page
        pop     ax              ;recover text
        ret

AM_attr:
        pop     dx              ;scrap old text
        mov     bh,screen_page
        mov     bl,attrib
        ret

AM_normal:
        pop     ax
        mov     bh,screen_page
        mov     bl,attrib
        ret

mup_inst db esc,'[24;1fUse ',24,' ',25,' ',26,' and ',27,' to move,',13,10
        db 'F7 to set other end of block, ESC to abort CUT.$'


mu_Pickup:
        call    save_screen
        call    save_cur
        mov     say_color_flag,0
        mov     wrap_flag,0
        mov     di,0700h
        mov     si,00FFh        ;setup for CLS2
        mov     dx,0            ;csrpos
        mov     bh,screen_page
        push    cursor
        call    cls2
        pop     cursor

        mov     dx,offset mup_inst
        call    print_cs
        call    restore_cur
        mov     dx,cursor
        mov     block_cursor,dx
        mov     last_x,dl
        mov     last_y,dh
        call    fix_block

mup_1:  getkey
        jz      mup_1
        cmp     ax,4100h        ;F7?
        je      mup_2

        search  text_table,ax
        jne     mup_1
        cmp     ah,2
        je      mup_1
        cmp     ah,3
        je      mup_1
        cmp     ah,8
        je      mup_1
        cmp     ah,12
        je      mup_1
        cmp     ah,13
        je      mup_1
        cmp     ah,11
        je      mup_esc
        jump    text_jmp_table,ah
        call    fix_block
        jmp     mup_1
mup_esc:
        call    restore_screen
        call    display_ctrls
        call    restore_cur
        ret

mup_2:  mov     bh,screen_page
        mov     ah,3            ;read curpos
        int     10h
        mov     cx,block_cursor
        cmp     ch,dh           ;make DX hold bigger y/x
        jbe     mup_3
        xchg    ch,dh
mup_3:  cmp     cl,dl
        jbe     mup_4
        xchg    cl,dl

mup_4:  push    dx              ;save bigger values
        sub     dx,cx
        inc     dl
        inc     dh              ;make go from 1
        mov     paste_size,dx   ;set y/x of block size
        pop     dx

        call    restore_screen
        mov     di,offset paste_buffer
        xchg    cx,dx           ;move small curpos to cursor register
        
mup_6:  push    dx
mup_5:  mov     ah,2
        int     10h
        mov     ah,8
        int     10h
        stosw

        cmp     dl,cl
        je      mup_next_line
        inc     dl
        jmp     mup_5

mup_next_line:
        pop     dx
        cmp     dh,ch
        je      mup_end
        inc     dh
        jmp     mup_6

mup_end:
        jmp     mup_esc


fb_y_more:
        jmp     fb_y_more_routine

fix_block:
        mov     bh,screen_page
        mov     ah,3
        int     10h             ;get curpos
        cmp     dl,last_x
        jb      fb_x_less
        ja      fb_x_more
        call    fb_center
fb_1:   cmp     dh,last_y
        jb      fb_y_less
        ja      fb_y_more
        call    fb_center
fb_2:   mov     last_x,dl
        mov     last_y,dh
        mov     ah,2
        int     10h             ;reset curpos
        ret

fb_x_less:
        cmp     dl,cursor_x
        jb      fbxl_less

        mov     cl,last_x
        cmp     dl,cl
        push    dx
        mov     attrib,7
        mov     dh,last_y
        jbe     fbxl_1
        xchg    dl,cl
fbxl_1: inc     dl
        call    fb_v_line
        cmp     dl,cl
        jne     fbxl_1
        pop     dx
        jmp     fb_1

fbxl_less:
        mov     cl,last_x
        cmp     dl,cl
        push    dx
        mov     attrib,7*16
        jae     fbxl_2
        xchg    dl,cl
fbxl_2: call    fb_v_line
        cmp     dl,cl
        je      fbxl_3
        dec     dl
        jmp     fbxl_2
fbxl_3: pop     dx
        jmp     fb_1

fb_x_more:
        cmp     dl,cursor_x
        ja      fbxl_less

        mov     cl,last_x
        push    dx
        mov     attrib,7
        mov     dh,last_y
        cmp     dl,cl
        jbe     fbxm_1
        xchg    dl,cl
fbxm_1: call    fb_v_line
        inc     dl
        cmp     dl,cl
        jne     fbxm_1
        pop     dx
        jmp     fb_1

fb_y_less:
        mov     quad,0
        cmp     dh,cursor_y
        mov     quad,0
        jb      fbyl_less
        mov     quad,255
fbym_1: mov     ch,last_y
        cmp     dh,ch
        push    dx
        mov     attrib,7
        mov     dl,last_x
        jbe     fbyl_1
        xchg    dh,ch
fbyl_1: call    fbyl_fix_quad_3_4
fbyl_2: call    fb_h_line
        inc     dh
        cmp     dh,ch
        jne     fbyl_2
        pop     dx
        jmp     fb_2

fbyl_less:
        mov     ch,last_y
        cmp     dh,ch
        push    dx
        mov     attrib,7*16
        jae     fbyl_4
        xchg    dh,ch
fbyl_4: dec     ch

fbyl_3: call    fb_h_line
        dec     dh
        cmp     dh,ch
        jne     fbyl_3
        pop     dx
        jmp     fb_2

fb_y_more_routine:
        cmp     dh,cursor_y
        mov     quad,255
        ja      fbyl_less
        mov     quad,0
        jmp     fbym_1

fbyl_fix_quad_3_4:
        test    quad,255
        jz      fbylfq34_ret
        inc     ch
        inc     dh
fbylfq34_ret:
        ret

fb_v_line:
        push    dx
        push    cx
        mov     bh,screen_page

        mov     ch,cursor_y
        cmp     dh,ch
        jbe     fbvl_1
        xchg    dh,ch

fbvl_1: mov     ah,2            ;set curpos
        int     10h
        mov     ah,8
        int     10h             ;read c/a

        push    cx
        mov     bl,attrib
        mov     cx,1
        mov     ah,9
        int     10h             ;write new attrib
        pop     cx

        cmp     dh,ch
        je      fbvl_2
        inc     dh
        jmp     fbvl_1

fbvl_2: pop     cx
        pop     dx
        ret

fb_h_line:
        push    dx
        push    cx
        mov     bh,screen_page

        mov     cl,cursor_x
        cmp     dl,cl
        jbe     fbhl_1
        xchg    dl,cl

fbhl_1: mov     ah,2            ;set curpos
        int     10h
        mov     ah,8
        int     10h             ;read c/a

        push    cx
        mov     bl,attrib
        mov     cx,1
        mov     ah,9
        int     10h             ;write new attrib
        pop     cx

        cmp     dl,cl
        je      fbhl_2
        inc     dl
        jmp     fbhl_1

fbhl_2: pop     cx
        pop     dx
        ret

fb_center:
        push    dx
        mov     ah,3
        int     10h
        pop     cx
        push    dx
        mov     dx,cx
        mov     ah,2
        int     10h
        
        mov     ah,8
        int     10h
        push    cx
        mov     bl,7*16
        mov     cx,1
        mov     ah,9
        int     10h
        pop     cx

        pop     dx
        mov     ah,2
        int     10h
        mov     dx,cx
        ret


mu_putdown:
        call    save_screen     ;save for later undo
        mov     al,attrib
        push    ax
        mov     ins_del_flag,255

        mov     bh,screen_page
        mov     ah,3
        int     10h             ;get curpos
        push    dx              ;save it

        mov     ah,22
        xchg    ah,dh
        sub     dh,ah
        mov     al,79
        xchg    al,dl
        sub     dl,al

        mov     cx,paste_size
        cmp     dh,ch           ;take smaller of two
        jbe     mupd_1
        mov     dh,ch
mupd_1: cmp     dl,cl
        jbe     mupd_2
        mov     dl,cl

mupd_2: mov     si,offset paste_buffer
        mov     cl,dh           ;get # lines to do
        mov     ch,0            ;into CX
        mov     bl,dl           ;get # cols
        mov     bh,0            ;into BX
        pop     dx              ;get cursor pos
        push    dx

mupd_4: push    dx              ;save cursor pos
        push    cx              ;save # lines to do
        push    si              ;save current paste_buffer position
        mov     cx,bx           ;get # cols to do

mupd_3: push    cx              ;save # cols left
        push    bx              ;save total cols to do
        mov     bh,screen_page

        mov     ah,2            ;set curpos
        int     10h

        lodsw                   ;get c/a from p_buff
        mov     attrib,ah
        push    dx
        push    si
        call    alt_modes
        pop     si
        pop     dx
        mov     cx,1
        mov     ah,9
        int     10h             ;write c/a from buffer

        pop     bx
        pop     cx              ;get # chrs to do
        inc     dl              ;next csr col
        loop    mupd_3
        pop     si              ;restore start of line in paste buffer
        mov     cx,paste_size
        mov     ch,0
        add     cx,cx
        add     si,cx
        pop     cx              ;get # lines left to do
        pop     dx              ;restore cursor pos
        inc     dh
        loop    mupd_4

        pop     dx
        mov     bh,screen_page
        mov     ah,2
        int     10h             ;restore curpos

        pop     ax
        mov     attrib,al
        mov     ins_del_flag,0
        ret

Macro_mess_1 db esc,'[24;1f',esc,'I give up. If you want macros, use ProKey or something.$'


MU_Macros:
        call    save_cur
        mov     dx,offset Macro_mess_1
        call    print_cs
        call    restore_cur
        ret


cmd_f:
MU_flip:
        mov     dx,offset screen_buffer_2
        cmp     screen_buffer, offset screen_buffer_1
        je      MUF_set
        mov     dx,offset screen_buffer_1
MUF_set:
        push    dx
        call    save_screen
        pop     dx
        mov     screen_buffer,dx
        call    restore_screen
        ret


wipe_prompt_1 db esc,'[24;1fAttributes, Text or Both (a/t/b)? $'
wipe_prompt_2 label byte
quit_prompt db esc,'[24;1fAre you sure (y/n)? $'
command_prompt db esc,'[24;1f',esc,'[0mCommand: $'
save_prompt db esc,'[24;1fSave to $'
CL_prompt db esc,'[24;1fLoad from $'
home db esc,'[1;1f$'
CL_err_mess db esc,'[24;1fError in Loading of file. Hit key to resume editing.$'
CS_err_mess db esc,'[24;1fError: Couldn',27h,'t save file. Hit key to resume editing.$'
crlf db 13,10
ctrl_z db 26


save_cur:
        mov     bh,screen_page
        mov     ah,3
        int     10h
        mov     cursor,dx
        ret

restore_cur:
        mov     bh,screen_page
        mov     ah,2
        mov     dx,cursor
        int     10h
        ret

get_filespec:
        call    print_cs
        call    save_screen
        push    si
        mov     dx,offset filespec_buffer
        mov     si,dx
        mov     bl,[si+1]
        mov     bh,0
        mov     byte ptr [si+bx+2],13
        xchg    bx,si
        pop     si
        mov     ah,0Ah
        int     21h             ;input filename
        mov     bx,offset filespec_buffer+2
        mov     dx,bx
        mov     al,[bx-1]
        mov     ah,0
        or      ax,ax
        jz      get_fs_ret_err
        add     bx,ax
        mov     byte ptr [bx],0
        push    bx

;open file for r/w
        mov     al,2
        push    dx
        mov     ah,3Dh
        int     21h
        pop     dx
        pop     bx
        jnc     get_fs_ret
        test    create,255
        jz      get_fs_ret_err
        push    bx
        mov     ah,3Ch
        mov     cx,0
        mov     al,2
        int     21h
        pop     bx
        jnc     get_fs_ret
get_fs_ret_err:
        stc
get_fs_ret:
        mov     byte ptr [bx],13     ;set buffer back to normal
        call    restore_screen
        ret

adjust:
        mov     dl,max_col
        mov     dh,cur_line
        
adjust_loop:
        dec     dl
        cmp     dl,255
        jz      adjust_end
        mov     ah,2
        mov     bh,screen_page
        int     10h             ;set cur_pos
        mov     ah,8
        mov     bh,screen_page
        int     10h
        cmp     al,0
        je      adjust_loopB
        cmp     al,255
        je      adjust_loopB
        cmp     al,32
        je      adjust_loopB
adjust_end:
        inc     dl
        mov     max_col,dl
A_ret:
        ret

adjust_loopB:
        and     ah,7*16         ;test for background color on.
        jz      adjust_loop
        jmp     adjust_end



fix_attrib:
        cmp     ah,attrib
        je      A_ret
        push    dx
        push    cx
        push    bx
        push    ax              ;save c/a
        mov     bp,offset buffer+2
        push    bp
        mov     attrib,ah
        mov     byte ptr [bp],'0'
        inc     bp
        mov     byte ptr [bp],';'
        inc     bp
        mov     byte ptr [bp],'3'
        inc     bp
        and     ah,7
        call    xlat_colors
        add     ah,30h          ;make decimal
        mov     byte ptr [bp],ah
        inc     bp
        mov     byte ptr [bp],';'
        inc     bp
        test    attrib,16+32+64 ;background set?
        jz      no_background
        mov     byte ptr [bp],'4'
        inc     bp
        mov     ah,attrib
        mov     cl,4
        ror     ah,cl
        and     ah,7
        call    xlat_colors
        add     ah,30h
        mov     byte ptr [bp],ah
        inc     bp
        mov     byte ptr [bp],';'
        inc     bp
no_background:
        test    attrib,8
        jz      no_intensity
        mov     byte ptr [bp],'1'
        inc     bp
        mov     byte ptr [bp],';'
        inc     bp
no_intensity:
        test    attrib,128
        jz      no_blinking
        mov     byte ptr [bp],'5'
        inc     bp
        inc     bp
no_blinking:
        dec     bp
        mov     byte ptr [bp],'m'
        inc     bp
        pop     cx
        push    cx              ;save pointer to buffer
        xchg    cx,bp
        sub     cx,bp
        inc     cx
        inc     cx
        pop     bp              ;restore ptr
        mov     byte ptr [bp-2],27
        mov     byte ptr [bp-1],'['
        mov     dx,offset buffer
        mov     ah,40h
        mov     bx,handle
        int     21h
        pop     ax
        pop     bx
        pop     cx
        pop     dx
        ret

colors db 0,4,2,6,1,5,3,7

Xlat_Colors:
        push    bx
        push    ax
        mov     al,ah
        mov     bx,offset colors
        xlat    colors
        pop     bx
        mov     ah,al
        mov     al,bl
        pop     bx
        ret

color_list db esc,'[24;1f'
        db esc,'[0;30;5;47mB',esc,'[0;30;47mlack'                  ;Black
        db esc,'[0;34;1;40m b',esc,'[0;34;1;5mL',esc,'[0;34;1mue ' ;bLue
        db esc,'[0;32;1;5;40mG',esc,'[0;32;1mreen '                ;Green
        db esc,'[0;36;1;5;40mC',esc,'[0;36;1myan '                 ;Cyan
        db esc,'[0;31;1;5;40mR',esc,'[0;31;1med '                  ;Red
        db esc,'[0;35;1;5;40mM',esc,'[0;35;1magenta '              ;Magenta
        db esc,'[0;33;1;5;40mY',esc,'[0;33;1mellow '               ;Yellow
        db esc,'[0;37;1;5;40mW',esc,'[0;37;1mhite '                ;White
        db '$'
colors_table db 9, 'BLGCRMYW',ESC
color_fore_back db esc,'[24;1fForeground or Background (f/b)? $'
color_blinking_mess db esc,'[24;1fBlinking (y/n)? $'
color_int_mess db esc,'[24;1fBright (y/n)? $'

cmd_R:

        ret
cmd_C:
        mov     dx,offset color_fore_back
        call    print_cs
CC_1:   getkey
        jz      cc_1
        or      al,al
        jz      cc_1
        call    capit_al
        cmp     al,27
        je      cc_ret
        cmp     al,'F'
        mov     cl,0            ;rotate no bits.
        je      cc_get_color
        cmp     al,'B'
        mov     cl,4
        je      cc_get_color
        jmp     cc_1

cc_ret: ret

cc_get_color:
        mov     rotate,cl       ;save distance to rotate
        mov     dx,offset color_list
        call    print_cs
cc_2:   getkey
        jz      cc_2
        or      al,al
        jz      cc_2
        search  colors_table,ax
        JNE     CC_2
        CMP     AH,9
        JZ      CC_RET
        dec     ah              ;make a color
        mov     cl,rotate
        rol     ah,cl           ;set for attrib pos
        mov     al,attrib
        mov     dl,7            ;a mask
        rol     dl,cl           ;pos it
        or      al,dl
        xor     al,dl           ;remove unwanted bits
        or      al,ah           ;put in new bits
        mov     attrib,al

        or      cl,cl           ;doing foreground?
        jnz     cc_ret          ;no, skip other questions

        and     al,7+7*16       ;eliminate blink+intensity bits
        mov     attrib,al

        mov     dx,offset color_int_mess
        call    print_cs
cc_3:   getkey
        jz      cc_3
        or      al,al
        jz      cc_3
        call    capit_al
        cmp     al,esc
        jz      cc_ret
        cmp     al,'N'
        jz      cc_4
        cmp     al,'Y'
        jne     cc_3
        or      attrib,8
cc_4:   mov     dx,offset color_blinking_mess
        call    print_cs
cc_5:   getkey
        jz      cc_5
        or      al,al
        jz      cc_5
        call    capit_al
        cmp     al,esc
        jz      cc_ret2
        cmp     al,'N'
        jz      cc_ret2
        cmp     al,'Y'
        jne     cc_5
        or      attrib,128
cc_ret2:
        ret


CS_error:
        jmp     Save_error
cmd_S:
        mov     create,255
        mov     dx,offset save_prompt
        call    get_filespec
        jc      CS_error
        mov     handle,ax
        mov     attrib,7        ;set attrib to default
        mov     cur_line,21
save_start:
        cmp     cur_line,0
        jnz     ss_1
        jmp     nothing_to_save
ss_1:   mov     max_col,79
        call    adjust
        dec     cur_line
        cmp     max_col,0
        jz      save_start
        mov     al,cur_line
        inc     al
        inc     al
        mov     max_line,al
        mov     cur_line,0
Save_loop:
        mov     max_col,79
        mov     cur_col,0
        call    adjust
        inc     max_col
        mov     cl,max_col
        mov     ch,0
        push    cx
Save_line:
        pop     cx
        dec     cx
        jcxz    Save_line_done
        push    cx
        mov     dl,cur_col
        mov     dh,cur_line
        mov     bh,screen_page
        mov     ah,2
        int     10h
        mov     ah,8
        int     10h             ;get c/a from screen
        call    fix_attrib
        mov     byte ptr [buffer],al
        mov     cx,1
        mov     dx,offset buffer
        mov     ah,40h
        mov     bx,handle
        int     21h             ;write chr to file
        inc     cur_col
        jmp     Save_line

Save_line_done:
        inc     cur_line
        mov     dx,offset crlf
        mov     cx,2
        mov     bx,handle
        mov     ah,40h
        int     21h
        mov     al,cur_line
        cmp     al,max_line
        jz      Save_done
        jmp     Save_loop

Save_done:
Nothing_to_save:
        mov     dx,offset ctrl_z
        mov     cx,1
        mov     ah,40h
        mov     bx,handle
        int     21h
        jc      Save_error
        or      ax,ax
        jz      Save_error
        call    CL_Ended
        ret

Save_error:
        mov     dx,offset CS_err_mess
        call    print_cs
        mov     ah,0Ch
        mov     al,1
        int     21h
        ret

cmd_L:
        mov     create,0
        mov     dx,offset CL_prompt
        call    get_filespec
        jc      CL_error_2
        mov     handle,ax
        mov     dx,offset home
        call    print_cs
CL_loop:
        mov     bx,handle
        mov     ah,3Fh
        mov     cx,1
        mov     dx,offset buffer
        int     21h
        jc      CL_Error
        or      ax,ax
        jz      CL_Ended

        mov     dl,byte ptr [buffer]
        cmp     dl,26           ;^Z terminating?
        jz      CL_Ended

        mov     ah,2
        int     21h
        jmp     CL_loop

CL_Ended:
        mov     bx,handle
        mov     ah,3Eh
        int     21h             ;close file
        ret

CL_Error:
        call    CL_ended        ;close file
CL_error_2:
        mov     dx,offset CL_err_mess
        call    print_cs
        mov     ah,0Ch
        mov     al,1
        int     21h
        ret


cmd_Q:
        mov     dx,offset quit_prompt
        call    print_cs
quit_loop:
        getkey
        jz      quit_loop
        or      al,al
        jz      quit_loop       
        call    capit_al
        cmp     al,'N'
        je      quit_end
        cmp     al,esc
        je      quit_end
        cmp     al,'Y'
        jne     quit_loop
        pop     ax
        stc
        ret
quit_end:
        ret

cmd_M:
        ret
cmd_W:
        mov     dx,offset wipe_prompt_1
        call    print_cs
wl_1:   getkey
        jz      wl_1
        or      al,al
        jz      wl_1
        call    capit_al
        cmp     al,esc          ;ESC key hit?
        jz      wipe_end
        mov     dx,00FFh        ;attribs?
        mov     cx,0700h
        cmp     al,'A'
        jz      wl_2
        mov     dx,0FF00h       ;text
        mov     cx,0020h
        cmp     al,'T'
        jz      wl_2
        mov     dx,0000         ;both
        mov     cx,0720h
        cmp     al,'B'
        jnz     wl_1

wl_2:   push    dx
        push    cx

        mov     dx,offset wipe_prompt_2
        call    print_cs
wipe_loop:
        getkey
        jz      wipe_loop
        or      al,al
        jz      wipe_loop       
        call    capit_al
        cmp     al,'N'
        je      wipe_end
        cmp     al,esc
        je      wipe_end
        cmp     al,'Y'
        jne     wipe_loop

        pop     di
        pop     si
        mov     dx,0            ;new cursor pos
        mov     bh,screen_page

cls2:   mov     ah,2            ;set curpos
        int     10h

        mov     ah,8            ;read c/a
        int     10h
        and     ax,si           ;clear unwanted part
        or      ax,di           ;move in new replacement
        mov     bl,ah
        mov     cx,1
        mov     ah,9 
        int     10h             ;write new c/a

        inc     dl
        cmp     dl,79
        jne     cls2
        mov     dl,0
        inc     dh
        cmp     dh,22
        jne     cls2

        mov     cursor,0
        mov     attrib,7

wipe_end:
        ret

cmd_esc:
        clc
        pop     ax
        call    restore_cur
        ret

mode_cmd:
        mov     dx,offset command_prompt
        call    print_cs
MC_key_loop:
        getkey
        jz      MC_key_loop
        search  cmd_key,ax
        jne     MC_key_loop
        jump    cmd_table,ah
        jmp     mode_cmd

status_line_1 db esc,'[23;1f',esc,'[0;40;33;7mtDoodle 1.00                  '
        db '     Mode: $'
status_line_2 db 'Current Attribute',esc,'[0;40;33;7m         Box: $'
status_line_3 db esc,'[0;6m$'

status_line_4 db 'Paint  $'
status_line_5 db 'Text   $'
status_line_6 db 'Both   $'

status_line_help db 10,13,esc,'[K'
        db esc,'[0;1m1',esc,'[0;7mBox   '
        db esc,'[0;1m 2',esc,'[0;7mGetClr'
        db esc,'[0;1m 3',esc,'[0;7mRevers'
        db esc,'[0;1m 4',esc,'[0;7mMode  '
        db esc,'[0;1m 5',esc,'[0;7mSayClr'
        db esc,'[0;1m 6',esc,'[0;7mFlip  '
        db esc,'[0;1m 7',esc,'[0;7mCut   '
        db esc,'[0;1m 8',esc,'[0;7mPaste '
        db esc,'[0;1m 9',esc,'[0;7mUndo  '
        db esc,'[0;1m 0',esc,'[0;7mMacros'
        db esc,'[0m$'

display_ctrls:
        push    cursor
        call    save_cur
        mov     dx,offset status_line_1
        call    print_cs

        mov     ah,mode
        mov     cl,5
        ror     ah,cl
        mov     dx,offset status_line_6
        and     ah,3          
        jz      DC_2
        mov     dx,offset status_line_4
        dec     ah
        jz      DC_2
        mov     dx,offset status_line_5
DC_2:   call    print_cs

        mov     handle,0        ;con:
        mov     ah,attrib
        push    ax
        mov     ah,0            ;force attrib change
        call    fix_attrib
        pop     ax
        call    fix_attrib

        mov     dx,offset status_line_2
        call    print_cs

        mov     al,'S'
        call    alt_modes
        cmp     al,'S'
        jnz     DC_1
        mov     al,'T'
DC_1:   mov     dl,al
        mov     ah,02
        int     21h
        mov     dx,offset status_line_3
        call    print_cs

        mov     dx,offset status_line_help
        mov     ah,9
        int     21h             ;print mess w/no crlf

        call    restore_cur
        pop     cursor
        ret

screen_buffer_1 label word
        org     $+1760*2+2
screen_buffer_2 label word
        org     $+1760*2+2
paste_buffer label byte
        org     $+1760*2+2
end_of_code label byte

cseg    ends
        end     start
