
	page	64,120
; PSET24.ASM - Printer set-up program 
;
; This program will allow the operator to pre-set certain printer
; states.  The printer will remain in these states until the
; printer power is recycled, or the printer is directed into 
; another state through program control.
;
;--------------------------------------------------------------------
;
; VERSION 2.4 - 24 Feb 86 - Added an equate for the Mannsman-Talley
; MT-180 printers.  This is not tested, as I don't have the printer.
; (I have been adding printers by request from mailed-in printer
; manuals).  Also fixed bug in version 2.3 in MPI180 left margin
; code. - Barron McIntire
;
; VERSION 2.3 - 7 Jan 86 - Added an equate for the MPI 180FT printer.
; I don't know if it will work with other MPI printers.   Also fixed
; bug in option display - the 7/72 inch line spacing message said
; 7.2 cpi print, a hangover from the HP verisons. - Barron McIntire 
;
; VERSION 2.2 - 24 Nov 85 - Re-written to work with the EPSON, GEMINI,
; CITIZEN type printers in the same manner as the CP/M PSET1x.ASM 
; versions.  This version will no longer work with the HP printers.
; Use version 2.0 or 2.1 for HP printers. - Barron McIntire
;
; VERSION 2.1 - 22 Nov 85 - Slightly modified to work with the
; HP 2932A printer. - Barron McIntire
;
; VERSION 2.0 - 21 Nov 85 - Completely re-written for MS-DOS and the
; HP 2631G printer.  Since the HP printers are totally different from
; any standard printer, this version will no longer run on the EPSONs
;                                                - Barron McIntire
;
; Modified from PSET15.ASM, an Epson printer set-up program
; that I wrote under CP/M 2.2.
;
; Written by:  Barron F. McIntire III
;              3400 S. Greeley Hwy #8
;              Cheyenne, Wyoming  82007
;              RCP/M phone 307-635-8366, 300/1200/2400 baud, 24 hours
;              CIS ID #74155,441
;
;********************************************************************
;
no	equ	0		;for conditional assembly
yes	equ	not no
cr	equ	0dh		;carriage return
lf	equ	0ah		;line feed
dos	equ	21h		;DOS call location
bel	equ	7		;bell
esc	equ	1bh		;escape character
cls	equ	26		;clear screen character
;
conin	equ	1		;console input function
conout	equ	2		;console output function
lstout	equ	5		;printer output function
linout	equ	9		;string print function
bufin	equ	10		;buffered keyboard input function
;
ver	equ	'2'		;version
modlev	equ	'4'		;modification level
;
; 		+++++ IMPORTANT NOTE +++++
;
; Only ONE of the following equates can be true.  Setting more
; than one true will cause unpredictable results!
;
epson	equ	yes		;yes for epson printers
citizen	equ	no		;yes for citizen printers
gemini	equ	no		;yes for gemini printers
mpi180	equ	no		;yes for MPI-180FT printer
mt180	equ	no		;yes for MT-180 printers
;
;********************************************************************
;
st_seg	segment	stack		;define stack segment
	db	20 dup	('stack   ')
st_seg	ends
;
;********************************************************************
;
data	segment
;
clr	db	cls,'$'		;clear screen data
;
messg	db	'            ***** '
	if	citizen
	db	'CITIZEN'
	endif
	if	gemini
	db	'GEMINI'
	endif
	if	epson
	db	'EPSON'
	endif
	if	mpi180
	db	'MPI-180FT'
	endif
	if	mt180
	db	'MT-180I/L'
	endif
	db	' PRINTER PRE-SET '
	db	'PROGRAM v',ver,'.',modlev,' *****',cr,lf,lf
	db	'This program will allow the operator to pre-set '
	db	'certain printer states.',cr,lf
	db	'The printer will remain in these states until the '
	db	'printer power is',cr,lf
	db	'recycled, or the printer is directed into another '
	db	'state by program control.',cr,lf,'$'
;
optmes	db	cr,lf,'The following options are available:',cr,lf,lf
;
	if	not mpi180
;
	db	'  A.  Printer initialization            '
	if	mt180
	db	'N.  Send Form Feed (TOF) to Printer',cr,lf
	endif
	if	not mt180
	db	'N.  Set 7/72 inch line spacing',cr,lf
	endif
	db	'  B.  Elite-sized character setting     '
	if	mt180
	db	'O.  Set 6 lines per inch spacing',cr,lf
	endif
	if	not mt180
	db	'O.  1/16 inch line spacing',cr,lf
	endif
	db	'  C.  Pica-sized character setting      '
	if	mt180
	db	'P.  Set 8 lines per inch spacing',cr,lf
	endif
	if	not mt180
	db	'P.  1/8 inch line spacing',cr,lf
	endif
	db	'  D.  Enlarged (expanded) mode          '
	if	mt180
	db	'Q.  Prop. Space on (req CQ mode)',cr,lf
	endif
	if	not mt180
	db	'Q.  n/72 inch line spacing',cr,lf
	endif
	db	'  E.  Send CR.LF to printer             '
	if	mt180
	db	'R.  Prop. Space off (req CQ mode)',cr,lf
	endif
	if	gemini
	db	'R.  n/144 inch line spacing',cr,lf
	endif
	if	(not gemini) and (not mt180)
	db	'R.  n/216 inch line spacing',cr,lf
	endif
	db	'  F.  Condensed mode                    '
	db	'S.  Form length setting',cr,lf
	if	mt180
	db	'  G.  Draft mode                        '
	endif
	if	not mt180
	db	'  G.  Emphasized/enlarged mode          '
	endif
	db	'T.  Skip over perforation',cr,lf
	db	'  H.  Emphasized mode                   '
	db	'U.  Right margin setting',cr,lf
	if	mt180
	db	'  I.  Correspondence mode - 10 cpi      '
	endif
	if	not mt180
	db	'  I.  Double strike mode                '
	endif
	db	'V.  Left margin setting',cr,lf
	if	mt180
	db	'  J.  Correspondence mode - 12.5 cpi    '
	endif
	if	not mt180
	db	'  J.  Alternate character set (italics) '
	endif
	db	'W.  Superscript mode',cr,lf
	db	'  K.  Underline mode                    '
	db	'X.  Subscript mode',cr,lf
	db	'  L.  Ignore paper end detector         '
	if	citizen
	db	'Y.  Correspondence quality mode',cr,lf
	endif
	if	not citizen
	db	'  ',cr,lf
	endif
	if	not mt180
	db	'  M.  Unidirectional printing           '
	endif
	if	mt180
	db	'  M.  Reverse Field mode                '
	endif
	if	citizen
	db	'Z.  Condensed Elite mode (160 col)',cr,lf
	endif
	if	not citizen
	db	'  ',cr,lf
	endif
;
	endif	;not mpi180
;
	if	mpi180
;
	db	'  A.  Send CR,LF to printer             '
	db	'N.  Send Form Feed (TOF) to printer',cr,lf
	db	'  B.  Set CQ mode 10 cpi                '
	db	'O.  Set 6 lines per inch spacing',cr,lf
	db	'  C.  Set CQ mode 12 cpi                '
	db	'P.  Set 8 lines per inch spacing',cr,lf
	db	'  D.  Set enlarged (elongated) mode on  '
	db	'S.  Set form length',cr,lf
	db	'  E.  Set enlarged (elongated) mode off '	
	db	'T.  Set skip over perforation on',cr,lf
	db	'  F.  Set draft mode 10 cpi             '
	db	'U.  Set skip over perforation off',cr,lf
	db	'  G.  Set draft mode 12 cpi             '
	db	'V.  Set left margin',cr,lf
	db	'  H.  Set draft mode 14.4 cpi           '
	db	'W.  Exit to DOS',cr,lf
	db	'  I.  Set draft mode 15 cpi             ',cr,lf
	db	'  J.  Set draft mode 17 cpi             ',cr,lf
	db	'  K.  Set underline on                  ',cr,lf
	db	'  L.  Set underline off                 ',cr,lf
;
	endif	;mpi180
;
	db	cr,lf,'Enter desired option:','$'
;
emess	db	bel,cr,lf,'++ UNKNOWN ENTRY! - Exit to DOS (Y/N) ?','$'
;
ermes	db	bel,cr,lf,'NON-NUMERIC character entered!  '
	db	'Try again!',cr,lf,'$'
;
msend	db	cr,lf,'Another option (Y/N) ?','$'
;
	if	not mpi180
mes17	db	'Enter n/72 line spacing required: ','$'
;
mes18	db	'Enter n/'
	if	gemini
	db	'144'
	endif
	if	not gemini
	db	'216'
	endif
	db	' line spacing required: ','$'
;
mes19	db	'Specify setting by lines (L) or inches (I): ','$'
;
minch	db	'Enter number if inches: ','$'
;
mlin	db	'Enter number of lines: ','$'
;
mes20	db	'Enter number of lines to be skipped: ','$'
;
mes21	db	'Enter number of characters required in line '
	db	'(P=80, E=96, C=137): ','$'
	endif	;not mpi180
;
mes22	db	'Enter '
	if	not mpi180
	db	'column in which to start left margin: ','$'
	endif
	if	mpi180
	db	'n/16 inch from left edge to set '
	db	'left margin',cr,lf
	db	'I.E...1/2 inch would be 8/16, so you would enter 8'
	db	cr,lf,lf,'Enter number (0-120): ','$'
	endif
;
	if	mpi180
flmpi	db	'Enter a number from 0 to 15 per the following',cr,lf
	db	'chart for the form length setting desired:',cr,lf,lf
	db	' 0=0.0 in    4=4.5 in    7=6.0 in'
	db	'   10=8.5 in   13=11.0 in',cr,lf
	db	' 1=3.0 in    5=5.0 in    8=7.0 in'
	db	'   11=9.5 in   14=12.0 in',cr,lf
	db	' 2=3.5 in    6=5.5 in    9=8.0 in'
	db	'   12=10.0 in  15=14.0 in',cr,lf
	db	' 3=4.0 in',cr,lf,lf
	db	'Enter number for desired form length: ','$'
	endif	;mpi180
;
buff	db	6		;4 bytes for number input
;
data	ends
;
;********************************************************************
;
pset	segment
;
main	proc	far
;
; Main part of program
;
	assume cs:pset,ds:data
;
start:
;
; Set up stack for return
;
	push	ds		;ds on stack
	sub	ax,ax		;set ax to zero
	push	ax		;zero on stack
	mov	ax,data
	mov	ds,ax		;data area to ds reg
;
; Display opening message
;
	mov	dx,offset clr	;get clear screen message
	mov	ah,linout	;get string print function
	int	dos		;call DOS
;
	mov	dx,offset messg	;get opening message
	mov	ah,linout	
	int	dos
;
; Display options
;
optdis:	
	mov	dx,offset optmes ;get options message
	mov	ah,linout
	int	dos
;
; Input option
;
optin:
	mov	ah,conin	;get keyboard input char
	int	dos
	and	al,5fh		;mask to upper case
	push	ax		;save character on stack
	mov	dl,cr		;send carriage return
	mov	ah,conout	
	int	dos
	mov	dl,lf		;send line feed
	mov	ah,conout
	int	dos
	pop	ax		;get char back from stack
;
; Compare option - goto proper lstout routine
;
	cmp	al,'A'
	jnz	optb
	jmp	opt1
optb:	cmp	al,'B'
	jnz	optc
	jmp	opt2
optc:	cmp	al,'C'
	jnz	optd
	jmp	opt3
optd:	cmp	al,'D'
	jnz	opte
	jmp	opt4
opte:	cmp	al,'E'
	jnz	optf
	jmp	opt5
optf:	cmp	al,'F'
	jnz	optg
	jmp	opt6
optg:	cmp	al,'G'
	jnz	opth
	jmp	opt7
opth:	cmp	al,'H'
	jnz	opti
	jmp	opt8
opti:	cmp	al,'I'
	jnz	optj
	jmp	opt9
optj:	cmp	al,'J'
	jnz	optk
	jmp	opt10 
optk:	cmp	al,'K'
	jnz	optl 
	jmp	opt11
optl:	cmp	al,'L'
	if	not mpi180
	jnz	optm 
	jmp	opt12
optm:	cmp	al,'M'
	jnz	optn
	jmp	opt13
	endif
	if	mpi180
	jnz	optn
	jmp	opt12
	endif
optn:	cmp	al,'N'
	jnz	opto
	jmp	opt14
opto:	cmp	al,'O'
	jnz	optp
	jmp	opt15
optp:	cmp	al,'P'
	if	not mpi180
	jnz	optq
	jmp	opt16 
optq:	cmp	al,'Q'
	jnz	optr 
	jmp	opt17
optr:	cmp	al,'R'
	jnz	opts 
	jmp	opt18
	endif
	if	mpi180
	jnz	opts
	jmp	opt16
	endif
opts:	cmp	al,'S'
	jnz	optt
	jmp	opt19
optt:	cmp	al,'T'
	jnz	optu
	jmp	opt20
optu:	cmp	al,'U'
	jnz	optv
	jmp	opt21
optv:	cmp	al,'V'
	if	not mpi180
	jnz	optw
	jmp	opt22
optw:	cmp	al,'W'
	jnz	optx
	jmp	opt23
optx:	cmp	al,'X'
	if	citizen
	jnz	opty
	endif
	if	not citizen
	jnz	opterr
	endif
	jmp	opt24
	if	citizen
opty:	cmp	al,'Y'
	jnz	optz
	jmp	opt25
optz:	cmp	al,'Z'
	jnz	opterr
	jmp	opt26
	endif
	endif	;not mpi180
	if	mpi180
	jnz	optex
	jmp	opt22
optex:	cmp	al,'W'
	jnz	opterr
	ret
	endif
;
; Error if no compare
;
opterr:	mov	dx,offset emess	;get error message
	mov	ah,linout
	int	dos
	mov	ah,conin	;get response
	int	dos
	and	al,5fh		;mask to upper case
	push	ax		;save on stack
	mov	dl,cr		;send carriage return
	mov	ah,conout
	int	dos
	mov	dl,lf		;send line feed
	mov	ah,conout
	int	dos
	pop	ax		;get char back from stack
	cmp	al,'Y'		;return to DOS ?
	jz	ext		;yes, go exit
	jmp	optdis		;no, then re-display options
ext:	jmp	exit		;exit to DOS
;
opt1:
	if	not mpi180
;
; Printer initialization
;
	call	escap		;send escape character to printer
	mov	dl,'@'		;get printer init char
	mov	ah,lstout	;get list out char
	int	dos		;send to printer
;
	endif	
	if	mpi180
;
; Send CR,LF to printer
;
	mov	dl,cr		;put cr in reg
	mov	ah,lstout	;get list out char
	int	dos		;send to printer
	mov	dl,lf		;put lf in reg
	mov	ah,lstout
	int	dos
;
	endif
	jmp	more
opt2:
	if	not mpi180
;
; Elite-sized character setting
;
	call	escap
;
	if	not mt180
;
	if	gemini			;setup for Gemini printers
	mov	dl,'B'
	mov	ah,lstout
	int	dos
	mov	dl,2
	mov	ah,lstout
	int	dos
	endif
;
	if	not gemini		;setup for non-gemini printers
	mov	dl,'M'
	mov	ah,lstout
	int	dos
	endif
;
	endif	;not mt180
;
	if	mt180
	mov	dl,'['
	mov	ah,lstout
	int	dos
	mov	dl,'5'
	mov	ah,lstout
	int	dos
	mov	dl,'w'
	mov	ah,lstout
	int	dos
	endif
;	
	endif	;not mpi180
;
	if	mpi180
;
; CQ mode, 10 cpi
;
	call	escap
	mov	dl,'A'
	mov	ah,lstout
	int	dos
	mov	dl,'2'
	mov	ah,lstout
	int	dos
	mov	dl,'0'
	mov	ah,lstout
	int	dos
	endif	;mpi180
;	
	jmp	more
opt3:
	if	not mpi180
;
; Pica-sized character setting
;
	call	escap
;
	if	not mt180
;
	if	gemini
	mov	dl,'B'
	mov	ah,lstout
	int	dos
	mov	dl,1
	mov	ah,lstout
	int	dos
	endif
	if	not gemini
	mov	dl,'P'
	mov	ah,lstout
	int	dos
	endif
;
	endif	;not mt180
;
	if	mt180
	mov	dl,'['
	mov	ah,lstout
	int	dos
	mov	dl,'4'
	mov	ah,lstout
	int	dos
	mov	dl,'w'
	mov	ah,lstout
	int	dos
	endif
;
	endif	;not mpi180
;
	if	mpi180
;
; CQ mode, 12 cpi
;
	call	escap
	mov	dl,'A'
	mov	ah,lstout
	int	dos
	mov	dl,'2'
	mov	ah,lstout
	int	dos
	mov	dl,'2'
	mov	ah,lstout
	int	dos
	endif	;mpi180
;
	jmp	more
opt4:
;
; Enlarged (expanded/elongated) mode
;
	call	escap
	if	not mpi180
	mov	dl,'W'
	mov	ah,lstout
	int	dos
	mov	dl,1
	mov	ah,lstout
	int	dos
	endif
	if	mpi180
	mov	dl,'N'
	mov	ah,lstout
	int	dos
	endif
	jmp	more
opt5:
	if	not mpi180
;
; Send CR,LF to printer
;
	mov	dl,cr
	mov	ah,lstout
	int	dos
	mov	dl,lf
	mov	ah,lstout
	int	dos
	endif	;not mpi180
;
	if	mpi180
;
; Set elongated mode off
;
	call	escap
	mov	dl,'O'
	mov	ah,lstout
	int	dos
	endif	;mpi180
;
	jmp	more
opt6:
	if	not mpi180
;
; Condensed mode
;
	if	not mt180
	mov	dl,15
	mov	ah,lstout
	int	dos
	endif
;
	if	mt180
	call	escap
	mov	dl,'['
	mov	ah,lstout
	int	dos
	mov	dl,'6'
	mov	ah,lstout
	int	dos
	mov	dl,'w'
	mov	ah,lstout
	int	dos
	endif
;
	endif	;not mpi180
;
	if	mpi180
;
; set draft mode, 10 cpi
;
	call	escap
	mov	dl,'A'
	mov	ah,lstout
	int	dos
	mov	dl,'0'
	mov	ah,lstout
	int	dos
	mov	dl,'0'
	mov	ah,lstout
	int	dos
	endif
;
	jmp	more
opt7:
	if	(not mpi180) and (not mt180)
;
; Emphasized and enlarged mode
;
	call	escap
	mov	dl,'E'
	mov	ah,lstout
	int	dos
	call	escap
	mov	dl,'W'
	mov	ah,lstout
	int	dos
	mov	dl,1
	mov	ah,lstout
	int	dos
	endif	;not mpi180 and not mt180
;
	if	mpi180
;
; Set draft mode, 12 cpi
;
	call	escap
	mov	dl,'A'
	mov	ah,lstout
	int	dos
	mov	dl,'0'
	mov	ah,lstout
	int	dos
	mov	dl,'2'
	mov	ah,lstout
	int	dos
	endif
;
	if	mt180
;
; Set Draft Mode
;
	call	escap
	mov	dl,'['
	mov	ah,lstout
	int	dos
	mov	dl,'0'
	mov	ah,lstout
	int	dos
	mov	dl,'w'
	mov	ah,lstout
	int	dos
	endif
;
	jmp	more
opt8:
	if	not mpi180
;
; Emphasized mode
;
	call	escap
;
	if	not mt180
	mov	dl,'E'
	mov	ah,linout
	int	dos
	endif
;
	if	mt180
	mov	dl,'['
	mov	ah,lstout
	int	dos
	mov	dl,'='
	mov	ah,lstout
	int	dos
	mov	dl,'z'
	mov	ah,lstout
	int	dos
	endif	;mt180
;
	endif	;not mpi180
;	
	if	mpi180
;
; Set draft mode, 14.4 cpi
;
	call	escap
	mov	dl,'A'
	mov	ah,lstout
	int	dos
	mov	dl,'0'
	mov	ah,lstout
	int	dos
	mov	dl,'4'
	mov	ah,lstout
	int	dos
	endif
;
	jmp	more
opt9:
	if	(not mpi180) and (not mt180)
;
; Double-strike mode
;
	call	escap
	mov	dl,'G'
	mov	ah,lstout
	int	dos
	endif	;not mpi180 and not mt180
;
	if	mpi180
;
; Set draft mode, 15 cpi
;
	call	escap
	mov	dl,'A'
	mov	ah,lstout
	int	dos
	mov	dl,'0'
	mov	ah,lstout
	int	dos
	mov	dl,'5'
	mov	ah,lstout
	int	dos
	endif
;
	if	mt180
;
; set CQ mode - 10 cpi
;
	call	escap
	mov	dl,'['
	mov	ah,lstout
	int	dos
	mov	dl,'1'
	mov	ah,lstout
	int	dos
	mov	dl,'y'
	mov	ah,lstout
	int	dos
	call	escap
	mov	dl,'['
	mov	ah,lstout
	int	dos
	mov	dl,'4'
	mov	ah,lstout
	int	dos
	mov	dl,'y'
	mov	ah,lstout
	int	dos
	endif
;
	jmp	more
opt10:
	if	(not mpi180) and (not mt180)
;
; Alternate character set (italics)
;
	call	escap
	mov	dl,'4'
	mov	ah,lstout
	int	dos
	endif
;
	if	mpi180
;
; Set draft mode, 17 cpi
;
	call	escap
	mov	dl,'A'
	mov	ah,lstout
	int	dos
	mov	dl,'0'
	mov	ah,lstout
	int	dos
	mov	dl,'7'
	mov	ah,lstout
	int	dos
	endif
;
	if	mt180	
;
; Set CQ mode - 12.5 cpi
;
	call	escap
	mov	dl,'['
	mov	ah,lstout
	int	dos
	mov	dl,'1'
	mov	ah,lstout
	int	dos
	mov	dl,'y'
	mov	ah,lstout
	int	dos
	call	escap
	mov	dl,'['
	mov	ah,lstout
	int	dos
	mov	dl,'5'
	mov	ah,lstout
	int	dos
	mov	dl,'y'
	mov	ah,lstout
	int	dos
	endif
;
	jmp	more
opt11:
;
; Underline mode on
;
	if	(not mpi180) and (not mt180)
	call	escap
	mov	dl,'-'
	mov	ah,lstout
	int	dos
	mov	dl,1
	mov	ah,lstout
	int	dos
	endif
;
	if	mpi180
	mov	dl,0eh
	mov	ah,lstout
	int	dos
	endif
;
	if	mt180
	call	escap
	mov	dl,'['
	mov	ah,lstout
	int	dos
	mov	dl,'4'
	mov	ah,lstout
	int	dos
	mov	dl,'m'
	mov	ah,lstout
	int	dos
	endif
;
	jmp	more
opt12:
	if	not mpi180
;
; Ignore paper end detector
;
	call	escap
;
	if	not mt180
	mov	dl,'8'
	mov	ah,lstout
	int	dos
	endif
;
	if	mt180
	mov	dl,'['
	mov	ah,lstout
	int	dos
	mov	dl,':'
	mov	ah,lstout
	int	dos
	mov	dl,'z'
	mov	ah,lstout
	int	dos
	endif
;
	endif	;not mpi180
;
	if	mpi180
;
; Underline mode off
;
	mov	dl,0fh
	mov	ah,lstout
	int	dos
	endif
; 
	jmp	more
	if	not mpi180
opt13:
	if	not mt180
;
; Unidirectional printing
;
	call	escap
	mov	dl,'U'
	mov	ah,lstout
	int	dos
	mov	dl,1
	mov	ah,lstout
	int	dos
	jmp	more
	endif
;
	if	mt180
;
; Set Reverse Field mode (inverse video printing)
;
	call	escap
	mov	dl,'['
	mov	ah,lstout
	int	dos
	mov	dl,'6'
	mov	ah,lstout
	int	dos
	mov	dl,'z'
	mov	ah,lstout
	int	dos
	endif
;
	endif	;not mpi180
opt14:
	if	(not mpi180) and (not mt180)
;
; 7/72 inch line spacing
;
	call	escap
	mov	dl,'1'
	mov	ah,lstout
	int	dos
	endif
;
	if	mpi180 or mt180
;
; Send form feed (Top Of Form) to printer
;
	mov	dl,0ch
	mov	ah,lstout
	int	dos
	endif
;
	jmp	more
opt15:
	if	(not mpi180) and (not mt180)
;
; 1/16 inch line spacing
;
	call	escap
	mov	dl,'2'
	mov	ah,lstout
	int	dos
	endif
;
	if	mpi180 or mt180
;
; Set 6 lines per inch line spacing
;
	endif	;mpi180 or mt180
;
	if	mpi180
	call	escap
	mov	dl,'T'
	mov	ah,lstout
	int	dos
	endif
;
	if	mt180
	call	escap
	mov	dl,'['
	mov	ah,lstout
	int	dos
	mov	dl,'3'
	mov	ah,lstout
	int	dos
	mov	dl,'z'
	mov	ah,lstout
	int	dos
	endif
;
	jmp	more
opt16:
	if	(not mpi180) and (not mt180)
;
; 1/8 inch line spacing
;
	call	escap
	mov	dl,'0'
	mov	ah,lstout
	int	dos
	endif
;
	if	mpi180 or mt180
;
; Set 8 lines per inch line spacing
;
	endif	;mpi180 or mt180
;
	if mpi180
	call	escap
	mov	dl,'S'
	mov	ah,lstout
	int	dos
	endif
;
	if	mt180
	call	escap
	mov	dl,'['
	mov	ah,lstout
	int	dos
	mov	dl,'4'
	mov	ah,lstout
	int	dos
	mov	dl,'z'
	mov	ah,lstout
	int	dos
	endif
;
	jmp	more
;
	if	not mpi180
opt17:
	if	not mt180
;
; n/72 inch line spacing
;
	mov	dx,offset mes17		;get message
	mov	ah,linout
	int	dos			;send it
	call	decin			;get decimal input
	cmp	bx,0000h		;less than 0?
	jl	opt17			;try again if so
	cmp	bx,055h			;greater than 85?
	jg	opt17			;try again if so
	push	bx
	call	escap			;must be ok, send to printer
	mov	dl,'A'
	mov	ah,lstout
	int	dos
	pop	bx
	mov	dl,bl
	mov	ah,lstout
	int	dos
	endif	;not mt180
;
	if	mt180
;
; Set Prop Space On
;
	call	escap
	mov	dl,'['
	mov	ah,lstout
	int	dos
	mov	dl,'2'
	mov	ah,lstout
	int	dos
	mov	dl,'y'
	mov	ah,lstout
	int	dos
	endif
;
	jmp	more
opt18:
	if	not mt180
;
; n/216 inch line spacing (n/144 for Gemini)
;
	mov	dx,offset mes18
	mov	ah,linout
	int	dos
	call	decin
	cmp	bx,0000h
	jl	opt18
	cmp	bx,0ffh
	jg	opt18
	push	bx
	call	escap
	mov	dl,'3'
	mov	ah,lstout
	int	dos
	pop	bx
	mov	dl,bl
	mov	ah,lstout
	int	dos
	endif	;not mt180
;
	if	mt180
;
; Set Prop Space Off
;
	call	escap
	mov	dl,'Q'
	mov	ah,lstout
	int	dos
	endif	;mt180
;
	jmp	more
	endif	;not mpi180
opt19:
;
; Form length setting
;
	if	(not mpi180) and (not mt180)
	mov	dx,offset mes19		;get line/inch message
	mov	ah,linout
	int	dos			;send it
	mov	ah,conin		;get response
	int	dos
	and	al,5fh			;mask off high bit
	push	ax
	mov	dl,cr			;send CR, LF to CRT
	mov	ah,lstout
	int	dos
	mov	dl,lf
	mov	ah,lstout
	int	dos
	pop	ax
	cmp	al,'I'			;is it inches?
	jnz	lines			;go to lines if not
inchs:
	mov	dx,offset minch
	mov	ah,linout
	int	dos
	call	decin
	cmp	bx,0000h
	jl	inchs
	cmp	bx,96h
	jg	inchs
	push	bx
	call	escap
	mov	dl,'C'
	mov	ah,lstout
	int	dos
	mov	dl,0
	mov	ah,lstout
	int	dos
	pop	bx
	mov	dl,bl
	mov	ah,lstout
	int	dos
	jmp	more
lines:
	mov	dx,offset mlin
	mov	ah,linout
	int	dos
	call	decin
	cmp	bx,0000h
	jl	lines
	cmp	bx,0ffh
	jg	lines
	push	bx
	call	escap
	mov	dl,'C'
	mov	ah,lstout
	int	dos
	pop	bx
	mov	dl,bl
	mov	ah,lstout
	int	dos
	endif	;not mpi180 and not mt180
;
	if	mpi180
mpifl:	mov	dx,offset flmpi		;get mpi180 form length message
	mov	ah,linout
	int	dos
	call	decin
	cmp	bx,0000h		;less than 0?
	jl	mpifl
	cmp	bx,000fh		;greater than 15?
	jg	mpifl
	add	bx,0030h		;convert to ASCII
	push	bx
	call	escap
	pop	bx
	mov	dl,bl
	mov	ah,lstout
	int	dos
	endif	;mpi180
;
	if	mt180
mtfl:	mov	dx,offset mlin
	mov	ah,linout
	int	dos
	call	decin
	cmp	bx,0000h
	jl	mtfl
	cmp	bx,007fh		;greater than 127?
	jg	mtfl
	call	escap
	mov	dl,'['
	mov	ah,lstout
	int	dos
	mov	dl,buff+2		;get first ASCII char
	mov	ah,lstout
	int	dos
	mov	dl,buff+3		;get next ASCII char
	cmp	dl,cr			;done?
	jz	done	
	mov	ah,lstout		;no, send it
	int	dos
	mov	dl,buff+4		;get last ASCII char
	cmp	dl,cr			;done?
	jz	done
	mov	ah,lstout		;no, send it
	int	dos
done:
	mov	dl,'s'
	mov	ah,lstout
	int	dos
	endif	;mt180
;	
	jmp	more
opt20:
;
; Skip over perforation on
;
	if	not mpi180
	mov	dx,offset mes20
	mov	ah,linout
	int	dos
	call	decin
	cmp	bx,0001h
	jl	opt20
	cmp	bx,07fh
	jg	opt20
	push	bx
	call	escap
	mov	dl,'N'
	mov	ah,lstout
	int	dos
	pop	bx
	mov	dl,bl
	mov	ah,lstout
	int	dos
	endif	;not mpi180
;
	if	mpi180
	call	escap
	mov	dl,'U'
	mov	ah,lstout
	int	dos
	endif
;
	jmp	more
opt21:
	if	not mpi180
;
; Right margin setting
;
	mov	dx,offset mes21
	mov	ah,linout
	int	dos
	call	decin
	cmp	bx,02h
	jl	opt21
	cmp	bx,0ffh
	jg	opt21
	push	bx
	call	escap
	mov	dl,'Q'
	mov	ah,lstout
	int	dos
	pop	bx
	mov	dl,bl
	mov	ah,lstout
	int	dos
	endif	;not mpi180
;
	if	mpi180
;
; Skip over perforation off
;
	call	escap
	mov	dl,'V'
	mov	ah,lstout
	int	dos
	endif
;
	jmp	more
opt22:
;
; Left margin setting
;
	mov	dx,offset mes22
	mov	ah,linout
	int	dos
	call	decin
	if	not mpi180
	cmp	bx,0001h
	jl	opt22
	cmp	bx,0ffh
	jg	opt22
	endif	;not mpi180 
	if	mpi180
	cmp	bx,0000h
	jl	opt22
	cmp	bx,0078h
	jg	opt22
	endif	;mpi180
	if	(not mpi180) and (not mt180)
	push	bx
	endif
	call	escap
	if	gemini
	mov	dl,'M'
	endif
	if	epson or citizen
	mov	dl,'l'
	endif
	if	mpi180
	mov	dl,'L'
	endif
	if	mt180
	mov	dl,'['
	endif
	mov	ah,lstout
	int	dos
	if	(not mpi180) and (not mt180) 
	pop	bx
	mov	dl,bl
	mov	ah,lstout
	int	dos
	endif	;not mpi180 and not mt180
;
	if	mpi180 or mt180
	mov	dl,buff+2
	mov	ah,lstout
	int	dos
	mov	dl,buff+3
	cmp	dl,cr
	jz	lmdn
	mov	ah,lstout
	int	dos
	mov	dl,buff+4
	cmp	dl,cr
	jz	lmdn
	mov	ah,lstout
	int	dos
lmdn:	
	if	mpi180
	mov	dl,'.'
	endif
	if	mt180
	mov	dl,'s'
	endif
	mov	ah,lstout
	int	dos
	endif	;mpi180 or mt180
;
	jmp	more
	if	not mpi180
opt23:
;
; Superscript mode
;
	call	escap
	mov	dl,'S'
	mov	ah,lstout
	int	dos
	mov	dl,0
	mov	ah,lstout
	int	dos
	jmp	more
opt24:
;
; Subscript mode
;
	call	escap
	mov	dl,'S'
	mov	ah,lstout
	int	dos
	mov	dl,1
	mov	ah,lstout
	int	dos
	jmp	more
;
	if	citizen
opt25:
;
; Correspondence quality mode
;
	call	escap
	mov	dl,'x'
	mov	ah,lstout
	int	dos
	mov	dl,1
	mov	ah,lstout
	int	dos
	jmp	more
opt26:
;
; Condensed elite mode
;
	call	escap
	mov	dl,'M'
	mov	ah,lstout
	int	dos
	mov	dl,15
	mov	ah,lstout
	int	dos
	jmp	more
;
	endif
	endif	;not mpi180
;
more:
	mov	dx,offset msend
	mov	ah,linout
	int	dos
	mov	ah,conin
	int	dos
	and	al,5fh
	push	ax
	mov	dl,cr
	mov	ah,conout
	int	dos
	mov	dl,lf
	mov	ah,conout
	int	dos
	pop	ax
	cmp	al,'Y'			;do it again?
	jnz	exit			;no, exit
	jmp	optdis			;else re-display options
;
exit:
	ret				;else return to DOS	
;
main	endp			;end of main program
;
;--------------------------------------------------------------------
;Procedure for decimal input
;Result is in BX register, with ASCII chars in buff
;
decin	proc	near
;
	mov	dx,offset buff
	mov	ah,bufin
	int	dos
;
	mov	bx,0		;clear bx reg
	mov	al,buff+2	;get first char
	sub	al,30h		;convert ASCII to decimal
	jl	error
	cmp	al,9d
	jg	error		;must be from 0 to 9
;
	cbw			;byte in al to word in ax
	xchg	ax,bx
	mov	cx,10d
	mul	cx		;digit X 10
	xchg	ax,bx
	add	bx,ax		;add digit and number
;
	mov	al,buff+3	;get next digit
	cmp	al,cr		;done?
	jz	retn		;return if done
	sub	al,30h		;convert ASCII to decimal
	jl	error
	cmp	al,9d
	jg	error
;
	cbw
	xchg	ax,bx
	mov	cx,10d
	mul	cx
	xchg	ax,bx
	add	bx,ax
;
	mov	al,buff+4
	cmp	al,cr
	jz	retn
	sub	al,30h
	jl	error
	cmp	al,9d
	jg	error
;
	cbw
	xchg	ax,bx
	mov	cx,10d
	mul	cx
	xchg	ax,bx
	add	bx,ax
	ret
;
error:
	mov	dx,offset ermes
	mov	ah,linout
	int	dos
	sub	dx,dx
retn:	ret
;
decin	endp
;
;--------------------------------------------------------------------
; Procedure to send escape sequence to printer
;	
escap	proc	near
;
	mov	dl,esc
	mov	ah,lstout
	int	dos
	ret
;
escap	endp
;
;--------------------------------------------------------------------
pset	ends
;********************************************************************
;
	end	start
