;**********************************************************************
;*                                                                    *
;*                       Auto log on to GEnie                         *
;*                                                                    *
;*            By Jack Brown [ SYSOP.FOG ]  January 1988               *
;*          loosely based on a script file from Datastorm             *
;**********************************************************************
;
; You should set your system to 7,E,1 since the GEnie U# prompt 
; comes through that way all the time, no matter what your setting.
;
; In order to use this file for logon, you must create a macro file
; called GENIE.KEY on your disk.  You do this by entering <alt>M in
; Procomm, select R to revise an entry.  You must enter your logon
; id and password in the ALT-0 position, and save your macro file to
; disk with the S command as GENIE.KEY.  Any time you change your
; password, all you have to change is your Macro file!
;
; The special FOG sign-up offer on GEnie can be obtained by calling
; 1-800-638-8369   When you get the U#= prompt, type in XJM11819,FOGHELP
; and follow the prompts to join GEnie.  3 Hours of non-prime time
; access (a $15 value) will be credited to your account!  This script file
; will allow you to log into the FOG RoundTable without having to
; know how to navigate the system.  Just enter GENIE into the Procomm
; dialing directory as a command file for your auto log on.
;
; Note that the special offer is available for a limited time.
:
CALLING:                               ;place call to go on-line
  CLEAR                                ;clear the screen
  EMULATE ANSI                         ;ANSI-BBS terminal emulation
;
 SET DUPLEX HALF                        ;turn echo on
;
LOOP:
 WAITFOR "U#="                           ; get GEnie prompt
  IF NOT WAITFOR                         ; if we don't get prompt
   TRANSMIT "^M"                         ; Send <cr>
   GOTO LOOP                             ; Try again
  ENDIF
  RFLUSH                                ;make sure no noise came in
;
SENDID:
MLOAD "GENIE.KEY"
 MACRO 0
 TRANSMIT "!"
 CLEAR
  WAITFOR "^M"                         ;wait for carriage return
  RGET S0                              ;get rest of prompt
  FIND S0 "U#"                         ;check for VALIDATION FAULT
  IF FOUND                             ;if it is
    GOTO SENDID                        ;try again
  ENDIF                                ;end of test
 ;
 WAITFOR "or <H>elp?" 180             ;wait for Genie Main menu prompt
  IF NOT WAITFOR                       ;no response from the system
    GOTO UNAVAILABLE                   ;hang up and try again?
  ENDIF                                ;continue
TRYAGAIN:                              ;loop for resending page number
  TRANSMIT "M715!"                     ;goto FOG Roundtable
  WAITFOR "Page 715" 180               ;did we make it
  IF WAITFOR                           ;test to make sure
    WAITFOR "or <H>elp?"               ;wait for the Roundtable prompt
    ALARM 1                            ;make some noise
    EXIT                               ;we made it!
  ENDIF                                ;end of test
  MESSAGE "^MDidn't make it to the FOG Roundtable.  Want to try again? (Y/N)"
  ALARM 1                              ;signal attention
  KFLUSH                               ;make sure no keys pressed
  GET S0 1                             ;get the keyboard input
  FIND S0 "Y"                          ;did we get a Y?
  IF FOUND                             ;test it
    GOTO TRYAGAIN                      ;send the page number again
  ENDIF                                ;continue
  EXIT                                 ;end it
;
UNAVAILABLE:                           ;system is unavailable
  HANGUP                               ;hangup phone
  CLEAR                                ;clear screen
  MESSAGE "^M^JGenie is not available.  Do you want to dial again? (Y/N)"
  ALARM 1                              ;make some noise
  KFLUSH                               ;clear the keyboard
  GET S0 1                             ;get one keystroke
  FIND S0 "Y"                          ;check for Y
  IF FOUND                             ;did we get it?
    GOTO CALLING                       ;if yes go call again
  ENDIF                                ;continue
;
EXIT                                   ;quit command file
