           TITLE     'Wolfware Sample Program','Printer Reset'

;-----------------------------------;
;            Printer Reset          ;
;                                   ;
; Initialize parallel printer port  ;
; one through the BIOS routine.     ;
; Once assembled, to reset the      ;
; printer, type:                    ;
;                                   ;
; PRES                              ;
;                                   ;
; This routine have the effect of   ;
; initializing the printer to its   ;
; power on characteristics.         ;
;-----------------------------------;

           PROC      FAR
PORT       EQU       1              ;printer port to initialize
ERROR_BITS EQU       00101001B      ;printer error bits

;----- print message to inform user on screen

           MOV       DX,OFFSET PRESMESS ;message location
           MOV       AH,9           ;string output
           INT       21H            ;execute

;----- reset printer port

           MOV       DX,PORT        ;port number
           MOV       AH,1           ;initialize port
           INT       17H            ;execute

           TEST      AH,ERROR_BITS  ;check if error
           JZ        PDONE          ;jump if OK

;----- error

           MOV       DX,OFFSET PRESERR  ;message location
           MOV       AH,9           ;string output
           INT       21H            ;execute

PDONE      INT       20H            ;exit

;----- data

PRESMESS   DB        10,'Printer ', PORT + '0' ,' reset', 13,10,'$'
PRESERR    DB        10,'Error in printer', 13,10,'$'
           ENDP

