procedure Msg(MsgString: str255; Col,Row: integer);
   { Print a message at location Col,Row }
 begin
    gotoXY(Col,Row);  write(MsgString);
 end;

procedure Center(S: str255; Col,Row,L: integer);
  { Center a string on a line of L length beginning at position Col,Row }
  {** (Col,Row) is row and column to center on **}
  {** L is the length of the line to center on **}
var I: integer;
 begin
    gotoXY(Col,Row);
    for I:= 1 to L do write(' ');
    gotoXY(Col+(L-Length(S)) div 2,Row); write(S);
 end;

procedure InvVideo( InvStr: str255);
    { print a string in inverse video }
 begin
   textBackground(15);textcolor(0); write(InvStr);
   textBackground(0) ;textcolor(7);
 end;

procedure Color(BackGnd,Txt: integer);
   { change the background & text color }
 begin
   textBackGround(BackGnd); textColor(Txt);
 end;

function UpcaseStr(S : Str80) : Str80;
   { convert a string to UpperCase }
var
  P : Integer;
begin
  for P := 1 to Length(S) do
    S[P] := Upcase(S[P]);
  UpcaseStr := S;
end;

function ConstStr(C : Char; N : Integer) : Str80;
  (*  ConstStr returns a string with N characters of value C *)
var
  S : string[80];
begin
  if N < 0 then
    N := 0;
  S[0] := Chr(N);
  FillChar(S[1],N,C);
  ConstStr := S;
end;

function fmt_real(num : real; len,dec: integer): str20;
   { Sstring is string[20] }
   { format a real number to length len (len is total length of string
     including commas and decimal), with dec decimal places }
 var  s1,s2,Temp : string[20];
      C,I,J,K,Cd : integer;
  begin
    str(num,S1);
    S1 := copy(S1,pos('+',S1)+1,2);
    val(S1,C,cd); str(num:C:dec,S1);
    S2 := copy(S1,pos('.',S1)+1,dec);
    S1 := copy(S1,1,pos('.',S1)-1);
    J:=1; K:=0;
    for I := length(S1) downto 1 do
      begin
       if ((j mod 3) = 0) and (I <> 1) then
         begin
           if (I=2) and (copy(s1,1,1)='-') then S1:=S1 else
           s1:=copy(s1,1,length(s1)-j-k)+','+copy(s1,i,length(s1)-i+1);
           k:=k+1;
         end;
       J:=J+1;
      end;
    Temp := S1+'.'+S2;
    if length(Temp) > len then Temp:='%'+Temp;
    if length(Temp) < len then
      begin
       repeat Temp:=' '+Temp; until length(Temp)=len;
      end;
    Fmt_real := Temp;
  end;

procedure Box(C1,R1,C2,R2,M: integer);
 { Draw a box with a dividing line }
 {* (C1,R1) is upper left of box, (C2,R2) is lower rt of box *}
 {* M is the row of the dividing line (2nd line) of box      *}
 var I,J,K: integer;
  begin
    K:= C2-C1-1; HighVideo;
    GotoXY(C1,R1); write('');
    for I:=1 to K do write('');
    write('');
    for I:=R1+1 to R2-1 do
    begin
      GotoXY(C1,I); write('');
      if I = M then begin
        for J:=1 to K do write('');
      end;
      GotoXY(C2,I); write('');
    end;
    GotoXY(C1,R2); write('');
    for I:=1 to K do write('');
    write(''); LowVideo;
  end;

procedure Option;
   { Read a keyboard character & convert to upper-case }
 begin
     read(kbd,Ch);  Ch:=UpCase(Ch);
 end;

procedure StripSpaces(S: str255; var NewStr: str255);
    {strip spaces from the end of a string}
 begin
   S:=S+'  '; NewStr := copy(S,1,pos('  ',S)-1);
 end;

procedure ClrWnd(C1,R1,C2,R2: integer);
   { Clear a selected portion of the screen }
   {** (C1,R1) & (C2,R2) are upper left and lower rt of window **}
 var I,J,K: integer;
 begin
   K:=C2-C1-1;
   for I:=R1 to R2 do
     begin
       gotoXY(C1,I); for J:= 1 to K do write(' ');
     end;
 end;

procedure SaveScreen;
    { save an image of the video in memory }
 var mono: boolean;
  begin
    if (mem[0000:1040] and $30) = $30 then Mono:=true else Mono:=false;
    if mono then move(video_scr1[1],memory_scr[1],4000)
    else         move(video_scr2[1],memory_scr[1],4000);
  end;

procedure FlashScreen;
    { redisplay a memory image of a video display }
 var mono: boolean;
  begin
    if (mem[0000:1040] and $30) = $30 then Mono:=true else Mono:=false;
    if mono then move(memory_scr[1],video_scr1[1],4000)
    else         move(memory_scr[1],video_scr2[1],4000);
  end;