/*
** Windows - Header file
**
** Copyright (c) 1984, 1985 - Philip A. Mongelluzzo
** All rights reserved.
*/

typedef struct wcb              /* Window control block */
{
int ulx,                        /* upper left corner x coordinate */
    uly,                        /* upper left corner y coordinate */
    xsize,                      /* width of window - INSIDE dimension */
    ysize,                      /* height of window - INSIDE dimension */
    ccx,                        /* current virtual cursor offset in window */
    ccy,
    style,                      /* character attribute to be used in window */
    bstyle,                     /* boarder attribute */
    bsize;                      /* total border size (0 or 2) */
char *scrnsave;                 /* pointer to screen save buffer */
int page,                       /* current video page being used */
    oldx,                       /* cursor position when window was */
    oldy,                       /* opened (used for screen restore) */
    wrpflg,                     /* wrap flag */
    synflg;                     /* cursor sync flag */
char *handle;                   /* my internal id */
} WINDOW, *WINDOWPTR;

WINDOWPTR wn_open();            /* returns pointer */
WINDOWPTR wn_save();            /* ditto ..... */
WINDOWPTR wn_move();

extern int wn_dmaflg;           /* write to video ram directly flag */
extern char wn_sbit;            /* retrace test bit 1=fast 8=slow */

#define FAST    0x01            /* for wn_sbit */
#define SLOW    0x08            /* ditto */

#define BLACK   0x00            /* foreground */
#define RED     0x04            /* background */
#define GREEN   0x02            /* colors */
#define YELLOW  0x06            /* bg << 4 | fg */
#define BLUE    0x01
#define MAGENTA 0x05
#define CYAN    0x03
#define WHITE   0x07
#define BLINK   0x80
#define BOLD    0x08
#define NDISPB  0x00            /* non display black */
#define NDISPW  0x77            /* non display white */
#define RVIDEO  0x70            /* reverse video */
#define UNLINE  0x01            /* under line (BLUE) */

#define NVIDEO  0x07            /* normal video */
#define NORMAL  0x03            /* cyan is normal for me */

/*
** Macro to set attribute byte
*/

#define v_setatr(bg,fg,blink,bold) ((blink|(bg<<4))|(fg|bold))

/* End */
