DEFINT A-Z

GOSUB INITIALIZE

GOSUB CREDITS

GOSUB LOADCATS

GOSUB PROCESSCAT

GOSUB CLEANUP

END

INITIALIZE:
  DIM CATEGORY.NAME$(99),CATEGORY.CODE$(99)
  DIR.CAT$ = "DIR.CAT"
  MASTER$ = "UPLOADS.FIX"
  DIR.EXTENSION$ = "DIR"
  CATEGORY.LEN = 3
  LINES.TRUNCATED = 0
  LINES.EXTENDED = 0
  LINES.EXCLUDED = 0
  TOT.LINES.OUT = 0
  DESC.LEN = 40
  IF LEN(COMMAND$) > 0 THEN _
     DESC.LEN = VAL(COMMAND$)
  LINE.LEN = 33 + DESC.LEN
RETURN

CREDITS:

  LOCATE 2,7
  PRINT "CNVDIR (c) 1986 Ken Goosens  An RBBS Conversion Utility"
  LOCATE 3,1
  PRINT "FORMAT:  CNVDIR <length>  where <length>=# chars to be in file description"
  LOCATE 4,5
  PRINT "This program converts directories for the Upload Management System"
  LOCATE 6,7
  PRINT "For all the directories listed in ";DIR.CAT$;" it "
  LOCATE 8,10
  PRINT "o  Screens out non-directory entries (e.g. headers)"
  LOCATE 9,10
  PRINT "o  Appends the directory entries to ";MASTER$
  LOCATE 10,10
  PRINT "o  Adds the category code specified in ";DIR.CAT$
  LOCATE 11,10
  PRINT "o  Makes the entries fixed length with a file decription of";STR$(DESC.LEN);" chars."
  LOCATE 14,5
  PRINT "On the current directory should be"
  LOCATE 16,5
  PRINT "   - the directories of files (extension ";DIR.EXTENSION$;")"
  LOCATE 17,5
  PRINT "   - the directory category file ";DIR.CAT$;" in format"
  LOCATE 18,5
  PRINT "       <directory name>,<dir codes>,<dir description>
  LOCATE 20,5
  PRINT "    After consolidation, sort the single directory by date."
  LOCATE 22,20
  INPUT "[A]bort, or [C]ontinue (A/C) ",X$
  IF X$<>"C" AND X$<>"c" THEN END
RETURN

LOADCATS:
  CLS
  LOCATE 5,8
  PRINT "Searching ";DIR.CAT$;" for single code categories: found ";
  COL = POS(0)
  OPEN DIR.CAT$ FOR INPUT AS #1
  NUM.CATS = 0
  WHILE NOT EOF(1) AND NUM.CATS < UBOUND(CATEGORY.CODE$)
     INPUT #1,CN$,CC$,X$
       IF INSTR(CC$,",")=0 THEN _
         NUM.CATS = NUM.CATS + 1:_
         LOCATE 5,COL:_
         PRINT NUM.CATS:_
         CATEGORY.NAME$(NUM.CATS) = CN$:_
         CATEGORY.CODE$(NUM.CATS) = CC$
  WEND
  CLOSE 1
RETURN

PROCESSCAT:
  OPEN MASTER$ FOR OUTPUT AS #2

  FOR I=1 TO NUM.CATS
     OPEN CATEGORY.NAME$(I)+"."+DIR.EXTENSION$ FOR INPUT AS #1
     LOCATE 10,25
     PRINT "Processing ";CATEGORY.NAME$(I);
     COL = POS(0) + 1
     PRINT SPACE$(10);
     CC$ = CATEGORY.CODE$(I)
     GOSUB CCLENGTH
     NUM.LINES = 0
     LINES.OUT = 0
     WHILE NOT EOF(1)
       NUM.LINES = NUM.LINES + 1
       LOCATE 10,COL
       PRINT NUM.LINES
       LINE INPUT #1,A$
       IF LEN(A$) > 30 THEN_
         IF MID$(A$,22,2)="  " AND MID$(A$,26,1)="-" _
            AND MID$(A$,29,1)="-" THEN _
		GOSUB LINELENGTH:_
		LINES.OUT = LINES.OUT + 1:_
                PRINT #2,A$;CC$_
         ELSE_
            LINES.EXCLUDED = LINES.EXCLUDED + 1_
       ELSE_
         LINES.EXCLUDED = LINES.EXCLUDED + 1
     WEND
     TOT.LINES.OUT = TOT.LINES.OUT + LINES.OUT
   CLOSE 1
   NEXT
RETURN

CLEANUP:
  CLOSE
  LOCATE 14,5
  PRINT "# LINES:  truncated ";LINES.TRUNCATED;"  extended ";LINES.EXTENDED;
  PRINT "  excluded ";LINES.EXCLUDED
  LOCATE 16,7
  PRINT "Your converted upload directory is file ";MASTER$
  LOCATE 17,20
  PRINT "It contains";STR$(TOT.LINES.OUT);" entries."
RETURN

CCLENGTH:
  L = LEN(CC$)
  IF L > CATEGORY.LEN THEN _
      PRINT "Category code ";CC$; "exceeds maximum length of ";CATEGORY.LEN:_
      PRINT "Aborting...":_
      END
  CC$ = CC$ + SPACE$(CATEGORY.LEN - L)
RETURN

LINELENGTH:
  L = LEN(A$)
  IF L > LINE.LEN THEN _
     LINES.TRUNCATED = LINES.TRUNCATED + 1:_
     A$ = LEFT$(A$,LINE.LEN)_
  ELSE IF L < LINE.LEN THEN _
     LINES.EXTENDED = LINES.EXTENDED + 1:_
     A$ = A$ + SPACE$(LINE.LEN-L)
RETURN
