(*****************************************************************************)
(*														                                               *)
(* TITLE   : PC-DOS 2.xx File Attribute Editor                               *)
(* Version : 2.04                                                            *)
(* Author  : Rick Housh                                                      *)
(* DATE    : 3/5/85.                                                         *)
(*                                                                           *)
(*****************************************************************************)

 {THIS PROGRAM WILL NOT WORK PROPERLY WITH A COMMAND LINE ARGUMENT UNTIL
 COMPILED TO A .COM FILE BECAUSE IT MUST SCAN THE MS-DOS COMMAND LINE AT
 THE SYSTEM LEVEL.  My sincere apologies to Mr. Wirth for the "Goto".
 Written in TURBO PASCAL, Version 3.01A.  Modified last on 7/27/85.

N.B. Be very careful when using this program with directories, especially
with hard disks.  You can make your directory invisible to the normal oper-
ating system commands.}


Program Read_and_Set_File_Attributes;

{$C-}  {For faster screen writes-can always use abort option anyway}

  Const                                {Names for the attribute bits}

    NowSet: Array [0..7] Of String[33]=
          ('Read only','Hidden','System','Volume label','Directory name',
           'Unarchived','Illegal Byte Value (2nd bit set)',
           'Illegal Byte Value (1st bit set)');

    SetTo: Array [0..7] Of String[12]=
          ('Read only','Read/write','Hidden','Not hidden',
           'System','Non-system','Unarchived','Archived');

           {We could have allowed the setting of the (presently) illegal
            first and second bits here, for some use of our own,
            but it will probably conflict with some future legal
            use}

  Label
    Start_here;                        {Sorry, but it's so much easier}

  Type

    FileNames=String[65];

    DataTransArea=Record        {Record of File Control Block + some buffers}

          KeyboardBufferAndOtherStuffWeDontNeed: Array [0..20] Of Byte;
          AttribByte: Byte;
          Time_Date_Size1_Size2: Array [0..3] Of Integer; {Maybe use it later}
          FileName: Array [0..12] Of Char;
        End;

    RegisterSet=Record Case Integer Of {Standard MS-DOS RegPack}

                  1: (AX,BX,CX,DX,BP,SI,DI,DS,ES,Flags: Integer);
                  2: (AL,AH,BL,BH,CL,CH,DL,DH: Byte);
                End;

  Var

    DirAndOrPath,Mask,CurrentFile: FileNames;
    CurDataTransArea: ^DataTransArea;
    Regs: RegisterSet;
    Finished,None,AttributeChanged,AnAttributeSet: Boolean;
    A,BitPattern,Index,J,P : Byte;
    C,ERR : Integer;
    Choice: String[2];
    Dummy: String[1];
    This: String[12];


Procedure Warble;
  Begin
    For A := 1 to 3 do
      Begin
        Sound(440);
        Delay(50);
        Sound(660);
        Delay(50);
        NoSound;
      End;
  End; {Procedure Warble}

Procedure Beep;
  Begin
    Sound(440);
    Delay(100);
    NoSound;
  End; {Procedure Beep}


Begin

{Introduction}
 P:=1;
 If ParamCount > 0 then if ParamStr(1) = ('?') then P := 0;
 If ParamCount = 0 then P:=0;
 If P = 0 then
  Begin
    ClrScr;
    WriteLn('File attribute program, by T. A. Housh, Jr.');
    WriteLn;
    LowVideo;
    WriteLn('This program will allow you to view and change the attributes');
    WriteLn('of an MS-DOS 2.xx file.');
    WriteLn;
    WriteLn('You may use wild cards or not, as you choose.');
    WriteLn;
    WriteLn('If you wish to examine a whole directory or disk just specify the');
    WriteLn('drive or path in the usual way, e.g. a: or b:\bin or whatever.');
    WriteLn('You may specify this parameter in the command line, or if');
    WriteLn('you wish, you may enter the program without a file parameter, in');
    WriteLn('which case this message will be displayed, and you will then be');
    WriteLn('prompted for a file name or other parameter.  If you enter a carriage');
    WriteLn('return in response, the file parameter will default to *.* on the');
    WriteLn('default drive and/or directory.  If you enter SETATR ? you will');
    WriteLn('receive this message and the program will terminate.');
    WriteLn;
    WriteLn('The designation "(No exceptions)" indicates no special attributes set,');
    WriteLn('that is, the file is read/write, non-system, not hidden, and has been');
    WriteLn('archived.');
    If ParamStr(1) = ('?') then Halt;
    WriteLn;
  end;

{Now look for a parameter in the command line}
If P =1 then Mask:=ParamStr(1) else Mask:=('');

(*Could define Mask as an array of ParamStr, with an index of 1..ParamCount
and loop through the whole program until MaxParamcount is reached, allowing
multiple files to be specified in the command line without wild cards..a
thought, but its getting pretty large already.*)

    If Mask='' Then

Start_Here: {If file name not specified, or restart requested, ask for target}

     Begin
     WriteLn;
     Write('Enter file name: ');
      ReadLn(Mask);
     End;

{START OF FILE SEARCH}

{Parse file name, force to upper case, look for directories and paths.}

    For Index:=1 To Length(Mask) Do
     Mask[Index]:=UpCase(Mask[Index]);
    Index:=Pos('\',Mask);
    If Pos(':',Mask)<>0 Then Index:=Pos(':',Mask);
    If Index<>0 Then
      Repeat
        J:=Pos('\',Copy(Mask,Index+1,64));
        Index:=Index+J;
      Until J=0;
    DirAndOrPath:=Copy(Mask,1,Index);

{If only directory or path, set wildcards for all files.}

    If DirAndOrPath=Mask Then Mask:=Mask+'*.*';

{Go to disk directory, get first (or only) file.}

    Mask[Length(Mask)+1]:=Chr(0);
    With Regs Do
     Begin
      AH:=$2F;                         {Get Data Transfer Address (DTA)}
      MsDos(Regs);
      CurDataTransArea:=Ptr(ES,BX);
      AH:=$4E;                         {Search for first}
      DS:=Seg(Mask[1]);
      DX:=Ofs(Mask[1]);
      CX:=$17;
      MsDos(Regs);
      Finished:=False;
      None:=True;

{START OF MAIN PROGRAM LOOP}

{If drive, directory, path, or file not found, display error and terminate.}

   Repeat
        This:='';
        WriteLn;
        If (Flags And 1)<>0 Then
         Begin
          Beep;
          HighVideo;
(*For some reason the following I/O error detection does not work*)
          Case AX Of                   {Limited Error Return Detection}
           $02: Write('File not found');
           $03: Write('Directory or path not found');
           $05: Write('Access denied.  Illegal device specified');
           $06: Write('Access denied. Invalid file handle');
           $0F: Write('Invalid drive specified');
           $12: If None Then Write('Specified file ',Mask,' not found');
            else Write('Unknown error ');
           End;
          LowVideo;
          WriteLn;
          Finished:=True;
         End
        Else

{If no error, then get first file and show attribute data.}

         Begin
          ERR:=0;
          None:=False;
          CurrentFile:=DirAndOrPath+
            Copy(CurDataTransArea^.FileName,1,
            Pos(#0,CurDataTransArea^.FileName));

{START OF RECYCLE LOOP}

        Repeat;
          ClrScr;
          LowVideo;
          Write('File Attribute Program.  Looking at: ');
          TextBackGround(White);
          TextColor(Black);
          WriteLn(Mask);
          LowVideo;
          If ERR<>0 Then
           Begin
             GotoXY(1,3);
             Warble;
             TextColor(LightGray + Blink);
             Write('Input error - ');
             HighVideo;
             WriteLN(' Try again.');
             LowVideo;
             ERR:=0;
           End;
          GotoXY(1,5);
          Write('Current File  -> ');
          TextColor(White + Blink);
          Write(Copy(CurrentFile,1,Length(CurrentFile)-1));
          If This <> '' Then
            Begin
             NormVideo;
             Write(' reset to ');
             HighVideo;
             Write(This,'.');
             Beep;
             NormVideo;
            End;
          WriteLn;
          NormVideo;
          AX:=$4300;                   {Read current file attribute byte}
          DS:=Seg(CurrentFile[1]);
          DX:=Ofs(CurrentFile[1]);
          MsDos(Regs);
          BitPattern:=CX;
          GotoXY(1,7);
          Write('Normal, except-> ');
          HighVideo;
          Write(#221);
          LowVideo;
          AnAttributeSet:=False;
          For Index:=0 To 7 Do
            If BitPattern And (1 Shl Index)<>0 Then
             Begin
              If AnAttributeSet Then Write(': ');
              Write(NowSet[Index]);
              AnAttributeSet:=True;
             End;
          If Not AnAttributeSet Then Write('No exceptions');
          HighVideo;
          WriteLn(#222);
          LowVideo;
          AttributeChanged:=False;
            GotoXY(1,9);
            WriteLn;
            WriteLn('Reset   to:      1:' ,SetTo[BitPattern AND 1]);
            WriteLn('                 2:' ,SetTo[(BitPattern AND 2) Shr 1+2]);
            WriteLn('                 3:' ,SetTo[(BitPattern AND 4) Shr 2+4]);
            WriteLn('                 4:' ,SetTo[(BitPattern AND 32) Shr 5+6]);
            WriteLn('    or');
            WriteLn;
            WriteLn('Proceed to:      5:Abort Program.');
            WriteLn('                 6:Restart Program. No further changes.');
            WriteLn('                 0:Next File.       No further changes.');
            WriteLn;
            WriteLn;

{Ask for changes or other instructions.}

            Write('Your choice? (Default = Next file)-> ');
            C:=0;
            ERR:=0;
            This:='';
            ReadLn(Choice);
            If Length(Choice) > 1 Then Choice := ('a'); {Set to illegal value}
            Val(Choice,C,ERR);   {Convert string to number, check for error.}
            If ERR<>0 Then C:=7; {Enable error trap, if input out of range.}
            Choice:='';
            Case C Of
               1: This:=SetTo[BitPattern AND 1];
               2: This:=SetTo[(BitPattern AND 2) Shr 1+2];
               3: This:=SetTo[(BitPattern AND 4) Shr 2+4];
               4: This:=SetTo[(BitPattern AND 32) Shr 5+6];
             End;
            Case C Of
               1: BitPattern:=BitPattern Xor 1;
               2: BitPattern:=BitPattern Xor 2;
               3: BitPattern:=BitPattern Xor 4;
               4: BitPattern:=BitPattern Xor 32;
             End;
              If C In [1..4] Then AttributeChanged:=True;
              If C=5 then Finished:=True;
              If C=6 Then Goto Start_here;
              If C=5 then C :=0;
              If C>7 Then C:=7;                               {Error Trap}
              If C=7 Then AttributeChanged:=True;

              {Not really, but doesn't matter, input error.  Change nothing,
              set error flag, beep, redisplay, with error message.}

              If C = 7 Then ERR:=1;

{If change requested, make it.}

         If AttributeChanged Then      {Reset attribute Byte}
            Begin
             AX:=$4301;
             DS:=Seg(CurrentFile[1]);
             DX:=Ofs(CurrentFile[1]);
             CX:=BitPattern And $FFE7;
             MsDos(Regs);
            End;

{Loop back to same file, unless no change requested and no error on input.}

          Until C=0;
          AH:=$4F;                     {Search for next}
          MsDos(Regs);
         End;

{Loop back to start of main program, get next file, unless end of requested
 files, or end of directory.}

    Until Finished;

{Termination sequence.}

     WriteLn('End of specified files or end of directory.');
     WriteLn('End of program.');
     NormVideo;
    End;

  End. {Of Read_And_Set_File_Attributes}
