FUNCTION Time:Real;
{
   Get time from system clock,  convert Hours, Minutes, Seconds,
   and Hundredths of Seconds to time in Seconds.    This makes it
   easy to measure elapsed time by subtracting one time from a
   later time.
}

TYPE Register_Type = Record
                       AX, BX, CX, DX : Integer
                     End;
VAR
  Reg : Register_Type;

BEGIN
  Reg.AX := $2C00;
  Intr($21,Reg);
  Time := (Reg.CX shr 8)       * 3600    {Hours      }
        + (Reg.CX and $00FF)   * 60      {Minutes    }
        + (Reg.DX shr 8)     { * 1 }     {Seconds    }
        + (Reg.DX and $00FF)   / 100 ;   {Hundredths }
END;
