{.PA -----------------------------------------------------------------------}

type

    String80T = string [80];

    DOSDTAT = array [0 .. 42] of byte;

    DOSFNMaskT = array [1 .. 14] of char;

    DOSRegsT = record case integer of
        1 : (AX, BX, CX, DX, BP, DI, SI, DS, ES, Flags : integer);
        2 : (AL, AH, BL, BH, CL, CH, DL, DH            : byte);
      end;


{.PA -----------------------------------------------------------------------}

procedure DOSGetFirstDirEntry (var Mask : DOSFNMaskT;
                               var DTA : DOSDTAT;
                               var FN;
                               var Error : integer);

var
    Namr : String [12] absolute FN;
    Regs : DOSRegsT;
    I : integer;


begin
  fillchar (DTA, sizeof(DOSDTAT), 0);

{ set up the disk transfer area
}
  with Regs do
    begin
      AX := $1a00;
      DS := seg(DTA);
      DX := ofs(DTA);
    end;  { with }
  msdos (Regs);

 { get the first match if it exists
 }
 with regs do
    begin
      AX := $4e00;
      DS := seg(mask);
      DX := ofs(mask);
      CX := 22;
    end;
  msdos (Regs);
  Error := Regs.AX and $FF;

{ copy the matching name if no error
}
  if error = 0 then
    begin
      i := 1;
      if error = 0 then
          repeat
              namr[i] := chr(mem[seg(dta):ofs(dta)+29+i]);
              i := i + 1;
          until not (namr[i-1] in [' ' .. '~']) or (i > 20);
      namr[0] := chr(i-1);
    end;  { if }
end;  { procedure }

{.PA -----------------------------------------------------------------------}

procedure DOSGetNextDirEntry (var DTA : DOSDTAT;
                              var FN;
                              var Error : integer);

var
    FileName : string [12] absolute FN;
    Regs : DOSRegsT;
    I : integer;

begin
  with Regs do
    begin
      ax := $4f00;
      cx := 22;
    end;  { with }
  msdos (regs);
  error := Regs.AX and $FF;

{ copy the matching name if no error
}
  if error = 0 then
    begin
      I := 1;
      while (I <= 12) and
       (chr(mem[seg(DTA):ofs(DTA)+29+i]) in [' '..'~']) do
        begin
          FileName[i] := chr(mem[seg(dta):ofs(dta)+29+i]);
          i := i + 1;  { should never get to 20 anyway... }
        end;  { while }
      FileName[0] := chr(i-1);
    end;  { if }
end;  { procedure }

{.PA -----------------------------------------------------------------------}

procedure PauseCheck (LinesPrinted, PauseCount : integer);

var
    Ch : char;

begin
  if (LinesPrinted mod PauseCount) = 0 then
    begin
      write ('*** Press return to continue ***');
      read (ch);
      write (chr(13));
      ClrEol;
    end;  { if }
end;  { procedure }


{.PA -----------------------------------------------------------------------}

procedure JEDirectory (Mask : DOSFNMaskT);

const
    LinesPerScreen = 22;  { pause every 22 lines }

var
    DTA : DOSDTAT;
    FileName : String80T;
    Error : integer;
    LineCt : integer;
    P : integer;
    Size : real;
    Time, Date, Seconds, Minutes, Hours, Day, Month, Year : integer;

begin
  ClrScr;
  Error := 0;
  LineCt := 0;
  DOSGetFirstDirEntry (Mask, DTA, FileName, Error);
  while Error = 0 do
    begin
      Size := DTA[26] + DTA[27]*256.0 + DTA[28]*65536.0 + DTA[29]*1048576.0;
      Time := DTA[22] + DTA[23]*256;
      Date := DTA[24] + DTA[25]*256;
      Seconds := (Time and $1F) * 2;
      Minutes := (Time and $07E0) shr 5;
      Hours := (Time and $F800) shr 11;
      Day := (Date and $1F);
      Month := (Date and $01E0) shr 5;
      Year := ((Date and $FE00) shr 9) + 80;
      P := pos('.',FileName);
      if P > 0 then
        begin
          write (' ':4,copy(FileName,1,P-1));  { P cannot be 0 here anyway }
          if P <= 8 then
              write (' ':(9 - P));
          write (copy(FileName,P,4):3,'  ',(Size/1024.0):6:1,'k  ',
                   Month:2,'/',Day:2,'/',Year:2,'  ',Hours:2,':');
          if Minutes < 10 then
              write ('0');
          writeln (Minutes:1);
        end;  { if }
      LineCt := LineCt + 1;
      PauseCheck (LineCt, LinesPerScreen);
      DOSGetNextDirEntry (DTA, FileName, Error);
    end;  { while }
  writeln (LineCt:1,' files');
end;  { procedure }


begin JEDirectory ('????????.???'); end. {May include Drive Spec (A: B: etc)}
