Program TurboScript;
{
*****************************************************************************
*                                                                           *
*                  Turbo Script   ---  Version 4.0                          *
*                                                                           *
*                         By Kevin Menningen                                *
*                                                                           *
*        Copyright (c) 1985 by Kevin Menningen.   All Rights Reserved.      *
*                                                                           *
*             Special thanks to Tim Conner for his contributions.           *
*                                                                           *
*  If you like this program, or even if you don't, please send me either    *
*  regular or electronic mail so I know you're out there. If you REALLY     *
*  like it, then a contribution as big as $1 will be GREATLY appreciated.   *
*  With the high cost of software these days, it would be a good idea to    *
*  support ALL public domain programmers to keep them off the streets! Send *
*  mail to:                                                                 *
*                                                                           *
*                            Kevin Menningen                                *
*                            2051 S. 95th Street                            *
*                            West Allis, WI  53227                          *
*                                                                           *
*                       BBS: Exec-PC BBS (414) 964-5160                     *
*****************************************************************************
}

{$C-,V-,K-}
type
    TempString = string[80];
var
    Words : array[1..500] of TempString;
    Buffer : array[0..1325] of integer;
    Row, Column, i, MaxRow, ScreenRow, Temp1, Temp2, Temp3, Keynum, Num, code,
    EndColumn, Index, NumEnd, Inum, Hour, Min, Sec : integer;
    Inkey, SecInkey, Choice, ch, Drive : char;
    Tabset : array[1..80] of boolean;
    TextFile : Text;
    TempWord, Glossary, DirString, Path, FileName, Oops : TempString;
    Secnum, Insertmode, Exit, Dir, Capsmode, pm : boolean;
    dosrec : record
               ax,bx,cx,dx,bp,si,di,ds,es,flags : integer;
             end;

{$I TSCRIPT2.PAS}

procedure DirGet  (Func, Asciiz : TempString; var FileName : TempString;
                   var Error : Integer; Option : Integer);
var
   OurDTA : array [ 1..43 ] of byte;    { Data Transfer Area buffer }
   CurDTAseg,                           { DTA segment before execution }
   CurDTAofs,                           { DTA offset    "        "     }
   OurDTAseg,                           { DTA segment and offset set after }
   OurDTAofs          : integer;        { start of program }

begin
    error := 0;
    If Func = 'FIRST' then begin
       Error := 0; {---------- Initialization processes ------------}
       For I := 1 to 43 do OurDTA[I]:=0;        {Initialize our DTA Buffer}
       dosrec.ax := $2F00;                      { Save Current DTA pointer}
       Intr($21,dosrec);                        { to be restored later    }
       CurDTASeg := dosrec.es;
       CurDTAOfs := dosrec.bx;
       error := dosrec.ax and $FF;
       if error = 0 then begin
          OurDTAseg := seg(OurDTA);           {Point DOS to our        }
          OurDTAofs := ofs(OurDTA);           {DTA Buffer              }
          dosrec.ax := $1A00;
          dosrec.ds := OurDTASeg;
          dosrec.dx := OurDTAOfs;
          Intr($21,dosrec);
          error := dosrec.ax and $FF;
       end;
       asciiz[length(asciiz)+1]:=chr(0); { Terminate name with hex00 }
       dosrec.ax := $4E00;          { Get first directory entry }
       dosrec.ds := seg(Asciiz);    { Point to the file mask }
       dosrec.dx := ofs(Asciiz);
       dosrec.dx := dosrec.dx + 1;    { Point past string's length byte }
       dosrec.cx := Option;
       end
    else
       dosrec.ax := $4F00;          {Get next directory entry}
    Intr($21,dosrec);               { Execute MSDos call }
    error := dosrec.ax and $FF;     { Get error return }
    I := 1;
    If error = 0 then
    Repeat                        { Get name from the DTA area }
        FileName[I]:=chr(mem[OurDTASeg:OurDTAOfs + 29 + I]);
        I := I + 1;
    Until (not (FileName[I - 1] in [' '..'~']));
    FileName[0]:=chr(I-1)         { set string length because assigning }
                                  { by element does not set length }
end;

procedure PrintDir;
var err,place : integer;
    firstname, nextnames, SearchString : TempString;

Begin
   ClrScr;
   DirGet('FIRST','????????.???'+chr(0),FIRSTNAME,err,8);
   SearchString := Drive + ':' + Path + DirString + chr(0);
   Writeln('Directory of ',SearchString,' Volume name is ',FIRSTNAME);
   Writeln;
   DirGet('FIRST',SearchString,Firstname,err,3);
   write(Firstname);
   place := 17;
   repeat
       if Place > 45 then begin
          Writeln;
          Place := 1;
       end;
       GotoXY(Place, WhereY);
       DirGet('NEXT',SearchString,Nextnames,err,3);
       Write(Nextnames);
       Place := Place + 16;
   until err<>0;
   dosrec.ax := $3600;
   dosrec.dx := 0;
   Intr($21, dosrec);
   Writeln;
   writeln('>>>  ',dosrec.bx,'k bytes free',chr(13),chr(10));
   if Inum = 3333 then begin
      writeln('Press any key to continue...');
      read(Kbd, Choice);
   end;
end;

function Exist(Name : TempString) : boolean;
begin
   Assign(TextFile, Name);
   {$I-}
   Reset(TextFile);
   {$I+}
   Exist := (IOresult = 0);
end;

procedure Warning;
begin
   ClrScr;
   Writeln(chr(7),'<<<<<<<<<<>>>>>>>>>>  ');
   writeln('That file already');
   writeln('    exists.');
   writeln;
   writeln('Replace it (Y/N)?');
   writeln;
   writeln('<<<<<<<<<<>>>>>>>>>>');
   GotoXY(19,6);
   Read(Kbd, Choice);
   GotoXY(19,6);
   write(Choice);
   if (Choice = 'n') or (Choice = 'N') then Exit := true;
end;

overlay procedure Savefile;
begin
   Temp1 := Column;
   Dir := false;
   CommandWindow('     Save File',28,6,52,18);
   GotoXY(1,5);
   writeln('Enter File Name:');
   Data_In(8, Filename);
   if Dir = True then begin
      Exit := false;
      Fill_Buffer('O',28,6,52,18);
      Fill_Buffer('I',2,3,78,19);
      CommandWindow(' ',2,3,52,19);
      PrintDir;
      CommandWindow('     Save File',54,6,78,18);
      GotoXY(1,5);
      Writeln('Enter File Name:');
      Data_In(8, Filename);
   end;
   if Exit = false then begin
      if Exist(FileName) = true then Warning;
      if Exit = false then begin
         Rewrite(TextFile);
         for i := 1 to MaxRow do begin
            FuncEnd;
            Writeln(TextFile, Copy(Words[i],1,Column));
         end;
         Close(TextFile);
      end;
   end;
   if Dir=false then Fill_Buffer('O',28,6,52,18) else Fill_Buffer('O',2,3,78,19);
   Column := Temp1;
end;

overlay procedure Loadfile(Title : TempString; Start : integer);
begin
   Dir := false;
   Temp1 := 3333;
   Temp2 := Row;
   CommandWindow('     '+Title+' File',28,6,52,18);
   GotoXY(1,5);
   Writeln('Enter File Name:');
   Data_In(8, Filename);
   if Dir = True then begin
      Exit := false;
      Fill_Buffer('O',28,6,52,18);
      Fill_Buffer('I',2,3,78,19);
      CommandWindow(' ',2,3,52,19);
      PrintDir;
      CommandWindow('     '+Title+' File',54,6,78,18);
      GotoXY(1,5);
      Writeln('Enter File Name:');
      Data_In(8, Filename);
   end;
   if Exit = false then if Exist(FileName)=true then begin
      if Title='Load' then ClearScreen;
      if Exit = false then begin
         Row := Start;
         While EOF(Textfile) = false do begin
            if Title = 'Merge' then InsertLine;
            Readln(TextFile, Words[Row]);
            if Length(Words[Row]) < 79 then Words[Row] := Words[Row] +
               Replicate(79-Length(Words[Row]),32);
            if Length(Words[Row]) >= 80 then Words[Row] := Copy(Words[Row], 1, 79);
            if Title = 'Load' then MaxRow := MaxRow + 1;
            Row := Row + 1;
         end;
         Temp1 := 1;
         Close(TextFile);
         Window(1,2,80,23);
         ClrScr;
         GotoXY(1,1);
         if Title = 'Load' then begin
            PrintWords(1);
            Row := 1;
         end else begin
            Row := Temp2;
            PrintWords(Row-ScreenRow+1);
         end;
         Oops := Words[Row];
      end;
   end
   else if Exit = False then begin
      ClrScr;
      writeln(chr(7));
      writeln('File does not exist');
      Delay(1000);
      Exit := true;
      Row := Temp2;
   end;
   if Exit = true then begin
      if Dir=false then Fill_Buffer('O',28,6,52,18) else Fill_Buffer('O',2,3,78,19);
   end;
end;

overlay procedure PrintFile;
var Linespaces,RowNum,j,LineNum,Page : integer;
    UnderMode, ItalicMode, BoldMode, PageNums : boolean;
    Typeset : TempString;

procedure SetMargins;
var  LeftMarg, RightMarg : integer;

begin
   Menu('Select Top Margin:',' 1"',' 1 1/2"',' 2"',' 2 1/2"',' None');
   if Num in [1..4] then begin
      Temp1 := (Num + 1)*3;
      ClrScr;
      writeln('Set Horizontal       Margins (Y/N)');
      read(Kbd, Choice);
      if (Choice = 'Y') or (Choice = 'y') then begin
          writeln;
          writeln('Enter Left margin:');
          Read(LeftMarg);
          writeln;
          writeln('Enter Right margin:');
          Read(RightMarg);
          Typeset := Typeset + chr(27) + chr(77) + chr(LeftMarg) +
                               chr(27) + chr(81) + chr(RightMarg);
      end;
   end else Temp1 := 1;
end;

procedure PrintTitle;
var Titlename : TempString;
    Spacing : integer;

begin
  Dir := true;
  CommandWindow('        Title',28,6,52,18);
  Dir := false;
  GotoXY(1,5);
  writeln('Enter title:');
  read(Titlename);
  Write(Lst, chr(27), chr(71), chr(27), chr(69), chr(27), chr(14));
  Spacing := 20 - Length(Titlename) div 2;
  Spacing := Spacing + Length(Titlename);
  writeln(Lst, Titlename : Spacing);
  writeln(Lst, chr(27), chr(64), Typeset);
  ClrScr;
  GotoXY(1,3);
  TextColor(White + Blink);
  writeln('Printing...');
  TextColor(White);
  writeln;
  writeln('<< Press any key >>');
  writeln('<< to abort.     >>');
end;

procedure Script(Style : integer);
begin
   Write(Lst, chr(27), chr(83), chr(Style));
   Index := Index + 1;
   repeat
      Write(Lst, TempWord[Index]);
      Index := Index + 1;
   until not(TempWord[Index] in ['0'..'9','-']) = true;
   write(Lst, chr(27), chr(84), TempWord[Index]);
end;

procedure Fonts(var Mode : boolean; Num : integer);
begin
   Mode := Not Mode;
   if Num = 45 then begin
      if Mode = true then Write(Lst, chr(27),chr(Num),chr(1)) else
        Write(Lst, chr(27), chr(Num), chr(0));
   end else if Mode = true then Write(Lst, chr(27), chr(Num)) else
        Write(Lst, chr(27), chr(Num+1));
end;


begin  { Print File }
   UnderMode := false;
   Italicmode := false;
   Boldmode := false;
   PageNums := false;
   Temp2 := Column;
   CommandWindow('     Print file',28,6,52,18);
   Typeset := chr(27)+chr(64);
   GotoXY(1,7);
   writeln('Press any key...');
   repeat until KeyPressed;
   repeat
      Menu('Choose print style:', ' Elite', ' Boldface', ' Italic', ' Compressed', ' Continue');
      Case Num of
          1 : Typeset := Concat(Typeset,chr(27),chr(66),chr(2),
                                chr(27),chr(77),chr(11));
          2 : Typeset := Concat(Typeset,chr(27),chr(71));
          3 : Typeset := Concat(Typeset,chr(27),chr(52));
          4 : Typeset := Concat(Typeset,chr(15),chr(27),chr(77),chr(32));
          5 :;
        else
          if Exit = false then write(chr(7));
        end;
      if Num in [1..4] then begin
         Sound(300);
         Delay(50);
         NoSound;
         write(' Done.');
         Delay(300);
      end;
   until (Num = 5) or (Exit = true);
   if Exit = false then begin
      SetMargins;
      ClrScr;
      writeln('Set line spacing:');
      writeln;
      writeln('1.  Single');
      writeln('2.  Double');
      writeln('3.  Triple');
      writeln;
      read(Kbd, Choice);
      Val(Choice, Num, code);
      if (Num in [1..3]) and (code = 0) then Linespaces := Num;
      writeln;
      Write('Do you want Page     Numbers? (Y/N): ');
      read(Kbd, Choice);
      if (Choice = 'Y') or (Choice = 'y') then PageNums := true;
      While KeyPressed do Read(Kbd,Choice);
      ClrScr;
      Writeln('Scroll paper to perf');
      Writeln('and press any key to');
      writeln('print, or Esc to');
      writeln('exit');
      read(Kbd, Choice);
      if ord(Choice) <> 27 then begin
         ClrScr;
         GotoXY(1,3);
         TextColor(White + Blink);
         writeln('Printing...');
         TextColor(White);
         writeln;
         writeln('<< Press any key >>');
         writeln('<< to abort.     >>');
         writeln(Lst, Typeset);
         RowNum:= 0;
         LineNum := 0;
         Page := 1;
         for j := 1 to Temp1 do write(Lst,chr(10));
         While (not KeyPressed) and (RowNum < MaxRow + 1) do begin
            TempWord := Replicate(EndColumn,32);
            RowNum := RowNum + 1;
            LineNum := LineNum + LineSpaces;
            if Copy(Words[RowNum],1,5) = 'Title' then PrintTitle
            else begin
               if Words[RowNum] <> TempWord then begin
                  i := RowNum;
                  FuncEnd;
                  TempWord := Copy(Words[RowNum],1,Column);
                  Index := 0;
                  repeat
                     Index := Index + 1;
                     case TempWord[Index] of
                        '\' : Fonts(UnderMode,45);
                        '~' : Script(0);
                        '|' : Script(1);
                        '' : Fonts(ItalicMode,52);
                        '' : Fonts(BoldMode,71);
                     else Write(Lst, TempWord[Index]);
                     end;
                  until Index >= Length(TempWord);
                  Write(Lst, chr(13));
               end;
               for j := 1 to Linespaces do write(Lst, chr(10));
            end;
            if (LineNum = (66-Temp1*2)) and (Temp1 > 2) then begin
               LineNum := 0;
               Page := Page + 1;
               for j := 1 to Temp1 do write(Lst, chr(10));
               if PageNums then begin
                  write(Lst, chr(10),chr(10),Replicate(73,32),'Page ',Page);
                  for j := 1 to Temp1-2 do write(Lst, chr(10));
               end else for j := 1 to Temp1 do write(Lst, chr(10));
            end;
         end;
         if KeyPressed then Read(Kbd, Choice);
      end;
   end;
   Column := Temp2;
   GotoXY(1,3);
   Writeln('            ');
   Fill_Buffer('O',28,6,52,18);
end;

overlay procedure Menu_S_R;

procedure Search;
var SearchString, Temp : TempString;
    Pointer, Position, Line, Len : integer;

begin
   Line := 2;
   SearchString := '';
   CommandWindow('       Search',28,6,52,18);
   GotoXY(1, 5);
   writeln('Enter String: ');
   writeln;
   write('? ');
   read(SearchString);
   Len := Length(SearchString);
   Window(1,2,80,23);
   ClrScr;
   for i := 1 to MaxRow do begin
      Pointer := Pos(SearchString, Words[i]);
      if (Exit = false) and (Pointer > 0) then begin
         Temp := Words[i];
         Position := Pointer;
         GotoXY(1, Line);
         LowVideo;
         write(Temp);
         NormVideo;
         While Pointer > 0 do begin
            GotoXY(Position, Line);
            write(Copy(Temp, Pointer, Len));
            Temp := Copy(Temp, Pointer + Len + 1,
                         80 - Pointer + Len + 1);
            Pointer := Pos(SearchString, Temp);
            Position := Position + Pointer + Len;
         end;
         writeln;
         Line := Line + 1;
         if Line = 20 then begin
            GotoXY(1, 22);
            write('Press any key to continue or Esc to exit ...');
            read(Kbd, Choice);
            if ord(Choice) = 27 then Exit := true else begin
               ClrScr;
               line := 2;
            end;
         end;
         if line > 2 then begin
            read(Kbd, Choice);
            if ord(Choice) = 27 then Exit := true;
         end;
      end;
   end;
   writeln(chr(13),chr(10),chr(10));
   writeln('End of search');
   Read(Kbd, Choice);
end;

procedure Replace;
var SearchString, Replacement : TempString;
    Pointer, Line, Len, Position : integer;

begin
   Line := 2;
   SearchString := '';
   Replacement := '';
   CommandWindow('      Replace',28,6,52,18);
   GotoXY(1, 5);
   writeln('Enter String: ');
   writeln;
   write('? ');
   read( SearchString);
   writeln;
   writeln('Enter Replacement:');
   writeln;
   write('? ');
   read( Replacement);
   Len := Length(Replacement);
   Window(1,2,80,23);
   ClrScr;
   for i := 1 to MaxRow do begin
      Pointer := Pos(SearchString, Words[i]);
      Position := Pointer;
      if (Pointer > 0) and (Exit = false) then begin
         TempWord := Words[i];
         repeat
            GotoXY(1, Line);
            LowVideo;
            write(Words[i]);
            NormVideo;
            GotoXY(Position, Line);
            write(Copy(Words[i], Position, Length(SearchString)));
            GotoXY(1,22);
            write('Replace Y/N');
            read(Kbd, Choice);
            if ord(Choice) = 27 then Exit := true else if (Choice = 'Y') or
            (Choice = 'y') then begin
               Words[i] := Copy(Words[i],1,Position-1) + Replacement +
                           Copy(Words[i], Position + Length(SearchString), 79-Len+1);
               GotoXY(Position, Line);
               Write(Copy(Words[i], Position, Len));
            end
            else begin
               GotoXY(80, Line);
               write('N');
            end;
            TempWord := Copy(Words[i], Position+Len+1, 79-Position+Len+1);
            Pointer := Pos(SearchString, TempWord);
            Position := Position + Pointer + Len;
         until Pointer = 0;
         Line := Line + 1;
         if Line = 20 then begin
            writeln('Press any key to continue or Esc to exit ...');
            read(Kbd, Choice);
            if ord(Choice) = 27 then Exit := true else begin
               ClrScr;
               line := 2;
            end;
         end;
      end;
   end;
   writeln;
   write('End of replace');
   Read(Kbd, Choice);
end;

begin  {Menu_S_R}
   CommandWindow('  Search / Replace',28,6,52,18);
   Exit := false;
   GotoXY(1,5);
   Writeln('Enter Choice: ');
   writeln;
   writeln('1.  Search');
   writeln('2.  Replace');
   writeln;
   write('? ');
   GotoXY(1,10);
   write('Press Esc to exit');
   read(Kbd, Choice);
   if ord(Choice) = 27 then Exit := true else Val(Choice, Num, code);
   if (Exit = false) and (Num in [1,2]) then
      case Num of
         1 : Search;
         2 : Replace;
        end
      else begin
         if Exit = false then write(chr(7));
         Fill_Buffer('O',28,6,52,18);
         Exit := true;
      end;
   ClrScr;
   GotoXY(1,1);
   PrintWords(Row-ScreenRow+1);
end;

overlay procedure DosMenu;
var CNum : integer;

procedure DelFile;
begin
  ClrScr;
  Dir := false;
  writeln('Enter file to Delete:');
  Data_In(4, FileName);
  if Dir = True then begin
      Exit := false;
      Fill_Buffer('O',28,6,52,18);
      Fill_Buffer('I',2,3,78,19);
      CommandWindow(' ',2,3,52,19);
      PrintDir;
      CommandWindow(' ',54,6,78,18);
      Writeln('Enter File Name:');
      Data_In(4, Filename);
  end;
  if (Exist(FileName) = true) and (Exit=false) then begin
     Erase(Textfile);
     GotoXY(1,6);
     writeln('File deleted');
     Delay(1000);
  end
   else begin
      GotoXY(1,6);
      if Exit=false then writeln(chr(7),'File does not exist');
      Delay(1000);
   end;
end;

procedure RenFile;
var OldName, NewName : TempString;

begin
   ClrScr;
   Writeln('Enter old file name:');
   Data_In(4, OldName);
   if Dir = True then begin
      Exit := false;
      Fill_Buffer('O',28,6,52,18);
      Fill_Buffer('I',2,3,78,19);
      CommandWindow(' ',2,3,52,19);
      PrintDir;
      CommandWindow(' ',54,6,78,18);
      Writeln('Enter old File Name:');
      Data_In(4, OldName);
   end;
   if (Exist(OldName) = true) and (Exit=false) then begin
      Close(Textfile);
      ClrScr;
      writeln('Enter new name:');
      Data_In(4, NewName);
      if (Exist(NewName) = false) and (Exit=false) then begin
         Close(Textfile);
         Assign(Textfile, OldName);
         Rename(Textfile, NewName);
         Close(Textfile);
      end
      else begin
         GotoXY(1,8);
         if Exit=false then write(chr(7),'New file already exists');
         Delay(1000);
      end;
   end
   else begin
      GotoXY(1,8);
      if Exit=false then write(chr(7),'File does not exist');
      Delay(1000);
   end;
end;

procedure Stuff;
begin
   ClrScr;
   Menu('  Disk Parameters',' Logged Drive',' Search Spec',' Change Dir',
        ' Exit',' ');
   if Exit=false then begin
      case Num of
         1 : begin
                ClrScr;
                GotoXY(1,5);
                Writeln('Enter new Drive');
                Write('    [A-F]?');
                Read(Kbd,Choice);
                Drive := UpCase(Choice);
                if not(Drive in ['A'..'F']) then Drive := 'A';
             end;
         2 : begin
                ClrScr;
                GotoXY(1,2);
                Writeln('Enter the Directory');
                Writeln('search string.');
                Writeln('Wildcards are');
                Writeln('allowed. Default');
                Writeln('is ''*.FIL''');
                Write(': ');
                Readln(DirString);
             end;
         3 : begin
                ClrScr;
                GotoXY(1,5);
                Writeln('Enter new Path');
                Writeln('Default = ''\''');
                Write(': ');
                Readln(Path);
                Path := Path + chr(0);
                dosrec.ds := Seg(Path);
                dosrec.dx := Ofs(Path);
                dosrec.ax := $3B00;
                MsDos(dosrec);
                if dosrec.ax <> 0 then Writeln(chr(7),'Bad Path');
             end;
         4 : ;
         else write(chr(7));
      end;
   end;
end;

begin  {DosMenu}
   Inum := 0;
   Dir := false;
   CommandWindow(' ',28,6,52,18);
   repeat
      ClrScr;
      Menu('      DOS Menu',' Directory',' Delete',' Rename',' Dir Stuff',
                            ' Exit to DOS');
      if Exit = false then begin
         CNum := Num;
         case CNum of
            1 : begin
                  Fill_Buffer('O',28,6,52,18);
                  CommandWindow(' ',2,3,52,19);
                  Inum := 3333;
                  PrintDir;
                  Fill_Buffer('O',2,3,52,19);
                end;
            2 : DelFile;
            3 : RenFile;
            4 : Stuff;
            5 : begin
                   ClrScr;
                   GotoXY(1,4);
                   Writeln('Exit Turbo Script,');
                   Writeln;
                   Write('Erase memory (Y/N)? ');
                   Read(Kbd, Choice);
                   if (Choice = 'Y') or (Choice = 'y') then NumEnd := 9999
                        else NumEnd := 0;
                end;
         else write(chr(7));
         end; { case }
      end;
   until CNum <> 4;
   if (CNum <> 1) and ((CNum <> 5) or (NumEnd=0)) then begin
      if Dir = false then Fill_Buffer('O',28,6,52,18) else
         Fill_Buffer('O',2,3,78,19);
   end;
end;

overlay procedure Help;
begin
   Assign(TextFile, 'HELP.HLP');
   Reset(TextFile);
   While (EOF(Textfile) = false) and (Choice <> chr(27)) do begin
      ClrScr;
      GotoXY(1,1);
      Index := 0;
      NormVideo;
      repeat
         Readln(TextFile, TempWord);
         Index := Index + 1;
         writeln(TempWord);
      until (Index = 20) or (EOF(TextFile)=true);
      LowVideo;
      GotoXY(1,22);
      Write('      < Press');
      NormVideo;
      Write(' ENTER ');
      LowVideo;
      Write('to continue >');
      read(Kbd, Choice);
   end;
   Close(TextFile);
   NormVideo;
   ClrScr;
   GotoXY(1,1);
   PrintWords(Row-ScreenRow+1);
end;

overlay procedure Initialize;
const
    Digits: array[1..10] of char = ('1','2','3','4','5','6','7','8','9','0');
    Positions: array[1..10] of integer = (1,8,18,25,33,39,49,59,67,74);

begin
    CrtInit;
    Row := 1;
    Column := 1;
    ScreenRow := 1;
    MaxRow := 1;
    EndColumn := 79;
    Window(1,1,80,25);
    ClrScr;
    GotoXY(1,1);
    Write(Replicate(80,205));
    GotoXY(1,24);
    Write(Replicate(80,196));
    GotoXY(34,1);
    Write('Turbo Script');
    GotoXY(54,1);
    writeln('Row = ',Row : 3,'  Column = ',Column : 2);
    GotoXY(1,25);
    LowVideo;
    write('Help ':6,'Ser/Rep ':10,'Tabs ':7,'Clock ':8,'DOS ':6);
    write('InsLine ':10,'DelLine ':10,'Print ':8,'Load ':7,'Save ':7);
    NormVideo;
    for i := 1 to 10 do begin
       GotoXY(Positions[i], 25);
       write(Digits[i]);
     end;
    Window(1,2,80,23);
    TempWord := Replicate(79,32);
    for i:=1 to 500 do Words[i] := TempWord;
    TempWord := '';
    Insertmode := false;
    Dir := false;
    pm := false;
    dosrec.ax := $1900;
    MsDos(dosrec);
    Drive := chr(65 + lo(dosrec.ax));
    DirString := '*.FIL';
    Path := '\';
    Hour := 25;
    Min := 70;
    Sec := 70;
    CapsMode := false;
    Mem[$40:$17] := 0;
    Exit := false;
    NumEnd := 1;
    for i := 1 to 80 do Tabset[i] := false;
    Tabset[6] := true;
    Tabset[40] := true;
end;

procedure TabMenu;
begin
   Window(1,1,80,25);
   GotoXY(1,1);
   write('Tabs '); LowVideo; Write ('- ['); NormVideo; write('S');
   LowVideo; Write(']et, ['); NormVideo; write('C'); LowVideo; write(']lear, [');
   NormVideo; Write('P'); LowVideo; Write(']urge: '); NormVideo;
   read(Kbd, Choice);
      if Choice in ['s','S'] then Tabset[Column] := true;
      if Choice in ['c','C'] then Tabset[Column] := false;
      if Choice in ['p','P'] then for i := 1 to 79 do Tabset[i] := false;
   if not(Choice in ['s','c','p','S','C','P']) then write(chr(7));
   GotoXY(1,1);
   write(Replicate(33,205));
   Window(1,2,80,25);
   CapsMode := Not CapsMode;
   Hour := 30; Min := 70; Sec := 70;
   CapsCheck;
end;

procedure PrevWord;
begin
   TempWord := Words[Row];
   Index := Column;
   repeat
      Index := Index - 1;
      ch := TempWord[Index];
   until ch <> ' ';
   repeat
      Index := Index - 1;
      ch := TempWord[Index];
   until (ch = ' ') or (Index < 1);
   Column := Index + 1;
   if Column < 1 then Column := 1;
end;

procedure NextWord;
begin
   TempWord := Words[Row];
   Index := Column;
   repeat
      Index := Index + 1;
      ch := TempWord[Index];
   until (ch = ' ') or (Index > EndColumn);
   repeat
      Index := Index + 1;
      ch := TempWord[Index];
   until ch <> ' ';
   Column := Index;
   if Column > EndColumn then Column := EndColumn;
end;

procedure Ascii;
var Ascnum, Repeats, r : integer;

begin
   Window(1,1,80,25);
   GotoXY(1,1);
   Write('Enter ASCII code number: --- ');
   GotoXY(26,1);
   Readln(Ascnum);
   GotoXY(1,1);
   Write('Enter number of repeats: --  ');
   GotoXY(26,1);
   Readln(Repeats);
   if not(Repeats in [1..EndColumn-1]) then Repeats := 1;
   GotoXY(1,1);
   Write(Replicate(30,205));
   If Ascnum < 255 then begin
      Window(1,2,80,23);
      GotoXY(Column,ScreenRow);
      for r := 1 to Repeats do begin
         Inkey := chr(Ascnum);
         Character;
      end;
   end
    else write(chr(7));
   CapsMode := not CapsMode;
   Hour := 30; Min := 70; Sec := 70;
   CapsCheck;
   Window(1,2,80,23);
end;

procedure MemoryFilled;
begin
   CommandWindow(' ',28,6,52,18);
   GotoXY(1,2);
   Writeln(chr(7),'You have used up all');
   Writeln('Available memory in');
   Writeln('Turbo Script. Please');
   Writeln('save your file now');
   Writeln('and continue.');
   Delay(3000);
   SaveFile;
   TempWord := Replicate(79,32);
   for i:=1 to 500 do Words[i]:=TempWord;
   ClrScr;
   Row := 1;  ScreenRow := 1;
   Column := 1;
end;

procedure EndFile;
begin
   Row := MaxRow + 1;
   Oops := Words[Row];
   ScreenRow := 12;
   Column := 1;
   Temp1 := Row-11;
   GotoXY(1,1);
   TempWord := Replicate(79,32);
   PrintWords(Temp1);
end;

procedure SetTime;
var TimeString : TempString;
    Colon,code,k : integer;

begin
   CommandWindow('     Set Time',28,6,52,18);
   k:=0;
   GotoXY(1,5);
   Writeln('Enter time and a=am');
   Writeln('p=pm   Ex: 9:56:10 p');
   Writeln;
   Write('>');
   Readln(TimeString);
   Writeln;
   Colon := Pos(':',TimeString)-1;
   Val(Copy(TimeString,1,Colon),Hour,code);
   k:=k+code;
   Val(Copy(TimeString,Colon+2,2),Min,code);
   k:=k+code;
   Val(Copy(TimeString,Colon+5,2),Sec,code);
   k:=k+code;
   if Copy(TimeString,Colon+8,1) = 'p' then begin
      Hour := Hour + 12;
      pm := true;
   end;
   if k <> 0 then Write(chr(7),'Invalid time') else begin
      dosrec.ax := $2D00;
      dosrec.cx := Hour shl 8 + Min;
      dosrec.dx := Sec shl 8;
      MsDos(dosrec);
   end;
   Fill_Buffer('O',28,6,52,18);
   Hour := 25;
   Min := 70;
   Sec := 70;
   CapsCheck;
end;

procedure HandleFunc;
begin
   case Keynum of
     7 : begin
            CommandWindow(' ',27,10,54,14);
            Writeln('Enter Glossary string:');
            Write('>');
            Readln(Glossary);
            Fill_Buffer('O',27,10,54,14);
         end;
     8 : Backspace;
     9 : begin
            if Column < EndColumn then begin
               Inkey := chr(32);
               repeat
                  Column := Column + 1;
                  if InsertMode then begin
                     Column := Column - 1;
                     Character;
                  end;
               until (Tabset[Column] = true) or (Column = EndColumn);
               if InsertMode then begin
                  GotoXY(1,ScreenRow);
                  Write(Words[Row]);
               end;
            end;
         end;
    13 : Enter;
    15 : begin
            if Column > 1 then begin
               repeat
                  Column := Column - 1;
               until Tabset[Column] = true;
            end;
         end;
    24 : begin
            Words[Row] := Oops;
            GotoXY(1, ScreenRow);
            write(Words[Row]);
         end;
    23 : begin
            Inkey := chr(251);
            Character;
         end;
    27 : begin
            Column := 1;
            GotoXY(1, WhereY);
            ClrEol;
            Words[Row] := Replicate(79,32);
         end;
    30 : Ascii;
    31 : begin
            Window(1,1,80,25);
            GotoXY(1,1);
            Write('Enter Right Column: --');
            GotoXY(21,1);
            Readln(EndColumn);
            if not(EndColumn in [2..79]) then EndColumn := 79;
            GotoXY(1,1);
            Write(Replicate(30,205));
            CapsMode := not CapsMode;
            Hour := 30; Min := 70; Sec := 70;
            CapsCheck;
            Window(1,2,80,23);
         end;
    34 : begin
            for i:=1 to Length(Glossary) do begin
               Inkey := Glossary[i];
               Character;
            end;
         end;
    46 : begin
            if Words[Row][1]=' ' then begin
               Column := 0;
               NextWord;
            end else Column:=1;
            Temp1 := Column;
            i := Row;
            FuncEnd;
            Column := Column - Temp1;
            Words[Row] := Replicate(Round((EndColumn-Column)/2),32) +
               Copy(Words[Row],Temp1,Column);
            FuncEnd;
            Words[Row] := Words[Row] + Replicate(EndColumn-Column,32);
            GotoXY(1, WhereY);
            Write(Words[Row]);
         end;
    48 : begin
            Inkey := chr(254);
            Character;
         end;
    50 : LoadFile('Merge',Row);
    59 : Help;
    60 : Menu_S_R;
    61 : TabMenu;
    62 : SetTime;
    63 : DosMenu;
    64 : Insertline;
    65 : Deleteline;
    66 : PrintFile;
    67 : Loadfile('Load',1);
    68 : Savefile;
    71 : Column := 1;
    72 : CursorUp;
    73 : begin
            Row := Row - 21;
            if Row < 1 then Row := 1;
            if Row-ScreenRow < 1 then ScreenRow := Row;
            PrintWords(Row-ScreenRow+1);
            Oops := Words[Row];
         end;
    75 : CursorLeft;
    77 : CursorRight;
    79 : begin
            i := Row;
            FuncEnd;
         end;
    80 : CursorDown;
    81 : begin
            if Row + 21 < 500 then begin
               Row := Row + 21;
               Oops := Words[Row];
               PrintWords(Row-ScreenRow+1);
            end;
         end;
    82 : if Insertmode then Insertmode := false
              else Insertmode := true;
    83 : Del;
   115 : PrevWord;
   116 : NextWord;
   117 : begin
            ClrEol;
            Words[Row] := Copy(Words[Row], 1, Column-1) + Replicate(EndColumn-Column+1, 32);
         end;
   118 : EndFile;
   119 : begin
            ClearScreen;
            Fill_Buffer('O',28,6,52,18);
            if Exit = false then begin
               ClrScr;
               ScreenRow := 1;
            end;
         end;
   132 : begin
           GotoXY(1,1);
           if Row > ScreenRow then PrintWords(1);
           Row := 1;
           Column := 1;
           ScreenRow := 1;
         end;
   else
     Sound(200);
     Delay(300);
     NoSound;
   end;
end;

begin
  Initialize;
  PrintRow;
  Port[980]:=11;  Port[981]:=7;
  repeat
    Secnum := false;
    if Getkey(Secnum, Inkey) then begin
       if Secnum then HandleFunc else Character;
       PrintRow;
       Exit := false;
       if Insertmode then begin
         Port[980]:=10;  Port[981]:=8;
         if Words[Row][EndColumn-1]<>' ' then begin
            Temp1 := Column; Temp2 := Row; Inum := ScreenRow;
            Column := 80;
            PrevWord;
            Enter;
            Column := Temp1; Row := Temp2; ScreenRow := Inum;
         end;
         GotoXY(Column, ScreenRow);
         TempWord := Copy(Words[Row],Column,EndColumn-Column);
         Write(TempWord);
       end;
       GotoXY(Column , ScreenRow);
    end;
    if Row > 500 then MemoryFilled;
    CapsCheck;
    Port[980]:=10;
    if InsertMode then Port[981]:=4 else Port[981]:=7;
    GotoXY(Column, ScreenRow);
  until NumEnd = 9999;
  Window(1,1,80,25);
  ClrScr;
end.
