;RAMFREE
;determine amount of available RAM without using CHKDSK
;Kim Kokkonen, TurboPower Software, 6/85, 408-438-8608
;written for MicroSoft Assembler version 4.0
;only works for up to 640K bytes
;
Cseg    segment public para
        assume  cs:Cseg, ds:Cseg, es:Cseg
        org     100H

ramfree proc    near

;shrink memory available to this program
coment: mov     bx,offset theend
        mov     cl,4
        shr     bx,cl           ;convert bytes to paragraphs
        inc     bx              ;round up to be safe
        mov     ah,4AH
        int     21H             ;DOS SETBLOCK function

;try to allocate the maximum memory
        mov     ah,4AH
        mov     bx,0FFFFH
        int     21H             ;use SETBLOCK again
                                ;BX contains number of paragraphs available

;convert paragraphs to a doubleword number of bytes in dx:ax
        mov     ax,bx
        xor     dx,dx
        mov     dl,ah           ;dl will contain top four bytes of ah
        mov     cl,4
        shr     dx,cl
        shl     ax,cl

;convert doubleword to a six char ASCII number
        mov     bx,offset nbyts
        add     bx,6            ;move past end of string

        mov     si,10           ;prepare to divide by 10
nexdgt: div     si              ;divide dx:ax by si
        or      dx,30H          ;convert remainder to ASCII digit
        dec     bx              ;backup in buffer
        mov     [bx],dl         ;store character
        xor     dx,dx           ;clear remainder
        or      ax,ax           ;all done?
        jnz     nexdgt          ;do next digit

;now output the string
        mov     dx,offset bmess$
        mov     ah,09H
        int     21H             ;print string

;exit
        mov     ax,4C00H
        int     21H

ramfree endp

;data area
bmess$  db      13,10,'RAM bytes available: '
nbyts   db      32,32,32,32,32,32,13,10,36 ;will hold ASCII number of bytes
theend  label   byte

Cseg    ends
        end     ComEnt
