	name	tee
	page	55,132
	title	'TEE - tee junction for DOS pipes'
;
; TEE --- A "tee" junction for DOS 2.x pipes
;         after the fashion of the Unix function TEE  
; 
; By A. K. Head, 6 Duffryn Place, Melbourne, Australia 3142
;    Somewhat overhauled & with error handling added by Ray Duncan
;
; TEE reads from the standard input (redirectable) and
; outputs to both the standard output (redirectable)
; and a file, e.g.:   DIR | TEE C:\MYDIR\FILE.EXT | SORT
;
; The file can be CON, LPT1, etc.  If it is CON, then
; keyboard Control-S pauses the display as usual.

command	equ	80h		; buffer for command tail
buflen	equ	16384		; buffer length, alter to taste

cr	equ	0dh		; ASCII carriage return
lf	equ	0ah		; ASCII line feed
ff	equ	0ch		; ASCII form feed
eof	equ	01ah		; End-of-file marker
tab	equ	09h		; ASCII tab code
blank	equ	20h		; ASCII blank

				; DOS 2.x pre-defined handles
stdin	equ	0000		; standard input file
stdout	equ	0001		; standard output file
stderr	equ	0002		; standard error file
stdaux	equ	0003		; standard auxilliary file
stdprn	equ	0004		; standard printer file


cseg	segment para public 'CODE'

	assume	cs:cseg,ds:cseg

	org	100H		; start .COM at 100H

tee	proc	far

	mov	cl,ds:command 	; get length of command tail.
	xor	ch,ch 
				; address of command string.
	mov	si,offset command+1 
	mov	di,offset command+1

tee1:				; squeeze out leading spaces.
	mov	al,byte ptr [si]
	cmp	al,blank
	jbe	tee2
	mov	byte ptr [di],al
	inc	di

tee2:	inc	si		; look through command tail
	loop	tee1		; until it's exhausted.
	mov	byte ptr [di],0 ; make ASCIIZ string.
	mov	ah,3ch		; create output file.
	mov	cx,0		; attribute=0.
	mov	dx,offset command+1
	int	21h
	jc	tee6		; can't create file
	mov	handle,ax	; save token for file.

tee3:	mov	ah,3fh		; read standard input.
	mov	bx,stdin
	mov	cx,buflen
	lea	dx,buffer
	int	21h
	jc	tee4		; jump, error.
	mov	nchar,ax	; save length of read.
	cmp	ax,0		; nothing read in?
	je	tee4		; end of file, exit.
	mov	ah,40h		; write to file...
	mov	bx,handle
	mov	cx,nchar
	int	21h
	jc	tee7		; jump, write failed.
	cmp	ax,nchar
	jne	tee7		; jump, write failed.
	mov	ah,40h		; now write to standard output...
	mov	bx,stdout
	int	21h
	jc	tee7		; jump, write failed.
	cmp	ax,nchar
	jne	tee7		; jump, write failed.
	jmp 	tee3		; read again until end of file.

tee4:	mov	ah,3eh		; close output file.
	mov	bx,handle
	int	21h

tee5:	mov	ax,4c00h	; exit with return code=0.
	int	21h

tee6:	mov	dx,offset err1	; print "Can't create file".
	mov	cx,err1len
     	mov	ah,40h		; display error message and exit.
	mov	bx,stderr
	int	21h
	mov	ax,4c01h	; exit with return code=1.
	int	21h

tee7:	mov	dx,offset err2	; print "Disk is full".
	mov	cx,err2len
     	mov	ah,40h		; display error message and exit.
	mov	bx,stderr
	int	21h
	mov	ah,3eh		; close output file.
	mov	bx,handle
	int	21h
	mov	ax,4c02h	; exit with return code=2.
	int	21h

tee	endp


nchar	dw 	0		; number of chars actually input.
handle	dw	0		; token for output file.

err1   	db	cr,lf
	db	'tee: Cannot create file' 
	db	cr,lf
err1len equ	(this byte)-(offset err1) 

err2 	db	cr,lf
	db	'tee: Disk is full.'
	db	cr,lf
err2len equ	(this byte)-(offset err2) 

buffer	equ	this byte	; data is read here from
				; standard input

cseg	ends

	end	tee
