	Name translat
	Title
	page	,132
comment /

	This program is a filter that reads a file and changes each
	sentence into the individual words, one word per line.
	Only alphabetic characters are retained - no case changes are
	performed.

/
;===================================================================
code	segment	public
;===================================================================
;
;	command line is at 80h of psp - first byte is length
;
	org	80h
parmsize	db	?
parm		db	7fh dup (?)
;
; .com starts at 100h - but must jump around any data area
;
	org	100h			; com file starts here
	assume	cs:code,ds:code,es:code
translat proc far
	jmp	clear
;===================================================================
;
; data area for .com programs
;
bufsiz		equ	80	; hadn't better be words this long!
inchar  	db	?
buffer		db	bufsiz dup (?)
count		dw	0
crlf		db	13,10	; end of line string
;
;===================================================================
clear:
;
; start of actual code is here (clear)
;
;
; Read a character.  If it is a-z or A-Z copy it to the output buffer
; and increment count.  If not, send the output buffer and enter
; bypass loop until alpha character is read again.
;
;
	lea	di,buffer	; set up output pointer
again:
;
; read a character
;
	xor	bx,bx		; zero is handle of standard input
	mov	cx,1h		; get 1 character
	lea	dx,inchar	; offset of inchar
	mov	ah,3fh		; read a file/device function
	int	21h		; invoke the function
;
; if carry set of ax=0 exit
;
	jc	oops		; i/o error
	and	ax,ax		; set flags
	jz	oops		; eof
;
; Now check for alpha character.
;
	mov	al,inchar
	call 	isalpha		; proc sets carry flag if not alpha
	jc	output
ok:
	inc	count
	stosb
	jmp	again
output:
	mov	bx,1h		; standard output handle
	lea	dx,buffer	;
	mov	cx,count	; get # of char to output
	mov	ah,40h		;
	int	21h		; call dos output function
	call outcrlf
skip:
;
; read a character until alphabetic.
;
	xor	bx,bx		; zero is handle of standard input
	mov	cx,1h		; get 1 character
	lea	dx,inchar	; offset of inchar
	mov	ah,3fh		; read a file/device function
	int	21h		; invoke the function
;
; if carry set of ax=0 exit
;
	jc	oops		; i/o error
	and	ax,ax		; set flags
	jz	oops		; eof
;
; now check it - if alpha, reset else skip again
;
	mov	al,inchar
	call	isalpha
	jc	skip
;
; character is alpha - reset buffer and jump to top again.
;
	mov	count,1h	; reset count
	lea	di,buffer 	; reset buffer
	stosb
	jmp	again		; repeat cycle
oops:
	cmp	count,0h	; if something in buffer, output it.
	jz	exit
;
	mov	bx,1h		; standard output handle
	lea	dx,buffer	;
	mov	cx,count	; get # of char to output
	mov	ah,40h		;
	int	21h		; call dos output function
	call	outcrlf
exit:
	int	20h		; return to dos
translat	endp
;
;
isalpha	proc	near
	stc			; assume bad
	cmp	al,'A'		; if <A or >z then bad
	jb	notalpha	;
	cmp	al,'z'
	ja	notalpha
	cmp	al,'Z'		; if <=Z or >=a then ok
	jbe	yesalpha
	cmp	al,'a'
	jb 	notalpha
yesalpha:
	clc
notalpha:
	ret
isalpha	endp
;
outcrlf	proc	near
	mov	bx,1h		; standard output handle
	lea	dx,crlf  	;
	mov	cx,2h   	; get # of char to output
	mov	ah,40h		;
	int	21h		; call dos output function
	ret
outcrlf	endp
;
code	ends
	end	translat
