/****************************************************************
 *   Metal Message System stuff (summary/adduser, etc..)
 *
 *	File:  MESTUFF.C
 *
 *	Z-Msg and Metal Message System are Trademarked and
 *	      Copyright (c) 1984, 1985, 1986  Tim Gary
 *		      All Rights Reserved.
 *
 ****************************************************************
 *
 *  1.50xx 04/10/86 Added ability to abort Modify command.
 *  1.50xx 03/13/86 Fix summary to go along with new msgheader()
 *  1.50xx 03/01/86 msgheader call fixed for new method..
 *  1.40xx 02/05/86 Hashed users file support adduser..
 *  1.40xx 01/26/86 Fix for new format of things..
 *  1.31   11/07/85 Add user routine bug fixed.
 *  1.31a  10/13/85 Release version.  Modfify command added.
 *  1.30xx 06/19/85 Expert toggle, and user name display moved here..
 *  1.30xx 05/01/85 Put Adduser routine here to distribute space.
 *  1.30xx 03/03/85 General checkup.
 *  1.10e  11/01/84 Added ability to do summary of dead msgs.
 *  1.10e  10/30/84 Width stuff changed again.
 *  1.10a   9/01/84 Taken from MS.C for Overlay Metal.
 *
 ****************************************************************/

#include "xpm.h"	/* CPMIO header file for i/o operations.*/
#include "megen.h"	/* general defines		*/
#include "meglob.h"	/* global variable definitions	*/
#include "meovfn.h"	/* overlay function numbers	*/
#include "mefiles.h"	/* file names			*/

#include "ctype.h"


/***************************************************
 * do a 'quick' or slow summary of the messages... *
 ***************************************************/

ovmain(func,parm)
int func;		/* not used in this overlay, but definition required */
int parm;
{
switch (func) {
	case ADDUSER:
		return adduser((char *)parm);
	case SUMM:
		return do_summ(parm);
	case WHO:
		return whoisthis();
	case EXPMODE:
		return expert();
	case EDITMSG:
		return edit_msg((unsigned)parm);
	}
}


edit_msg(msg_num)
 unsigned msg_num;
{
int ind,lines;
char tx,temp[20];
msg_record *mptr;

if (!msgcount)
	{
	send("\nThere are currently no messages active.\n");
	return ERROR;
	}

if (!msg_num)		/* if message number not given.. */
	{
	sprintf(buffer,"Edit which message header (first=%u, last=%u)? ",
		fmsg,lmsg);
	ask(buffer,buffer,10,UP);
	if (!isdigit(*buffer)) return ERROR;
	msg_num=atoi(buffer);
	}

if (msg_num<=0 || msg_num>lmsg)
	{
	send("\nMessage out of range.\n");
	return ERROR;
	}

if ( (ind=getindex(msg_num))==ERROR)
	{
	send("\nMessage not found.\n");
	return ERROR;
	}

messages=open(MESSAGES,0);
mptr=bufloc(messages);
setarec(messages,msg[ind].seek);

tx=user.flags;  user.flags&=EXPERT;	/* save old flags, and set expert */
lines=msgheader(messages,0,3);
user.flags=tx;

if (lines==NULL || lines==ERROR)
	{
	close(messages);
	if (lines) send("\nMessage not addressed to you.\n");
	return ERROR;
	}

setrrec(messages,-1);
msgheader(messages,0,2);	/* display it this time */

send("\nHit RETURN if you do not wish to change the current value.\n\n");

sprintf(buffer,"New subject (truncated to %d letters)",TOPICLEN);
askstr(buffer,mptr->topic,TOPICLEN);

if (user.status==SYSOP)
	{
	strcpy(temp,ascdate(mptr->date_entr));
	askstr("Message sent date (mm/dd/yy)",temp,8);
	dateasc(temp,mptr->date_entr);
	askstr("FULL name of Message sender",mptr->sender,NAMELEN);
	}

if ( !strcmp(mptr->sender,user.name) || user.status==SYSOP )
	{
	askstr("New recipient (full name)",mptr->receiver,NAMELEN+1);
	ask("Make message Private or Normal (P/N)? ",buffer,2,UPLOW);
	*buffer=tolower(*buffer);
	if (*buffer!=PRIVMSG && *buffer!=NORMMSG)
		printf("\nMessage left %s\n",mptr->status==PRIVMSG ? "PRIVATE" : "NORMAL(public)");
  	  else mptr->status=*buffer;
	}
   else	if (mptr->status==NORMMSG)
		{
		ask("Make this message addressed to ALL USERS? ",temp,2,UP);
		if (*temp=='Y') strcpy(mptr->receiver,"ALL USERS");
		}

   do	{
	ask("\nSave changes [y/n]? ",temp,2,UP);
	if (*temp=='Y')
		{
		send("\n[Saving changes]");
		setrrec(messages,-1);
		write(messages,0);

		summary=open(SUMMARY,0);
		setarec(summary,((msg[ind].flags&SUMSEEK)<<5));

		mptr=bufloc(summary);
		 do read(summary,1);
   		while (mptr->number!=msg_num);

		setrrec(summary,-1);
		movmem(bufloc(messages),bufloc(summary),128);
		write(summary,0);
		break;
		}
	} while (*temp!='N');

close(summary);
close(messages);

}  /* end of edit header... */


/*********************
 * Get string, etc.. *
 *********************/

askstr(outstr,str,max)
 register char *outstr;
 char *str,max;
{
char ts[MAXLINE+1];

sprintf(ts,"[ %s ] %s? ",*str ? str : "-none-",outstr);

ask(ts,ts,max,UPLOW);
	
if (*ts!='\0') strcpy(str,ts);
}


/**********************
 * toggle expert mode *
 **********************/

expert()
{
user.flags^=EXPERT;
if (user.flags&EXPERT) send("\n[Expert mode]");
  else send("\n[Novice mode]");
}


/*************
 * Show user *
 *************/

whoisthis()
{
printf("Name - %s\n",user.name);
}


adduser(nada)
int nada;
{
register int cfast;	/* fast c variable	*/
char name[NAMELEN+1];	/* temp name	*/
char temp[MAXLINE+1];
usr *up;

if (user.status!=SYSOP) return;	/* sysop only command */

/* if (O.RTC==NOCLOCK) gcntrs(0); */	/* get counters (date) */

do {
  ask("User name? ",name,NAMELEN,UPLOW);
  if (*name=='\0') break;
  capstr(name);

  if ((users=open(USERFILE,1))!=NULL)
     {					/* open users file, and create it
						if it doesn't exist now */
  up=bufloc(users);

  if (find_user(name)<0)
	{
	send("\nUser Exists, use 'E'dit to change info.\n");
	break;		/* exit this loop and ask for name again */
	}

    }	/* good open loop */

close(users);

/* user not found, get new user, location and password */

	if (cfast!=128)
		newuser(name);    /* newuser or bad name */

} while (1);	/* new user loop */

}


/**/
/* this routine checks if mistaken name, or gets new user's info	*/
/**/

newuser(name)
char *name;
{
register int cfast;
char temp[MAXLINE+1];
usr userbuf;

setmem(&userbuf,128,0);		/* zero out buffer */

  do	{
 	ask("\nPassword? ",temp,PASSLEN,UP);
	if (*temp=='\0') return ERROR;
	if (isspc(temp)) {
			 send("\nSpaces aren't allowed in passwords!!\n");
			 continue;	/* ask again... */
			 }
	if (isdigit(*temp))
			{
			send("\nThe first character must NOT be numeric!!\n");
			continue;
			}
	break;
	} while (1);

users=open(USERFILE,1);	/* open for r/w */

/* printf("\nusers=%xh  seek loc=%u  dead_user=%u  dead_rec=%u\n",
	users,getrec(users),dead_user_no,dead_rec_no);			*/

/*   printf("\nUser number is %u.\n",userbuf.number);	*/

  strcpy(userbuf.name,name);
  strcpy(userbuf.pass,temp);
  userbuf.flags=0;		/* initial user parms.. */
  userbuf.lastread=0;
  userbuf.status=NORMAL;
  userbuf.height=24;
  userbuf.width=0;
  userbuf.calls=1;
  getdate();
  movmem(date,userbuf.date,3);
  movmem(time,userbuf.time,2);

  add_user(&userbuf);
  close(users);

  return NULL;		/* got a new usr ok.. */

}	/* newuser */


do_summ(mode)
 int mode;
{
register int flag;
register unsigned start;
char temp[MAXLINE+1],sreq;
msg_record *mptr;

#ifdef MULTI_USER
 mu_update();		/* get anything new that's happened */
#endif

*temp='\0';
if (!msgcount) return;

do	{	/* if '?' entered, or user is novice.. print this... */
	if (*temp=='?' || ( !(user.flags&EXPERT) && strloc==0))
		{
		send("\nEnter message number to start summary at.\n");
		if (*temp=='?') search_help();
		}
	sprintf(buffer,"\nStarting message (%u-%u) ?",fmsg,lmsg);
	ask(buffer,temp,MAXLINE,UP);
	} while (*temp=='?');

if (*temp=='K')
	{
	sprintf(temp,"%s",temp+1);
	mode|=READ_KIL;
	}

sreq=msearch(temp);		/* setup search string if called for.. */
if (!strcmp(temp,"0")) *temp='1';	/* make 0 same as 1 */
if (isdigit(*temp))		/* number entered.. check if valid */
  {
  if ((start=atoi(temp))>lmsg || start<1)
		{
		send("\n[Invalid message number]");
		return;
		}
  }
  else if (sreq==FALSE)
		{
		send("\n[Invalid message number or search function]");
		return;		/* no #, see if search req */
		}
	 else start=1;			/* yep.. start at first msg */

	if ((summary=open(SUMMARY,F_RD | F_UNLOCK))==NULL)
		return;
	setarec(summary,1);		/* skip count */
	mptr=bufloc(summary);
	novhelp();			/* help a local novice */
	while (read(summary,1)==128 && (mptr->number)<start);
	setrrec(summary,-1);
	do flag=msgheader(summary,start,mode);
	 while (!breakkey() && flag!=ERROR);
	close(summary);
	if (flag==ERROR) send("\n[End Msgs]\n");
}


/* End of File */
