/***********************************************************************
 *
 *	Options/configuration file for METAL/Z-MSG
 *
 *
 *	   Copyright (c) 1984, 1985, 1986 by Tim Gary
 *		    All rights reserved.
 *
 *	FILE: MEINITO.H
 *
 **********************************************************************
 *
 * 1.50xx 08/04/86  Fixed for QUESTION, and command mask..
 * 1.50xx 07/04/86  Hacked for DUU: drive user format instead of UU/D:
 * 1.50xx 05/14/86  Fix for new O variable fields..
 * 1.50xx 04/10/86  Initparms init value added..
 * 1.50xx 04/07/86  Usertype stuff changed..
 * 1.50xx 03/08/86  2 extra user types, initial group flags..
 * 1.50xx 03/01/86  In prep for the new tagged read, etc..
 * 1.40xx 02/21/86  Todays help command additions..
 * 1.40xx 02/05/86  Hash file location added..
 * 1.40xx 01/29/86  Carefull.. all users but twits have sys access..
 * 1.40xx 01/19/86  Changed file init stuff..
 * 1.31a  10/13/85  This file was created from HMH.H to allow a more
 *		   efficient method of 'option' variable initialization.
 * 1.31xx 08/11/85  File created.
 *
 *********************************************************************/

#define METAL

#define CONFIG_VERS "v150-4"	/* cfg vers, CHANGE when O format changed! */

/************************************************************************
   Options are contained in this large structure, and are initialized
  here.  BE VERY VERY CAREFULL NOT TO DELETE A COMMA, OR OTHER SUCH
  PUNCTUATION IN THE DECLARATIONS, SINCE THE ORDER OF THINGS HAS EVERY-
  THING TO DO WITH THE WAY IT GETS INITIALIZED!!!!!!!!!!!		*/

struct	options	O = {	/* and off we go !! */

/************************************************************************
 * The following is the initializing of one HUGE structure of options	*
 ************************************************************************/

	"Zilch!!!!",	/* To allow config to do its job (DON'T TOUCH!!) */
	CONFIG_VERS,	/* config file version number */

/**********************************************************/
/******* OPTIONS that are likely to need changing.. *******/
/**********************************************************/

/*************************************************************************
 Each user is of a certian 'type'; here is where types are defined.
	In this order:
		1) Character to use as type identifier (DON'T CHANGE!)
		2) Maximum CP/M user area avaliable to him/her (0=no CP/M)
		31) Max drive..
		3) Timeout before loging out, if idle (in mins, 0=no access)
		4) Priv. flags..killmsgs, zcpr, read priv, post msgs, post priv
		5) Minutes to auto logout (typing or not)
		6) Flags for use in command aliases
		7) Set of system segments to load (z3)
			(FIXED ORDER: ENV NDR RCP FCP IOP (don't include type))
		8) Z3 registers set for this user type.. (high byte set if register to be set from low byte..)
		9) Z3 System file number to put last user name in (0=none)...
		10) Search path in DU form (z3)		*/

/*	/--option #'s from above----\	*/
/*--1-----2--31--3--4-------------------------------------------5---6----*/
{
  SYSOP,  15,15,30,KILLFLAG|READPRIV|POSTMSG|ZCPRFLAG|POSTPRIV, 00,0xffff,
  /* 7) */	{ "","","","","" },
  /* 8) */	{ 0,0,0,0,0,0,0,0,0,0 },
  /* 9) */	1,
  /* 10) */	{ 1,'$', 1,0, 0,0, 0,0, 0,0, 0,0, 0,0, 0,0 },
  SPECIAL,12,15,15,KILLFLAG|POSTMSG|POSTPRIV,			90,0x0fff,
  /* 7) */	{ "","","","","" },
  /* 8) */	{ 0,0,0,0,0,0,0,0,0,0 },
  /* 9) */	1,
  /* 10) */	{ 1,'$', 1,0, 0,0, 0,0, 0,0, 0,0, 0,0, 0,0 },
  NORMAL, 10,15,5,POSTMSG|POSTPRIV, 				60,0x00ff,
  /* 7) */	{ "","","","","" },
  /* 8) */	{ 0,0,0,0,0,0,0,0,0,0 },
  /* 9) */	1,
  /* 10) */	{ 1,'$', 1,0, 0,0, 0,0, 0,0, 0,0, 0,0, 0,0 },
  NOCPM,  00,15,5,POSTMSG, 					60,0x000f,
  /* 7) */	{ "","","","","" },
  /* 8) */	{ 0,0,0,0,0,0,0,0,0,0 },
  /* 9) */	1,
  /* 10) */	{ 1,'$', 1,0, 0,0, 0,0, 0,0, 0,0, 0,0, 0,0 },
  TWIT,  00,15,00,FALSE, 					0,0x0000,
  /* 7) */	{ "","","","","" },
  /* 8) */	{ 0,0,0,0,0,0,0,0,0,0 },
  /* 9) */	1,
  /* 10) */	{ 1,'$', 1,0, 0,0, 0,0, 0,0, 0,0, 0,0, 0,0 },
  'a', 10,15,5,POSTMSG|POSTPRIV, 				60,0x00ff,
  /* 7) */	{ "","","","","" },
  /* 8) */	{ 0,0,0,0,0,0,0,0,0,0 },
  /* 9) */	1,
  /* 10) */	{ 1,'$', 1,0, 0,0, 0,0, 0,0, 0,0, 0,0, 0,0 },
  'b', 10,15,5,POSTMSG|POSTPRIV, 				60,0x00ff,
  /* 7) */	{ "","","","","" },
  /* 8) */	{ 0,0,0,0,0,0,0,0,0,0 },
  /* 9) */	1,
  /* 10) */	{ 1,'$', 1,0, 0,0, 0,0, 0,0, 0,0, 0,0, 0,0 },
  'c', 10,15,5,POSTMSG|POSTPRIV, 				60,0x00ff,
  /* 7) */	{ "","","","","" },
  /* 8) */	{ 0,0,0,0,0,0,0,0,0,0 },
  /* 9) */	1,
  /* 10) */	{ 1,'$', 1,0, 0,0, 0,0, 0,0, 0,0, 0,0, 0,0 },
  'd', 10,15,5,POSTMSG|POSTPRIV, 				60,0x00ff,
  /* 7) */	{ "","","","","" },
  /* 8) */	{ 0,0,0,0,0,0,0,0,0,0 },
  /* 9) */	1,
  /* 10) */	{ 1,'$', 1,0, 0,0, 0,0, 0,0, 0,0, 0,0, 0,0 },
  'e', 10,15,5,POSTMSG|POSTPRIV, 				60,0x00ff,
  /* 7) */	{ "","","","","" },
  /* 8) */	{ 0,0,0,0,0,0,0,0,0,0 },
  /* 9) */	1,
  /* 10) */	{ 1,'$', 1,0, 0,0, 0,0, 0,0, 0,0, 0,0, 0,0 },
/* end of table */
  '\0', 0,00,00,0, 0,0,
  /* 7) */	{ "","","","","" },
  /* 8) */	{ 0,0,0,0,0,0,0,0,0,0 },
  /* 9) */	1,
  /* 10) */	{ 0,0, 0,0, 0,0, 0,0, 0,0, 0,0, 0,0, 0,0 },
/* end of table DON'T CHANGE! !! ! !*/
	},


/************************************************************************
 Most sysops want the initial user to either be of 'normal' status, or
 'nocpm' status, but you can make it whatever you like..
 Take the status from the above table (SYSOP, SPECIAL, NORMAL, NOCPM,
 TWIT (sure!), 'a', 'b', 'c')...					*/

	NORMAL,	/* this is what you change */


/************************************************************************
 Is the bbs to be a private or pay system?
 	if SO set private to YES,This will require a system id code to logon.
	if NOT (it's public) then set to NO.				*/

	NO,	/* <--- that's what you change	*/

/* The following definition is for private systems ONLY	*/
/* (you may ignore it, if the above itset to 'NO')		*/

/* this is the private system password to get on to the system	*/
/* it can be UP TO 8 CHARS LONG (NO MORE)!			*/

	"CODXYZZY",	/* <--- this is it	*/


/**************************************************************************
	 The following table MUST BE KEPT IN THE SAME ORDER!!!!!!!!

	The filenames remain the same as defined in mefiles.h, but
	you may change the location (user area and drive) of each file.

	Locations are of the form:  [user/][drive:]	  */

{	"i14:",		/* "bulletin"	Bulletins file */
	"i14:",		/* "welcome"	Welcome file, as typed bye BYE */
	"i14:",		/* "users"	Users file */
	"i14:",		/* "callers"	callers log */
	"i14:",		/* "counters"	system special counters */
	"i14:",		/* "messages"	Main Message file */
	"i14:",		/* "summary"	Message Summary file */
	"i14:",		/* "lastcalr"	Last caller file */
	"i14:",		/* "newuser"	file to type for new users */
	"i14:",		/* "help"	brief command list help */
	"i14:",		/* "cpminfo" 	help file when exiting to cpm */
	"i14:",		/* "system.inf"	In private sys. account info, etc.*/
	"i14:",		/* "groups"	groups descrption file	*/
	"i14:",		/* "othersys"	other systems file	*/
	"i14:",		/* "notes.ind"	Notes index file	*/
	"i14:",		/* "feature.ind" Features index file	*/
	"i00:",		/* "meovr.mov"	main overlay file.	*/
	"i14:",		/* "commands"	Z3 commands file	*/
	"i14:",		/* "users.idx"  hash file for users	*/
	"i00:",		/* "methelp.lbr" help lib		*/
	0	 /* leave alone */
	},


/* These two files are fully specified by the sysop */

	OSCOM,		/* file to run when G or BYE commands given in bbs */
	BYECOM,		/* file to run when J or C commands given */


/************************************************************************
   after a certain number of unsuccessful login attempts, a person is
   hung-up on.  This variable declares that number.
   NOTE: attempt to logon as sysop counts as TWO tries.			*/

	5,	/* <--- Right here...	*/


/************************************************************************
   You can set an upper limit on the amount of active messages.  Each
   active message will take up 8 bytes of memory.			*/

	250,	/* <--- And here...	*/


/**************************************************************************
   Each line of a message can be up to 128 chars, but for a clear display
   the max length of a line of entered text should be something like 80	  */

	80,	/* <--- Change this if you like */


/************************************************************************
   You can set the maximum number of lines a message can have.  This is
  limited to 250 lines.

   100 lines at 80 chars a line (assuming completely full msg) would
   take 8k (RAM) above the actual program.				*/

	100,	/* <--- Here */


/************************************************************************
   A buffer space is needed in Metal to hold message pointers.  Each
  Space in the buffer takes up 8 bytes of memory.  This number MUST
  be larger than the Max Active message count above.			*/

	400,	/* Plenty of space */


/***************************************************************************
	NOCLOCK	is set if no clock routines are used..
	Anything else assumes clock installed..

/* this is what you change for clock or not */

	NOCLOCK,	/* <--- Change this */

/*************************************************************************
  If your BYE is setup to ask for NULLS, then set the following to YES,
  else, set it to NO.							*/

	NO,	/* <--- Change this as desired	*/


/***************************************************************************
   If you are running ZCPR 1 or 2 in Secure mode, set the following to YES.
   If ZCPR3 is being used, set this to 3, otherwise set it to NO.	  */

	YES,	/* <--- And here */

 /* loc of WHEEL, ignore if above isn't set to YES (ZCPR3 gets it from
    environment descriptor)  */

	0x003e,	/* <--- Here..	*/


/***************************************************************************
  The following variable is used ONLY for NON-MP/M, MULTI_USER systems.

   For multiuser systems which make it dificult to tell which console is
  running the program (like TurboDos...) we need to have a set of 4 locations
  in memory that will be used to contain a simulated console Id.  The
  following is the starting address of the 4 locations in NON-COMMON memory.
  Usually there is room someplace in the base page of memory (0-100h)
  to place this.  This is currently set for a "reserved" area in TurboDos. */

	0x003b,	/* here.. */


/************************************************************************
   Initial group access level for new callers..
									*/
	0x0001,		/* public groups only */


/************************************************************************
   Initial default terminal line length.. this is currently not used*****/

	80,	/* Alter this if you like */ 


/**************************************************************************
   Initial user parameters.  This is a bit mask value.			  */

	0,	/* <------ this


/**************************************************************************
   Initial question for 12 char string...				  */

	"Enter your phone number (xxx-xxx-xxxx, to be kept confidential)-> ",


/************************************************************************
   Location of site.  Up to 80 chars. Displayed in MENTER 		*/

	" -- name of system -- ",	/* <--- You got it!! */


/************************************************************************
   If you wish callers log and comments to go to printer and not a file
   then set this to YES, else set to NO.				*/

	NO,	/* <--- This one too */


/************************************************************************
   If you have a 25th line on your terminal that doesn't scroll, then
   the following to YES, and set the appropriate control chars, and
   port addresses below.  Otherwise declare the variable to NO		*/

	NO,	/* Set this to yes or no	*/

/* Up to 15 chars can be used to get to or from the 25th line		*/

/*** You may ignore the following if the above is NO ***/

/*	vvvvvvvvvvvvv---- change ALL OF these !!!!!		*/
	"\033\070",	/* Sequence to get to the 25th line	*/
	"\n",		/* Sequence to return from 25th line	*/
	0x13,		/* terinal output status port		*/
	0x12,		/* terminal data output port	  	*/
	0x01,		/* terminal status mask.. if bit is one,*/
			/* then ready to output char to port    */

/* NOTE::::: If you are using a non-I/O mapped video board that has a 25th
   line (Kaypro people), you can set the following values to obtain the
   same results as if it were i/o mapped:
	Set Terminal Output Status AND Terminal Status Mask to 0 (zero).
	Then find your bios output routine like this:
		A>ddt
		DDT Version...
		-l0		; list from 0
		0000 JMP B603	; look at where this jump instruction goes to
		-lb603		; and list from that address
		B603 JMP xyz
		B60x...		; we want the one at B60E in this case
				; (first two digits + 0E as last two digits)
		B60E JMP e877	; Ok, now write down the address this jump
				;  instruction goes to (e877h in this ex.)
	Now With the address you've written down, enter it as the
	'Terminal Output Data Port'.

	That's it!

	MAJOR NOTE::  This method is BIOS Dependent, so you'll have to
		      go through the same procedure anytime you use a
		      different flavored BIOS!!!!!!!!!!!!!!!!!!!!!
									*/


/************************************************************************
   CHANGE THESE!!!!!!!!  Sysop built-in password, and name
 */

	"Tim Gary",	/* <--- Sysop's full name (change this)		*/
	"NOPASS",	/* <--- Change to a password (UPPER CASE ONLY)	*/


/************************************************************************
 	DO NOT CHANGE THE FOLLOWING...
				
 */
#ifdef METAL
	"Metal Message System [A Heavy BBS]",
#else
	"Z-Msg Message Handling System",
#endif

	"Version 1.5xx [ 8/13/86 test ]",

#ifdef METAL
	";METAL ALIAS",
#else
	";Z-MSG ALIAS",
#endif
	0x48,			/* message buffer offset */

/* leave this alone!!!!!!!! */
"KABOOM!!!"	/* signal end of structure -------DO NOT TOUCH */

};	/* WHEW !!!!!!!!!!!!!!!!!   THAT'S IT!!!!!!!!!!!!!!!!!!!!!!!!!! */


/* EOF (MEINITO.H) */

