/****************************************************************
 *   Metal Message System stuff (summary/adduser, etc..)
 *
 *	File:  MESTUFF.C
 *
 *	Z-Msg and Metal Message System are Trademarked and
 *	      Copyright (c) 1984, 1985  Tim Gary
 *		      All Rights Reserved.
 *
 ****************************************************************
 *
 *  1.31a  10/13/85 Release version.  Modfify command added.
 *  1.30xx 06/19/85 Expert toggle, and user name display moved here..
 *  1.30xx 05/01/85 Put Adduser routine here to distribute space.
 *  1.30xx 03/03/85 General checkup.
 *  1.10e  11/01/84 Added ability to do summary of dead msgs.
 *  1.10e  10/30/84 Width stuff changed again.
 *  1.10a   9/01/84 Taken from MS.C for Overlay Metal.
 *
 ****************************************************************/

#include "xpm.h"	/* CPMIO header file for i/o operations.*/
#include "megen.h"	/* general defines		*/
#include "meglob.h"	/* global variable definitions	*/
#include "meovfn.h"	/* overlay function numbers	*/
#include "mefiles.h"	/* file names			*/

#include "ctype.h"


/***************************************************
 * do a 'quick' or slow summary of the messages... *
 ***************************************************/

ovmain(func,parm)
int func;		/* not used in this overlay, but definition required */
int parm;
{
switch (func) {
	case ADDUSER:
		if (user.status!=SYSOP) return;
		return adduser((char *)parm);
	case SUMM:
		return do_summ(parm);
	case WHO:
		return whoisthis();
	case EXPERT:
		return expert();
	case EDITMSG:
		return edit_msg((unsigned)parm);
	case PAUSE:
		return pause();
	}
}


edit_msg(msg_num)
 unsigned msg_num;
{
int ind,lines;
char tx;
msg_record *mptr;

if (!msgcount)
	{
	send("\nThere are currently no messages active.\n");
	return ERROR;
	}

if (user.status==NOCPM) return ERROR;

if (!msg_num)		/* if message number not given.. */
	{
	sprintf(buffer,"Edit which message header\n(first=%u, last=%u)? ",
		fmsg,lmsg);
	ask(buffer,buffer,MAXLINE,UP);
	if (!isdigit(*buffer)) return ERROR;
	msg_num=atoi(buffer);
	}

if (msg_num<0 || msg_num>lmsg)
	{
	send("\nMessage out of range.\n");
	return ERROR;
	}

if ( (ind=getindex(msg_num))==ERROR)
	{
	send("\nMessage not found.\n");
	return ERROR;
	}

messages=open(MESSAGES,0);
mptr=bufloc(messages);
setarec(messages,msg[ind].seek);

tx=user.parm.expert;  user.parm.expert=PON;
lines=msgheader(messages,0,3);
user.parm.expert=tx;

if (lines==NULL || lines==ERROR)
	{
	close(messages);
	if (lines) send("\nMessage not addressed to you.\n");
	return ERROR;
	}

setrrec(messages,-1);
msgheader(messages,0,2);	/* display it this time */

send("\nHit RETURN\nif you do not wish to change the current value.\n\n");

sprintf(buffer,"New subject\n(truncated to %d letters)",TOPICLEN);
askstr(buffer,mptr->topic,TOPICLEN);

if (user.status==SYSOP)
	{
	askstr("Message sent date (mm/dd/yy)",mptr->date,DATELEN-1);
	sepstr=' ';
	askstr("FIRST name of Message sender",mptr->fsend,FNAMELEN);
	sepstr='\0';
	askstr("LAST name of Message sender",mptr->lsend,LNAMELEN);
	}

if ( (!strcmp(mptr->fsend,user.first) && !strcmp(mptr->lsend,user.last)) ||
	user.status==SYSOP )
	{
	askstr("New recipient (full name)",mptr->receiver,FNAMELEN+LNAMELEN+2);
	ask("Make message Private or Normal (P/N)? ",buffer,2,UPLOW);
	*buffer=tolower(*buffer);
	if (*buffer!=PRIVMSG && *buffer!=NORMMSG)
		printf("\nMessage left %s\n",mptr->status==PRIVMSG ? "PRIVATE" : "NORMAL(public)");
  	  else mptr->status=*buffer;
	}
   else	if (mptr->status==NORMMSG)
		{
		char temp[10];
		ask("Make this message addressed to ALL USERS? ",temp,2,UP);
		if (*temp=='Y') strcpy(mptr->receiver,"ALL USERS");
		}

send("\n[Saving changes]");

setrrec(messages,-1);
write(messages,0);

summary=open(SUMMARY,0);
setarec(summary,1);	/* skip first record */
mptr=bufloc(summary);
 do read(summary,1);
   while (mptr->number!=msg_num);
setrrec(summary,-1);
movmem(bufloc(messages),bufloc(summary),128);
write(summary,0);
close(summary);
close(messages);

}  /* end of edit header... */


/*********************
 * Get string, etc.. *
 *********************/

askstr(outstr,str,max)
 register char *outstr;
 char *str,max;
{
char ts[MAXLINE+1];

sprintf(ts,"[ %s ] %s? ",*str ? str : "-none-",outstr);

ask(ts,ts,max,UPLOW);
	
if (*ts!='\0') strcpy(str,ts);
}


/**********************
 * toggle expert mode *
 **********************/

expert()
{
user.parm.expert==PON ?		/* so what if it could be an IF.. */
  (send("\n[Novice mode]"),user.parm.expert=POFF) :
  (send("\n[Expert mode]"),user.parm.expert=PON);
}


/*************
 * Show user *
 *************/

whoisthis()
{
printf("Name - %s %s\n       %s",user.first,user.last,user.city);
}


static unsigned dead_rec_no;
static unsigned dead_user_no;

adduser(nada)
int nada;
{
register int cfast;				/* fast c variable	*/
char first[FNAMELEN+1],last[LNAMELEN+1];	/* temp name	*/
char temp[MAXLINE+1];
unsigned tu;
usr *up;

gcntrs(0);	/* get counters (date) */

do {
  sepstr=' ';
  ask("User name? ",first,FNAMELEN,UPLOW);
  sepstr='\0';
  if (*first=='\0') break;
  capstr(first);

  ask("Last name? ",last,LNAMELEN,UPLOW);
  if (*last=='\0') break;
  capstr(last);

  if ((users=open(USERFILE,1))!=NULL)
     {					/* open users file, and create it
						if it doesn't exist now */
  up=bufloc(users);
  dead_user_no=dead_rec_no=up->number=0;	/* clear these */

  do	{
	tu=up->number;
	cfast=read(users,1);		/* read and increment record counter */
	if (cfast!=128) break;		/* exit loop if eof */

	/* get desired info from users file... */

	if (dead_rec_no==0) dead_user_no=tu;

	if (up->number==0 && dead_rec_no==0)
		{
		dead_user_no++;	/* make the user one after last ok one */
		dead_rec_no=getrec(users)-1;
		}

	/* see if a match of either name or user number */

	  if (  up->number && ((ustrcmp(first,up->first)==0)
		  && (ustrcmp(last,up->last)==0)) )
		{
		send("\nUser Exists, use 'E'dit to change info.\n");
		break;		/* exit this loop and ask for name again */
		}

	} while (cfast==128);	/* read do loop ends */

    }	/* good open loop */

close(users);

/* user not found, get new user, location and password */

	if (cfast!=128)
		newuser(first,last);    /* newuser or bad name */

} while (1);	/* new user loop */

}


/**/
/* this routine checks if mistaken name, or gets new user's info	*/
/**/

newuser(first,last)
char *first,*last;
{
register int cfast;
char temp[MAXLINE+1];
usr userbuf;

setmem(&userbuf,128,0);		/* zero out buffer */

  ask("\nCity, State/Prov? ",userbuf.city,CITYLEN,UPLOW);
  if (userbuf.city[0]=='\0') return ERROR;   /* not entered, get name again */
  capstr(userbuf.city);

  printf("\nUser is %s %s \nfrom %s", first,last,userbuf.city);
  ask(", Right? ",temp,1,UP);
  if (*temp=='N') return ERROR;

  do	{
 	ask("\nPassword? ",temp,PASSLEN,UP);
	if (*temp=='\0') return ERROR;
	if (isspc(temp)) {
			 send("\nSpaces aren't allowed in passwords!!\n");
			 continue;	/* ask again... */
			 }
	if (isdigit(*temp))
			{
			send("\nThe first character must NOT be numeric!!\n");
			continue;
			}
	break;
	} while (1);

users=open(USERFILE,1);	/* open for r/w */

if (dead_rec_no!=0) userbuf.number=dead_user_no;
	else {
	     toeof(users);
	     if (!getrec(users)) userbuf.number=1;
	 	else {
		     usr *up;
		     setrrec(users,-1);
		     read(users,1);
		     up=bufloc(users);
		     userbuf.number=up->number+1;
		     }
	      }

/* printf("\nusers=%xh  seek loc=%u  dead_user=%u  dead_rec=%u\n",
	users,getrec(users),dead_user_no,dead_rec_no);			*/

  printf("\nUser number is %u.\n",userbuf.number);

  strcpy(userbuf.first,first);	strcpy(userbuf.last,last);
  strcpy(userbuf.pass,temp);
  strcpy(&userbuf.parm.ulcase,"0001110");     /* initial user parms.. */
  userbuf.lastread=0;
  userbuf.status=NORMAL;	userbuf.type=get_type(userbuf.status);
  userbuf.parm.height=24;
  userbuf.parm.width=0;
  userbuf.parm.calls=1;
  getdate();
  strcpy(userbuf.date,date);
  strcpy(userbuf.time,time);

if (dead_rec_no!=0)
	setarec(users,dead_rec_no);

  movmem(&userbuf,bufloc(users),128);
  write(users,1);
  close(users);

  return NULL;		/* got a new usr ok.. */

}	/* newuser */


do_summ(mode)
 int mode;
{
register int flag;
register unsigned start;
char temp[MAXLINE+1],sreq;

#ifdef MULTI_USER
 mu_update();		/* get anything new that's happened */
#endif

*temp='\0';
if (!msgcount) return;

do	{	/* if '?' entered, or user is novice.. print this... */
	if (*temp=='?' || (user.parm.expert==POFF && strloc==0))
		{
		send("\nEnter message number to start summary at.\n");
		if (*temp=='?') search_help();
		}
	sprintf(buffer,"\nStarting message (%u-%u) ?",fmsg,lmsg);
	ask(buffer,temp,MAXLINE,UP);
	} while (*temp=='?');

if (*temp=='K')
	{
	sprintf(temp,"%s",temp+1);
	mode|=0x80;
	}

sreq=msearch(temp);		/* setup search string if called for.. */
if (!strcmp(temp,"0")) *temp='1';	/* make 0 same as 1 */
if (isdigit(*temp))		/* number entered.. check if valid */
  {
  if ((start=atoi(temp))>lmsg || start<1)
		{
		send("\n[Invalid message number]");
		return;
		}
  }
  else if (sreq==FALSE) return;		/* no #, see if search req */
	 else start=1;			/* yep.. start at first msg */

	if ((summary=open(SUMMARY,F_RD | F_UNLOCK))==NULL)
		return;
	setarec(summary,1);		/* skip count */
	novhelp();			/* help a local novice */
	do flag=msgheader(summary,start,mode);
	 while (!breakkey() && flag!=ERROR);
	close(summary);
	if (flag==ERROR) send("\n[End Msgs]\n");
}

/**********************
 * toggle pause  mode *
 **********************/

pause()
 {

	if (height!=0)
		{
		height=0;
		send("\n[Pause off]");
		}
	else	{
		(height=user.parm.height);
		send("\n[Pause on]");
		}
 }


/* End of File */
