/***********************************************************************
 *
 *	Options/configuration file for METAL/Z-MSG
 *
 *
 *	   Copyright (c) 1984, 1985 by Tim Gary
 *		    All rights reserved.
 *
 *	FILE: MEINITO.H
 *
 **********************************************************************
 *
 * 1.31a  10/13/85  This file was created from HMH.H to allow a more
 *		   efficient method of 'option' variable initialization.
 * 1.31xx 08/11/85  File created.
 *
 *********************************************************************/

#define METAL

#define CONFIG_VERS "v131-3"	/* cfg vers, CHANGE when O format changed! */

/************************************************************************
   Options are contained in this large structure, and are initialized
  here.  BE VERY VERY CAREFULL NOT TO DELETE A COMMA, OR OTHER SUCH
  PUNCTUATION IN THE DECLARATIONS, SINCE THE ORDER OF THINGS HAS EVERY-
  THING TO DO WITH THE WAY IT GETS INITIALIZED!!!!!!!!!!!		*/

struct	options	O = {	/* and off we go !! */

/************************************************************************
 * The following is the initializing of one HUGE structure of options	*
 ************************************************************************/

	"Zilch!!!!",	/* To allow config to do its job (DON'T TOUCH!!) */
	CONFIG_VERS,	/* config file version number */

/**********************************************************/
/******* OPTIONS that are likely to need changing.. *******/
/**********************************************************/

/*************************************************************************
 Each user is of a certain 'type'; here is where types are defined.
	In this order:
		1) Character to use as type identifier (DON'T CHANGE!)
		2) Maximum CP/M user area avaliable to him/her (0=no CP/M)
		31) Max drive..
		3) Timeout before loging out, if idle (in mins, 0=no access)
		4) YES/NO flag, can he/she kill messages
		5) YES/NO flag, does he/she get ZCPR privs (era, save, etc)
		6) YES/NO flag, can the user read private msgs (not to them)?
		7) YES/NO flag, can the user post messages??
		8) Minutes to auto logout (typing or not)
		9) Flags for use in command aliases
		10) Set of system segments to load (z3)
			(FIXED ORDER: ENV NDR RCP FCP IOP (don't include type))
		11) Z3 registers set for this user type.. (high byte set if register to be set from low byte..)
		12) Z3 System file number to put last user name in (0=none)...
		13) Search path in DU form (z3)		*/

/*	/--option #'s from above----\	*/
/*--1-----2--31--3--4---5---6---7---8---9--*/
{ SYSOP,  15,15,30,YES,YES,YES,YES, 0,0xffff,  /* power hungry SYSOP */
  /* 10) */	{ "","","","","" },
  /* 11) */	{ 0,0,0,0,0,0,0,0,0,0 },
  /* 12) */	1,
  /* 13) */	{ 1,'$', 1,0, 0,0, 0,0, 0,0, 0,0, 0,0, 0,0 },
  SPECIAL,12,15,15,YES, NO, NO,YES,90,0x0fff,  /* SPECIAL user */
  /* 10) */	{ "","","","","" },
  /* 11) */	{ 0,0,0,0,0,0,0,0,0,0 },
  /* 12) */	1,
  /* 13) */	{ 1,'$', 1,0, 0,0, 0,0, 0,0, 0,0, 0,0, 0,0 },
  NORMAL,  3,15, 5, NO, NO, NO,YES,60,0x00ff,  /* etc... */
  /* 10) */	{ "","","","","" },
  /* 11) */	{ 0,0,0,0,0,0,0,0,0,0 },
  /* 12) */	1,
  /* 13) */	{ 1,'$', 1,0, 0,0, 0,0, 0,0, 0,0, 0,0, 0,0 },
  NOCPM,   0,15, 5, NO, NO, NO,NO,60,0x000f,
  /* 10) */	{ "","","","","" },
  /* 11) */	{ 0,0,0,0,0,0,0,0,0,0 },
  /* 12) */	1,
  /* 13) */	{ 1,'$', 1,0, 0,0, 0,0, 0,0, 0,0, 0,0, 0,0 },
  TWIT,	   0,15, 0, NO, NO, NO, NO, 1,0x0000,
  /* 10) */	{ "","","","","" },
  /* 11) */	{ 0,0,0,0,0,0,0,0,0,0 },
  /* 12) */	1,
  /* 13) */	{ 0,0, 0,0, 0,0, 0,0, 0,0, 0,0, 0,0, 0,0 },
  'a',	   0,15, 0,  0,  0,  0,  0, 0,0x0000,  /* room for 3 others */
  /* 10) */	{ "","","","","" },
  /* 11) */	{ 0,0,0,0,0,0,0,0,0,0 },
  /* 12) */	1,
  /* 13) */	{ 1,'$', 1,0, 0,0, 0,0, 0,0, 0,0, 0,0, 0,0 },
  'b',	   0,15, 0,  0,  0,  0,  0, 0,0x0000,
  /* 10) */	{ "","","","","" },
  /* 11) */	{ 0,0,0,0,0,0,0,0,0,0 },
  /* 12) */	1,
  /* 13) */	{ 1,'$', 1,0, 0,0, 0,0, 0,0, 0,0, 0,0, 0,0 },
  'c',	   0,15, 0,  0,  0,  0,  0, 0,0x0000,
  /* 10) */	{ "","","","","" },
  /* 11) */	{ 0,0,0,0,0,0,0,0,0,0 },
  /* 12) */	1,
  /* 13) */	{ 1,'$', 1,0, 0,0, 0,0, 0,0, 0,0, 0,0, 0,0 },
/* end of table */
  0,0,0,0,0,0,0,0,0,0,
  /* 10) */	{ "","","","","" },
  /* 11) */	{ 0,0,0,0,0,0,0,0,0,0 },
  /* 12) */	1,
  /* 13) */	{ 0,0, 0,0, 0,0, 0,0, 0,0, 0,0, 0,0, 0,0 },
/* end of table DON'T CHANGE! !! ! !*/
	},

/************************************************************************
 Most sysops want the initial user to either be of 'normal' status, or
 'nocpm' status, but you can make it whatever you like..
 Take the status from the above table (SYSOP, SPECIAL, NORMAL, NOCPM,
 TWIT (sure!), 'a', 'b', 'c')...					*/

	NOCPM,	/* this is what you change */


/************************************************************************
 Is the bbs to be a private or pay system?
 	if SO set private to YES,This will require a system id code to logon.
	if NOT (it's public) then set to NO.				*/

	NO,	/* <--- that's what you change	*/

/* The following definition is for private systems ONLY	*/
/* (you may ignore it, if the above itset to 'NO')		*/

/* this is the private system password to get on to the system	*/
/* it can be UP TO 8 CHARS LONG (NO MORE)!			*/

	"CODXYZZY",	/* <--- this is it	*/


/**************************************************************************
	 The following table MUST BE KEPT IN THE SAME ORDER!!!!!!!!

	You may change the filenames to suit your tastes, also you
	may change the location (user area and drive) of each file.

	Filenames are of the format:  [user/][drive:]filename.ext	  */

{	"14/a:bulletin.met",	/* Bulletins file */
	"14/a:welcome.met",	/* Welcome file, as typed bye BYE */
	"15/a:users.log",	/* Users file */
	"14/a:callers.log",	/* callers log */
	"15/a:counters",	/* system special counters */
	"15/a:messages.log",	/* Main Message file */
	"15/a:summary",	 	/* Message Summary file */
	"15/a:lastcalr",	/* Last caller file */
	"14/a:newuser.met",	/* file to type for new users */
	"14/a:help.met",	/* brief command list help */
	"14/a:cpminfo.met", 	/* help file when exiting to cpm */
	"14/a:system.inf",	/* In private sys. account info, etc.*/
	"14/a:appinfo.met",	/* info for new APPLY file */
	"14/a:othersys.met",	/* other systems file  */
	"14/a:notes.ind",	/* Notes index file    */
	"14/a:feature.ind",	/* Features index file */
	"15/a:meovr.mov",	/* main overlay file.  */
	"14/a:commands",	/* Z3 commands file	*/
	"14/a:display.met",
	"14/a:article.ind", 
	"14/a:items.ind",
	BYECOM,			/* BYE program for disconnect */
	OSCOM,			/* program to run as going to OS.. */
	0	 /* leave alone */
	},


/************************************************************************
   after a certain number of unsuccessful login attempts, a person is
   hung-up on.  This variable declares that number.
   NOTE: attempt to logon as sysop counts as TWO tries.			*/

	5,	/* <--- Right here...	*/


/************************************************************************
   You can set an upper limit on the amount of active messages.  Each
   active message will take up 8 bytes of memory.			*/

	200,	/* <--- And here...	*/


/**************************************************************************
   Each line of a message can be up to 128 chars, but for a clear display
   the max length of a line of entered text should be something like 80	  */

	52,	/* <--- Change this if you like */


/************************************************************************
   You can set the maximum number of lines a message can have.  This is
  limited to 250 lines.

   100 lines at 80 chars a line (assuming completely full msg) would
   take 8k (RAM) above the actual program.				*/

	50,	/* <--- Here */


/************************************************************************
   A buffer space is needed in Metal to hold message pointers.  Each
  Space in the buffer takes up 8 bytes of memory.  This number MUST
  be larger than the Max Active message count above.			*/

	300,	/* Plenty of space */


/***************************************************************************
	NOCLOCK	is set if no clock routines are used..
	Anything else assumes clock installed..

/* this is what you change for clock or not */

	NOCLOCK,	/* <--- Change this */

/*************************************************************************
  If your BYE is setup to ask for NULLS, then set the following to YES,
  else, set it to NO.							*/

	NO,	/* <--- Change this as desired	*/


/***************************************************************************
   If you are running ZCPR 1 or 2 in Secure mode, set the following to YES.
   If ZCPR3 is being used, set this to 3, otherwise set it to NO.	  */

	YES,	/* <--- And here */

 /* loc of WHEEL, ignore if above isn't set to YES (ZCPR3 gets it from
    environment descriptor  */

	0x003e,	/* <--- Here..	*/


/***************************************************************************
  The following variable is used ONLY for NON-MP/M, MULTI_USER systems.

   For multiuser systems which make it dificult to tell which console is
  running the program (like TurboDos...) we need to have a set of 4 locations
  in memory that will be used to contain a simulated console Id.  The
  following is the starting address of the 4 locations in NON-COMMON memory.
  Usually there is room someplace in the base page of memory (0-100h)
  to place this.  This is currently set for a "reserved" area in TurboDos. */

	0x003b,	/* here.. */


/************************************************************************
   Initial default terminal line length.. this is currently not used*****/

	80,	/* Alter this if you like */ 


/************************************************************************
   Location of site.  Up to 80 chars. Displayed in MENTER 		*/

	" -- name of system -- ",	/* <--- You got it!! */


/************************************************************************
   If you wish callers log and comments to go to printer and not a file
   then set this to YES, else set to NO.				*/

	NO,	/* <--- This one too */


/************************************************************************
   If you have a 25th line on your terminal that doesn't scroll, then
   the following to YES, and set the appropriate control chars, and
   port addresses below.  Otherwise declare the variable to NO		*/

	NO,	/* Set this to yes or no	*/

/* Up to 15 chars can be used to get to or from the 25th line		*/

/*** You may ignore the following if the above is NO ***/

/*	vvvvvvvvvvvvv---- change ALL OF these !!!!!		*/
	"\033\070",	/* Sequence to get to the 25th line	*/
	"\n",		/* Sequence to return from 25th line	*/
	0x13,		/* terinal output status port		*/
	0x12,		/* terminal data output port	  	*/
	0x01,		/* terminal status mask.. if bit is one,*/
			/* then ready to output char to port    */

/* NOTE::::: If you are using a non-I/O mapped video board that has a 25th
   line (Kaypro people), you can set the following values to obtain the
   same results as if it were i/o mapped:
	Set Terminal Output Status AND Terminal Status Mask to 0 (zero).
	Then find your bios output routine like this:
		A>ddt
		DDT Version...
		-l0		; list from 0
		0000 JMP B603	; look at where this jump instruction goes to
		-lb603		; and list from that address
		B603 JMP xyz
		B60x...		; we want the one at B60E in this case
				; (first two digits + 0E as last two digits)
		B60E JMP e877	; Ok, now write down the address this jump
				;  instruction goes to (e877h in this ex.)
	Now With the address you've written down, enter it as the
	'Terminal Output Data Port'.

	That's it!

	MAJOR NOTE::  This method is BIOS Dependent, so you'll have to
		      go through the same procedure anytime you use a
		      different flavored BIOS!!!!!!!!!!!!!!!!!!!!!
									*/


/************************************************************************
   CHANGE THESE!!!!!!!!  Sysop built-in password, and name
 */

	"Tim",		/* <--- Sysop's first name (change this)	*/
	"Gary",		/* <--- Sysop's last name  (  "      " )	*/

	"NOPASS",	/* <--- Change to a password (UPPER CASE ONLY)	*/


/************************************************************************
 	DO NOT CHANGE THE FOLLOWING...
				
 */
#ifdef METAL
	"Metal Message System [A Heavy BBS]",
#else
	"Z-Msg Message Handling System",
#endif

	"Version 1.31cF",

#ifdef METAL
	";METAL ALIAS",
#else
	";Z-MSG ALIAS",
#endif
	0x48,			/* message buffer offset */

/* leave this alone!!!!!!!! */
"KABOOM!!!"	/* signal end of structure -------DO NOT TOUCH */

};	/* WHEW !!!!!!!!!!!!!!!!!   THAT'S IT!!!!!!!!!!!!!!!!!!!!!!!!!! */


/* EOF (MEINITO.H) */

