/*
 * This program (written by Henry Yen) gets run at boot up time and remains
 * running always. Its function is to acctually do the starting of hasp when
 * you execute /usr/hasp/start.hasp. Since this program has no controlling
 * tty attached to it, HASP wont have on either when it starts it.
 * To install this,         cd /etc
 * Type make -f .makefile haspmon
 * The owner, group and mode will be set for you.       J.B.B.
 */

#include	"setjmp.h"

int pass0 = 1;

jmp_buf	sjbuf;


main()
{
	int j;
	register int i;
	int reset();

	setuid(68);
	unlink("/etc/.hasp");
	i = creat("/etc/.hasp",0);
	setpgrp(-1);
	j = getpid();
	write(i,&j,2);
	close(i);
	for (i = 1;i < 16;i++)
		signal(i,1);
	chdir("/usr/hasp");
	setjmp(sjbuf);
	signal(2,reset);
	chmod("/etc/.hasp",0);
	if (pass0)
		pass0 = 0;
	else {
		switch(fork()) {
			case -1:
				reset();
				abort();
			case 0:
				execl("/usr/hasp/start.hasp2","start.hasp2",0);
				exit(1);
			default:
				wait(&j);
		}
	}
	chmod("/etc/.hasp",0600);
	pause();
	abort();
}

reset()
{
	longjmp(sjbuf, 1);
}
