#
/*  saccess
 * a subroutine to check if access to file is legal for the real user.
 * this allows programs to run setuid root, and still enforce the standard
 * file protection modes.
 * call by:
 * saccess(file, mode)
 *  char *file;    int mode;
 * where mode is either 4 to check read access or 2 to check write access.
 * for a file to be readable the person must have read authorization for the
 * file, and at least search permission in every directory leading to the file.
 * for a file to be writeable the person must have write authorization
 * for the file (if it exists), and must also have write authorization
 * in the directory to which the file will be attached, as well as
 * having at least search permission in every directory leading up
 * to the file.
 * for the superuser read access requires that the file exist, and
 * write access requires that at least one write authorization bit
 * be set if the file already exists.
 *
 * by David E. Miran
 * Version of 2/1/83
 */

char	auid;	/* actual uid */
char	agid;	/* actual gid */
int	idset	0;	/* id's have been gotten */
#define	READ	4
#define	WRITE	2
#define	XQT	1

saccess(file, imode)
char file[];
int imode;
{
int firstd, last, ymode;
char c;
char	fcp[100];
register int i, flen, xmode;

struct	{	/* stat system call inode buffer */
	char	fill1[4];
	int	flags;
	char	fill2;
	char	fuid;	/* files user id */
	char	fgid;	/* files group id */
	char	fill3[27];
	}	sbuf;

	if (idset == 0)  {	/* need to get uid and gid */
		auid = getuid() & 0377;
		agid = getgid() & 0377;
		idset++;
	}
	if (stat(file, &sbuf) < 0)	{   /* file does not exist */
		if (imode & READ) return(0);  /* can't read it */
		if (auid == 0) return(1); /* super user can write */
		goto ckdir;
	}
	xmode = imode;
	if (auid == 0)  {	/* super user */
		if (xmode == READ) return(1);
		if (sbuf.flags & 0222) return(1); /* write ok if any set */
		return(0);
	}
	if (auid == sbuf.fuid) {
		xmode = xmode<<6;
		goto ckf;
	}
	if (agid == sbuf.fgid)  {
		xmode = xmode<<3;
	}
ckf:
	if (!(xmode & sbuf.flags)) return(0); /* sorry - no access to file */
ckdir:
	/* start checking up the directory chain */
	firstd = 1;	/* this is the first directory */
	i = 0;
	while (fcp[i] = file[i]) i++;	/* copy file name */
	flen = i-1;
	ymode = XQT;
	last = 0;
backlp:
	/* start backing up through the name */
	c = fcp[flen--];
	if (flen < 0) { /* nearly done */
		if (c != '/') fcp[0] = '.';
		fcp[1] = '\0';
		last = 1;
		if (imode & READ) return(1);
		goto do_ck;
	}
	if (c != '/') goto backlp;  /* remove next char */
	fcp[flen+1] = '\0';
do_ck:
	/* get the directory's status entry */
	stat(fcp, &sbuf);
	ymode = XQT;
	if (auid == sbuf.fuid) {
		ymode = ymode <<6;
		goto ckd;
	}
	if (agid == sbuf.fgid)  {
		ymode = ymode <<3;
	}
ckd:
	if (!(ymode & sbuf.flags)) return(0); /* no search permission */
	if ( (imode & WRITE) && firstd) { /* check directory write auth */
		ymode = WRITE;
		if (auid == sbuf.fuid) {
			ymode = ymode <<6;
			goto ckw;
		}
		if (agid == sbuf.fgid)  {
			ymode = ymode <<3;
	}
ckw:
		if (!(ymode & sbuf.flags)) return(0); /* no write permission */
		firstd = 0;
	}
	if (last) return(1);   /* made it */
	goto backlp;
}
