/*
 * pltlp
 * combined LP-11 line printer and XY-11 plotter driver
 * Note they share a buffer and so cannot be used simultaneously
 * by David E. Miran   -  version of 12/10/82
 */

#include "../hd/param.h"
#include "../hd/conf.h"
#include "../hd/user.h"
#include "../hd/seg.h"

#define	LPADDR	0177514
#define PLTADDR 0172554
#define	IENABLE	0100
#define	DONE	0200
#define	LPPRI	2
#define	LPLWAT	150
#define	LPHWAT	512
#define	MAXCOL	136
#define	EJECT	02
#define	OPEN	04
#define	CLOSING 020	/* waiting on close, but output not done */
#define	RMODE	0100		/* raw mode - no formfeed on close */
#define	PLOT	010		/* device plotter */
#define FIXMOD	0177		/* device to reset driver to closed state */
#define	FORM	014
struct {
	int lpsr;
	int lpbuf;
};
struct  {
	int	cc;	/* buffer character count */
	char	*iptr;
	char	*optr;
	int	flag;
	int	mcc;	/* highest char position printed */
	int	ccc;	/* calculated character position */
	int	mlc;	/* line number on page */
} lp11;
int	*lpdev;
char	*lpmem;		/* mapped location of lp buffer */
struct bufpt lpseg;

lpinit()
{
	getobuf(&lpmem, &lpseg, LPHWAT);  /* allocate external buffer */
}
lpopen(dev, rwflag)
{
	if (lp11.flag) {
		if (dev.d_minor == FIXMOD) lp11.flag = 0;
		u.u_error = EIO;
		return;
	}
	lp11.flag = OPEN | dev.d_minor;
	lp11.iptr = lp11.optr = lpmem;
	lp11.cc = 0;
	if (lp11.flag & PLOT)
		lpdev = PLTADDR;
	else
		lpdev = LPADDR;
	if (lpdev->lpsr < 0) {  /* return if device off-line */
		lp11.flag = 0;
		u.u_error = EIO;
		return;
	}
	lpdev->lpsr =| IENABLE;
	if (!(lp11.flag & (RMODE | PLOT)))
		lpcanon(FORM);
}
lpclose(dev, rwflag)
{
int sps;
	if (!(lp11.flag & (RMODE | PLOT)))
		lpcanon(FORM);
	sps = spl6();
	if (lp11.cc != 0)
		lp11.flag |= CLOSING;
	else
		lp11.flag = 0;
	splx(sps);
	while ((lp11.flag & CLOSING) != 0)
		sleep(&lp11,LPPRI);
	lpdev->lpsr = 0;	/* disable interrupts when not active */
}
lpwrite()
{
	register int c;

	while ((c=cpass())>=0) {
		if (lp11.flag & PLOT)
			lpoutput(c);
		else
			lpcanon(c);
	}
}
lpcanon(c)
{
	register c1, c2;
	c1 = c;
	switch(c1) {
	case '\t':
		lp11.ccc = (lp11.ccc+8) & ~7;
		return;
	case FORM:
	case '\n':
		lp11.mcc = 0;
		if( lp11.mlc || (c1 != FORM)) lpoutput(c1);
		lp11.mlc++;
		if(c1 == FORM)
			lp11.mlc = 0;
	case '\r':
		lp11.ccc = 0;
		return;
	case 010:
		if(lp11.ccc > 0)
			lp11.ccc--;
		return;
	case ' ':
		lp11.ccc++;
		return;
	default:
		if(lp11.ccc < lp11.mcc) {
			lpoutput('\r');
			lp11.mcc = 0;
		}
		if(lp11.ccc < MAXCOL) {
			while(lp11.ccc > lp11.mcc) {
				lpoutput(' ');
				lp11.mcc++;
			}
			lpoutput(c1);
			lp11.mcc++;
		}
		lp11.ccc++;
	}
}
lpint()
{
	mapin(&lpseg);
	while (lpdev->lpsr&DONE && lp11.cc ) {
		lpdev->lpbuf = *lp11.optr++;
		--lp11.cc;
		if(lp11.optr == lpmem+LPHWAT)
			lp11.optr = lpmem;
	}
	mapout();
	if (lp11.cc <= LPLWAT) wakeup(&lpseg);
	if (((lp11.flag & CLOSING) != 0) && (lp11.cc == 0))  {
		lp11.flag = 0;
		 wakeup(&lp11);
	}
}
lpoutput(c)
{
	if (lp11.cc >= LPHWAT)
		sleep(&lpseg, LPPRI);
	mapin(&lpseg);
	*lp11.iptr++ = c;
	if(lp11.iptr == lpmem+LPHWAT)
		lp11.iptr = lpmem;
	lp11.cc++;
	mapout();
	spl5();
	lpint();
	spl0();
}
