/*
			    tpr

                        By William J. Kurth
                      State Laboratory of Hygiene
                            June 8, 1983

Tpr issues left margin and font type commands for the Toshiba Letterperfect printer.
 -m{n} indents the left margin n spaces.  -f{n} sets the font style.
The Font styles are:
n = 0  -  High speed font
n = 1  -  High quality Prestige Elite
n = 2  -  High quality Courier.
-pn sets the pitch to n characters per inch.  N may be 10 or 12.
-l prints the name of each file followed by a blank line.
  -i issues a top of form at the end of each file otherwise each file is seperated by one line.
*/

#include <stdio.h>
#define BUFSIZE   512
int fd, fl3;
int font, marg, bs, fl, fl2;
int fseen 0;
int caption 0;
int pit, pitch;
pit = 0, pitch = 0;
font = 0, marg = 0, bs = 0, fl = 0, fl2 = 0, fl3 = 0;
main(argc, argv)	
int argc;
char *argv[];
{
	FILE *fp, *fopen();
	int n;
	char *arg;

	setbuf(stdout, NULL);
	printf("\033\032I");  /* start each file with a reset */
	while (--argc) {
		if(*(arg = *++argv) == '-') switch(*++arg) { /* Check for options */
			case 'f': font = atoi(++arg);
			break;
			case 'p': pit = atoi(++arg);
			if(pit == 10) pitch = 12;
			if(pit == 12) pitch = 10;
			break;
			case 'l': caption = 1;
			break;
			case 'm': marg = atoi(++arg);
			break;
			case 'i': fl3 = 1;
			break;
			default:
				fprintf(stderr,
					"tpr: %s Not an option.\n", *argv);	
					exit(1);
					break;
				} else {
					if ((fd = open(*argv, 0)) == -1) {
					fprintf(stderr,
						"tpr: can't open %s\n", *argv);
					exit(1);
					} else{
						if(caption == 1)
							printf("%s\n\n", *argv);
						doit(fd);
						close(fd);
						fseen = 1;
					}
				}
		}
	if(!fseen) doit(0);
	exit(0);
}
doit(fd) /* Copy file with printer control characters to standard output */
{
int n;
char buf[BUFSIZE];
bs = marg;
fl2 = marg;
lp: /* set margin */
	while (fl2--) printf(" ");  /* margin indent */
	if(marg > 0) {
		printf("\0339");
		}
	if(font > 0) printf("\033*%d", font); /* Set Font */
	if((pitch == 12) || (pitch == 10)) printf("\033E%d", pitch);
	while ((n = read(fd, buf, BUFSIZE)) > 0)
		write(1, buf, n);
lp2:		/* full reset after each file */
	if ((marg > 0) || (pitch > 0) || (font > 0)) printf("\033\032I");
	if(fl3 == 1) printf("\014"); /* -i option top of form between files. */
}
