/*
 * prem		remove a print control file and all spool files
 *		before it gets printed. If now being printed, kill it.
 *
 * Must run set-user root to be able to send signals to tpd.
 *
 * command:
 *
 *	% prem prid [?]
 *
 * where:
 *	prid = id number of print to remove
 *	? is terminal code if not for line printer
 *
 * Written by Bob Beck, 26-JAN-77.
 * modified for multiple device support by David Miran
 * version of 12/21/82
 */

#include	<stdio.h>
#include "tpdinf.h"

char	cf[] "/sptmp/data/cf%xxxxx";
char	sf[] "/sptmp/data/sf%";
char	*lp	"/dev/lp";
char	*dev	"/dev/tty?";
int	tmode	0;
char	term	'%';
char	*progname;

struct	printid	prid;
struct	control	ctl;
int	argid;
char	dlook();

main(argc,argv)
int	argc;
char	*argv[];
{
  register int fd;
register int spfd;
  int i;

	progname = argv[0];
	/* get terminal code (if not for line printer) */
	if (argc > 2) {
		term = argv[2][0];
		termset();
	}
	/*
	 * check and get arg id number.
	 */

	if (argc < 2) {
		printf("Useage: %s prid [?]\n",progname);
		exit(0);
	}
	argid = decimal(argv[1]);

	/*
	 * change mode to ignore printing. if printing, kill it.
	 */

	ascnum(cf+15,argid);
#ifdef VERIFY
	verify(cf,"remove");			/* check permission */
#endif
	chmod(cf,IGNMODE);
	if ((spfd = open(tpdprid,0)) >= 0) {
		read(spfd,&prid,sizeof prid);
		if (prid.prpid == argid)
			tpdkick(L_KILL);	/* kill it if present print */
		close(spfd);
	}

	/*
	 * delete control file and all spool files.
	 */

	if ((spfd = open(cf,0)) < 0) {
		printf("%s:  Can't open control file %s\n",progname,cf);
		exit(1);
	}
	read(spfd,&ctl,sizeof ctl);
	close(spfd);
	unlink(cf);
	for(i = 0; i < ctl.nfiles; i++)
		unlink(makefn(sf,i,ctl.sfpid));
}
/*
 * verify	check that calling user owns spool file.
 *		If not ask if the person really wants to kill/stop/remove it
 *		By David E. Miran
 * version of 12/16/82
 */

struct	control	ctl;

verify(file,what)
char	*file, *what;
{
register int user;
int fd;
char	xbuf[20];
int	flag;

	flag = 0;
	user = getuid() & 0377;
ck:
	if ((fd = open(file,0)) < 0) {
		if (flag) {
quit:
			printf("%s:  Spool file %s not found\n",progname,file);
			exit(1);
		}
		flag++;
		/* since couldn't find it try searching directory */
		term = dlook(file);
		if (term == '\0') goto quit;
		termset();
		goto ck;
	}
	if (read(fd,&ctl,sizeof ctl) < 0) {
		printf("%s:  Can't read spool file %s\n",progname,file);
		exit(1);
	}
	close(fd);

	if ((ctl.uid & 0377) != user) {
		printf("%s: The job %d queued to %s is not yours!\n",progname,argid,tmode?dev:lp);
		printf("Do you really want to %s it?  Type y or n.\n",what);
		read(0,xbuf,20);
		if (xbuf[0] != 'y') exit(1);
	}
}
/*
 * tpdkick	routine to send a signal to executing tpd.
 *		note: must be super user to do kill of process
 *		not same user.
 *
 * Written by Bob Beck, 21-JAN-77.
 */

tpdkick(sig)
int	sig;
{
  register int fd;
  int pid;

	if ((fd = open(tpdpid,0)) < 0) {
		write(1,"Can't read tpd pid.\n",20);
		exit(1);
	}
	read(fd,&pid,2);
	close(fd);
	kill(pid,sig);
}
termset()
{
	if (term == '%') tmode = 0;
		else tmode = 1;
	cf[14] = term;
	sf[14] = term;
	tpdpid[12] = term;
	tpdprid[12] = term;
	dev[8] = term;
}
char dlook(cname)
char *cname;
{
struct	{
	int	inum;
	char	fnam[15];
	} dirent;
int	*first	dirent.fnam;
int	dir, n;

	dir = open(usrtpd,0);
	seek(dir,32,0);			/* skip "." and ".." */
	while(1) {
		if ((n = read(dir,&dirent,16)) <= 0)
			return('\0');
		if (*first != 'cf' || !dirent.inum)
			continue;
		if (strcmp(&dirent.fnam[3],&cname[15]) == 0) break;	/* found matching id number */
	}
	close(dir);
	return(dirent.fnam[2]);
}
