/*
 * fscan file
 * allow random probe and display of text files
 * by David E. Miran
 * January 7, 1981
 */

#include	"myio.h"

struct fbuf in, out;
int ifid, isize;
long diff;
long off;
char line[512];

main(argc, argv)
int argc;
char **argv;
{
extern long tell();
extern long atol();
	if ((ifid = open(argv[1], 0)) < 0) {
		printf("fscan: cannot open %s\n", argv[1]);
		exit(1);
	}
	seek(ifid, 0, 2);
	off = tell(ifid);
	seek(ifid, 0, 0);
	printf("$$$ file size is %D $$$\n", off);
	finit(&in, ifid);
	finit(&out, 1);
	n10();

inlp:
	write(1, ">", 1);
	isize = read(0, line, 512);
	if (isize < 1) goto done;
	if (line[0] == 'q') goto done;
	if (isize == 1) {  /* newline only - do 10 more lines */
		n10();
		goto inlp;
	}
	if (line[0] == '$') {
		seek(ifid, 0, 2);
		finit(&in, ifid);
		n10();
		goto inlp;
	}
	if (line[0] == '+') {
		off = atol(&line[1]);
	}  else  {
		off = atol(line);
	}
	if (line[isize-2] == 'k') off *= 1024;
	if (line[isize-2] == 'b') off *= 512;
	diff = in.nrd - in.ptr;
	if (in.nrd < 1) diff = 0;
	if ((line[0] == '+') || (line[0] == '-')) off = off - diff;
	if ((line[0] == '+') || (line[0] == '-'))  {
		off = off + tell(ifid);
		lseek(ifid, off, 0);  /* relative offset */
	} else {
		lseek(ifid, off, 0);
	}
	if (argc > 2) {
		printf("about to tell\n");
		off = tell(ifid);
		printf("final file offset (via tell) is %D\n", off);
	}
	finit(&in, ifid);
	n10();
	goto inlp;
done:
	close(ifid);
	exit(0);
}

n10()	/* print next 10 lines from the file */
{
register int i, j;
	for (i=0; i<10; i++) {
		j = getl(line, &in);
		if (j < 1) {
			fflush(&out);
			printf("$$$ EOF $$$\n");
			return;
		}
		putrec(line, j, &out);
	}
	fflush(&out);
}
getl(rec, file)
register char *rec;
struct fbuf *file;
{
	register int i;
	register char c;
	i = 0;
lp:
	c = get(file);
	if (file->nrd < 1) return(0);
	rec[i++] = c;
	if (c == '\n') {
		rec[i] = '\0';
		return(i);
	}
	goto lp;
}
