/*
 *  defines of codes for ntr protocol rje package
 *  David E. Miran  10/14/82
 *  Wisconsin State Hygiene Lab
 */

/* input and output are relative to the Univac 1100, while
   sinput and soutput (site input and site output) are relative to
   the program ntr running on the pdp-11 and usually refer to
   transmission relative to the pdp-11 to and from the Univac 1100
 */

/* site specific codes and user id's  */

#define		SITEID	'L'	/* hygiene lab is site L */
#define		SITUID	9	/* rje user id */
#define		SITGID	9	/* rje group id */
#define		DPGROUP	20	/* data processing group id */
#define		NRECDEV	4	/* number of devices which can receive */

/* arbitrary constants - may be altered */
#define		NSEC	30	/* time is seconds between site clock ticks */
#define		NTICK	3	/* number of ticks before declaring Univac 1100 has timed out */
#define		MAXTIME	60	/* number of seconds since last input before declaring timeout */
#define		RETRYLIM  10	/* number of retransmit tries before giving up hope */

/*  external codes for devices */

#define		READER	2
#define		PUNCH	3
#define		PR1	4
#define		PR2	5
#define		CONSOL	0
#define		SITE	15
#define		EXNODEV  20

/* internal device codes - for scheduling table use */
#define		NODEV	0
#define		DEVCONS 1
#define		DEVSITE 2
#define		DEVCR	3
#define		DEVPU	4
#define		DEVLP	5

/*  Internal (to site) message types */

#define		IDATA	0	/* data to (sender) or from (receiver) U1100 */
#define		ICTRL	1	/* control message to or from U1100 */
#define		ILOG	2	/* log message (internal site log)  */
#define		ISTRT	3	/* initialize device - data follows */
#define		ISHUT	4	/* Shutdown message */
#define		ITRC	5	/* trace control via rje commands */
#define		IDISP	6	/* display message from U1100 to receiver */
#define		IFLUSH	7	/* flush mark from sender to protocol */
#define		IEOF	010	/* eof from sender (i.e. no more follows) */
#define		IEOJ	020	/* end of job (for job transmission) */
#define		IEOI	040	/* end of input/output for a device */

/*  U1100 message types  */

#define		ACK	0
#define		NAK1	1
#define		NAK2	2
#define		REQ	2	/* request output from 1100 */
#define		DATA	3	/* data transfer message */
#define		TERMD	4	/* terminate device */
#define		SUSPEN	5	/* suspend device or site */
#define		RESUME	6	/* resume device or site */
#define		LOCKTM	7	/* lock and term */
#define		REQUEUE	8	/* requeue file */
#define		LOCKRQ	9	/* lock and requeue */
#define		REPRNT	10	/* reprint/repunch */
#define		SKIP	11	/* skip foreward */
#define		DISPF	12	/* display files */
#define		DISPQ	13	/* display queue */
#define		ILLMSG	55	/* illegal message */
#define		TERMST	56	/* terminate site */
#define		UNLOCK	57	/* unlock device */
#define		RQTERM	57	/* requeue and term site - signoff */
#define		COMPTM	58	/* complete active and term */
#define		COMQTM	59	/* complete queues and term */
#define		LOCKOUT	61	/* lockout device */
#define		INIT	62	/* initialize device or site */
#define		DISPLY	63	/* display message on 1100 console */

/* character code definitions */

#define		SYNC	0226	/* sync with even parity */
#define		SOM	01	/* start of message */
#define		STX	02	/* start of text */
#define		EOM	03	/* end of message */
#define		ENDIM	077	/* end of data image */
#define		ENDBUF	017	/* end of data buffer */

/* device function codes */
/* printer */
#define		FD	0	/* data is in fieldata code */
#define		ASCII	1	/* data is in ascii code */

/* card reader */
#define		SENDAS	6	/* send ascii data */

/* card punch */
#define		PNCHFD	01	/* punch fieldata */
#define		PNCHAS	06	/* punch ascii */
#define		PNCHFDE	02	/* other fieldata */
#define		PNCHASF	03	/* other ascii */
#define		PNCHASE	04	/* other ascii */
#define		PNCHFDA	05	/* other fieldata */
#define		PNCHCB	00	/* column binary */

/* miscellaneous definitions */

#define		CONTIN	020	/* image to be continued */
#define		P0770	040	/* image needs wide 0770 printer */
#define		PRFUNC	017	/* mask for printer function code bits */
#define		HOME	040	/* home paper bit */
#define		LPI8	0100	/* 8 lpi printing bit - should never see */
#define		LNMASK	077	/* line spacing mask */
#define		DATAEOF 056	/* detail code for end of file */
#define		DEVTERM 020	/* device terminated status code */

/* message sizes */

#define		SNDSIZE	112	/* size of data in data message to 1100 */
#define		RECSIZE	237	/* size of data in data message from 1100 */
#define		IDSIZE	125	/* size of input data messages to U1100 (including syncs) */
#define		ICSIZE	12	/* size of input control messages from U1100 (including syncs) */
#define		OSIZE	246	/* size of output (from 1100) data message */
#define		CSIZE	8	/* size of control message */

/* rje state codes */
#define		WAIT	01	/* waiting for response from macc */
#define		JOBPRG	02	/* job transmission in progress */
#define		ACTIVE	04	/* site active (logged in successfully) */
#define		SUSPND	010	/* site suspended (send only ack/nak) */
#define		WTNAK2	020	/* waiting on nak2 */
#define		RECPRG	040	/* receiving output from macc */
#define		TIMOUT	0100	/* U1100 timed out (2 minute) */
#define		FLUSH	0200	/* flush queued sinput (from sender) to marker after 1100 timeout */
#define		IDLE	0400	/* site is exchanging timeout naks with U1100 */
#define		ITRACE	01000	/* trace input to U1100 */
#define		OTRACE	02000	/* trace output from U1000 */
#define		CTRACE	04000	/* write only control info in trace */
#define		ANYTRACE 07000	/* is any trace set */
#define		FREADY	010000	/* file is ready for transmission */
#define		TESTMD	020000	/* test mode */
#define		BUFASK	040000	/* we have asked for output */
#define		TERMED	0100000	/* site has been terminated (usually via keyin */

/* signals */
#define		CLOCK	8	/* use fp exception as alarm clock signal */
#define		WORK	6	/* (iot) signal from sender that there is work */
				/* also signal from send and keyin to sender */
#define		QUIT	3	/* signal to shut system down - ctrl \ */

/* external site status codes - for file rje/stat and status program */
#define		NOTOP	0	/* site not operational - programs not running */
#define		WTLOG	1	/* waiting for response to orig login or login keyin */
#define		TERMK	2	/* site terminated via keyin - programs still running */
#define		TIMDOUT	3	/* Univac 1100 has timed out - attempting to restore contact */
/*		ACTIVE	4	   is defined in site state codes */
