#
/*
 * recv
 * this is the received output interpreter for an NTR rje package for
 * communication between a pdp-11 running UNIX and a UNIVAC 1100 computer.
 * Output of various types is interpreted by the recv routine and put into
 * the appropriate files.  This routine also maintains the log files and
 * notifies users when their jobs are complete.
 *
 * Written by David E. Miran
 * Wisconsin State Hygiene Lab
 * 465 Henry Mall
 * Madison, Wi 53706
 *
 *  October 27, 1982
 *
 */

#include	<stdio.h>
#include	"rjedef.h"
#include	"rjeforms.h"
#include	<time.h>
#define		NDEV	4	/* number of possible output devices */
				/* PR1, PR2, CONSOL, PUNCH */

int	bc[NDEV],cc[NDEV];			/* segment blank count/char count */
int	bufeof;			/* flag set to 1 on buffer end */
int	consfid;		/* file id of console */
char	cr	'\r';		/* a carriage return for console messages */
char	rcurjob[NDEV][7];	/* current transmittal number of received job */
char	curline[NDEV][256];	/* current output line (per device) */
int	curpos[NDEV];		/* current output line pointer */
int	devopn[NDEV];		/* is device active -  1=yes */
int	eofwarn[NDEV];		/* set if image is next to last, 2 if image is eoj tof */
int	fc;			/* input function code (for an image) */
int	fdmode[NDEV];		/* set to 1 if image is fieldata */
int	gdev;			/* a global variable to hold device code */
int	improg[NDEV];		/* image in progress */
int	inpnt;			/* input buffer position counter */
struct  locmesg *lriptr;	/* local copy of message pointer */
int	logfid;			/* log file's file id */
char	newln[2]	"\n";	/* a blank line */
char	newrun[7];		/* runid read from input */
int	nextrun[NDEV];		/* set if next line should have runid */
char	obuf[NDEV][512];	/* output buffers for devices */
int	ofid[NDEV];		/* output file id */
int	outpnt[NDEV];		/* output character counter */
char	ovpr[4]		"~0\n";		/* overprint control line */
int	rjeown;			/* the user/group of the rje system */
int	savsp[NDEV];		/* saved line spacing count */
char	segbuf[128];		/* buffer in which to put image segments */
int	segprog[NDEV];		/* segment in progress per device flags */
char	*sigline[]	{	/* lines to match from job text */
		"*  *  *  *  *  *  UNIVAC ",	/* 25 chars */
		"RUNID: ",			/*  7 chars */
		"***EOF*** ",			/* 10 chars */
		0};
char	spline[8]	"~x\0\0\0\0\0";	/* print control line */
int	sp1,sp2;		/* line printer spacing control bytes */
char	sqline[256];		/* buffer to squash line (install tabs) */
int	topform[NDEV];		/* spacing is top of form */
char	topline[4]	"~*\n";	/* print control line for top of form */
int	tpos;			/* tab conversion position */
int	tsavsp;			/* saved spaces for tab conversion */
int	tvec[2];		/* for time stamp time */
char	*tptr;			/* for time as a char string */

/* These are the variables used by the user notification code */

struct	{
	char	fill1a[7];
	char	fuid;
	char	fill2a[28];
	}	stbuf;		/* file status buffer */
struct	{
	char	pname[8];
	char	fill3a[8];
	}	utbuf;		/* /etc/utmp buffer */
char	pwbuf[150];		/* password buffer */
char	*lpt;			/* command line pointer */
char	uname[8];		/* user name */
char	mailit[46]	"mail  xxxxxxxx < /rje/user_notify\0";
char	wrtit[46]	"write xxxxxxxx < /rje/user_notify\0";
char	msgline[25]	"Job xxxxxx is complete.\n";

char get();

recv(riptr)
struct locmesg *riptr;
{
extern char *garbage, *jobout, *jobctrl, *constemp;
extern int rjestate, rtrace, rtracfid;
register int i, dev, ig;


	lriptr = riptr;
	if (rjestate & TESTMD)
		printf("entered recv\n");
	if (rtrace)
		write(rtracfid, riptr, riptr->m_size+5);
/* accept data from protocol routines */
	riptr->m_type =& 07;	/* clear special bits */
	if (riptr->m_type == ILOG) goto log_it;
	if (riptr->m_type == IDATA) goto do_data;
	if (riptr->m_type == IFLUSH) goto flush;
	printf("recv: unrecognized message - type=%o\n\r",riptr->m_type);
	return;

flush:     /* re-initialization - close all files and restart */
	for (i=0; i<NDEV; i++) {
		if (devopn[i] == 0) continue;
		dev = gdev = i;
		put('\n');
		topform[dev] = 1;
		closerun();
		improg[dev] = 0;
	}
	return;
log_it:
	stampit(0);
	for (i=0; i<riptr->m_size; i++)
		sqline[i]=riptr->m_text[i];
	i=riptr->m_size;
	write(logfid, sqline, i);
	write(consfid, sqline, i);
	write(consfid, &cr, 1);
	return;

do_data:
	ig = riptr->m_dev;
	switch (ig) {	/* which device */
		case  PR1:
			dev = gdev = 0;   break;
		case PR2:
			dev = gdev = 1;  break;
		case CONSOL:
			dev = gdev = 2;
			if (devopn[dev] == 0) {
			/* set up console temporary file */
				ofid[dev] = creat(constemp, 0644);
				outpnt[dev] = 0;
				devopn[dev] = 1;
				curpos[dev] = 0;
			}
			break;
		case PUNCH:
			dev = gdev = 3;
			if (devopn[dev] == 0) {
				if ((ofid[dev] = open("punch")) < 0) {
					ofid[dev] = creat("punch", 0644);
					chown("punch", rjeown);
				}  else  {
					seek(ofid[dev], 0, 2);	/* go to end */
				}
				devopn[dev] = 1;
				outpnt[dev] = curpos[dev] = 0;
			}
			break;
		default:
			printf("recv: data for unknown device %d ignored\n\r",ig);
			return;
	}	/* end of switch */

	inpnt = bufeof = 0;

linelp:
	/* return here to get each line for processing */
	ig = getline();
	if (ig == -1)  {   /* end of file - clean it up */
		if (rjestate & TESTMD)
			printf("recv: got endfile on device %d\n",dev);
		closerun();
		if (riptr->m_dev == CONSOL) {
			close(ofid[dev]);
			ofid[dev] = open(constemp, 0);
			/* get timestamp for log messages */
			stampit(1);
			write(consfid, &cr, 1);
			while ((i = read(ofid[dev], obuf[dev], 512)) > 0) {
				write(logfid, obuf[dev], i);
				write(consfid, obuf[dev], i);
			}
			close(ofid[dev]);
			ofid[dev] = -1;
		}	/* end of console handler */
		return;  /* go back for more */
	}
	if (ig == 1)  {  /* end of buffer - line incomplete */
		return;
	}
	/* we have gotten a full line back */
	putline();	/* write it out with spacing info */
	goto linelp;	/* and get next line */
}

/* getline - assemble a line of text with spacing control info */
/*	return codes:   0 = line ready, 1 = end of buffer (image incomplete),
			-1 = end of file
 */

getline()
{
register int dev, i;
register char c;
int is, j;

	dev = gdev;
	if (improg[dev]) goto segloop;	/* line is in progress */
nline:
	c = get();	/* get function code for a line */
	if (bufeof) goto geteof;
	if (c == ENDBUF) goto geteof;
	if (c == DATAEOF) return(-1);	/* end of file */
	c =& PRFUNC;	/* mask E and C bits */
	if (lriptr->m_dev == PUNCH) {
		if ((c==1) || (c==2) || (c==5))
			fdmode[dev] = 1;
		else
			fdmode[dev] = 0;
	}  else  {
		if (c == 0)
			fdmode[dev] = 1;	/* fieldata input - Yecch */
		else
			fdmode[dev] = 0;	/* ascii input - much better */
	}
	improg[dev] = 1;
	curpos[dev] = 0;
	sp1 = get();
	sp2 = get();	/* print line spacing control bytes */
	if (sp1 & HOME)	{	/* top of form */
		topform[dev] =1 ;
		savsp[dev] = 0;
		get();	/* grab end of image */
		improg[dev] = 0;
		goto nline;
	}
	j = ((sp1&037)<<6) | (sp2&077);
	savsp[dev] =+ j;
segloop:
	/* add segments to the lines until a line is complete */
	is = getseg();
	if (is == 1) {	/* end of image (line) */
		curline[dev][curpos[dev]] = '\n';
		if (lriptr ->m_dev == CONSOL) {
			curpos[dev]++;
			curline[dev][curpos[dev]] = '\r';
		}
		curline[dev][curpos[dev]+1] = '\0';  /* for debugging purposed */
		improg[dev] = 0;
		return(0);
	}
	if (is == -1)   return(1);	/* end of buffer */
	/* we have a good segment - copy it */
	for (i = 0; i<bc[dev]; i++)
		curline[dev][curpos[dev]++] = ' ';
	for (i = 0; i<cc[dev]; i++)
		curline[dev][curpos[dev]++] = segbuf[i];
	goto segloop;
geteof:
	/* check if this buffer is an end of file */
	if (lriptr->m_detail == DATAEOF)  {
		return(-1);
	}
	return(1);
}

/* getseg - extract image segments from the buffer and perform fieldata
 *		to ascii translation if needed
 *	return codes:  0 - segment ready, 1 - end of image, -1 - end of buffer
 */

getseg()
{
register int i, dev;
register char c;
extern char fatab[64];

	dev = gdev;
	if (segprog[dev]) goto getcc;	/* we got the bc last time */
	segprog[dev]++;
	cc[dev] = -1;
	bc[dev] = get();
	if (bc[dev] == ENDIM) {
		segprog[dev] = 0;
		return(1);	/* end of image */
	}
	if (bufeof)	{	/* end of buffer */
		segprog[dev] = 0;
		return(-1);
	}
getcc:
	if (cc[dev] == -1) cc[dev] = get();
	if (bufeof) {	/* end of buffer */
		cc[dev] = -1;
		return(-1);
	}

/* note - the following piece of code presumes that the actual character
 *	  string of an image segment is never broken across buffer
 *	  boundaries
 */
	for (i = 0; i<cc[dev]; i++)  {
		c = get();
		if (fdmode[dev])	c = fatab[c];  /* fieldata translate */
		segbuf[i] = c;
	}
	segbuf[cc[dev]] = '\0';  /* mainly for debugging purposes */
	segprog[dev] = 0;
	return(0);
}

/* get - return a character - set bufeof on end of buffer */

char get()
{
	if (inpnt == lriptr->m_size) {	/* end of buffer */
		bufeof = 1;
		return(0);
	}
	return(lriptr->m_text[inpnt++]);
}

/* closerun - end of job recognized - drain buffers and reset everything */

closerun()
{
register int dev, i;
extern char *jobctrl;

	dev = gdev;
	if (devopn[dev] == 0) return;
	if (topform[dev]) {	/* top of form */
		put('~'); put('*');  put('\n');
		topform[dev] = 0;
	}
	if (outpnt[dev] > 0)   /* need to flush output buffer */
		write(ofid[dev], obuf[dev], outpnt[dev]);
	if (lriptr->m_dev == CONSOL) goto fclean;
	close(ofid[dev]);
	ofid[dev] = -1;
	if (rcurjob[dev][0] == '\0') goto fclean;
	for (i=0; i<7; i++)
		jobctrl[i+10] = rcurjob[dev][i];
	chmod(jobctrl, 0670);	/* mark control file as data received */
	if (!(lriptr->m_type == IFLUSH)) notify();
	rcurjob[dev][0] = '\0';
fclean:
	devopn[dev] = 0;
	outpnt[dev] = 0;
}

/* putline - interpret spacing control and write out lines, also tab conversion */

putline()
{

register int dev;
register char c;

	dev = gdev;
	if (topform[dev]) {	/* top of form */
		putl(topline,3);
		topform[dev] = 0;
	}
dosp:		/* handle line spacing */
	switch (savsp[dev]) {
		case 0:		/* overprint */
			putl(ovpr, 3);
			break;
		case 1:		break;
		case 2:
			putl(newln, 1);
			break;
		default:		/* generate a print control line */
			sprintf(spline,"~%02d\n",savsp[dev]);
			putl(spline, 4);
	}	/* end of switch */

/* now process the line - check if it is special, install tabs, and write it out */

	savsp[dev] = 0;
	chkl(curline[dev]);
	putl(curline[dev], curpos[dev]+1);
}

/* cmp - compare 2 character strings up to n characters - return 1 on match */

cmp(s1, s2, len)
char *s1, *s2;
int len;
{
register int i;
register char c1, c2;

	for (i = 0; i<len; i++) {
		c1 = *(s1+i);
		c2 = *(s2+i);
		if (c1 != c2) return(0);
	}
	return(1);
}

/* chkl - check lines to recognize start and end of job, and
 *		take action by opening and closing files.
 */

chkl(line)
char line[];
{
register int i, dev;
extern char *jobout, *garbage;

	dev = gdev;
	if (nextrun[dev]) {   /* this line should have a runid */
		nextrun[dev] = 0;
		if (cmp(sigline[1], line, 7)) {	/* found runid */
			for (i=0; i<6; i++)
				newrun[i] = line[i+7];
			if (devopn[dev]) {	/* file in progress */
				if (cmp(newrun, rcurjob[dev], 6))
					return(0);	/* same runid so ignore */
				/* we have a new runid - finish old one and then begin again */
				closerun();
			}	/* end of file in progress code */
		/* open up a new run */
			for (i=0; i<6;i++)
				jobout[i+9] = rcurjob[dev][i] = newrun[i];
			if ((ofid[dev] = open(jobout, 1)) < 0)  {
				ofid[dev] = creat(jobout, 0644);
				chown(jobout, rjeown);
			}  else  {
				seek(ofid[dev], 0, 2);	/* move to end of existing file */
			}
			devopn[dev] = 1;
			return(0);
		}
		return(0);  /* did not get a runid as expected - forget it */
	}
	/* check for start of job */
	if (cmp(sigline[0], line, 25)) {
		nextrun[dev] = 1;
		return(0);
	}
	/* check for end of job */
	if (cmp(sigline[2], line, 10)) {
		eofwarn[dev] = 1;
		return(0);
	}
}

/* putl - write out lines and also close file at end of job */

putl(line, len)
char line[];
int len;
{
register int i, dev;

	dev = gdev;
	tpos = tsavsp = 0;
	for (i = 0; i<len; i++)		tput(line[i]);
	if (eofwarn[dev] == 2)	{	/* this image was end of file top of form */
		closerun();
		eofwarn[dev] = 0;
		return(0);
	}
	if (eofwarn[dev] == 1) eofwarn[dev] = 2;
	/* next image will be top of form at end of job */
}

/* tput - convert spaces to tabs where possible */

tput(c)
char c;
{
	tpos++;
	if (c != ' ') {
		while (tsavsp--) put(' ');
		tsavsp = 0;
		put(c);
		if (tpos == 8) tpos = 0;
		return;
	}
	tsavsp++;
	if (tpos == 8) {
		if (tsavsp == 1)
			put(' ');
		else
			put('\t');
		tpos = tsavsp = 0;
	}
	return;
}

/* put - buffered output, 1 character at a time, with delayed file opening until
		runid is recognized.  If none found by time buffer is full then
		file garbage is opened for output.
 */

put(c)
char c;
{
register int dev;
extern char *garbage;

	dev = gdev;
	obuf[dev][outpnt[dev]++] = c;
	if (outpnt[dev] < 512) return(0);
	if (devopn[dev]) goto dowrite;
/* we have to write but a file has not been opened - open garbage file */
	if ((ofid[dev] = open(garbage, 1)) < 0)
		ofid[dev] = creat(garbage, 0644);
	else
		seek(ofid[dev], 0, 2);
	devopn[dev] = 1;
	rcurjob[dev][0] = '\0';

dowrite:
	write(ofid[dev], obuf[dev], 512);
	outpnt[dev] = 0;
}
notify()
{
extern int rjestate;
register int i, dev;
register char c;
int dowri;
int uid, fid, nrd, pid, wtstat;
extern char *jobout, *msgfil;
	dev = gdev;
	for (i=0;i<6; i++)
		jobout[i+9] = rcurjob[dev][i];
	if (rjestate & TESTMD)
		printf("recv:notify: jobout = %s\n",jobout);
	/* now to set up the message */
	for (i=0; i<6; i++)
		msgline[i+4] = rcurjob[dev][i];
	stampit(0);
	write(logfid, msgline, 24);
	write(consfid, msgline, 24);
	write(consfid, &cr, 1);
	stat(jobout, &stbuf);
	uid = stbuf.fuid;
	if (uid == SITUID) {
		printf("job %-6.6s is not owned - uid=%d\n",rcurjob[dev], uid);
		return;
	}
	if (getpw(uid, pwbuf)) {
		printf("can't find owner (uid=%d) of job %s\n\r", uid, rcurjob[dev]);
		return;
	}
	i = 0;
	while ((c = pwbuf[i]) != ':')
		uname[i++] = c;
	while (i < 8)
		uname[i++] = ' ';
	/* got the user's name - see if he is logged in */
	fid = open("/etc/utmp", 0);
	dowri = 0;
	while ((nrd = read(fid, &utbuf, 16)) == 16)
		if (cmp(utbuf.pname, uname, 8)) {
			dowri++;
			goto utdone;
		}
utdone:
	close(fid);
	fid = creat(msgfil, 0644);
	write(fid, msgline, 24);
	close(fid);
	for (i=0; i<8; i++)
		mailit[i+6] = wrtit[i+6] = uname[i];
	if (dowri)
		lpt = wrtit;
	else
		lpt = mailit;
	/* all set - now to fork off a shell to do the command */
	if ((pid = fork()) == 0) {
		execl("/bin/sh", "sh", "-c", lpt, 0);
		exit(0);
	}
	/* this is the parent - wait and then return */
	wait(&wtstat);	/* wait for child process to complete */
}

stampit(md)
int md;
{
	/* get timestamp for log messages */
struct time *localtime(), *tmpt;
char tmbuf[20];
int i;
	time(tvec);
	tmpt = localtime(tvec);
	sprintf(tmbuf,"%02d/%02d %02d:%02d:%02d \n",
		tmpt->t_month+1,tmpt->t_day_month,tmpt->t_hours,tmpt->t_minutes,tmpt->t_seconds);
	if(md == 1) i = 16;
	else i = 15;
	write(logfid, tmbuf, i);
	write(consfid, tmbuf, i);
}
