/*
 * tabit infile outfile
 * convert spaces in lines to tabs as much as possible
 *
 *
 * Written by David E. Miran
 * Wisconsin State Hygiene Lab
 * 465 Henry Mall
 * Madison, Wi 53706
 *
 *  January 23, 1981
 *
 */

char ibuf[512], obuf[512];
int ifid, ofid;
int iptr, optr;
int nrd;
int tpos  0;
int tsavsp 0;

main(argc,argv)
int argc;
char **argv;
{
register int i;
register char c;
extern char get();

	if (argc < 3) {
		printf("usage: tabit infile outfile\n");
		exit(1);
	}
	if ((ifid = open(argv[1], 0)) < 0) {
		printf("cannot open input file %s\n", argv[1]);
		exit(1);
	}
	if ((ofid = creat(argv[2], 0644)) < 0) {
		printf("cannot open output file %s\n",argv[2]);
		exit(1);
	}
	iptr = nrd = 512;	/* force a read */
	optr = 0;
	for (;;) 
		tput(get());
}
char get()
{
	if (iptr == nrd) {
		nrd = read(ifid, ibuf, 512);
		if (nrd < 1) {	/* all done */
			close(ifid);
			if (optr>0) write(ofid, obuf, optr);
			close(ofid);
			exit(0);
		}
		iptr = 0;
	}
	return(ibuf[iptr++]);
}

/* tput - convert spaces to tabs where possible */

tput(c)
char c;
{
	tpos++;
	if (c == '\n') {
		put(c);
		tsavsp=0;
		tpos=0;
		return;
	}
	if (c != ' ') {
		while (tsavsp--) put(' ');
		tsavsp = 0;
		put(c);
		if (tpos == 8) tpos = 0;
		return;
	}
	tsavsp++;
	if ( tpos == 8) {
		if (tsavsp == 1)
			put (' ');
		else
			put('\t');
		tpos = tsavsp = 0;
	}
	return;
}

/* put - buffered output */

put(c)
char c;
{
	obuf[optr++] = c;
	if (optr == 512) {
		write(ofid, obuf, 512);
		optr=0;
	}
}
