.TH atodate 3L
.SH NAME
atodate - convert standard times and people times
see also "man local date"
.SH SYNOPSIS
.nf
#include "stdtime.h"

/* DATE curtime; */

TIME atodate (string)
char *string;

.fi
.SH DESCRIPTION
atodate - converts ascii string to a time.  Several forms are allowed.
If the first element of the string is an integer a "ymdtime" is assumed.
The forms allowed for ymd type times are somewhat flexible.  In the
description below, yyyy represents at most 4 digits of year.  Similiarly,
mm, dd, hh, MM, ss represent digits for month, day, hour, minute, and second.
The symbol "mon" represents the month as a string.  "mon" may be abbreviated.
Case of letters is ignored.  The ymd forms (and restrictions) follow:
.nf
	":" or white-space may be used where ":" is shown.
	if only a 2-digit year is given, year must be > 31.
	yyyy:mm:dd:hh:MM:ss
	yyyy:mm:dd hhH:MMm:ssS  (e.g. 1976:5:15 20h:15m:20s)
	yyyy:mm:dd:hh:MM
	yyyy:mm:dd:hh
	yyyy:mm:dd
	yyyy:mm
	yyyy
	The form of time within a day shown above also is used
	in the forms below.
	yyyy mon dd
	mm/dd/yyyy
	dd mon yyyy
	ddmonyyyy
	mon yyyy
	mon dd yyyy
.fi
If the first element is a string but not a month
the time will be one on the following
forms:
- - none at present - -
.SH FILES
.nf
/usr/src/local/date/times.c
/usr/local/lib/libdate.a
/usr/src/local/date/makefile is a make file.
see also timecnv(1l) time(2) and ctime(3).
.SH BUGS
.fi
Do not make an external variable "time" if you use "timenow".
