/*

Name:
	makesus

Function:
	Creates the name of the suspense file from the user supplied date.

Algorithm:
	Validate the given date. Create the date with the format sus.ddmmm.
	Return a pointer to the suspense file name.

Parameters:
	due-date                the due date of the suspense
	envp                    environment pointer

Returns:
	Pointer to the suspense file name.
	NULL if invalid date format

Files and Programs:
	user supplied list file or default list file


*/
#include <stdio.h>


char *makesus(datein, user)
char *datein,
     *user;

{
    static char id[] = "%W% %H%";
    static char sus_name[128];
    char *suspense = sus_name,
	  date_buf[10],
	 *date = date_buf;

    extern char *findenv();
    extern char *valid_date();

    if (*datein == 'd')  {
	if((date = new_date (7)) == NULL)             /* Set 7 day default increnent */
	    return(NULL);
    }
    else
	if ((valid_date(datein, date, 0)) == NULL)         /* Validate date */
		return (NULL);
    strcat (suspense, user);
    strcat (suspense, "/exec/suspenses/sus.");
    strcat (suspense , date);
    return (suspense);
}
