/*
Name:
	DESUS Calendar System Command

Function:
	Delete a suspense list item.

Algorithm:
	Validate the user supplied date and create a suspense file name from
	it. Open the suspense file. Then copy all but the specified item to
	the temp file. Copy the temp file back to the list file. Unlink
	the temp file.

Parameters:
	item number             the line number of the list item in the list file
	user supplied date

Returns:
	ENOERR	Normal exit
	EFORM	Bad date format or incorrect number of command line arguments

Files and Programs:
	suspense file for given date
	TEMPFILE                                        temporary file for extraction

Installation Instructions:
	Compile as follows: cc -o $EXEC.DIR/desus desus.c ../library
	Change owner to root
	Deny write permissions except for owner

History:
	Dec 79,	Release 2 Version 1, G. Maltagliati, coded in shell
	Nov 80,	Release 5 Version 1, G. Maltagliati, coded in C for efficiency
	Jul 82, Release 7 Version 1, L. Reed, for Perkin-Elmer
	Aug 82, Release 7 Version 2, J. Neyer...rewrite exec support


*/
#include <stdio.h>
#include "../includes/error.h"
#include "../includes/getdef.h"
#define TEMPFILE "/tmp/desusXXXXXX"
#define USAGE "You must enter:  desus item-number date\n"

char id[] = "%W% %H%";

/*

Name:
	main

Function:
	Validate parameters. Open the list file.
	Delete the item. List the suspense list.

Algorithm:
	Insure that the correct number of arguments were entered on the command
	line. Validate the user supplied date and build a suspense file name.
	Open the suspense file. Call desus to delete the item.
	Call dolist_call to sort and re-display the new suspense list.

Parameters:
	item number		the line number of the dolist item in the dolist file
	user supplied date

Returns:
	ENOERR	Normal exit
	EFORM	Bad date format or incorrect number of command line arguments

Files and Programs:
	suspense file for given date
	TEMPFILE
	dolist


*/
main (argc, argv, envp)
int     argc;						/* Count of command line arguments */
char   *argv[];						/* Pointer to list of argument pointers */
char   **envp;                  /* the environment */
{


    char *lfile;                                        /* Pointer to list file name */

    FILE *fp;

    extern char *getline();
    extern char *mktemp();
    extern char *sprintf();
    extern char *strcat();
    extern char *findenv();

    if (argc != 3)       {
	fprintf (stderr, USAGE);
	exit(EFORM);
    }
    if ((lfile = makesus(argv[2], findenv("HOME", envp))) == NULL)       {
	fprintf(stderr, "desus: invalid date %s\n", argv[2]);
	exit(EFORM);
    }
    if ((fp = fopen(lfile, "r")) == NULL)   {         /* Open the list file */
	fprintf (stderr, "addsus: cannot open list file %s\n", lfile);
	exit (EACCES);
    }
    delist(lfile, argv[1]);
    dolist_call(lfile, findenv("USER", envp));
    exit(ENOERR);
}
