/*
 *	vform
 *	State Hygiene Laboratory Virology database system
 *	Data entry and Enquiry format analysis program
 *	by David E. Miran
 *	3/4/82
 */

#include	<stdio.h>
#include	<myio.h>
#include	"vir.h"
#include	"virfiles.h"
#define		SCRWID	80

extern char mget();

char	iline[100];	/* reserved space for manipulation */

struct	fdef	fld[MAXFLD];	/* the format field descriptors */
struct	dexhead	hrec;		/* HFILE (header file) */
struct	fmt_inf	fmtinf[MAXFMT];	/* format information (internal) */
struct	fmt_def fmtdef[MAXFMT];
struct	fil_ent filent[MAXFILE];

main()
{
int h, i, j;
	h = open(hfile,2);
	i = read(h, &hrec, sizeof(struct dexhead));
	read(h, &fmtdef[0],MAXFMT*sizeof (struct fmt_def));
	read(h, &filent[0],hrec.numfmt * sizeof(struct fil_ent));
	hrec.nfmtfld = 0;
	for (i=0; i<hrec.numfmt; i++) {
		j = formanal(fmtdef[i].fmt_name, &hrec.nfmtfld, fmtdef[i].fmt_num,i);
		if (j) {
			printf("vform:  cannot read format %s\n",fmtdef[i].fmt_name);
			exit(1);
		}
	}
	j = 0;
	for (i=0; i<hrec.numfmt; i++)
		if (fmtinf[i].fmt_mod & SPECIMEN) j++;
	if (j> 0) hrec.nonspec = 0;
	else  hrec.nonspec = 1;
	time(&hrec.fmtime);
	lseek(h, 0L, 0);
	write(h, &hrec, sizeof(struct dexhead));
	write(h, &fmtdef[0],MAXFMT * sizeof (struct fmt_def));
	write(h, &filent[0],hrec.numfmt * sizeof(struct fil_ent));
	close(h);
	h = creat(fmtfile, 0664);
	write(h, &fmtinf[0],hrec.numfmt * sizeof(struct fmt_inf));
	write(h, &fld[0], hrec.nfmtfld * sizeof(struct fdef));
	close(h);
	printf("vform done\n");
}

formanal(fname, stnum,fmnum, seq)
char *fname;
int *stnum, fmnum, seq;
{
	register char ch, nch;
	register int fnum;
	int fldnum, fid, i, fprog, lpos, lnum, curpos;
	struct fbuf ffin;
	int lprog;

	if ((fid = open(fname, 0)) < 0) return(1);
	mfinit(&ffin, fid);
	lnum = fprog = curpos = 0;
	lprog = 0;
	fnum = *stnum -1;
	fldnum = -1;
/* fnum is position in the arrary of fields for all formats,
 * fldnum is position of field within the specified format (first is 0)
 */

	lpos = 1;	/* for teleray, 0 for anything else? */
	ch = mget(&ffin);
	nch = mget(&ffin);
	fmtinf[fmnum].st_fld = fnum + 1;
	fmtinf[fmnum].fmt_mod = 0;

in_lp:
	if ((ch == ' ') && (nch == '[')) {  /* start of a field */
		if (fprog) goto err;
		lpos += 2;
		ch = mget(&ffin);
		nch = mget(&ffin);
		fnum++;
		fprog++;
		fldnum++;
		if (fnum > MAXFLD) goto err2;
		fld[fnum].f_size = 0;
		fld[fnum].f_anum = 0;
		fld[fnum].f_flags = 0;
		fld[fnum].f_pos = curpos;
/* starting position of field counting only characters in fields */
		goto in_lp;
	}
	if ((ch == ']') && ((nch == ' ') || (nch == '\n'))) { /* end of field */
		if (!fprog) goto err;
		lprog = 0;
		if (fld[fnum].f_flags & PNAME) { /* patient name */
			fmtinf[seq].fld_nam = fldnum;
		}
		if (fld[fnum].f_flags & PNUM)
			fmtinf[seq].fld_pn = fldnum;
		if (fld[fnum].f_flags & PNUMYR)
			fmtinf[seq].fld_pny = fldnum;
		fmtinf[fmnum].fmt_mod |= fld[fnum].f_flags;
		lpos += 2;
		if (nch == '\n') {
			ch = nch;
		}  else  {
			ch = mget(&ffin);
		}
		nch = mget(&ffin);
		fprog = 0;
		goto in_lp;
	}
	if (ch == '\n') {
		if (lpos > SCRWID) goto err;
		if (fprog) goto err;
		lnum++;
		if (lnum >= PAGELEN) goto endform;
		lpos = 1;   /* on teleray, 0 on all others */
		ch = nch;
		nch = mget(&ffin);
		if ((ch == 0) || (nch == 0)) goto endform;
		goto in_lp;
	}
	if (!lprog) lpos++;
	if (fprog) {	/* field in progress - analyze modifiers */
		if (!lprog)  {
			fld[fnum].f_size++;
			curpos++;
		}
		switch (ch)	{ /* set up descriptor */
			case 'B':
			case ' ':
				break;	/* ignore characters */
			case 'L': fld[fnum].f_flags =| LCASE; break;
			case '9': fld[fnum].f_flags =| NUMERIC; break;
			case 'R': fld[fnum].f_flags =| REQUIRED; break;
			case 'A': fld[fnum].f_flags =| ALPHA; break;
			case 'D': fld[fnum].f_flags =| DATE; break;
			case 'N': fld[fnum].f_flags =| LABNUM; break;
			case 'P': fld[fnum].f_flags =| PNAME; break;
			case 'H': fld[fnum].f_flags =| DNAME; break;
			case 'C': fld[fnum].f_flags =| CITY; break;
			case 'X': fld[fnum].f_flags =| RANGE; break;
			case 'S': fld[fnum].f_flags =| SPECIMEN; break;
			case 'p': fld[fnum].f_flags =| PNUM; break;
			case 'c': fld[fnum].f_flags =| PNUMYR; break;
			case 'l':
				i = (nch - '0') &0177;
				lpos -= (fld[fnum].f_size - i);
				curpos -= (fld[fnum].f_size - i);
				fld[fnum].f_size = i;
				lprog=1;
				ch = nch;
				nch = mget(&ffin);
				break;
			case 's': fld[fnum].f_flags =| SOURCE;
				goto patchit;
			case 'a': fld[fnum].f_flags =| AUTO;
patchit:
				iline[0] = nch;
				iline[1] = '\0';
				fld[fnum].f_anum = atoi(iline);
				ch = nch;
				nch = mget(&ffin);
				if (!lprog) {
					curpos++;
					fld[fnum].f_size++;
					lpos++;
				}
				break;
			default:
				goto err;
		}
	}
	ch=nch;
	nch=mget(&ffin);
	if (ch != 0) goto in_lp;
endform:
	close(fid);
	fmtinf[fmnum].end_fld = fnum;
	fmtinf[fmnum].num_fld = fldnum + 1;
	fmtinf[fmnum].num_chr = curpos;
	*stnum = fnum + 1;
	return(0);
err:
	printf("vform: error in format %s in line %d - where first line is zero\n", fname, lnum);
	exit(1);
err2:
	printf("vform: too many fields in all formats\n");
	exit(1);
}
