/*
 *	vfind
 *	Variable Information Retrieval
 *	State Hygiene Laboratory pseudo database system
 *	record extraction program
 *	by David E. Miran
 *	9/3/82
 */

#include	<stdio.h>
#include	"vmyio.h"
#include	"vir.h"
#include	"virfiles.h"
#define		P 1
#define		N 2
#define		S 3
#define		NS 4
/* defines for record selection rules -
 * P - by patient name
 * N - by patient number
 * S - by specimen number
 * NS - by patient number selected by looking up a specimen number
 */

int	hfid, pfid, p1fid, p2fid, nfid, n1fid, n2fid, sfid, s1fid, s2fid, dfid;

extern char mget();
extern long atol(), lseek();

struct	dexhead	hrec;		/* HFILE (header file) */
struct	fil_ent	filent[MAXFILE]; /* data file information - HFILE-3 */
struct	pat_ent	prec;		/* one record from PFILE */
struct	num_ent	snrec;		/* one record from NFILE */
struct	sp_ent	srec;		/* one record from SFILE */

char	recbuf[MAXRSIZE];	/* record buffer */
struct fbuf ibuf, obuf;  /* stdin and stdout buffers */

long  lk_pnum;			/* patient number for lookup */
char	lk_pnam[PNSIZE];	/* patient name for lookup */

struct	pat_ent	cur;	/* current patient name and number */
int	cur_rcnt	0;	/* count of records in current set */

struct {
	struct	num_ent crec_n;
	int	nfmt_num;	/* format associated with this record */
	int	crfl;		/* filspot of file for this record */
	}  crec[MAXREC];	/* pointers to records in working set */

long	num, ndist;

int	fmtlim	0;	/* set if retrieval limited to selected formats */
int	fmtrst[MAXFMT];	/* set if format type selected for retrieval */
char	*fmtn[] {"1.", "2.", "3.", "4.", "5.", "6.", "7.", "8.", "9."};

/* LOOKUP - control variables and tables (?2 files) */
char	pbase[NCPAT][16];	/* p2 file */
long	nbase[NCREC];		/* n2 file */
long	sbase[NCSPEC];		/* s2 file */
int	pbcnt, nbcnt, sbcnt;  /* counts of entries in p2, n2, s2 */
int	plookp, nlookp, slookp;  /* set if currently searching p, n, or s file */
int	plooku, nlooku, slooku;  /* set if search beyond sequential area */
struct fbuf plbuf, nlbuf, slbuf;  /* buffers for index files */
long ploc, nloc, sloc;  /* current offsets into index files */
int	filspot;		/* current data file pointer in filent table */

char	cfile[50];	/* current directory name */


/* options */
int	fopt	0;
int	smode	0;	/* P=1, N=2, S=3, NS=4 */
int	rmode	0;	/* set if range mode selection turned on -r  */
int	nopt	0;	/* if set then format codes are not prepended */

/* MISC - miscellaneous variables */

char	*progname;
char	rbuf[80];	/* spare line buffer */
int	emode	0;	/* set if end record needed */
char	*erec	"0!\n";	/* end record */
int	elen	3;	/* length of erec */

long	r1,r2;	/* bottom and top of range */
long	topn,tops;	/* highest nfile, sfile entry */
int	endn, ends;	/* set when end of nfile, sfile has been reached */
			/* which implies topn, tops are now valid */

main(argc, argv)
int argc;
char **argv;
{
	register int i, j;
	register char c;
	int k;

	r1 = r2 = topn = tops = endn = ends = 0;
	progname = *argv;
	cfile[0] = '.';  cfile[1] = '\0';

/* analysis of options */

	while (--argc) {
		argv++;
		if (strcmp(*argv,"-f") == 0) {
			fopt = 1;
			continue;
		}
		if (strcmp(*argv,"-e") == 0) {
			emode = 1;
			continue;
		}
		if (strcmp(*argv, "-nf") == 0) {
			nopt = 1;
			continue;
		}
		if (strcmp(*argv,"-o") == 0) {
			argc--;  argv++;
			strcpy(cfile,*argv);
			if (chdir(cfile) != 0) {
				fprintf(stderr,"%s: Access forbidden to directory %s\n",progname,cfile);
				exit(1);
			}
			continue;
		}

		if (strcmp(*argv,"-n") == 0) {
			if (smode) goto multimode;
			smode = N;
			continue;
		}

		if (strcmp(*argv,"-p") == 0) {
			if (smode) goto multimode;
			smode = P;
			continue;
		}

		if (strcmp(*argv,"-s") == 0) {
			if (smode) goto multimode;
			smode = S;
			continue;
		}

		if (strcmp(*argv,"-ns") == 0) {
			if (smode) goto multimode;
			smode = NS;
			continue;
		}
		if (strcmp(*argv, "-r") == 0) {
			argc--; argv++;
			r1 = atol(*argv);
			argc--; argv++;
			r2 = atol(*argv);
			rmode = 1;
			continue;
		}
		c = argv[0][1];
		if ((c >= '1') && (c <= '9')) {
			fmtlim = 1;
			i = (c - '0') & 0377;
			fmtrst[i-1] = 1;
			continue;
		}
		/* add new options here */
	}
	goto ckmode;
multimode:
	fprintf(stderr,"vfind: more than one selection mode specified. Must have one of -n,-s,-p,-ns\n");
	exit(1);

ckmode:
	if (!smode) {
		fprintf(stderr,"vfind: no selection mode specified - must have -p, -n , -s, or -ns option\n");
		exit(1);
	}
	vopen();
	for (i=0; i<9; i++) fmtn[i][1] = hrec.fldsep;
	erec[1] = hrec.recsep;
	if (hrec.modata) elen = 2;
	mfinit(&ibuf,0);
	mfinit(&obuf,1);
	if (rmode) num = r1;
inloop:
	if (rmode) goto dosw;
	i = mgetlin(rbuf, &ibuf);
	if (i <= 0) goto done;
	if (smode != P)   num = atol(rbuf);
dosw:
	switch(smode) {
		case P:
			i = j = plookp = 0;
			while (c = rbuf[i++]) {
				if (( c >= 'a') && (c <= 'z')) c &= 0137;	/* fold to upper case */
				lk_pnam[j++] = c;
				if (j >= PNSIZE) break;
			}
			if (j < PNSIZE)   lk_pnam[j] = '\0';
			while (loadpat(lk_pnam)) {
				loadws(cur.p_num);
				if (cur_rcnt < 1) continue;
				gencur();
				endrec();
			}
			break;
		case N:
			nlookp = 0;
			j = loadws(num);
			if (j < 0) goto done;
			if (cur_rcnt < 1) break;
			gencur();
			endrec();
			break;
		case S:
			slookp = 0;
			while ((k = looks(num)) > 0) {
				filspot = lookupn(srec.sf_num);
				j = filent[filspot].fmt_cd;
				genrec(srec.sf_num,srec.sf_loc,j);
			}
			if (k < 0) goto done;
			endrec();
			break;
		case NS:
			slookp = 0;
			k = looks(num);
			if (k < 0) goto done;
			if (k == 0) break;
			lk_pnum = srec.xp_num;
			nlookp = 0;
			loadws(lk_pnum);
			if (cur_rcnt < 1) break;
			gencur();
			endrec();
			break;
	}	/* end of smode switch */
	if (rmode) {
		num++;
		if (num > r2) goto done;
	}
	goto inloop;
done:
	mflush(&obuf);
	vclose();
}

/*******************************  vopen  *************************************/

vopen()
{
register int i;
	vfopn(&hfid,hfile, 0);
	vfopn(&pfid,pfile, 0);
	vfopn(&p1fid,p1, 0);
	vfopn(&p2fid,p2, 0);
	vfopn(&nfid,nfile, 0);
	vfopn(&n1fid,n1, 0);
	vfopn(&n2fid,n2, 0);
	vfopn(&sfid,sfile, 0);
	vfopn(&s1fid,s1, 0);
	vfopn(&s2fid,s2, 0);

	read(hfid, &hrec, sizeof hrec);
	lseek(hfid, (long) MAXFMT * sizeof (struct fmt_def), 1);
	read(hfid, &filent[0], hrec.numfile * sizeof (struct fil_ent));
	close(hfid);
	i = read(n2fid, &nbase[0], NCREC*4);
	nbcnt = i/4;
	i = read(p2fid,&pbase[0][0],NCPAT * 16);
	pbcnt = i/16;
	i = read(s2fid, &sbase[0], NCSPEC * 4);
	sbcnt = i/4;
	close(p2fid); close(n2fid);
	if (!hrec.nonspec) {
		vfopn(&sfid,sfile, 0);
		vfopn(&s1fid,s1, 0);
		vfopn(&s2fid,s2, 0);
		i = read(s2fid, &sbase[0], NCSPEC * 4);
		sbcnt = i/4;
		close(s2fid);
	}
}

/********************************  vfopn  ***********************************/
vfopn(fid, fn, md)
int *fid, md;
char *fn;
{
	if ((*fid = open(fn,md)) < 0) {
		fprintf("%s: Cannot open file %s\n",progname,fn);
		exit(1);
	}
}

/********************************  vclose  ***********************************/

vclose()
{
register int i, j, k;
	close(pfid);
	close(p1fid);
	close(nfid);
	close(n1fid);
	if (!hrec.nonspec) {
		close(sfid);
		close(s1fid);
	}
}

/******************************  lookn  **********************************/
/* find a patient number index entry and return it in snrec   */

lookn(xnum)
long xnum;
{
long i;
long off1;
long ynum;

	if (endn && (xnum > topn)) return(-1);
	if (nlookp) goto nextrec;
	if (hrec.nmaxseq == 0) {
		nloc = 0;
		nlooku = 1;
		goto doseek;
	}
	for (i=0; i<nbcnt; i++)
		if (nbase[i] >= xnum) goto seta;
seta:
	if (i > 0) i--;
	off1 = (long) VBSIZE * i;
	i = off1/4;
/* off1 is the lseek distance into n1dex and i is # of records skipped */
	lseek(n1fid, off1, 0);
	mfinit(&nlbuf, n1fid);
	while (mgetrec(&ynum, 4, &nlbuf)) {
		if (ynum >= xnum) goto setb;
		i++;
	}
setb:
	if (i > 0) i--;
	nloc = (long) BSZN * i;
	nlooku = 0;
doseek:
	lseek(nfid, nloc, 0);
	nlookp = 1;
nextset:
	mfinit(&nlbuf, nfid);
	nloc -= sizeof (struct num_ent);
nextrec:
	while (mgetrec(&snrec, sizeof (struct num_ent), &nlbuf)) {
		nloc += sizeof (struct num_ent);
		if (snrec.np_num == 0L) continue;
		if (!endn)
			if (snrec.np_num > topn) topn = snrec.np_num;
		if (snrec.np_num < xnum) continue;
		ndist = nloc/sizeof (struct num_ent);
		if (ndist >= hrec.nmaxseq) nlooku = 1;
		if (snrec.np_num > xnum) {
			if (nlooku == 0) {
				if (endn) i=0;
				else i = 1;
				nloc = lseek(nfid, (long) (hrec.nmaxseq - i) * sizeof (struct num_ent), 0);
				nlooku = 1;
				goto nextset;
			}
			continue;
		}
		return(1);  /* match found */
	}
	nlookp = 0;
	endn = 1;
	return(0);  /* end of matching patient numbers */
}

/******************************  lookp  **********************************/
/* find a patient name/number index entry and return it in prec   */

lookp(xname)
char *xname;
{
long i;
static int pcnt;
long off1;

	if (plookp) goto nextrec;
	for (pcnt = 0; pcnt < PNSIZE; pcnt++)   /* count up size of name */
		if (xname[pcnt] == '\0') break;
	if (hrec.pmaxseq == 0) {
		ploc = 0;
		plooku = 1;
		goto doseek;
	}
	for (i=0; i<pbcnt; i++)
		if (strncmp(pbase[i], xname, pcnt) >= 0) goto seta;
seta:
	if (i > 0) i--;
	off1 = (long) VBSIZE * i;
	i = off1/16;
/* off1 is the lseek distance into p1dex and i is # of records skipped */
	lseek(p1fid, off1, 0);
	mfinit(&plbuf, p1fid);
	while (mgetrec(&prec, 16, &plbuf)) {
		if (strncmp(&prec, xname, pcnt) >= 0) goto setb;
		i++;
	}
setb:
	if (i > 0) i--;
	ploc = (long) BSZP * i;
	plooku = 0;
doseek:
	lseek(pfid, ploc, 0);
	plookp = 1;
nextset:
	mfinit(&plbuf, pfid);
	ploc -= sizeof (struct pat_ent);
nextrec:
	while (mgetrec(&prec, sizeof (struct pat_ent), &plbuf)) {
		ploc += sizeof (struct pat_ent);
		if (prec.p_num == 0L) continue;
		if (pcnt == 0) return(1);
		if (strncmp(prec.p_name, xname, pcnt) < 0) continue;
		ndist = ploc/sizeof (struct pat_ent);
		if (ndist >= hrec.pmaxseq) plooku = 1;
		if (strncmp(prec.p_name, xname, pcnt) > 0) {
			if (plooku == 0) {
				ploc = lseek(pfid, (long) hrec.pmaxseq * sizeof (struct pat_ent), 0);
				plooku = 1;
				goto nextset;
			}
			continue;
		}
		return(1);  /* match found */
	}
	plookp = 0;
	return(0);  /* end of matching names */
}

/******************************  looks  **********************************/
/* find a specimen number index entry and return it in srec   */

looks(xnum)
long xnum;
{
long i;
long off1;
long ynum;

	if (ends && (xnum > tops)) return(-1);
	if (slookp) goto nextrec;
	if (hrec.smaxseq == 0) {
		sloc = 0;
		slooku = 1;
		goto doseek;
	}
	for (i=0; i<sbcnt; i++)
		if (sbase[i] >= xnum) goto seta;
seta:
	if (i > 0) i--;
	off1 = (long) VBSIZE * i;
	i = off1/4;
/* off1 is the lseek distance into s1dex and i is # of records skipped */
	lseek(s1fid, off1, 0);
	mfinit(&slbuf, s1fid);
	while (mgetrec(&ynum, 4, &slbuf)) {
		if (ynum >= xnum) goto setb;
		i++;
	}
setb:
	if (i > 0) i--;
	sloc = (long) BSZS * i;
	slooku = 0;
doseek:
	lseek(sfid, sloc, 0);
	slookp = 1;
nextset:
	mfinit(&slbuf, sfid);
	sloc -= sizeof (struct sp_ent);
nextrec:
	while (mgetrec(&srec, sizeof (struct sp_ent), &slbuf)) {
		sloc += sizeof (struct sp_ent);
		if (srec.xp_num == 0) continue;
		if (!ends)
			if (srec.sp_num > tops) tops = srec.sp_num;
		if (srec.sp_num < xnum) continue;
		ndist = sloc/sizeof (struct sp_ent);
		if (ndist >= hrec.smaxseq) slooku = 1;
		if (srec.sp_num > xnum) {
			if (slooku == 0) {
				if (ends) i = 0;
				else i = 1;
				sloc = lseek(sfid, (long) (hrec.smaxseq - i) * sizeof (struct sp_ent), 0);
				slooku = 1;
				goto nextset;
			}
			continue;
		}
		return(1);  /* match found */
	}
	slookp = 0;
	ends = 1;
	return(0);  /* end of matching specimen numbers */
}

/*******************************  getfrec  **********************************/
/* get a record from a specified file and offset.
   terminate program in error if record too large or contains del codes */

getfrec(filen, record, loc)
unsigned filen;
long loc;
char *record;
{
struct fbuf rb;
int ifid, ispt;
register char c;
register int i;
/* return codes  n>0 is record size.  n = 0 means eof.  n = -2 means file error */
	i = 0;
	ispt = filspot;
	if (ispt < 0) return(0);
	ifid = open(filent[ispt].f_name, 0);
	if (ifid < 0) return(0);
	lseek(ifid, loc, 0);
	mfinit(&rb, ifid);
glp:
	c = mget(&rb);
	if (rb.nrd < 1) {
retnx:
		close(ifid);
		return(0);
	}
	if ((c == '\n') && (!hrec.modata)) goto glp;
	if (c == 0177) goto retnx;
	if (i > MAXRSIZE) goto retnx;
	record[i++] = c;
	if (c == hrec.recsep) {
		record[i] = '\0';
		close(ifid);
		return(i);
	}
	goto glp;
}
/*****************************  loadpat  ***********************************/
/* set up next patient - xname as current and load working set.
 * return 1 if found, 0 if not found or done with this name */

loadpat(xpname)
char *xpname;
{
register int i;
	i = lookp(xpname);
	if (!i) return(i);
	ncpy(&cur, &prec, sizeof prec);
	loadws(cur.p_num);
	return(i);
}


/****************************  loadws  *************************************/
/* load working set - i.e. index entries of all records for this patient */

loadws(xpnum)
long xpnum;
{
register int i, j, k;
	cur_rcnt = nlookp = 0;
	i = 0;
	while ((k = lookn(xpnum)) > 0) {  /* returns entry in snrec */
		if (i >= MAXREC) {
			cur_rcnt = i;
			return(0);
		}
		ncpy(&crec[i], &snrec, sizeof snrec);
		j = lookupn(crec[i].crec_n.nf_num);
		crec[i].crfl = j;
		crec[i].nfmt_num = filent[j].fmt_cd;
		i++;
	}
	cur_rcnt = i;
	return(k);
}
/*******************************  lookup, lookupn  *************************/
/* look up files in the file table by name or number */

lookup(fname)
char *fname;
{
register int i;
	for (i=0; i<hrec.numfile; i++)
		if (strcmp(fname, filent[i].f_name) == 0) return(i);
	return(-1);
}
lookupn(fnum)
unsigned fnum;
{
register int i;
	for (i=0; i<hrec.numfile; i++)
		if (fnum == filent[i].f_num) return(i);
	return(-1);
}


/*******************************  ncpy  ************************************/
/* copy exactly n characters */
ncpy(to, from, n)
char *to, *from;
int n;
{
	while (n--) *to++ = *from++;
}
ncpyt(to, from, n)	/* and add a null at the end */
char *to, *from;
int n;
{
	while (n--) *to++ = *from++;
	*to = '\0';
}
gencur()
{
register int i, j, ifmt;
	for (ifmt = 0; ifmt < hrec.numfmt; ifmt++) {
		for (i=0; i<cur_rcnt; i++) {
			j = crec[i].nfmt_num;
			if (j != ifmt) continue;
			filspot = crec[i].crfl;
			genrec(crec[i].crec_n.nf_num, crec[i].crec_n.f_loc, j);
		}
	}
}
genrec(fnum, floc, fmt)   /* filspot is always current */
unsigned fnum;
long floc;
int fmt;
{
register int i, j, k;
	if (fmtlim && (fmtrst[fmt] ==0)) return;
	i = getfrec(fnum, recbuf, floc);
	if (i < 1) return;
	if (!nopt)
		mputrec(fmtn[fmt],2, &obuf);
	if (!fopt) goto no_f;
	mputrec(recbuf,i, &obuf);
	mput('\n', &obuf);
	return;
no_f:
	j=2;
	for (k=0; k<i; k++) {
		mput(recbuf[k], &obuf);
		j++;
		if (j >=78) {
			mput('\n', &obuf);
			j=0;
		}
	}
	if (j > 0) mput('\n', &obuf);
}
endrec()
{
	if (!emode) return;
	mputrec(erec, elen, &obuf);
}
